/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AffordableFilter;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.BuildableFilter;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.ConstructionBackend;
import com.zarkonnen.airships.EditMissionIntent;
import com.zarkonnen.airships.FileScreen;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.Loadable;
import com.zarkonnen.airships.MissionSetupIntent;
import com.zarkonnen.airships.PlaceShipTool;
import com.zarkonnen.airships.PriceInlineInfo;
import com.zarkonnen.airships.ShipEditorUtils;
import com.zarkonnen.airships.ShipHelperWidget;
import com.zarkonnen.airships.ShipType;
import com.zarkonnen.airships.SingleCombatSetupIntent;
import com.zarkonnen.airships.Tech;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.json.JSONObject;

public strictfp class AddConstructionButton
extends UniScreen.Button {
    public final ShipType type;

    public AddConstructionButton(ShipType type) {
        this.type = type;
    }

    @Override
    public boolean visible(UniScreen us) {
        if (us.intent instanceof MissionSetupIntent && !this.type.mobile) {
            return false;
        }
        return (us.intent instanceof SingleCombatSetupIntent || us.intent instanceof EditMissionIntent || us.intent instanceof MissionSetupIntent) && us.tool == UniScreen.NAVIGATE;
    }

    @Override
    public String text(UniScreen us) {
        if (us.tool instanceof PlaceShipTool) {
            return Lang._t("Cancel", new Object[0]);
        }
        return Lang._t("Add_" + this.type.name(), new Object[0]);
    }

    @Override
    public String hotkey(UniScreen us) {
        switch (this.type) {
            case AIRSHIP: {
                return "I";
            }
            case LANDSHIP: {
                return "N";
            }
            case BUILDING: {
                return "B";
            }
        }
        return null;
    }

    @Override
    public void click(Input in, UniScreen us) {
        if (us.tool instanceof PlaceShipTool) {
            us.tool = UniScreen.NAVIGATE;
        } else {
            this.addShip(us);
        }
    }

    @Override
    public boolean gold(UniScreen us) {
        if (!(us.intent instanceof SingleCombatSetupIntent || us.intent instanceof EditMissionIntent || us.intent instanceof MissionSetupIntent)) {
            return false;
        }
        return us.combat.sides.get((int)0).ships.isEmpty() || us.combat.sides.get((int)1).ships.isEmpty();
    }

    private void addShip(UniScreen us) {
        int sideIndexForSHWArms = 0;
        int sideIndex = -1;
        Combat.Side side = null;
        if (us.intent instanceof MissionSetupIntent) {
            sideIndexForSHWArms = sideIndex = ((MissionSetupIntent)us.intent).mission.playerSideIndex;
            side = us.combat.sides.get(sideIndex);
        }
        ShipHelperWidget shw = ShipHelperWidget.get(this.type, us.combat.sides.get((int)sideIndexForSHWArms).arms, Tech.getStandardBonuses(), null, 0);
        ConstructionBackend cbe = ShipEditorUtils.shipsList(this.type, shw);
        FileScreen fs = new FileScreen(cbe, new AddMission(us.g, us, !this.type.mobile, side, sideIndex, this.type, cbe), shw, new PriceInlineInfo(shw, null), this.type.name());
        fs.enabledFilter = us.intent instanceof MissionSetupIntent ? new AffordableFilter(((MissionSetupIntent)us.intent).getBudgetLeft(us), shw, null) : new BuildableFilter(shw);
        us.g.s = fs;
    }

    public strictfp static class AddMission
    implements FileScreen.Mission {
        private final AirshipGame g;
        private final UniScreen us;
        private final boolean flipped;
        private final Combat.Side side;
        private final int sideIndex;
        private final ShipType type;
        private final ConstructionBackend backend;

        public AddMission(AirshipGame g, UniScreen us, boolean flipped, Combat.Side side, int sideIndex, ShipType type, ConstructionBackend backend) {
            this.g = g;
            this.us = us;
            this.flipped = flipped;
            this.side = side;
            this.sideIndex = sideIndex;
            this.type = type;
            this.backend = backend;
        }

        @Override
        public FileScreen.Mode mode() {
            return FileScreen.Mode.OPEN;
        }

        @Override
        public String text() {
            return Lang._t("Add_" + this.type.name() + "_to_fleet_", new Object[0]);
        }

        @Override
        public String fileSelectionText() {
            return Lang._t("Add", new Object[0]);
        }

        @Override
        public String initialInput() {
            return "";
        }

        @Override
        public void fileSelected(String path) {
            this.g.s = this.us;
            try {
                Airship shipToPlace = new Airship(new JSONObject(FileUtils.readFileToString((File)this.backend.getFile(FileScreen.splitPath(path)), (String)"UTF-8")));
                shipToPlace.setFlipped(this.flipped, null);
                shipToPlace.flipTo = this.flipped;
                shipToPlace.currentBonuses = Tech.getStandardBonuses();
                shipToPlace.constructionBonuses = Tech.getStandardBonuses();
                shipToPlace.repair();
                PlaceShipTool pst = new PlaceShipTool(shipToPlace, false, this.side, this.sideIndex);
                pst.multiPlace = true;
                this.us.tool = pst;
            }
            catch (Loadable.NotFoundException e) {
                this.g.showError(e.getMessage());
            }
            catch (Exception e) {
                this.g.reportError(Lang._t("Unable_to_load_" + this.type.name(), new Object[0]), e, null, false);
            }
        }

        @Override
        public void cancelled() {
            this.g.s = this.us;
        }
    }
}

