/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Achievement;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.Keys;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MainMenu;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.Screen;
import com.zarkonnen.catengine.Hooks;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.Rect;
import com.zarkonnen.catengine.util.ScreenMode;
import java.util.ArrayList;

public strictfp class AchievementsScreen
implements Screen {
    public AirshipGame g;

    public AchievementsScreen(AirshipGame g) {
        this.g = g;
    }

    @Override
    public void input(Input in, MyDraw.State drawState, Pt cursor, Pt click, int ms) {
        if (in.keyPressed("ESCAPE") || in.keyPressed(Keys.get("leave", "L"))) {
            this.g.s = new MainMenu(this.g, MainMenu.Submenu.SETTINGS_AND_INFO);
        }
    }

    @Override
    public void render(MyDraw d, ScreenMode sm, Hooks hs, Pt cursor) {
        d.drawBG(MyDraw.SCREEN_BG, sm);
        d.drawTopBar(sm);
        d.button(sm.width - MyDraw.SIDE_CLEARANCE - d.bw(Lang._t("Leave", new Object[0])), MyDraw.TOP_BAR_INSET, d.bw(Lang._t("Leave", new Object[0])), Lang._t("Leave", new Object[0]), Keys.get("leave", "L"), new Runnable(){

            @Override
            public void run() {
                AchievementsScreen.this.g.s = new MainMenu(AchievementsScreen.this.g, MainMenu.Submenu.SETTINGS_AND_INFO);
            }
        });
        int y = MyDraw.TOP_BAR_H + MyDraw.UI_SPACING;
        int x = MyDraw.SIDE_CLEARANCE;
        d.text(Lang._t("Achievements", new Object[0]), AGame.BIG_FOUNT, MyDraw.SIDE_CLEARANCE, MyDraw.TOP_BAR_INSET);
        int maxColW = 0;
        for (Achievement a : Achievement.values()) {
            int maxTextW = sm.width - x - 68 - MyDraw.UI_SPACING - MyDraw.SIDE_CLEARANCE;
            Rect textSize = d.textSize(a.displayName.toUpperCase() + "\n" + a.desc, AGame.FOUNT, 0.0, 0.0, maxTextW);
            int h = StrictMath.max((int)textSize.height, 68);
            int w = 68 + MyDraw.UI_SPACING + (int)textSize.width + MyDraw.UI_SPACING;
            maxColW = StrictMath.max(w, maxColW);
            if (y + h > sm.height - MyDraw.SIDE_CLEARANCE) {
                x += maxColW;
                y = MyDraw.TOP_BAR_H + MyDraw.UI_SPACING * 2;
                maxColW = 0;
            }
            boolean ia = Achievement.isAchieved(a);
            d.drawPanel(x, y, 68, 68);
            d.blit(ia ? a.logo : a.offLogo, x + 2, y + 2);
            d.text((ia ? MyDraw.SELECTED_C : "") + a.displayName.toUpperCase() + "\n" + a.desc, AGame.FOUNT, x + 68 + MyDraw.UI_SPACING, y, maxTextW);
            y += h + MyDraw.UI_SPACING;
        }
    }

    @Override
    public ArrayList<String> music() {
        return AGame.NO_MUSIC;
    }

    @Override
    public String appearancePostfix() {
        return "DAY";
    }

    @Override
    public boolean alwaysUseAppearancePostfix() {
        return false;
    }
}

