/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.ChallengeCombatIntent;
import com.zarkonnen.airships.ChallengeEditShipIntent;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.EditShipIntent;
import com.zarkonnen.airships.Fleet;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.ScreenMode;

public strictfp class ZoomToFitButton
extends UniScreen.Button {
    @Override
    public boolean visible(UniScreen us) {
        return !(us.intent instanceof ChallengeEditShipIntent) && !(us.intent instanceof ChallengeCombatIntent);
    }

    @Override
    public String text(UniScreen us) {
        return Lang._t("Zoom_to_fit", new Object[0]);
    }

    @Override
    public void click(Input in, UniScreen us) {
        ZoomToFitButton.zoomToFit(in, us, 1.0);
    }

    public static void zoomOut(Input in, UniScreen us) {
        us.zoom = Math.max(0.49 * (double)in.mode().width / 1536.0, StrictMath.min(1.5151515151515152E-4 * (double)in.mode().width, 5.555555555555556E-4 * (double)in.mode().height));
        us.scrollX = 0;
        us.scrollY = 0;
    }

    public static void zoomOutToDefences(Input in, UniScreen us) {
        us.zoom = Math.max(0.49 * (double)in.mode().width / 1536.0, StrictMath.min(1.5151515151515152E-4 * (double)in.mode().width, 5.555555555555556E-4 * (double)in.mode().height));
        us.scrollX = (int)(-3200.0 / us.zoom);
        us.scrollY = 0;
    }

    public static void zoomToFit(Input in, UniScreen us, double mixFactor) {
        int left = 10000;
        int right = -10000;
        int top = 10000;
        int bottom = -10000;
        boolean hasShips = false;
        if (us.combat != null) {
            for (Combat.Side s : us.combat.sides) {
                for (Airship ship : s.ships) {
                    if (!ship.inCombat(us.combat) && !ship.hasFlyers()) continue;
                    hasShips = true;
                    left = StrictMath.min(ship.getIntX() - 100, left);
                    right = StrictMath.max(ship.getIntX() + ship.getWidth() * 16 + 100, right);
                    top = StrictMath.min(ship.getIntY() - 100, top);
                    bottom = StrictMath.max(ship.getIntY() + ship.getHeight() * 16 + 100, bottom);
                }
            }
            if (!hasShips) {
                for (Combat.Side s : us.combat.sides) {
                    for (Airship ship : s.ships) {
                        hasShips = true;
                        left = StrictMath.min(ship.getIntX() - 100, left);
                        right = StrictMath.max(ship.getIntX() + ship.getWidth() * 16 + 100, right);
                        top = StrictMath.min(ship.getIntY() - 100, top);
                        bottom = StrictMath.max(ship.getIntY() + ship.getHeight() * 16 + 100, bottom);
                    }
                }
            }
        } else if (us.city != null) {
            for (Airship ship : us.city.getDefences()) {
                hasShips = true;
                left = StrictMath.min(ship.getIntX() - 100, left);
                right = StrictMath.max(ship.getIntX() + ship.getWidth() * 16 + 100, right);
                top = StrictMath.min(ship.getIntY() - 100, top);
                bottom = StrictMath.max(ship.getIntY() + ship.getHeight() * 16 + 100, bottom);
            }
            Fleet fl = us.wm.getGarrison(us.city);
            if (fl != null) {
                for (Airship ship : fl.actives) {
                    hasShips = true;
                    left = StrictMath.min(ship.getIntX() - 100, left);
                    right = StrictMath.max(ship.getIntX() + ship.getWidth() * 16 + 100, right);
                    top = StrictMath.min(ship.getIntY() - 100, top);
                    bottom = StrictMath.max(ship.getIntY() + ship.getHeight() * 16 + 100, bottom);
                }
            }
        } else if (us.standaloneEditShip != null && !us.standaloneEditShip.modules.isEmpty()) {
            Airship ship = us.standaloneEditShip;
            hasShips = true;
            left = StrictMath.min(ship.getIntX() - 100, left);
            right = StrictMath.max(ship.getIntX() + ship.getWidth() * 16 + 100, right);
            top = StrictMath.min(ship.getIntY() - 100, top);
            bottom = StrictMath.max(ship.getIntY() + ship.getHeight() * 16 + 100, bottom);
        }
        if (!hasShips) {
            return;
        }
        ScreenMode sm = in.mode();
        left = StrictMath.max(left, -3199);
        right = StrictMath.min(right, 3199);
        bottom = StrictMath.min(bottom, 832);
        int w = right - left;
        double wZoom = 1.0 / (double)w * (double)sm.width;
        int h = bottom - top;
        double hZoom = 1.0 / (double)h * (double)sm.height;
        double zoom = StrictMath.min(wZoom, hZoom);
        double scrollX = -left - w / 2;
        double scrollY = -top - h / 2;
        us.zoom = us.zoom * (1.0 - mixFactor) + zoom * mixFactor;
        us.scrollX = (int)((double)us.scrollX * (1.0 - mixFactor) + scrollX * mixFactor);
        us.scrollY = (int)((double)us.scrollY * (1.0 - mixFactor) + scrollY * mixFactor);
        if (us.intent instanceof ChallengeCombatIntent) {
            us.zoom *= 0.65;
        }
    }

    public static void zoomToEditShip(Input in, UniScreen us) {
        if (!(us.intent instanceof EditShipIntent)) {
            return;
        }
        int panelW = StrictMath.max(320, (int)((double)in.mode().width * 0.3));
        Airship ship = ((EditShipIntent)us.intent).getShip(us);
        int left = StrictMath.min(ship.getIntX() - 100, 10000);
        int right = StrictMath.max(ship.getIntX() + ship.getWidth() * 16 + 100, -10000);
        int top = StrictMath.min(ship.getIntY() - 100, 10000);
        int bottom = StrictMath.max(ship.getIntY() + ship.getHeight() * 16 + 100, -10000);
        ScreenMode sm = in.mode();
        int w = right - left;
        double wZoom = 1.0 / (double)w * (double)(sm.width - panelW);
        int h = bottom - top;
        double hZoom = 1.0 / (double)h * (double)sm.height;
        us.zoom = StrictMath.min(wZoom, hZoom);
        us.scrollX = -left - w / 2 + (int)((double)(panelW / 2) / us.zoom);
        us.scrollY = -top - h / 2;
        if (us.intent instanceof ChallengeEditShipIntent) {
            us.scrollY = (int)((double)us.scrollY + 100.0 / us.zoom);
        }
    }

    @Override
    public String hotkey(UniScreen us) {
        return null;
    }
}

