/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Body;
import com.zarkonnen.airships.MiscCombatSound;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.Particle;
import com.zarkonnen.airships.ParticleType;
import com.zarkonnen.airships.Rect2D;
import com.zarkonnen.airships.TimeOfDay;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Clr;
import java.util.ArrayList;
import org.lwjgl.opengl.GL11;
import org.newdawn.slick.opengl.TextureImpl;

public strictfp class WeatherVisualLayer
implements UniScreen.VisualLayer {
    public ArrayList<Drop> drops = new ArrayList();
    public static final int N_SNOW = 1000;
    public static final int N_RAIN = 120;
    public static final int N_FEW_STARS = 100;
    public static final int N_MANY_STARS = 1000;
    public static final Clr RAIN_C = new Clr(191, 191, 191, 128);
    public static final Clr DUST_C = new Clr(51, 26, 8, 128);
    public static final Clr STAR_C = new Clr(255, 255, 255, 128);
    public static final Clr STAR_C_BRIGHT = new Clr(255, 255, 255, 192);
    private int ticksDone = 0;

    @Override
    public void tick(Input in, int ms, UniScreen us) {
        block14: {
            TimeOfDay tod;
            block16: {
                block15: {
                    int i;
                    block13: {
                        int i2;
                        if (this.ticksDone++ < 3) {
                            return;
                        }
                        if (!us.isTimeMoving()) {
                            ms = 0;
                        }
                        tod = us.getTimeOfDay();
                        if (!tod.effect.snow) break block13;
                        if (this.drops.isEmpty()) {
                            this.drops.ensureCapacity(1000);
                            for (i2 = 0; i2 < 1000; ++i2) {
                                this.drops.add(new Drop(AGame.ANIM_R.nextInt(6400) - 3200, AGame.ANIM_R.nextInt(2500) + 512 - 2500, 0.0, 0.01 + AGame.ANIM_R.nextDouble() * 0.02));
                            }
                        }
                        for (i2 = 0; i2 < 1000; ++i2) {
                            Drop d = this.drops.get(i2);
                            d.y += d.dy * (double)ms;
                            if (us.combat != null && us.combat.physics != null) {
                                int bsz = us.combat.physics.bodies.size();
                                for (int bi = 0; bi < bsz; ++bi) {
                                    Body b = us.combat.physics.bodies.get(bi);
                                    if (b == us.combat.landFormations.get(0) || !b.canParticleStick(d.x, d.y)) continue;
                                    Particle snowP = new Particle(ParticleType.ofName("ground_snow"), d.x - b.getX(), d.y - b.getY(), 0.0, 0.0);
                                    b.stuckParticles.add(snowP);
                                    d.y = -1988.0;
                                    d.x = AGame.ANIM_R.nextInt(6400) - 3200;
                                    break;
                                }
                            }
                            if (!(d.y > 512.0)) continue;
                            d.y = -1988.0;
                        }
                        break block14;
                    }
                    if (!tod.effect.rain) break block15;
                    if (this.drops.isEmpty()) {
                        this.drops.ensureCapacity(120);
                        for (i = 0; i < 120; ++i) {
                            this.drops.add(new Drop(AGame.ANIM_R.nextInt(6400) - 3200, AGame.ANIM_R.nextInt(2660) + 512 - 2500, 0.0, 0.7 + AGame.ANIM_R.nextDouble() * 0.2, 20 + AGame.ANIM_R.nextInt(10)));
                        }
                    }
                    for (i = 0; i < 120; ++i) {
                        Drop d = this.drops.get(i);
                        d.y += d.dy * (double)ms;
                        if (!(d.y + (double)d.size > 672.0)) continue;
                        d.y = -1988.0;
                        d.x = AGame.ANIM_R.nextInt(6400) - 3200;
                    }
                    if (us.combat == null || AGame.ANIM_R.nextInt(1000) != 0) break block14;
                    us.combat.play(MiscCombatSound.THUNDER, -1488.0, AGame.ANIM_R.nextInt(6400) - 3200, 0.0, 0.0, false);
                    break block14;
                }
                if (!tod.effect.fewStars) break block16;
                if (!this.drops.isEmpty()) break block14;
                this.drops.ensureCapacity(100);
                for (int i = 0; i < 100; ++i) {
                    this.drops.add(new Drop(AGame.ANIM_R.nextInt(6400) - 3200, AGame.ANIM_R.nextInt(2660) + 512 - 2500, 0.1 + AGame.ANIM_R.nextDouble(), 0.0, AGame.ANIM_R.nextInt(20)));
                }
                break block14;
            }
            if (tod.effect.manyStars && this.drops.isEmpty()) {
                this.drops.ensureCapacity(1000);
                for (int i = 0; i < 1000; ++i) {
                    this.drops.add(new Drop(AGame.ANIM_R.nextInt(6400) - 3200, AGame.ANIM_R.nextInt(2660) + 512 - 2500, 0.1 + AGame.ANIM_R.nextDouble(), 0.0, AGame.ANIM_R.nextInt(20)));
                }
            }
        }
    }

    @Override
    public void draw(MyDraw d, UniScreen us, double cropX, double cropY, double cropW, double cropH) {
        TextureImpl.bindNone();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glBegin((int)7);
        TimeOfDay tod = us.getTimeOfDay();
        if (tod.effect.snow) {
            double sz = StrictMath.max(2.0, 1.5 / us.zoom);
            if (!this.drops.isEmpty()) {
                for (int i = 0; i < 1000; ++i) {
                    Drop drop = this.drops.get(i);
                    if (!Rect2D.contains(cropX, cropY, cropW, cropH, drop.x, drop.y)) continue;
                    GL11.glVertex2d((double)(drop.x + sz), (double)drop.y);
                    GL11.glVertex2d((double)(drop.x + sz), (double)(drop.y + sz));
                    GL11.glVertex2d((double)drop.x, (double)(drop.y + sz));
                    GL11.glVertex2d((double)drop.x, (double)drop.y);
                }
            }
        } else if (tod.effect.rain) {
            double sz = 1.1 / us.zoom;
            GL11.glColor4f((float)0.75f, (float)0.75f, (float)0.75f, (float)0.5f);
            if (!this.drops.isEmpty()) {
                for (int i = 0; i < 120; ++i) {
                    Drop drop = this.drops.get(i);
                    if (!Rect2D.contains(cropX, cropY, cropW, cropH, drop.x, drop.y)) continue;
                    GL11.glVertex2d((double)(drop.x + sz), (double)drop.y);
                    GL11.glVertex2d((double)(drop.x + sz), (double)(drop.y + (double)drop.size));
                    GL11.glVertex2d((double)drop.x, (double)(drop.y + (double)drop.size));
                    GL11.glVertex2d((double)drop.x, (double)drop.y);
                }
            }
        } else if (tod.effect.fewStars || tod.effect.manyStars) {
            double sz = 1.0 / us.zoom;
            for (int i = 0; i < this.drops.size(); ++i) {
                Drop drop = this.drops.get(i);
                if (!Rect2D.contains(cropX, cropY, cropW, cropH, drop.x, drop.y)) continue;
                if (this.ticksDone / 20 % 20 == drop.size) {
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)(StrictMath.min(0.5, 0.5 * us.zoom) * drop.dx)));
                } else {
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)(StrictMath.min(0.75, 0.75 * us.zoom) * drop.dx)));
                }
                GL11.glVertex2d((double)(drop.x + sz), (double)drop.y);
                GL11.glVertex2d((double)(drop.x + sz), (double)(drop.y + sz));
                GL11.glVertex2d((double)drop.x, (double)(drop.y + sz));
                GL11.glVertex2d((double)drop.x, (double)drop.y);
            }
        }
        GL11.glEnd();
    }

    public strictfp class Drop {
        public double x;
        public double y;
        public double dx;
        public double dy;
        public int size;

        public Drop(double x, double y, double dx, double dy) {
            this.x = x;
            this.y = y;
            this.dx = dx;
            this.dy = dy;
        }

        public Drop(double x, double y, double dx, double dy, int size) {
            this.x = x;
            this.y = y;
            this.dx = dx;
            this.dy = dy;
            this.size = size;
        }
    }
}

