/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.Analytics;
import com.zarkonnen.airships.CampaignCombatSetupIntent;
import com.zarkonnen.airships.ChallengeCombatIntent;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.CombatIntent;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MissionCombatIntent;
import com.zarkonnen.airships.MissionSequence;
import com.zarkonnen.airships.MultiplayerCampaignCombatSetupIntent;
import com.zarkonnen.airships.MultiplayerCombatIntent;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.SingleCombatIntent;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Fount;
import com.zarkonnen.catengine.Hooks;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.Rect;
import com.zarkonnen.catengine.util.ScreenMode;
import java.io.IOException;
import java.util.ArrayList;

public strictfp class VictoryOrDefeatOverlay
implements UniScreen.InfoPanel {
    public Combat cachedC;
    public ArrayList<ArrayList<String>> lines = new ArrayList();

    @Override
    public void draw(MyDraw d, Pt cursor, ScreenMode sm, Hooks hs, final UniScreen us) {
        if (us.hideUI) {
            return;
        }
        if (us.intent instanceof ChallengeCombatIntent) {
            return;
        }
        if (us.intent instanceof CombatIntent && ((CombatIntent)us.intent).spectate()) {
            return;
        }
        if (us.mySide == null) {
            return;
        }
        if (us.combat != null && us.combat.isFinished()) {
            Pt dims;
            if (us.intent instanceof MissionCombatIntent) {
                MissionCombatIntent mci = (MissionCombatIntent)us.intent;
                String title = null;
                String msg = null;
                if (us.combat.won(us.mySide) && !mci.m.getText(MissionSequence.Mission.TextSlot.victory).isEmpty()) {
                    title = Lang._t("VICTORY", new Object[0]);
                    msg = mci.m.getText(MissionSequence.Mission.TextSlot.victory);
                }
                if (!us.combat.won(us.mySide) && !mci.m.getText(MissionSequence.Mission.TextSlot.defeat).isEmpty()) {
                    title = Lang._t("DEFEAT", new Object[0]);
                    msg = mci.m.getText(MissionSequence.Mission.TextSlot.defeat);
                }
                if (title != null) {
                    int y = MyDraw.TOP_BAR_H + MyDraw.UI_SPACING;
                    d.text(mci.seq.getName(), AGame.HUGE_FOUNT, sm.width / 2 - (int)d.textSize((String)mci.seq.getName(), (Fount)AGame.HUGE_FOUNT).x / 2, y);
                    Rect msgSize = d.textSize(msg, AGame.FOUNT, 0.0, 0.0, 300 - MyDraw.WINDOW_INSET * 2);
                    int msgW = (int)StrictMath.ceil(msgSize.width);
                    int msgH = (int)StrictMath.ceil(msgSize.height);
                    int x = sm.width / 2 - msgW / 2;
                    d.drawWindow(x, y += AGame.HUGE_FOUNT.height + MyDraw.UI_SPACING, msgW + MyDraw.WINDOW_INSET * 2, msgH + MyDraw.WINDOW_INSET * 2 + MyDraw.BUTTON_H + MyDraw.UI_SPACING);
                    d.text(msg, AGame.FOUNT, x += MyDraw.WINDOW_INSET, y += MyDraw.WINDOW_INSET, 300 - MyDraw.WINDOW_INSET * 2);
                    d.button(x, y += msgH + MyDraw.UI_SPACING, d.bw(Lang._t("OK", new Object[0])), Lang._t("OK", new Object[0]), new Runnable(){

                        @Override
                        public void run() {
                            VictoryOrDefeatOverlay.this.ok(us);
                        }
                    });
                    return;
                }
            }
            int y = MyDraw.TOP_BAR_H + MyDraw.UI_SPACING;
            if (us.combat.isRaid) {
                dims = d.textSize(Lang._t("RAID_COMPLETE", new Object[0]), AGame.HUGE_FOUNT);
                d.borderedText(Lang._t("RAID_COMPLETE", new Object[0]), AGame.HUGE_FOUNT, Clr.BLACK, Clr.WHITE, (int)((double)(sm.width / 2) - dims.x / 2.0), y);
            } else if (us.combat.won(us.mySide)) {
                dims = d.textSize(Lang._t("VICTORY", new Object[0]), AGame.HUGE_FOUNT);
                d.borderedText(Lang._t("VICTORY", new Object[0]), AGame.HUGE_FOUNT, Clr.BLACK, Clr.WHITE, (int)((double)(sm.width / 2) - dims.x / 2.0), y);
            } else if (us.combat.won(us.combat.otherSide(us.mySide))) {
                dims = d.textSize(Lang._t("DEFEAT", new Object[0]), AGame.HUGE_FOUNT);
                d.borderedText(Lang._t("DEFEAT", new Object[0]), AGame.HUGE_FOUNT, Clr.BLACK, Clr.WHITE, (int)((double)(sm.width / 2) - dims.x / 2.0), y);
            } else {
                dims = d.textSize(Lang._t("DRAW", new Object[0]), AGame.HUGE_FOUNT);
                d.borderedText(Lang._t("DRAW", new Object[0]), AGame.HUGE_FOUNT, Clr.BLACK, Clr.WHITE, (int)((double)(sm.width / 2) - dims.x / 2.0), y);
            }
            d.button(sm.width / 2 - d.bw(Lang._t("OK", new Object[0])) / 2, y += AGame.HUGE_FOUNT.height, d.bw(Lang._t("OK", new Object[0])), Lang._t("OK", new Object[0]), new Runnable(){

                @Override
                public void run() {
                    VictoryOrDefeatOverlay.this.ok(us);
                }
            });
            y += MyDraw.BUTTON_H + MyDraw.UI_SPACING;
            this.genLines(us.combat);
            int w = 0;
            int[] colW = new int[4];
            for (int colI = 0; colI < 4; ++colI) {
                ArrayList<String> col = this.lines.get(colI);
                for (String l : col) {
                    colW[colI] = StrictMath.max(colW[colI], (int)d.textSize((String)l, (Fount)AGame.FOUNT).x);
                }
                w += colW[colI];
            }
            int x = sm.width / 2 - (w += MyDraw.UI_SPACING * 4 + MyDraw.WINDOW_INSET * 2) / 2;
            int nLines = StrictMath.min(StrictMath.max(this.lines.get(0).size(), this.lines.get(2).size()), (sm.height - y - AGame.FOUNT.lineHeight) / AGame.FOUNT.lineHeight);
            int h = nLines * AGame.FOUNT.lineHeight + MyDraw.WINDOW_INSET * 2;
            d.drawWindow(x, y, w, h);
            x += MyDraw.WINDOW_INSET;
            y += MyDraw.WINDOW_INSET;
            w -= MyDraw.WINDOW_INSET * 2;
            for (int i = 0; i < StrictMath.max(this.lines.get(0).size(), this.lines.get(2).size()); ++i) {
                if (i < this.lines.get(0).size()) {
                    d.text(this.lines.get(0).get(i), AGame.FOUNT, x, y + i * AGame.FOUNT.lineHeight);
                }
                if (i < this.lines.get(1).size()) {
                    d.text(this.lines.get(1).get(i), AGame.FOUNT, x + colW[0] + MyDraw.UI_SPACING, y + i * AGame.FOUNT.lineHeight);
                }
                if (i < this.lines.get(2).size()) {
                    d.text(this.lines.get(2).get(i), AGame.FOUNT, x + colW[0] + colW[1] + MyDraw.UI_SPACING * 3, y + i * AGame.FOUNT.lineHeight);
                }
                if (i >= this.lines.get(3).size()) continue;
                d.text(this.lines.get(3).get(i), AGame.FOUNT, x + colW[0] + colW[1] + colW[2] + MyDraw.UI_SPACING * 4, y + i * AGame.FOUNT.lineHeight);
            }
        }
    }

    private void ok(UniScreen us) {
        if (us.intent instanceof SingleCombatIntent) {
            if (us.combat.won(us.mySide)) {
                Analytics.singleCombatVictory();
            } else {
                Analytics.singleCombatDefeat();
            }
        }
        if (us.intent instanceof MultiplayerCombatIntent) {
            if (us.combat.won(us.mySide)) {
                Analytics.mpVictory(us.g.lanClient != null);
            } else {
                Analytics.mpDefeat(us.g.lanClient != null);
            }
        }
        try {
            us.combat.saveRecording();
        }
        catch (IOException e) {
            e.printStackTrace();
            us.g.showError(Lang._t("Unable_to_save_combat_recording.", new Object[0]));
        }
        if (us.intent instanceof CombatIntent) {
            ((CombatIntent)us.intent).leave(us);
        }
        if (us.intent instanceof CampaignCombatSetupIntent) {
            ((CampaignCombatSetupIntent)us.intent).leave(us);
        }
        if (us.intent instanceof MultiplayerCampaignCombatSetupIntent) {
            ((MultiplayerCampaignCombatSetupIntent)us.intent).leave(us);
        }
    }

    @Override
    public void tick(Input in, int ms, UniScreen us) {
        if (us.intent instanceof ChallengeCombatIntent) {
            return;
        }
        if (us.intent instanceof CombatIntent && ((CombatIntent)us.intent).spectate()) {
            return;
        }
        if (us.mySide == null) {
            return;
        }
        if (us.combat != null && us.combat.isFinished() && in.keyPressed("ENTER")) {
            this.ok(us);
        }
    }

    @Override
    public boolean chatEnabled(UniScreen us) {
        return false;
    }

    @Override
    public boolean doScroll(UniScreen us, int scrollAmt, Pt cursor, ScreenMode sm) {
        return false;
    }

    private String pad(String s, int n) {
        while (s.length() < n) {
            s = s + " ";
        }
        return s;
    }

    private void genLines(Combat c) {
        if (c == this.cachedC) {
            return;
        }
        this.cachedC = c;
        for (int i = 0; i < 4; ++i) {
            ArrayList<String> ls = new ArrayList<String>();
            this.lines.add(ls);
            if (c.isRaid) {
                if (i == 0) {
                    ls.add(Lang._t("raiding_looted_" + c.lootAmount, new Object[0]));
                } else {
                    ls.add("");
                }
                ls.add("");
            }
            int sideIndex = i / 2;
            boolean names = i % 2 == 0;
            Combat.Side s = c.sides.get(sideIndex);
            Combat.Side otherS = c.sides.get(sideIndex == 0 ? 1 : 0);
            ls.add(names ? s.getName().toUpperCase() : "");
            ls.add("");
            for (Airship ship : s.originalComposition) {
                if (names) {
                    ls.add(ship.getName());
                    continue;
                }
                if (!s.ships.contains(ship) && !s.reserve.contains(ship)) {
                    if (otherS.ships.contains(ship) || otherS.reserve.contains(ship)) {
                        ls.add(MyDraw.ERROR_C + Lang._t("CAPTURED", new Object[0]) + "[]");
                        continue;
                    }
                    ls.add(MyDraw.ERROR_C + Lang._t("DESTROYED", new Object[0]) + "[]");
                    continue;
                }
                String err = ship.uselessReason();
                if (err == null) {
                    err = ship.harmlessReason();
                    if (err == null) {
                        if (s.surrendered) {
                            ls.add("[99ff99]" + Lang._t(ship.type.mobile && c.isRaid ? "ESCAPED" : "SURRENDERED", new Object[0]) + "[]");
                            continue;
                        }
                        ls.add("[99ff99]" + Lang._t("SURVIVED", new Object[0]) + "[]");
                        continue;
                    }
                    ls.add(err.toUpperCase());
                    continue;
                }
                ls.add(MyDraw.ERROR_C + err.toUpperCase());
            }
        }
    }

    @Override
    public boolean arrowKeysInUse(UniScreen us) {
        return false;
    }
}

