/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.codedisaster.steamworks.SteamPublishedFileID;
import com.codedisaster.steamworks.SteamPublishedFileUpdateHandle;
import com.codedisaster.steamworks.SteamRemoteStorage;
import com.codedisaster.steamworks.SteamRemoteStorageCallback;
import com.codedisaster.steamworks.SteamResult;
import com.codedisaster.steamworks.SteamUGCHandle;
import com.elliotkroo.GifSequenceWriter;
import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.PublishedItemsManager;
import com.zarkonnen.airships.SteamBackend;
import com.zarkonnen.catengine.util.Clr;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.newdawn.slick.Color;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;

public strictfp class UploadShipProcess
implements SteamRemoteStorageCallback {
    final Airship ship;
    final PublishedItemsManager.Entry doUpdate;
    public MyDraw d;
    final String desc;
    final ArrayList<String> tags;
    String baseName;
    String previewName;
    boolean inited;
    boolean failed;
    byte[] shipData = null;
    byte[] previewImageData = null;
    boolean uploadedShip;
    boolean uploadedPreview;
    boolean publishing;
    boolean published;
    boolean cleanedUp;
    String publishError = null;
    public boolean needsWLA = false;
    public long needsWLAId = -1L;

    public UploadShipProcess(Airship ship, String desc, ArrayList<String> tags, PublishedItemsManager.Entry doUpdate) {
        this.ship = ship;
        this.desc = desc;
        this.tags = tags;
        this.doUpdate = doUpdate;
    }

    public Progress tick() {
        if (this.failed) {
            return new Progress(true, true, 1, 1, Lang._t("Publishing_failed", new Object[0]) + (this.publishError != null ? "\n" + this.publishError : ""));
        }
        if (!this.inited) {
            this.inited = true;
            this.baseName = this.ship.type.name() + "-" + System.currentTimeMillis() + "-" + this.ship.getName();
            this.previewName = "preview-" + this.baseName;
            return new Progress(false, false, 0, 5, Lang._t("Preparing_data", new Object[0]));
        }
        if (this.shipData == null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                OutputStreamWriter osw = new OutputStreamWriter((OutputStream)baos, "UTF-8");
                osw.write(this.ship.toJSON(null).toString());
                osw.flush();
                osw.close();
                this.shipData = baos.toByteArray();
            }
            catch (Exception e) {
                this.failed = true;
                e.printStackTrace();
                return new Progress(true, true, 1, 1, Lang._t("Unable_to_prepare_data", new Object[0]) + ": " + e.getMessage());
            }
            return new Progress(false, false, 1, 5, Lang._t("Preparing_preview", new Object[0]));
        }
        if (this.d == null) {
            return new Progress(false, false, 1, 5, Lang._t("Preparing_preview", new Object[0]));
        }
        if (this.previewImageData == null) {
            try {
                double shipW = 460.8;
                double scale = StrictMath.min(shipW / (double)this.ship.getWidth() / 16.0, shipW / (double)this.ship.getHeight() / 16.0);
                this.d.rect(AGame.SKY, 0.0, 0.0, 512.0, 512.0);
                this.d.shift(25.6, 25.6);
                this.d.scale(scale, scale);
                this.ship.draw(this.d, shipW / scale / 2.0 - (double)(this.ship.getWidth() * 16 / 2), shipW / scale / 2.0 - (double)(this.ship.getHeight() * 16 / 2), 0, true, false, true, AirshipGame.instance.getBestCOA(), true, null, 1.0f, Color.white, 1.0f, Clr.WHITE);
                this.d.resetTransforms();
                Image previewImg = new Image(512, 512);
                ((Graphics)this.d.frame().nativeRenderer()).copyArea(previewImg, 0, 0);
                byte[] rawImgData = previewImg.getTexture().getTextureData();
                ByteBuffer bb = ByteBuffer.allocate(rawImgData.length);
                bb.put(rawImgData);
                bb.rewind();
                IntBuffer ib = bb.asIntBuffer();
                previewImg.destroy();
                BufferedImage frame1 = new BufferedImage(512, 512, 1);
                for (int y = 0; y < 512; ++y) {
                    for (int x = 0; x < 512; ++x) {
                        int off = y * 512 + x;
                        int clr = ib.get(off) >> 8;
                        frame1.setRGB(x, 511 - y, clr);
                    }
                }
                this.d.rect(AGame.SKY, 0.0, 0.0, 512.0, 512.0);
                this.d.shift(25.6, 25.6);
                this.d.scale(scale, scale);
                this.ship.draw(this.d, shipW / scale / 2.0 - (double)(this.ship.getWidth() * 16 / 2), shipW / scale / 2.0 - (double)(this.ship.getHeight() * 16 / 2), 0, false, false, true, AirshipGame.instance.getBestCOA(), true, null, 1.0f, Color.white, 1.0f, Clr.WHITE);
                this.d.resetTransforms();
                previewImg = new Image(512, 512);
                ((Graphics)this.d.frame().nativeRenderer()).copyArea(previewImg, 0, 0);
                rawImgData = previewImg.getTexture().getTextureData();
                bb = ByteBuffer.allocate(rawImgData.length);
                bb.put(rawImgData);
                bb.rewind();
                ib = bb.asIntBuffer();
                previewImg.destroy();
                BufferedImage frame2 = new BufferedImage(512, 512, 1);
                for (int y = 0; y < 512; ++y) {
                    for (int x = 0; x < 512; ++x) {
                        int off = y * 512 + x;
                        int clr = ib.get(off) >> 8;
                        frame2.setRGB(x, 511 - y, clr);
                    }
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                MemoryCacheImageOutputStream mcios = new MemoryCacheImageOutputStream(baos);
                GifSequenceWriter gsw = new GifSequenceWriter(mcios, 1, 4000, true);
                gsw.writeToSequence(frame1);
                gsw.writeToSequence(frame2);
                gsw.close();
                mcios.flush();
                mcios.close();
                this.previewImageData = baos.toByteArray();
            }
            catch (Exception e) {
                this.failed = true;
                e.printStackTrace();
                return new Progress(true, true, 1, 1, Lang._t("Unable_to_prepare_preview", new Object[0]) + ": " + e.getMessage());
            }
            return new Progress(false, false, 2, 5, Lang._t("Uploading_", new Object[0]));
        }
        if (!this.uploadedShip) {
            try {
                SteamBackend.writeFile(this.baseName, this.shipData);
                this.uploadedShip = true;
            }
            catch (Exception e) {
                this.failed = true;
                e.printStackTrace();
                return new Progress(true, true, 1, 1, Lang._t("Unable_to_upload", new Object[0]) + ": " + e.getMessage());
            }
            return new Progress(false, false, 3, 5, Lang._t("Uploading_preview_", new Object[0]));
        }
        if (!this.uploadedPreview) {
            try {
                SteamBackend.writeFile(this.previewName, this.previewImageData);
                this.uploadedPreview = true;
            }
            catch (Exception e) {
                this.failed = true;
                e.printStackTrace();
                return new Progress(true, true, 1, 1, Lang._t("Unable_to_upload_preview", new Object[0]) + ":" + e.getMessage());
            }
            return new Progress(false, false, 4, 5, Lang._t("Publishing_", new Object[0]));
        }
        if (!this.publishing) {
            try {
                String tag = "Constructions";
                switch (this.ship.type) {
                    case AIRSHIP: {
                        tag = "Airships";
                        break;
                    }
                    case LANDSHIP: {
                        tag = "Landships";
                        break;
                    }
                    case BUILDING: {
                        tag = "Buildings";
                    }
                }
                ArrayList<String> myTags = new ArrayList<String>();
                myTags.add(tag);
                myTags.addAll(this.tags);
                if (this.doUpdate != null) {
                    SteamPublishedFileUpdateHandle spfuh = SteamBackend.storage.createPublishedFileUpdateRequest(this.doUpdate.fileID);
                    SteamBackend.storage.updatePublishedFileFile(spfuh, this.baseName);
                    SteamBackend.storage.updatePublishedFilePreviewFile(spfuh, this.previewName);
                    SteamBackend.storage.updatePublishedFileDescription(spfuh, this.desc);
                    SteamBackend.storage.updatePublishedFileTags(spfuh, AGame.normalizeTags(myTags.toArray(new String[myTags.size()])));
                    SteamBackend.storage.commitPublishedFileUpdate(spfuh);
                    SteamBackend.remoteStorageCallback = this;
                } else {
                    SteamBackend.remoteStorageCallback = this;
                    SteamBackend.storage.publishWorkshopFile(this.baseName, this.previewName, 342560L, this.ship.getName(), this.desc, SteamRemoteStorage.PublishedFileVisibility.Public, AGame.normalizeTags(myTags.toArray(new String[myTags.size()])), SteamRemoteStorage.WorkshopFileType.Community);
                }
                this.publishing = true;
            }
            catch (Exception e) {
                this.failed = true;
                e.printStackTrace();
                return new Progress(true, true, 1, 1, Lang._t("Unable_to_publish", new Object[0]) + ": " + e.getMessage());
            }
            return new Progress(false, false, 4, 5, Lang._t("Publishing_", new Object[0]));
        }
        if (!this.published) {
            return new Progress(false, false, 4, 5, Lang._t("Publishing_", new Object[0]));
        }
        if (this.doUpdate != null && !this.cleanedUp) {
            try {
                SteamBackend.storage.fileDelete(this.doUpdate.fileName);
                SteamBackend.storage.fileDelete("preview-" + this.doUpdate.fileName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.cleanedUp = true;
        }
        return new Progress(true, false, 5, 5, Lang._t("Done", new Object[0]));
    }

    public void onFileShareResult(SteamUGCHandle fileHandle, String fileName, SteamResult sr) {
    }

    public void onDownloadUGCResult(SteamUGCHandle fileHandle, SteamResult sr) {
    }

    public void onPublishFileResult(SteamPublishedFileID publishedFileID, boolean needsToAcceptWLA, SteamResult sr) {
        if (sr == SteamResult.OK) {
            this.published = true;
            this.needsWLA = needsToAcceptWLA;
            this.needsWLAId = publishedFileID.getNativeHandle();
            PublishedItemsManager.put(this.ship.type.publishedItemType, this.ship.getName(), this.desc, this.tags, -1, publishedFileID, this.baseName);
        } else {
            this.failed = true;
            this.publishError = sr.name();
            this.needsWLA = false;
            this.needsWLAId = -1L;
        }
        SteamBackend.remoteStorageCallback = null;
    }

    public void onUpdatePublishedFileResult(SteamPublishedFileID publishedFileID, boolean needsToAcceptWLA, SteamResult sr) {
        if (sr == SteamResult.OK) {
            this.published = true;
            this.needsWLA = needsToAcceptWLA;
            PublishedItemsManager.put(this.ship.type.publishedItemType, this.doUpdate.title, this.desc, this.tags, this.doUpdate.modified, this.doUpdate.fileID, this.baseName);
        } else {
            this.failed = true;
            this.publishError = sr.name();
            this.needsWLA = false;
        }
        SteamBackend.remoteStorageCallback = null;
    }

    public strictfp static class Progress {
        public final boolean done;
        public final boolean failed;
        public final int progress;
        public final int total;
        public final String desc;

        public Progress(boolean done, boolean failed, int progress, int total, String desc) {
            this.done = done;
            this.failed = failed;
            this.progress = progress;
            this.total = total;
            this.desc = desc;
        }
    }
}

