/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.codedisaster.steamworks.SteamPublishedFileID;
import com.codedisaster.steamworks.SteamPublishedFileUpdateHandle;
import com.codedisaster.steamworks.SteamRemoteStorage;
import com.codedisaster.steamworks.SteamRemoteStorageCallback;
import com.codedisaster.steamworks.SteamResult;
import com.codedisaster.steamworks.SteamUGCHandle;
import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.Mod;
import com.zarkonnen.airships.PublishedItemsManager;
import com.zarkonnen.airships.SteamBackend;
import com.zarkonnen.airships.ZipUtils;
import com.zarkonnen.catengine.Input;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;

public strictfp class UploadModProcess
implements SteamRemoteStorageCallback {
    public final Mod mod;
    public final PublishedItemsManager.Entry doUpdate;
    private String baseName;
    private String previewName;
    private byte[] modData;
    private byte[] previewData;
    public String publishError = null;
    public boolean needsWLA = false;
    public long needsWLAId = -1L;
    public boolean inited;
    public boolean baked;
    public boolean zipped;
    public boolean uploadedMod;
    public boolean uploadedPreview;
    public boolean publishing;
    public boolean published;
    public boolean cleanedUp;
    public boolean failed;
    private static final int CHUNK = 4096;

    public UploadModProcess(Mod mod, PublishedItemsManager.Entry doUpdate) {
        this.mod = mod;
        this.doUpdate = doUpdate;
    }

    public Progress tick(Input in) {
        if (this.failed) {
            return new Progress(true, true, 1, 1, Lang._t("Publishing_failed", new Object[0]) + (this.publishError != null ? "\n" + this.publishError : ""));
        }
        if (!this.inited) {
            this.inited = true;
            this.baseName = "MOD-" + System.currentTimeMillis() + "-" + this.mod.id;
            this.previewName = "preview-" + this.baseName;
            return new Progress(false, false, 0, 8, Lang._t("Generating_graphics_for_x", this.mod.id));
        }
        if (!this.baked) {
            this.baked = true;
            boolean needsGenerateDerivedData = true;
            try {
                needsGenerateDerivedData = this.mod.needsGenerateDerivedData();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (needsGenerateDerivedData) {
                this.mod.regenerateDerivedData(in);
            }
            return new Progress(false, false, 1, 8, Lang._t("Preparing_data", new Object[0]));
        }
        if (!this.zipped) {
            this.zipped = true;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                ZipUtils.enzip(this.mod.dir, bos);
                this.modData = bos.toByteArray();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.publishError = Lang._t("Unable_to_compress_mod", new Object[0]) + ": " + e.getMessage();
                this.failed = true;
                return new Progress(true, true, 1, 1, this.publishError);
            }
            return new Progress(false, false, 2, 8, Lang._t("Uploading_", new Object[0]));
        }
        if (!this.uploadedMod) {
            this.uploadedMod = true;
            try {
                SteamBackend.writeFile(this.baseName, this.modData);
            }
            catch (Exception e) {
                this.failed = true;
                e.printStackTrace();
                return new Progress(true, true, 1, 1, Lang._t("Unable_to_upload", new Object[0]) + ": " + e.getMessage());
            }
            return new Progress(false, false, 3, 8, Lang._t("Uploading_", new Object[0]));
        }
        if (!this.uploadedPreview) {
            this.uploadedPreview = true;
            try {
                int l;
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                FileInputStream fis = new FileInputStream(new File(this.mod.dir, "logo.png"));
                byte[] data = new byte[4096];
                while ((l = fis.read(data)) != -1) {
                    bos.write(data, 0, l);
                }
                fis.close();
                this.previewData = bos.toByteArray();
                SteamBackend.writeFile(this.previewName, this.previewData);
            }
            catch (Exception e) {
                this.failed = true;
                e.printStackTrace();
                return new Progress(true, true, 1, 1, Lang._t("Unable_to_upload", new Object[0]) + ": " + e.getMessage());
            }
            return new Progress(false, false, 2, 5, Lang._t("Publishing_", new Object[0]));
        }
        if (!this.publishing) {
            try {
                ArrayList<String> tags = new ArrayList<String>();
                tags.add("Mods");
                tags.addAll(this.mod.tags);
                if (this.doUpdate != null) {
                    SteamPublishedFileUpdateHandle spfuh = SteamBackend.storage.createPublishedFileUpdateRequest(this.doUpdate.fileID);
                    SteamBackend.storage.updatePublishedFileFile(spfuh, this.baseName);
                    SteamBackend.storage.updatePublishedFilePreviewFile(spfuh, this.previewName);
                    SteamBackend.storage.updatePublishedFileDescription(spfuh, this.mod.getIdeallyEnglishDescription());
                    SteamBackend.storage.updatePublishedFileTags(spfuh, AGame.normalizeTags(tags.toArray(new String[tags.size()])));
                    SteamBackend.storage.commitPublishedFileUpdate(spfuh);
                    SteamBackend.remoteStorageCallback = this;
                } else {
                    SteamBackend.remoteStorageCallback = this;
                    SteamBackend.storage.publishWorkshopFile(this.baseName, this.previewName, 342560L, this.mod.getIdeallyEnglishName(), this.mod.getIdeallyEnglishDescription(), SteamRemoteStorage.PublishedFileVisibility.Public, AGame.normalizeTags(tags.toArray(new String[tags.size()])), SteamRemoteStorage.WorkshopFileType.Community);
                }
                this.publishing = true;
            }
            catch (Exception e) {
                this.failed = true;
                e.printStackTrace();
                return new Progress(true, true, 1, 1, Lang._t("Unable_to_publish", new Object[0]) + ": " + e.getMessage());
            }
            return new Progress(false, false, 4, 5, Lang._t("Publishing_", new Object[0]));
        }
        if (!this.published) {
            return new Progress(false, false, 4, 5, Lang._t("Publishing_", new Object[0]));
        }
        if (this.doUpdate != null && !this.cleanedUp) {
            try {
                SteamBackend.storage.fileDelete(this.doUpdate.fileName);
                SteamBackend.storage.fileDelete("preview-" + this.doUpdate.fileName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.cleanedUp = true;
        }
        return new Progress(true, false, 8, 8, Lang._t("Done", new Object[0]));
    }

    public void onFileShareResult(SteamUGCHandle fileHandle, String fileName, SteamResult sr) {
    }

    public void onDownloadUGCResult(SteamUGCHandle fileHandle, SteamResult sr) {
    }

    public void onPublishFileResult(SteamPublishedFileID publishedFileID, boolean needsToAcceptWLA, SteamResult sr) {
        if (sr == SteamResult.OK) {
            this.published = true;
            this.needsWLA = needsToAcceptWLA;
            this.needsWLAId = publishedFileID.getNativeHandle();
            PublishedItemsManager.put(PublishedItemsManager.Type.MOD, this.mod.getIdeallyEnglishName(), this.mod.getIdeallyEnglishDescription(), this.mod.tags, -1, publishedFileID, this.baseName);
        } else {
            this.failed = true;
            this.publishError = sr.name();
            this.needsWLA = false;
            this.needsWLAId = -1L;
        }
        SteamBackend.remoteStorageCallback = null;
    }

    public void onUpdatePublishedFileResult(SteamPublishedFileID publishedFileID, boolean needsToAcceptWLA, SteamResult sr) {
        if (sr == SteamResult.OK) {
            this.published = true;
            this.needsWLA = needsToAcceptWLA;
            PublishedItemsManager.put(PublishedItemsManager.Type.MOD, this.doUpdate.title, this.mod.getIdeallyEnglishDescription(), this.mod.tags, this.doUpdate.modified, this.doUpdate.fileID, this.baseName);
        } else {
            this.failed = true;
            this.publishError = sr.name();
            this.needsWLA = false;
        }
        SteamBackend.remoteStorageCallback = null;
    }

    public strictfp static class Progress {
        public final boolean done;
        public final boolean failed;
        public final int progress;
        public final int total;
        public final String desc;

        public Progress(boolean done, boolean failed, int progress, int total, String desc) {
            this.done = done;
            this.failed = failed;
            this.progress = progress;
            this.total = total;
            this.desc = desc;
        }
    }
}

