/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.Crewman;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.RotatingColoringShader;
import com.zarkonnen.airships.SelectionVisualLayer;
import com.zarkonnen.airships.SpritesheetBundle;
import com.zarkonnen.airships.TimeOfDay;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;
import java.util.HashSet;
import org.newdawn.slick.Color;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;

public strictfp class TroopsVisualLayer
implements UniScreen.VisualLayer {
    public static final Color ROPE_C = new Color(217, 203, 177);
    private final HashSet<SpritesheetBundle> additionalSSBs = new HashSet();
    private final float[][] coaColors = new float[5][3];

    @Override
    public void tick(Input in, int ms, UniScreen us) {
    }

    @Override
    public void draw(MyDraw d, UniScreen us, double cropX, double cropY, double cropW, double cropH) {
        int tsz;
        if (us.combat == null) {
            return;
        }
        TimeOfDay tod = us.getTimeOfDay();
        int ssz = us.combat.sides.size();
        if (!us.hideUI) {
            for (int si = 0; si < ssz; ++si) {
                Combat.Side side = us.combat.sides.get(si);
                int tsz2 = side.troops.size();
                for (int ti = 0; ti < tsz2; ++ti) {
                    Crewman t = side.troops.get(ti);
                    if ((t.attachedTo != us.selectedShip || us.selectedShip == null) && (t.attachedTo != us.selectedLF || us.selectedLF == null)) continue;
                    double border = 2.0 / us.zoom;
                    d.rect(SelectionVisualLayer.SHIP_SELECT2, t.getX() - border, t.getY() - border, t.getBBWidth() + border * 2.0, border);
                    d.rect(SelectionVisualLayer.SHIP_SELECT2, t.getX() - border, t.getY() + t.getBBHeight(), t.getBBWidth() + border * 2.0, border);
                    d.rect(SelectionVisualLayer.SHIP_SELECT2, t.getX() - border, t.getY() - border, border, t.getBBHeight() + border * 2.0);
                    d.rect(SelectionVisualLayer.SHIP_SELECT2, t.getX() + t.getBBWidth(), t.getY() - border, border, t.getBBHeight() + border * 2.0);
                    d.rect(SelectionVisualLayer.SHIP_SELECT, t.getX() - (border /= 2.0), t.getY() - border, t.getBBWidth() + border * 2.0, border);
                    d.rect(SelectionVisualLayer.SHIP_SELECT, t.getX() - border, t.getY() + t.getBBHeight(), t.getBBWidth() + border * 2.0, border);
                    d.rect(SelectionVisualLayer.SHIP_SELECT, t.getX() - border, t.getY() - border, border, t.getBBHeight() + border * 2.0);
                    d.rect(SelectionVisualLayer.SHIP_SELECT, t.getX() + t.getBBWidth(), t.getY() - border, border, t.getBBHeight() + border * 2.0);
                }
            }
        }
        SpritesheetBundle baseSSB = SpritesheetBundle.ofName("spritesheet");
        this.additionalSSBs.clear();
        RotatingColoringShader.lockShader(baseSSB, d, us.lightingMap, tod.lightStrength, tod.ambient, tod.ambientSaturation);
        for (int si = 0; si < ssz; ++si) {
            Combat.Side side = us.combat.sides.get(si);
            this.coaColors[0] = side.arms.getTincture((int)0).replacementValue;
            this.coaColors[1] = side.arms.getTincture((int)1).replacementValue;
            this.coaColors[2] = side.arms.getTincture((int)2).replacementValue;
            this.coaColors[3] = side.arms.getFirstColour().replacementValue;
            this.coaColors[4] = side.arms.getFirstMetal().replacementValue;
            tsz = side.troops.size();
            for (int ti = 0; ti < tsz; ++ti) {
                Crewman t = side.troops.get(ti);
                t.anim.draw(d, t.getX(), t.getY(), false, us.lightingMap, tod.lightStrength, tod.ambient, tod.ambientSaturation, tod.ambientTint, baseSSB, this.additionalSSBs, this.coaColors);
            }
        }
        RotatingColoringShader.unlockShader();
        for (SpritesheetBundle ssb : this.additionalSSBs) {
            RotatingColoringShader.lockShader(ssb, d, us.lightingMap, tod.lightStrength, tod.ambient, tod.ambientSaturation);
            for (int si = 0; si < ssz; ++si) {
                Combat.Side side = us.combat.sides.get(si);
                this.coaColors[0] = side.arms.getTincture((int)0).replacementValue;
                this.coaColors[1] = side.arms.getTincture((int)1).replacementValue;
                this.coaColors[2] = side.arms.getTincture((int)2).replacementValue;
                int tsz3 = side.troops.size();
                for (int ti = 0; ti < tsz3; ++ti) {
                    Crewman t = side.troops.get(ti);
                    t.anim.draw(d, t.getX(), t.getY(), false, us.lightingMap, tod.lightStrength, tod.ambient, tod.ambientSaturation, tod.ambientTint, ssb, null, this.coaColors);
                }
            }
            RotatingColoringShader.unlockShader();
        }
        for (int si = 0; si < ssz; ++si) {
            Combat.Side side = us.combat.sides.get(si);
            tsz = side.troops.size();
            for (int ti = 0; ti < tsz; ++ti) {
                Crewman t = side.troops.get(ti);
                if (!t.hookLaunched) continue;
                double sX = t.hookSource.x;
                double sY = t.hookSource.y;
                double tX = t.hookTarget.x;
                double tY = t.hookTarget.y;
                double hX = sX + (tX - sX) * t.hookProgress / t.hookDist;
                double hY = sY + (tY - sY) * t.hookProgress / t.hookDist;
                if (t.hookedGR != null) {
                    sX = t.getX();
                    sY = t.getY();
                    hX = tX += t.hookTargetBody.getX() + (double)(t.hookedGR.gridX * 16);
                    hY = tY += t.hookTargetBody.getY() + (double)(t.hookedGR.gridY * 16);
                }
                if (t.type.hookImg.machineImgCache != null) {
                    ((Image)t.type.hookImg.machineImgCache).setFilter(9728);
                }
                d.blit(t.type.hookImg, hX - (double)(t.type.hookImg.srcWidth / 2), hY - (double)(t.type.hookImg.srcHeight / 2), StrictMath.atan2(tY - sY, tX - sX));
                Graphics g = (Graphics)d.frame().nativeRenderer();
                g.setColor(ROPE_C);
                float lw = StrictMath.max(1.0f, (float)(t.type.hookRopeWidth * us.zoom));
                g.setLineWidth(lw);
                g.drawLine((float)(t.getX() + t.getBBWidth() / 2.0), (float)(t.getY() + t.getBBHeight() / 2.0), (float)hX, (float)hY);
                g.setLineWidth(1.0f);
            }
        }
    }
}

