/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.Body;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.Crewman;
import com.zarkonnen.airships.Foot;
import com.zarkonnen.airships.GridBody;
import com.zarkonnen.airships.LandFormation;
import com.zarkonnen.airships.Particle;
import com.zarkonnen.airships.Rect2D;
import com.zarkonnen.airships.WheelBody;

public strictfp class TroopPhysics {
    public static final double COLLISION_SPEED_SQ_TO_DAMAGE = 3.0;
    public static final double MIN_WHEEL_OR_FOOT_DEATH_SPEED = 0.01;

    public static void tick(int ms, Combat c, Combat.Side viewingSide) {
        int ssz = c.sides.size();
        for (int si = 0; si < ssz; ++si) {
            Combat.Side side = c.sides.get(si);
            boolean onViewingSide = side == viewingSide;
            int tsz = side.troops.size();
            for (int ti = 0; ti < tsz; ++ti) {
                Crewman t = side.troops.get(ti);
                t.setX(t.getX() + (t.dx + t.mvDx) * (double)ms);
                t.setY(t.getY() + (t.dy + t.mvDy) * (double)ms);
                if (t.type.canFly) {
                    t.attachedTo = null;
                    continue;
                }
                boolean wasAlive = t.alive();
                t.attachedTo = null;
                int bsz = c.physics.bodies.size();
                for (int bi = 0; bi < bsz; ++bi) {
                    Airship ship;
                    Body b = c.physics.bodies.get(bi);
                    if (t.ignores(b) || !Rect2D.intersects(t.getX(), t.getY(), t.getBBWidth(), t.getBBHeight(), b.getX(), b.getY(), b.getBBWidth(), b.getBBHeight()) || !b.collidesWith(t)) continue;
                    double collisionSpeedSquared = (t.dx - b.getxSpeed()) * (t.dx - b.getxSpeed()) + (t.dy - b.getySpeed()) * (t.dy - b.getySpeed());
                    int dmg = (int)StrictMath.floor(collisionSpeedSquared * 3.0);
                    if (b instanceof Foot && StrictMath.abs((ship = ((Foot)b).ship).getxSpeed()) + StrictMath.abs(ship.getySpeed()) >= 0.01 && !side.ships.contains(ship)) {
                        dmg = 10;
                    }
                    if (b instanceof WheelBody && !side.ships.contains(((WheelBody)b).ship) && StrictMath.abs((ship = ((WheelBody)b).ship).getxSpeed()) + StrictMath.abs(ship.getySpeed()) >= 0.01 && !side.ships.contains(ship)) {
                        dmg = 10;
                    }
                    t.hp -= dmg;
                    if (t.type.bloodParticleExternal != null) {
                        int parts = StrictMath.min(10, dmg * 4);
                        for (int i = 0; i < parts; ++i) {
                            c.particles.add(new Particle(t.type.bloodParticleExternal, t.getX() + t.getBBWidth() / 2.0, t.getY() + t.getBBHeight() / 2.0));
                        }
                    }
                    if (!t.alive() && wasAlive && t.type.deathSnd != null) {
                        c.play(t.type.deathSnd, t.getX(), t.getY(), t.dx, t.dy, onViewingSide);
                    }
                    wasAlive = t.alive();
                    if (b instanceof WheelBody || b instanceof Foot) continue;
                    t.attachedTo = b;
                    if (b instanceof GridBody) {
                        GridBody gb = (GridBody)b;
                        double yBoundary = gb.yBoundaryAt(t.getX() + t.getBBWidth() / 2.0);
                        if (b.isImmobile() && b instanceof LandFormation && gb.solidAt((int)StrictMath.floor((t.getX() + t.getBBWidth() / 2.0 - b.getX()) / 16.0), (int)StrictMath.floor((t.getY() + t.getBBHeight() / 2.0 - b.getY()) / 16.0))) {
                            t.setY(StrictMath.min(t.getY(), yBoundary - t.getBBHeight() + 0.5));
                        }
                        t.standing = t.getY() <= yBoundary - t.getBBHeight() + 3.0 && t.getY() > yBoundary - t.getBBHeight() - 1.0;
                    }
                    t.dx = b.getxSpeed();
                    t.dy = b.getySpeed();
                }
                if (t.attachedTo == null) {
                    t.dy += c.physics.gravity * (double)ms;
                }
                if (!t.hookLaunched || t.hookedGR == null) continue;
                double hookX = t.hookTarget.x + t.hookTargetBody.getX() + (double)(t.hookedGR.gridX * 16);
                double hookY = t.hookTarget.y + t.hookTargetBody.getY() + (double)(t.hookedGR.gridY * 16);
                double ropeLength = t.hookProgress;
                double distSq = (t.getX() - hookX) * (t.getX() - hookX) + (t.getY() - hookY) * (t.getY() - hookY);
                if (!(distSq > ropeLength * ropeLength)) continue;
                double dist = StrictMath.sqrt(distSq);
                double ropeUnitX = (t.getX() - hookX) / dist;
                double ropeUnitY = (t.getY() - hookY) / dist;
                t.setX(hookX + ropeUnitX * ropeLength);
                t.setY(hookY + ropeUnitY * ropeLength);
                t.dx -= t.dx * ropeUnitX * ropeUnitX / 8.0;
                t.dy -= t.dy * ropeUnitY * ropeUnitY / 8.0;
            }
        }
    }
}

