/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.ChallengeCombatIntent;
import com.zarkonnen.airships.CombatIntent;
import com.zarkonnen.airships.InitCombatProcess;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.SingleCombatIntent;
import com.zarkonnen.airships.TacticalAI;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;

public strictfp class ToggleAIControlButton
extends UniScreen.Button {
    private boolean selected = false;

    @Override
    public boolean visible(UniScreen us) {
        return us.intent instanceof SingleCombatIntent && !(us.intent instanceof ChallengeCombatIntent) && us.mySide != null;
    }

    @Override
    public boolean isToggle() {
        return true;
    }

    @Override
    public boolean selected(UniScreen us) {
        return this.selected;
    }

    @Override
    public String text(UniScreen us) {
        return Lang._t("AI_Control", new Object[0]);
    }

    @Override
    public void click(Input in, UniScreen us) {
        if (this.selected) {
            for (Airship ship : us.mySide.ships) {
                ship.ai = null;
            }
            us.mySide.usingAI = false;
        } else {
            for (Airship ship : us.mySide.ships) {
                ship.ai = new TacticalAI(ship, us.combat, us.mySide, us.combat.otherSide(us.mySide));
                ship.ai.doesSurrender = false;
            }
            us.mySide.usingAI = true;
            ((CombatIntent)us.intent).initCombatProcess = new InitCombatProcess(us.combat);
        }
        this.selected = !this.selected;
    }
}

