/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import java.awt.image.BufferedImage;
import java.util.ArrayList;

public final class TileMask {
    public static final TileMask FULL;
    public static final TileMask EMPTY;
    public final boolean[][] mask;
    public final TileMask flipped;
    public final ArrayList<Rect> rects;

    private static ArrayList<Rect> genRects(boolean[][] origMask) {
        boolean[][] mask = new boolean[origMask.length][origMask[0].length];
        for (int y = 0; y < mask.length; ++y) {
            System.arraycopy(origMask[y], 0, mask[y], 0, origMask[y].length);
        }
        ArrayList<Rect> l = new ArrayList<Rect>();
        block1: for (int startY = 0; startY < mask.length; ++startY) {
            for (int startX = 0; startX < mask[0].length; ++startX) {
                int h;
                int w = mask[0].length - startX;
                block3: for (h = mask.length - startY; h > 1; --h) {
                    for (int checkY = startY + h - 1; checkY >= startY; --checkY) {
                        for (int checkX = startX; checkX < startX + w; ++checkX) {
                            if (mask[checkY][checkX]) continue;
                            continue block3;
                        }
                    }
                }
                if (h == 1) {
                    block6: while (w > 0) {
                        for (int checkX = startX + w - 1; checkX >= startX; --checkX) {
                            if (mask[startY][checkX]) continue;
                            --w;
                            continue block6;
                        }
                    }
                }
                if (w <= 0 || h <= 0) continue;
                l.add(new Rect(startX, startY, w, h));
                for (int yy = startY; yy < startY + h; ++yy) {
                    for (int xx = startX; xx < startX + w; ++xx) {
                        mask[yy][xx] = false;
                    }
                }
                if (w == mask[0].length && h > 1) {
                    startY += h - 1;
                    continue block1;
                }
                startX += w - 1;
            }
        }
        return l;
    }

    public TileMask(boolean[][] mask) {
        this.mask = mask;
        this.flipped = new TileMask(TileMask.flip(mask), this);
        this.rects = TileMask.genRects(mask);
    }

    private TileMask(boolean[][] mask, TileMask flipped) {
        this.mask = mask;
        this.flipped = flipped;
        this.rects = TileMask.genRects(mask);
    }

    private TileMask(boolean[][] mask, ArrayList<Rect> rects) {
        this.mask = mask;
        this.flipped = this;
        this.rects = rects;
    }

    public static TileMask fromImage(BufferedImage img, int imgX, int imgY) {
        boolean full = true;
        boolean empty = true;
        boolean[][] mask = new boolean[16][16];
        for (int y = 0; y < mask.length; ++y) {
            for (int x = 0; x < mask[0].length; ++x) {
                if (img.getAlphaRaster().getSample(imgX + x, imgY + y, 0) != 0) {
                    mask[y][x] = true;
                    empty = false;
                    continue;
                }
                full = false;
            }
        }
        return full ? FULL : (empty ? EMPTY : new TileMask(mask));
    }

    private static boolean[][] flip(boolean[][] mask) {
        boolean[][] m2 = new boolean[mask.length][mask[0].length];
        for (int y = 0; y < mask.length; ++y) {
            for (int x = 0; x < mask[0].length; ++x) {
                m2[y][mask[0].length - x - 1] = mask[y][x];
            }
        }
        return m2;
    }

    public boolean intersects(int myX, int myY, boolean myFlipped, TileMask t2, int t2X, int t2Y, boolean t2Flipped) {
        if (this == EMPTY || t2 == EMPTY) {
            return false;
        }
        if (this == FULL) {
            if (t2 == FULL) {
                return myX + 16 > t2X && myY + 16 > t2Y && t2X + 16 > myX && t2Y + 16 > myY;
            }
            return this.intersectsBlock(t2X, t2Y, t2Flipped, myX, myY);
        }
        if (t2 == FULL) {
            return this.intersectsBlock(myX, myY, myFlipped, t2X, t2Y);
        }
        TileMask t1 = myFlipped ? this.flipped : this;
        t2 = t2Flipped ? t2.flipped : t2;
        int dx = myX - t2X;
        int dy = myY - t2Y;
        int xLoopStart = StrictMath.max(0, -dx);
        int yLoopStart = StrictMath.max(0, -dy);
        int xLoopEnd = 16 - StrictMath.max(0, dx);
        int yLoopEnd = 16 - StrictMath.max(0, dy);
        for (int y = yLoopStart; y < yLoopEnd; ++y) {
            for (int x = xLoopStart; x < xLoopEnd; ++x) {
                if (!t1.mask[y][x] || !t2.mask[y + dy][x + dx]) continue;
                return true;
            }
        }
        return false;
    }

    public boolean intersectsBlock(int myX, int myY, boolean myFlipped, int bx, int by) {
        TileMask t1 = myFlipped ? this.flipped : this;
        int dx = myX - bx;
        int dy = myY - by;
        int xLoopStart = StrictMath.max(0, -dx);
        int yLoopStart = StrictMath.max(0, -dy);
        int xLoopEnd = 16 - StrictMath.max(0, dx);
        int yLoopEnd = 16 - StrictMath.max(0, dy);
        for (int y = yLoopStart; y < yLoopEnd; ++y) {
            for (int x = xLoopStart; x < xLoopEnd; ++x) {
                if (!t1.mask[y][x]) continue;
                return true;
            }
        }
        return false;
    }

    public boolean intersectsRect(int myX, int myY, boolean myFlipped, int rx, int ry, int rw, int rh) {
        if (this == EMPTY) {
            return false;
        }
        if (this == FULL) {
            return myX + 16 > rx && myY + 16 > ry && rx + rw > myX && ry + rh > myY;
        }
        TileMask t1 = myFlipped ? this.flipped : this;
        int dx = myX - rx;
        int dy = myY - ry;
        int xLoopStart = StrictMath.max(0, -dx);
        int yLoopStart = StrictMath.max(0, -dy);
        int xLoopEnd = StrictMath.min(16, rw - StrictMath.max(0, dx));
        int yLoopEnd = StrictMath.min(16, rh - StrictMath.max(0, dy));
        for (int y = yLoopStart; y < yLoopEnd; ++y) {
            for (int x = xLoopStart; x < xLoopEnd; ++x) {
                if (!t1.mask[y][x]) continue;
                return true;
            }
        }
        return false;
    }

    static {
        EMPTY = new TileMask(new boolean[16][16], new ArrayList<Rect>());
        boolean[][] mask = new boolean[16][16];
        for (int y = 0; y < mask.length; ++y) {
            for (int x = 0; x < mask[0].length; ++x) {
                mask[y][x] = true;
            }
        }
        ArrayList<Rect> rs = new ArrayList<Rect>();
        rs.add(new Rect(0, 0, 16, 16));
        FULL = new TileMask(mask, rs);
    }

    public static class Rect {
        public final int x;
        public final int y;
        public final int w;
        public final int h;

        public Rect(int x, int y, int w, int h) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
        }
    }
}

