/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.Module;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.RotatingShader;
import com.zarkonnen.airships.Shot;
import com.zarkonnen.airships.SpritesheetBundle;
import com.zarkonnen.airships.Tether;
import com.zarkonnen.airships.TimeOfDay;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;
import java.util.HashSet;
import org.newdawn.slick.Graphics;

public class TethersVisualLayer
implements UniScreen.VisualLayer {
    private final HashSet<SpritesheetBundle> additionalSSBs = new HashSet();

    @Override
    public void tick(Input in, int ms, UniScreen us) {
    }

    @Override
    public void draw(MyDraw d, UniScreen us, double cropX, double cropY, double cropW, double cropH) {
        if (us.combat == null) {
            return;
        }
        Graphics g = (Graphics)d.frame().nativeRenderer();
        for (Combat.Side s : us.combat.sides) {
            for (Airship airship : s.ships) {
                for (Module m : airship.modules) {
                    Tether t = m.tether;
                    if (t == null) continue;
                    g.setColor(t.spec.color);
                    float lw = StrictMath.max(1.0f, (float)(t.spec.width * us.zoom));
                    g.setLineWidth(lw);
                    g.drawLine((float)(t.ta.ship.getX() + (double)(t.ta.ship.gridXToWorldX(t.ta.module.x, t.ta.module.type.getW()) * 16) + (t.ta.ship.flipped ? (double)(t.ta.module.type.getW() * 16) - t.spec.anchorX * 16.0 : t.spec.anchorX * 16.0)), (float)(t.ta.ship.getY() + (double)(t.ta.module.y * 16) + t.spec.anchorY * 16.0), (float)(t.tb.ship.getX() + (double)(t.tb.ship.gridXToWorldX(t.tb.x, 1) * 16) + 8.0), (float)(t.tb.ship.getY() + (double)(t.tb.y * 16) + 8.0));
                    g.setLineWidth(1.0f);
                }
            }
        }
        TimeOfDay tod = us.getTimeOfDay();
        SpritesheetBundle baseSSB = SpritesheetBundle.ofName("spritesheet");
        this.additionalSSBs.clear();
        RotatingShader.lockShader(baseSSB, d, us.lightingMap, tod.lightStrength, tod.ambient, tod.ambientSaturation);
        for (Combat.Side side : us.combat.sides) {
            for (Airship ship : side.ships) {
                for (Module m : ship.modules) {
                    Tether t = m.tether;
                    if (t == null || t.shotAppearance == null) continue;
                    if (!t.shotAppearance.src.equals(baseSSB.name)) {
                        this.additionalSSBs.add(SpritesheetBundle.ofName(t.shotAppearance.src));
                        continue;
                    }
                    double sx = t.tb.ship.getX() + (double)(t.tb.ship.gridXToWorldX(t.tb.x, 1) * 16) + 8.0 - (double)(t.shotAppearance.srcWidth / 2);
                    double sy = t.tb.ship.getY() + (double)(t.tb.y * 16) + 8.0 - (double)(t.shotAppearance.srcHeight / 2);
                    RotatingShader.draw(t.shotAppearance, d, sx, sy, t.shotAngle, false, us.lightingMap, tod.lightStrength, tod.ambient, tod.ambientSaturation, tod.ambientTint);
                }
            }
        }
        RotatingShader.unlockShader();
        for (SpritesheetBundle spritesheetBundle : this.additionalSSBs) {
            RotatingShader.lockShader(spritesheetBundle, d, us.lightingMap, tod.lightStrength, tod.ambient, tod.ambientSaturation);
            for (Combat.Side s : us.combat.sides) {
                for (Airship ship : s.ships) {
                    for (Module m : ship.modules) {
                        Tether t = m.tether;
                        if (t == null || t.shotAppearance == null || !t.shotAppearance.src.equals(spritesheetBundle.name)) continue;
                        double sx = t.tb.ship.getX() + (double)(t.tb.ship.gridXToWorldX(t.tb.x, 1) * 16) + 8.0 - (double)(t.shotAppearance.srcWidth / 2);
                        double sy = t.tb.ship.getY() + (double)(t.tb.y * 16) + 8.0 - (double)(t.shotAppearance.srcHeight / 2);
                        RotatingShader.draw(t.shotAppearance, d, sx, sy, t.shotAngle, false, us.lightingMap, tod.lightStrength, tod.ambient, tod.ambientSaturation, tod.ambientTint);
                    }
                }
            }
            RotatingShader.unlockShader();
        }
        for (Shot shot : us.combat.shots) {
            if (shot.weapon == null || shot.weapon.hp <= 0 || shot.weapon.type.getTetherSpec(shot.weaponBonuses) == null) continue;
            Tether.Spec tspec = shot.weapon.type.getTetherSpec(shot.weaponBonuses);
            float lw = StrictMath.max(1.0f, (float)(tspec.width * us.zoom));
            g.setColor(tspec.color);
            g.setLineWidth(lw);
            g.drawLine((float)(shot.weapon.ship.getX() + (double)(shot.weapon.ship.gridXToWorldX(shot.weapon.x, shot.weapon.type.getW()) * 16) + (shot.weapon.ship.flipped ? (double)(shot.weapon.type.getW() * 16) - tspec.anchorX * 16.0 : tspec.anchorX * 16.0)), (float)(shot.weapon.ship.getY() + (double)(shot.weapon.y * 16) + tspec.anchorY * 16.0), (float)shot.getX(), (float)shot.getY());
            g.setLineWidth(1.0f);
        }
    }
}

