/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.Client;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.CombatIntent;
import com.zarkonnen.airships.CommandButtonsPanel;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.Rect2D;
import com.zarkonnen.airships.SelectionVisualLayer;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;

public strictfp class TetherCommandTool
extends UniScreen.Tool {
    @Override
    public String getLabel() {
        return Lang._t("Launch_tether_at_", new Object[0]);
    }

    @Override
    public void draw(MyDraw d, Pt cursor, ScreenMode sm, UniScreen us) {
        double y;
        double x = us.screenToWorldX(cursor.x);
        Airship hs = TetherCommandTool.hoverShip(us, x, y = us.screenToWorldY(cursor.y));
        if (hs != null) {
            d.state.setCursor("FULL_TARGET", null);
            d.scale(us.zoom, us.zoom);
            d.shift(us.adjScrollX, us.adjScrollY);
            SelectionVisualLayer.drawGridBodyOutline(d, us.zoom, hs, SelectionVisualLayer.SHIP_TARGET, SelectionVisualLayer.SHIP_TARGET2);
            d.resetTransforms();
        } else {
            d.state.setCursor("EMPTY_TARGET", null);
        }
    }

    public static Airship hoverShip(UniScreen us, double x, double y) {
        Combat.Side enemy = us.combat.otherSide(us.mySide);
        for (Airship as : enemy.ships) {
            if (!Rect2D.contains(as.getX(), as.getY(), as.getBBWidth(), as.getBBHeight(), x, y)) continue;
            return as;
        }
        return null;
    }

    @Override
    public boolean click(Input in, Pt click, ScreenMode sm, UniScreen us) {
        double y;
        CommandButtonsPanel cbp = us.panel(CommandButtonsPanel.class);
        if (us.intent instanceof CombatIntent && click.x > (double)cbp.panelX && click.x < (double)(cbp.panelX + cbp.panelW) && click.y > (double)(sm.height - cbp.panelH)) {
            return false;
        }
        double x = us.screenToWorldX(click.x);
        Airship hs = TetherCommandTool.hoverShip(us, x, y = us.screenToWorldY(click.y));
        if (hs != null) {
            if (us.selectedShip != null && us.selectedShip.readyForCommand()) {
                us.combat.giveCommand(Client.msg("tetherAt").put("id", us.combat.getShipID(us.selectedShip)).put("target", us.combat.getShipID(hs)));
            } else {
                for (Airship s : us.selectedShips) {
                    if (!s.readyForCommand() || !s.canShoot()) continue;
                    us.combat.giveCommand(Client.msg("tetherAt").put("id", us.combat.getShipID(s)).put("target", us.combat.getShipID(hs)));
                }
            }
            us.tool = UniScreen.NAVIGATE;
        }
        return true;
    }

    @Override
    public boolean rightClick(Input in, Pt click, ScreenMode sm, UniScreen us) {
        us.tool = UniScreen.NAVIGATE;
        return true;
    }

    @Override
    public void tick(Input in, int ms, UniScreen us) {
        if (in.keyPressed("ESCAPE")) {
            us.tool = UniScreen.NAVIGATE;
        }
    }
}

