/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.BonusSet;
import com.zarkonnen.airships.BonusableValue;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.Direction;
import com.zarkonnen.airships.Particle;
import com.zarkonnen.airships.ParticleType;
import com.zarkonnen.airships.SoundEffect;
import com.zarkonnen.airships.Tile;
import com.zarkonnen.catengine.Img;
import org.json.JSONObject;
import org.newdawn.slick.Color;

public strictfp class Tether {
    public final Spec spec;
    public final Tile ta;
    public final Tile tb;
    public double desiredLength;
    public Img shotAppearance;
    public double shotAngle;

    public Tether(Spec spec, Tile ta, Tile tb, Img shotAppearance, double shotAngle) {
        this.spec = spec;
        this.ta = ta;
        this.tb = tb;
        this.shotAppearance = shotAppearance;
        this.shotAngle = shotAngle;
        this.desiredLength = this.length();
    }

    private double length() {
        double ax = this.ta.ship.getX() + (double)(this.ta.ship.gridXToWorldX(this.ta.x, 1) * 16) + 8.0;
        double ay = this.ta.ship.getY() + (double)(this.ta.y * 16) + 8.0;
        double bx = this.tb.ship.getX() + (double)(this.tb.ship.gridXToWorldX(this.tb.x, 1) * 16) + 8.0;
        double by = this.tb.ship.getY() + (double)(this.tb.y * 16) + 8.0;
        return StrictMath.sqrt((ax - bx) * (ax - bx) + (ay - by) * (ay - by));
    }

    public boolean tick(int ms, Combat c, boolean onViewingSide) {
        if (!this.ta.ship.tiles.contains(this.ta) || !this.tb.ship.tiles.contains(this.tb)) {
            return true;
        }
        if (c.sideOf(this.ta.ship) == null || !c.sideOf((Airship)this.ta.ship).ships.contains(this.ta.ship) || c.sideOf(this.tb.ship) == null || !c.sideOf((Airship)this.tb.ship).ships.contains(this.tb.ship)) {
            return true;
        }
        this.desiredLength = this.desiredLength <= this.spec.minLength + this.spec.shrinkSpeed * (double)ms ? this.spec.minLength : (this.desiredLength -= this.spec.shrinkSpeed * (double)ms);
        double length = this.length();
        if (this.desiredLength < length) {
            double force = this.spec.k * (length - this.desiredLength) / 2.0;
            double ax = this.ta.ship.getX() + (double)(this.ta.ship.gridXToWorldX(this.ta.x, 1) * 16) + 8.0;
            double ay = this.ta.ship.getY() + (double)(this.ta.y * 16) + 8.0;
            double bx = this.tb.ship.getX() + (double)(this.tb.ship.gridXToWorldX(this.tb.x, 1) * 16) + 8.0;
            double by = this.tb.ship.getY() + (double)(this.tb.y * 16) + 8.0;
            if (force >= this.spec.tearForce) {
                if (this.spec.ripSound != null) {
                    c.play(this.spec.ripSound, ax / 2.0 + bx / 2.0, ay / 2.0 + by / 2.0, 0.0, 0.0, onViewingSide);
                }
                if (this.spec.ripParticle != null) {
                    for (double along = AGame.ANIM_R.nextDouble() * 0.04; along < 1.0; along += AGame.ANIM_R.nextDouble() * 0.08) {
                        c.particles.add(new Particle(this.spec.ripParticle, ax * (1.0 - along) + bx * along, ay * (1.0 - along) + by * along));
                    }
                }
                return true;
            }
            double abDir = Direction.radiansFromTo(ax, ay, bx, by);
            double xComponent = StrictMath.cos(abDir);
            double yComponent = StrictMath.sin(abDir);
            this.ta.ship.setxForce(this.ta.ship.getxForce() + xComponent * force);
            this.ta.ship.setyForce(this.ta.ship.getyForce() + yComponent * force);
            this.tb.ship.setxForce(this.tb.ship.getxForce() - xComponent * force);
            this.tb.ship.setyForce(this.tb.ship.getyForce() - yComponent * force);
            this.ta.ship.exertedXForce += xComponent * force;
            this.ta.ship.exertedYForce += yComponent * force;
            this.tb.ship.exertedXForce -= xComponent * force;
            this.tb.ship.exertedYForce -= yComponent * force;
        }
        return false;
    }

    public strictfp static class Spec {
        public final double maxRange;
        public final double tearForce;
        public final double minLength;
        public final double shrinkSpeed;
        public final double k;
        public final double anchorX;
        public final double anchorY;
        public final double width;
        public final Color color;
        public final SoundEffect ripSound;
        public final ParticleType ripParticle;

        public Spec(double maxRange, double tearForce, double minLength, double shrinkSpeed, double k, double anchorX, double anchorY, double width, Color color, SoundEffect ripSound, ParticleType ripParticle) {
            this.maxRange = maxRange;
            this.tearForce = tearForce;
            this.minLength = minLength;
            this.shrinkSpeed = shrinkSpeed;
            this.k = k;
            this.anchorX = anchorX;
            this.anchorY = anchorY;
            this.width = width;
            this.color = color;
            this.ripSound = ripSound;
            this.ripParticle = ripParticle;
        }

        public Spec(JSONObject o) {
            this.maxRange = o.getDouble("maxRange");
            this.tearForce = o.getDouble("tearForce");
            this.minLength = o.getDouble("minLength");
            this.shrinkSpeed = o.getDouble("shrinkSpeed");
            this.anchorX = o.getDouble("anchorX");
            this.anchorY = o.getDouble("anchorY");
            this.k = o.getDouble("k");
            this.width = o.getDouble("width");
            JSONObject c = o.getJSONObject("color");
            this.color = new Color(c.getInt("r"), c.getInt("g"), c.getInt("b"), c.optInt("a", 255));
            SoundEffect rs = null;
            if (o.has("ripSound")) {
                try {
                    rs = new SoundEffect(o.getString("ripSound"));
                }
                catch (Exception e) {
                    rs = new SoundEffect(o.getJSONObject("ripSound"));
                }
            }
            this.ripSound = rs;
            this.ripParticle = o.has("ripParticle") ? ParticleType.ofName(o.getString("ripParticle")) : null;
        }

        public Spec flipped(int moduleWidth) {
            return new Spec(this.maxRange, this.tearForce, this.minLength, this.shrinkSpeed, this.k, (double)moduleWidth - this.anchorX, this.anchorY, this.width, this.color, this.ripSound, this.ripParticle);
        }

        public strictfp static class FromJSON
        implements BonusableValue.FromJSON<Spec> {
            @Override
            public Spec construct(JSONObject o, BonusSet b) {
                return new Spec(o);
            }
        }
    }
}

