/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.AffordableFilter;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.Bonus;
import com.zarkonnen.airships.BuildShipMission;
import com.zarkonnen.airships.CampaignCombatSetupIntent;
import com.zarkonnen.airships.CampaignWorld;
import com.zarkonnen.airships.ChatAdapter;
import com.zarkonnen.airships.City;
import com.zarkonnen.airships.Client;
import com.zarkonnen.airships.CoatOfArms;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.CombatOutcome;
import com.zarkonnen.airships.Compression;
import com.zarkonnen.airships.ConstructionBackend;
import com.zarkonnen.airships.DateInfo;
import com.zarkonnen.airships.DefencesIntent;
import com.zarkonnen.airships.DesignFromStrategicIntent;
import com.zarkonnen.airships.Empire;
import com.zarkonnen.airships.EspionageIntent;
import com.zarkonnen.airships.FileScreen;
import com.zarkonnen.airships.Fleet;
import com.zarkonnen.airships.FleetElementAdapter;
import com.zarkonnen.airships.FleetOwner;
import com.zarkonnen.airships.GenericChatMsg;
import com.zarkonnen.airships.HasCombatInfo;
import com.zarkonnen.airships.InputRunnable;
import com.zarkonnen.airships.JSONFileBackend;
import com.zarkonnen.airships.Keys;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MainMenu;
import com.zarkonnen.airships.MapLocation;
import com.zarkonnen.airships.Marshalling;
import com.zarkonnen.airships.MetaLobbyScreen;
import com.zarkonnen.airships.ModReloadProgressDialog;
import com.zarkonnen.airships.MonsterNest;
import com.zarkonnen.airships.MonsterNestType;
import com.zarkonnen.airships.MultiplayerCampaignCombatSetupIntent;
import com.zarkonnen.airships.MultiplayerEditShipIntent;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.OpenGameMission;
import com.zarkonnen.airships.PriceInlineInfo;
import com.zarkonnen.airships.RefitFromStrategicIntent;
import com.zarkonnen.airships.RefitShipMission;
import com.zarkonnen.airships.ResearchSpeed;
import com.zarkonnen.airships.Road;
import com.zarkonnen.airships.SaveGameMission;
import com.zarkonnen.airships.Screen;
import com.zarkonnen.airships.ScrollBar;
import com.zarkonnen.airships.SecretPoliceLevel;
import com.zarkonnen.airships.ShapeUtils;
import com.zarkonnen.airships.ShipEditorUtils;
import com.zarkonnen.airships.ShipHelperWidget;
import com.zarkonnen.airships.ShipNameDialog;
import com.zarkonnen.airships.ShipType;
import com.zarkonnen.airships.SimplePref;
import com.zarkonnen.airships.SpriteUtils;
import com.zarkonnen.airships.Spy;
import com.zarkonnen.airships.SpyActionResult;
import com.zarkonnen.airships.StrategicHelp;
import com.zarkonnen.airships.StrategicPlayerInfo;
import com.zarkonnen.airships.TakeoverMethod;
import com.zarkonnen.airships.Tech;
import com.zarkonnen.airships.TechScreen;
import com.zarkonnen.airships.TextField;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.airships.ViewCityIntent;
import com.zarkonnen.airships.WorldMap;
import com.zarkonnen.catengine.Fount;
import com.zarkonnen.catengine.Hook;
import com.zarkonnen.catengine.Hooks;
import com.zarkonnen.catengine.Img;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.Rect;
import com.zarkonnen.catengine.util.ScreenMode;
import com.zarkonnen.catengine.util.Utils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import org.json.JSONArray;
import org.json.JSONObject;
import org.lwjgl.opengl.GL11;
import org.newdawn.slick.Color;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.geom.Shape;
import org.newdawn.slick.opengl.TextureImpl;

public strictfp class StrategicScreen
implements Screen,
FileScreen.BackgroundTask {
    public static final Clr ROT = Clr.fromHex((String)"74595233");
    public static final Clr PARCHMENT = Clr.fromHex((String)"e7e0a9");
    public static final Clr PARCHMENT_OVER = Clr.fromHex((String)"e7e0a966");
    public static final Clr INK_TINT = Clr.fromHex((String)"745952").mix(0.3, PARCHMENT);
    public static final Clr INK = Clr.fromHex((String)"7d673e");
    public static final Color INK_C = new Color(StrategicScreen.INK.r, StrategicScreen.INK.g, StrategicScreen.INK.b);
    public static final Clr DARK_INK = Clr.fromHex((String)"7d673e");
    public static final Clr DARKER_INK = Clr.fromHex((String)"7d673e");
    public static final Color DARKER_INK_C = new Color(StrategicScreen.DARKER_INK.r, StrategicScreen.DARKER_INK.g, StrategicScreen.DARKER_INK.b);
    public static final Clr RED_INK = Clr.fromHex((String)"7d673e").mix(0.7, Clr.RED);
    public static final Clr DARK_RED_INK = Clr.fromHex((String)"7d673e").mix(0.25, Clr.RED);
    public static final String DARK_RED_INK_TINT = DARK_RED_INK.toString();
    public static final Clr DARK_GREEN_INK = Clr.fromHex((String)"7d673e").mix(0.15, Clr.GREEN);
    public static final String DARK_GREEN_INK_TINT = DARK_GREEN_INK.toString();
    public static final int MAP_TILE_SIZE = StrictMath.max(16, 32);
    public static final Clr BACKDROP_DARKENING = new Clr(216, 216, 216);
    public static final Clr GOLD = new Clr(255, 255, 145);
    private final Img indicator = new Img("ui", 208, 512, 16, 16, false);
    private final Img editAirship = new Img("ui", 16, 496, 16, 16, false);
    private final Img editLandship = new Img("ui", 32, 496, 16, 16, false);
    private final Img editBuilding = new Img("ui", 96, 496, 16, 16, false);
    private final Img[] mountains = new Img[5];
    private final Img[] trees = new Img[6];
    private final Img[] swamps = new Img[4];
    private final Img[] sea_creatures = new Img[7];
    private final Img[] cities = new Img[10];
    private final Img[] towns = new Img[6];
    private final Img[] mountains_bg = new Img[5];
    private final Img[] trees_bg = new Img[6];
    private final Img[] sea_creatures_bg = new Img[7];
    private final Img[] cities_bg = new Img[10];
    private final Img[] towns_bg = new Img[6];
    private final Img airfleet = new Img("ui", 160, 480, 32, 32, false);
    private final Img airfleetOutline = new Img("ui", 192, 480, 32, 32, false);
    private final Img landfleet = new Img("ui", 224, 480, 32, 32, false);
    private final Img landfleetOutline = new Img("ui", 256, 480, 32, 32, false);
    private final Img mixedfleet = new Img("ui", 288, 480, 32, 32, false);
    private final Img mixedfleetOutline = new Img("ui", 320, 480, 32, 32, false);
    private final Img convoy = new Img("ui", 352, 480, 32, 32, false);
    private final Img convoyOutline = new Img("ui", 384, 480, 32, 32, false);
    private final Img escortedConvoy = new Img("ui", 416, 480, 32, 32, false);
    private final Img escortedConvoyOutline = new Img("ui", 448, 480, 32, 32, false);
    private final Img victoryUnderlay = new Img("ui", 0, 512, 32, 32, false);
    private final Img defeatOverlay = new Img("ui", 32, 512, 32, 32, false);
    private final Img fight = new Img("ui", 64, 512, 16, 16, false);
    private final Img shipLoss = new Img("ui", 80, 512, 16, 16, false);
    private final Img mapGoto = new Img("ui", 0, 416, 16, 16, false);
    private final Img invader = new Img("ui", 16, 496, 16, 16, false);
    private final Img fight_big = new Img("ui", 272, 288, 64, 64, false);
    final Img edit = new Img("ui", 416, 416, 16, 16, false);
    final Img refit = new Img("ui", 224, 384, 16, 16, false);
    final Img repair = new Img("ui", 48, 416, 16, 16, false);
    final Img scrap = new Img("ui", 432, 416, 16, 16, false);
    final Img scuttle = new Img("ui", 144, 416, 16, 16, false);
    private final Img emptyNest = new Img("ui", 416, 464, 16, 16, false);
    private final Img emptyNestBG = new Img("ui", 432, 464, 16, 16, false);
    public static final double TOO_CLOSE = 1.0;
    public static final int AUTOSAVE_INTERVAL_MS = 300000;
    public static final int MIN_ZOOM_LEVEL = 4;
    public static final int MAX_ZOOM_LEVEL = 32;
    public static boolean autosaveFile2 = false;
    public int techScreenScrollX = MyDraw.SIDE_CLEARANCE;
    public int techScreenScrollY = MyDraw.UI_SPACING + MyDraw.TOP_BAR_H;
    public boolean debug = AGame.isDebug();
    public AirshipGame g;
    public final CampaignWorld w;
    public CombatOutcome combatOutcome;
    public boolean combatConfirmed = false;
    public UniScreen combatUniScreen = null;
    public int time = 0;
    private CampaignWorld.Speed lastNonStopSpeed = CampaignWorld.Speed.NORMAL;
    private long lastAutosaved = System.currentTimeMillis();
    public double scrollX = 0.0;
    public double scrollY = 0.0;
    public double adjScrollX = 0.0;
    public double adjScrollY = 0.0;
    public double zoom = 8.0;
    private boolean dragging = false;
    private double dragStartX;
    private double dragStartY;
    private double dragStartScrollX;
    private double dragStartScrollY;
    public Pt currentCursor = null;
    boolean menu;
    private boolean showEmpireDetails = false;
    private EmpireDetailsMode empireDetailsMode = EmpireDetailsMode.BUDGET;
    private MonsterNest selectedNest = null;
    private MonsterNest upgradeStartedNest = null;
    private MonsterNest upgradeNearingCompletionNest = null;
    private MonsterNest upgradeCompleteNest = null;
    ShipNameDialog shipNameDialog = null;
    Airship askForScrap = null;
    Airship askForScuttle = null;
    ArrayList<String> disconnectedPlayers = new ArrayList();
    private int fleetListWidth = 0;
    boolean checkLeave;
    private City hoverCity;
    private City nextHoverCity;
    private Fleet hoverFleet;
    private Fleet nextHoverFleet;
    public City menuCity;
    Fleet selectedFleet;
    ArrayList<Airship> fleetSelection = new ArrayList();
    private final ScrollBar fleetScrollBar = new ScrollBar();
    private MapLocation highlitTravelConnection;
    private int highlitTravelConnectionTime = 10;
    private StrategicHelp.HelpMsg helpMsg = null;
    private final ArrayList<Backdrop> backdrops = new ArrayList();
    private transient EnumMap<ShipType, UniScreen> mpEditors = new EnumMap(ShipType.class);
    public transient boolean showTooSlowMessage = false;
    public transient boolean tooSlowMessageShown = false;
    private final ScrollBar chatScrollBar = new ScrollBar();
    public final TextField chatField = new TextField();
    private final ChatAdapter<GenericChatMsg> chatAdapter = new ChatAdapter();
    JSONObject gameToLoad;
    ModReloadProgressDialog mrpd;
    private static final BackdropType[] STAINS = new BackdropType[]{new BackdropType(new Img("stains", 10, 11, 279, 167, false), false), new BackdropType(new Img("stains", 324, 0, 205, 202, false), false), new BackdropType(new Img("stains", 0, 200, 318, 321, false), false), new BackdropType(new Img("stains", 337, 220, 292, 290, false), false), new BackdropType(new Img("stains", 60, 577, 96, 99, false), false), new BackdropType(new Img("stains", 255, 594, 102, 88, false), false), new BackdropType(new Img("stains", 465, 528, 224, 215, false), false), new BackdropType(new Img("stains", 22, 697, 204, 209, false), false), new BackdropType(new Img("stains", 797, 192, 124, 114, false), false)};
    private static final BackdropType[] BACKDROPS = new BackdropType[]{new BackdropType(new Img("p_dove.jpg", 0, 0, 843, 1024, false), true), new BackdropType(new Img("p_wyrm.jpg", 0, 0, 843, 1024, false), true), new BackdropType(new Img("p_report.jpg", 0, 0, 843, 1024, false), true), new BackdropType(new Img("p_spy.jpg", 0, 0, 843, 1024, false), true), new BackdropType(new Img("p_listing.jpg", 0, 0, 843, 1024, false), true), new BackdropType(new Img("p_spider.jpg", 0, 0, 843, 1024, false), true), new BackdropType(new Img("p_dragon.jpg", 0, 0, 843, 1024, false), true), new BackdropType(new Img("p_torpedo.jpg", 0, 0, 843, 566, false), true), new BackdropType(new Img("p_guardian.jpg", 0, 0, 843, 1024, false), true), new BackdropType(new Img("p_cultists.jpg", 0, 0, 843, 1024, false), true), new BackdropType(new Img("p_kraken.jpg", 0, 0, 843, 1024, false), true), new BackdropType(new Img("p_jelly.jpg", 0, 0, 843, 1024, false), true), new BackdropType(new Img("notes.jpg", 114, 4, 292, 73, false), true), new BackdropType(new Img("notes.jpg", 396, 4, 153, 73, false), true), new BackdropType(new Img("notes.jpg", 530, 2, 152, 70, false), true), new BackdropType(new Img("notes.jpg", 86, 79, 215, 59, false), true), new BackdropType(new Img("notes.jpg", 425, 79, 121, 61, false), true), new BackdropType(new Img("notes.jpg", 540, 82, 116, 54, false), true), new BackdropType(new Img("notes.jpg", 329, 149, 116, 54, false), true), new BackdropType(new Img("notes.jpg", 438, 150, 116, 54, false), true), new BackdropType(new Img("notes.jpg", 118, 151, 225, 54, false), true), new BackdropType(new Img("notes.jpg", 80, 223, 225, 54, false), true), new BackdropType(new Img("notes.jpg", 280, 221, 225, 54, false), true), new BackdropType(new Img("notes.jpg", 250, 291, 265, 57, false), true), new BackdropType(new Img("notes.jpg", 127, 352, 288, 57, false), true), new BackdropType(new Img("notes.jpg", 429, 350, 288, 57, false), true), new BackdropType(new Img("notes.jpg", 124, 412, 288, 57, false), true), new BackdropType(new Img("notes.jpg", 100, 663, 288, 57, false), true), new BackdropType(new Img("notes.jpg", 112, 728, 288, 57, false), true), new BackdropType(new Img("notes.jpg", 101, 796, 288, 57, false), true), new BackdropType(new Img("notes.jpg", 382, 805, 288, 57, false), true), new BackdropType(new Img("notes.jpg", 384, 724, 288, 57, false), true), new BackdropType(new Img("notes.jpg", 394, 667, 288, 57, false), true), new BackdropType(new Img("notes.jpg", 115, 469, 288, 96, false), true), new BackdropType(new Img("notes.jpg", 371, 488, 288, 57, false), true), new BackdropType(new Img("notes.jpg", 507, 571, 155, 41, false), true), new BackdropType(new Img("notes.jpg", 104, 286, 155, 41, false), true), new BackdropType(new Img("notes.jpg", 561, 408, 155, 83, false), true), new BackdropType(new Img("notes.jpg", 411, 404, 155, 83, false), true), new BackdropType(new Img("notes.jpg", 123, 575, 177, 83, false), true), new BackdropType(new Img("notes.jpg", 339, 575, 177, 83, false), true)};
    public static Image MAP_BG;
    private final FleetElementAdapter fea = new FleetElementAdapter(this);
    public static final Clr MAP_SHADOW;
    public static final int DOCKED_FLEET_DX = -32;
    public static final int FLEET_IMG_SZ = 32;

    public StrategicScreen(AirshipGame g, CampaignWorld w) {
        int i;
        this.g = g;
        this.w = w;
        this.chatField.focus = false;
        this.chatScrollBar.stickToBottom = true;
        this.chatScrollBar.offset = 100000;
        for (i = 0; i < 5; ++i) {
            this.mountains[i] = new Img("ui", i * 16, 464, 16, 16, false);
            this.mountains_bg[i] = new Img("ui", i * 16, 432, 16, 16, false);
        }
        for (i = 0; i < 6; ++i) {
            this.trees[i] = new Img("ui", 80 + i * 16, 464, 16, 16, false);
            this.trees_bg[i] = new Img("ui", 80 + i * 16, 432, 16, 16, false);
        }
        for (i = 0; i < 4; ++i) {
            this.swamps[i] = new Img("ui", 192 + i * 16, 464, 16, 16, false);
        }
        for (i = 0; i < 7; ++i) {
            this.sea_creatures[i] = new Img("ui", 256 + i * 16, 464, 16, 16, false);
            this.sea_creatures_bg[i] = new Img("ui", 256 + i * 16, 432, 16, 16, false);
        }
        for (i = 0; i < 10; ++i) {
            this.cities[i] = new Img("ui", i * 16, 480, 16, 16, false);
            this.cities_bg[i] = new Img("ui", i * 16, 448, 16, 16, false);
        }
        for (i = 0; i < 6; ++i) {
            this.towns[i] = new Img("ui", 160 + i * 16, 448, 16, 16, false);
            this.towns_bg[i] = new Img("ui", 256 + i * 16, 448, 16, 16, false);
        }
        if (this.menuCity == null && w != null && w.player != null) {
            this.menuCity = w.player.cities.get(0);
        }
        this.updateBackgrounds();
    }

    void surrender() {
        if (this.w.player == null) {
            return;
        }
        this.w.giveCommand(Client.msg("surrenderStrategic").put("empire", this.w.player.id));
        this.spectate();
    }

    void spectate() {
        this.w.player = null;
        this.selectedFleet = null;
        this.selectedNest = null;
        this.menuCity = null;
    }

    void checkedLeave() {
        if (this.w.isHost()) {
            this.checkLeave = true;
        } else {
            this.leave();
        }
    }

    void leave() {
        if (this.g.s != this) {
            return;
        }
        this.g.doLowMemoryCheck();
        if (this.w != null && this.w.isMultiplayer()) {
            if (this.g.lanClient != null) {
                this.g.lanClient.close();
                this.g.lanClient = null;
                this.g.s = new MainMenu(this.g, MainMenu.Submenu.MULTIPLAYER);
            } else {
                this.g.s = new MetaLobbyScreen(this.g, null);
                this.g.sendMessage(Client.msg("changeChannel").put("id", 0));
                this.g.helloSent = false;
            }
            if (this.w.mpServer != null) {
                this.w.mpServer.close();
                this.w.mpServer = null;
                this.g.lanServer = null;
            }
        } else {
            this.g.s = new MainMenu(this.g, this.w != null && this.w.isMultiplayer() ? MainMenu.Submenu.MULTIPLAYER : MainMenu.Submenu.CONQUEST);
        }
    }

    void updateBackgrounds() {
        if (this.w == null) {
            return;
        }
        this.backdrops.clear();
        int nBackdrops = this.w.map.empires.size() / 4 + 5;
        ArrayList<BackdropType> stains = new ArrayList<BackdropType>(Arrays.asList(STAINS));
        Collections.shuffle(stains, AGame.ANIM_R);
        ArrayList<BackdropType> backs = new ArrayList<BackdropType>(Arrays.asList(BACKDROPS));
        Collections.shuffle(backs, AGame.ANIM_R);
        ArrayList<BackdropType> cands = new ArrayList<BackdropType>();
        cands.addAll(stains.subList(0, StrictMath.min(nBackdrops / 2, stains.size())));
        cands.addAll(backs);
        block6: for (int i = 0; i < nBackdrops; ++i) {
            BackdropType c = (BackdropType)cands.get(i);
            switch (AGame.ANIM_R.nextInt(4)) {
                case 0: {
                    this.backdrops.add(new Backdrop(c, -50 + AGame.ANIM_R.nextInt(this.w.map.water[0].length + 100 - c.img.srcWidth / 8), -AGame.ANIM_R.nextInt(100), -0.2 + 0.4 * AGame.ANIM_R.nextDouble()));
                    continue block6;
                }
                case 1: {
                    this.backdrops.add(new Backdrop(c, -50 + AGame.ANIM_R.nextInt(this.w.map.water[0].length + 100 - c.img.srcWidth / 8), this.w.map.water.length - c.img.srcHeight / 8 + AGame.ANIM_R.nextInt(50), -0.2 + 0.4 * AGame.ANIM_R.nextDouble()));
                    continue block6;
                }
                case 2: {
                    this.backdrops.add(new Backdrop(c, -AGame.ANIM_R.nextInt(50), -50 + AGame.ANIM_R.nextInt(this.w.map.water.length + 100 - c.img.srcHeight / 8), -0.2 + 0.4 * AGame.ANIM_R.nextDouble()));
                    continue block6;
                }
                case 3: {
                    this.backdrops.add(new Backdrop(c, this.w.map.water[0].length - c.img.srcWidth / 8 + AGame.ANIM_R.nextInt(100), -50 + AGame.ANIM_R.nextInt(this.w.map.water.length + 100 - c.img.srcHeight / 8), -0.2 + 0.4 * AGame.ANIM_R.nextDouble()));
                }
            }
        }
    }

    public double screenToWorldX(double x) {
        return x / this.zoom - this.adjScrollX;
    }

    public double screenToWorldY(double y) {
        return y / this.zoom - this.adjScrollY;
    }

    public double worldToScreenX(double x) {
        return (x + this.adjScrollX) * this.zoom;
    }

    public double worldToScreenY(double y) {
        return (y + this.adjScrollY) * this.zoom;
    }

    public void postCombat() {
        this.combatOutcome = this.w.postCombat(false);
    }

    public boolean modalUp() {
        if (this.w.player == null) {
            return false;
        }
        for (City c : this.w.player.cities) {
            if (!c.takeoverNeeded) continue;
            return true;
        }
        for (Fleet fl : this.w.player.getFleets()) {
            if (!fl.fleeDestinationNeeded) continue;
            if (this.selectedFleet == null) {
                this.selectedFleet = fl;
                this.fleetSelection = new ArrayList<Airship>(fl.actives);
                this.fleetSelection.addAll(fl.reserve);
            }
            return true;
        }
        return false;
    }

    private void doScrap() {
        if (this.w.player == null) {
            return;
        }
        this.w.giveCommand(this.w.shipMsg("scrapShip", this.askForScrap).put("empire", this.w.player.id));
        this.askForScrap = null;
        if (this.selectedFleet != null && this.selectedFleet.actives.isEmpty() && this.selectedFleet.reserve.isEmpty()) {
            this.selectedFleet = null;
        }
    }

    private void doScuttle() {
        if (this.w.player == null) {
            return;
        }
        this.w.giveCommand(this.w.shipMsg("scuttleShip", this.askForScuttle).put("empire", this.w.player.id));
        this.askForScuttle = null;
        if (this.selectedFleet != null && this.selectedFleet.actives.isEmpty() && this.selectedFleet.reserve.isEmpty()) {
            this.selectedFleet = null;
        }
    }

    private boolean showAutosaveNotice() {
        long t = System.currentTimeMillis();
        return t >= this.lastAutosaved + 300000L - 1000L && !this.w.defeat() && !this.w.victory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void autosaveIfNeeded() {
        long t = System.currentTimeMillis();
        if (t >= this.lastAutosaved + 300000L && !this.w.defeat() && !this.w.victory()) {
            this.lastAutosaved = t;
            File f = new File(new File(AGame.getGameDirectory(), "saves"), "AUTOSAVE" + (autosaveFile2 ? "_2" : "") + ".json");
            f.getParentFile().mkdirs();
            BufferedWriter bw = null;
            try {
                bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF-8"));
                this.w.toJSON().write(bw);
                bw.flush();
                autosaveFile2 = !autosaveFile2;
            }
            catch (OutOfMemoryError oome) {
                bw = null;
                this.g.reportError("AutosaveOOME", new RuntimeException(oome), null, false, true);
            }
            catch (Exception e) {
                this.g.reportError(Lang._t("Unable_to_save_game", new Object[0]), e, null, false);
            }
            finally {
                try {
                    bw.close();
                }
                catch (Exception oome) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void emergencySave(String reason) {
        long t = System.currentTimeMillis();
        File f = new File(new File(AGame.getGameDirectory(), "saves"), "EMERGENCY SAVE " + reason + " " + t + ".json");
        f.getParentFile().mkdirs();
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF-8"));
            this.w.toJSON().write(bw);
            bw.flush();
        }
        catch (OutOfMemoryError oome) {
            bw = null;
            this.g.reportError("emergencySaveOOME", new RuntimeException(oome), null, false, true);
        }
        catch (Exception exception) {
        }
        finally {
            try {
                bw.close();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public boolean backgroundTick(int ms) {
        if (this.w == null) {
            return false;
        }
        if (this.w.isMultiplayer()) {
            int mySideIndex;
            this.w.tick(ms);
            if (this.baseTick(ms)) {
                return true;
            }
            if (this.w.combatInfo != null && this.combatUniScreen != null && (mySideIndex = this.w.combatInfo.playerCombatSideIndex(this.w)) != -1 && this.w.multiplayerCampaignCombatIntent != null) {
                this.g.s = this.combatUniScreen;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean showNotice() {
        if (this.w == null) {
            return false;
        }
        return this.w.isMultiplayer();
    }

    private boolean showCombatNotice() {
        if (this.w == null) {
            return false;
        }
        return this.w.combatInfo != null && this.combatUniScreen != null || this.combatOutcome != null;
    }

    private String noticeInfoString() {
        if (this.w == null) {
            return "";
        }
        if (this.w.combatInfo != null && this.combatUniScreen != null) {
            boolean spectate;
            boolean bl = spectate = this.w.combatInfo.playerCombatSideIndex(this.w) == -1;
            if (spectate) {
                if (this.w.combatInfo.defendingLoc == null) {
                    return Lang._t("Combat_between_x_and_y", this.w.combatInfo.attacker(this.w.map).getName(), this.w.combatInfo.defender(this.w.map).getName());
                }
                return Lang._t("Combat_between_x_and_y_at_z", this.w.combatInfo.attacker(this.w.map).getName(), this.w.combatInfo.defender(this.w.map).getName(), this.w.combatInfo.defendingLoc.getDisplayName());
            }
            if (this.w.combatInfo.attacker(this.w.map) == this.w.player) {
                if (this.w.combatInfo.defendingLoc == null) {
                    return Lang._t("You_are_intercepting_x", this.w.combatInfo.defender(this.w.map).getName());
                }
                return Lang._t("You_are_attacking_x_at_y", this.w.combatInfo.defender(this.w.map).getName(), this.w.combatInfo.defendingLoc.getDisplayName());
            }
            if (this.w.combatInfo.defendingLoc == null) {
                return Lang._t("You_are_being_intercepted_by_x", this.w.combatInfo.attacker(this.w.map).getName());
            }
            return Lang._t("You_are_being_attacked_by_x_at_y", this.w.combatInfo.attacker(this.w.map).getName(), this.w.combatInfo.defendingLoc.getDisplayName());
        }
        if (this.combatOutcome != null) {
            if (this.combatOutcome.loc == null) {
                return Lang._t("outcome_vs_y", this.combatOutcome.type.getName(), this.combatOutcome.opponentName);
            }
            return Lang._t("outcome_vs_y_at_z", this.combatOutcome.type.getName(), this.combatOutcome.opponentName, this.combatOutcome.loc.getDisplayName());
        }
        return "???";
    }

    private String noticeButtonText() {
        if (this.w == null) {
            return "";
        }
        if (this.w.combatInfo != null && this.combatUniScreen != null) {
            boolean spectate;
            boolean bl = spectate = this.w.combatInfo.playerCombatSideIndex(this.w) == -1;
            if (spectate) {
                return Lang._t("Spectate", new Object[0]);
            }
            if (this.w.multiplayerCampaignCombatSetupIntent != null) {
                return Lang._t("Setup", new Object[0]) + " (" + this.w.multiplayerCampaignCombatSetupIntent.countdownLeft / 1000 + ")";
            }
            return Lang._t("Combat", new Object[0]);
        }
        return Lang._t("do_view", new Object[0]);
    }

    private void doNoticeButton() {
        if (this.w == null) {
            return;
        }
        if (this.w.combatInfo != null && this.combatUniScreen != null) {
            this.g.s = this.combatUniScreen;
        } else if (this.combatOutcome != null) {
            this.g.s = this;
            this.scrollX = -this.combatOutcome.x;
            this.scrollY = -this.combatOutcome.y;
        } else {
            this.g.s = this;
        }
    }

    @Override
    public void renderNotice(MyDraw d, ScreenMode sm, Hooks hs, Pt cursor, int x, int y, int width, int height) {
        if (this.showCombatNotice()) {
            final StrategicScreen ss = this;
            d.blit(this.fight_big, x, y);
            String info = this.noticeInfoString();
            d.text(info, AGame.FOUNT, x += this.fight_big.srcWidth + MyDraw.UI_SPACING, y, width -= this.fight_big.srcWidth + MyDraw.UI_SPACING);
            y = (int)((double)y + (d.textSize((String)info, (Fount)AGame.FOUNT, (double)((double)x), (double)((double)y), (int)width).height + (double)MyDraw.UI_SPACING));
            d.button(x, y, width, this.noticeButtonText(), new Runnable(){

                @Override
                public void run() {
                    ss.doNoticeButton();
                }
            });
        } else {
            d.blit(this.w.speed.icon, x, y);
        }
    }

    @Override
    public int noticeHeight(MyDraw d, int width) {
        if (this.showCombatNotice()) {
            return StrictMath.max(this.fight_big.srcHeight, (int)d.textSize((String)this.noticeInfoString(), (Fount)AGame.FOUNT, (double)0.0, (double)0.0, (int)(width - this.fight_big.srcWidth - MyDraw.UI_SPACING)).height + MyDraw.UI_SPACING + MyDraw.BUTTON_H);
        }
        return 16;
    }

    private boolean baseTick(int ms) {
        this.autosaveIfNeeded();
        if (this.w.combatInfo != null && this.w.waitingForCombatSetup && this.w.combatInfo.isUncontested()) {
            this.combatOutcome = this.w.postCombat(true);
            this.w.combatInfo = null;
            this.w.waitingForCombatSetup = false;
            this.combatConfirmed = false;
        }
        if (this.w.combatInfo != null && (this.combatConfirmed || this.w.isMultiplayer()) && this.w.waitingForCombatSetup) {
            HasCombatInfo intent;
            this.combatConfirmed = false;
            int mySideIndex = this.w.combatInfo.playerCombatSideIndex(this.w);
            if (this.w.isMultiplayer()) {
                this.w.multiplayerCampaignCombatSetupIntent = new MultiplayerCampaignCombatSetupIntent(this, this.w.combatInfo, mySideIndex == -1);
                intent = this.w.multiplayerCampaignCombatSetupIntent;
            } else {
                intent = new CampaignCombatSetupIntent(this, this.w.combatInfo);
            }
            this.w.waitingForCombatSetup = false;
            this.combatUniScreen = new UniScreen(this.g, (UniScreen.Intent)((Object)intent));
            this.combatUniScreen.combat = this.w.combatInfo.combat;
            this.combatUniScreen.cw = this.w;
            Combat.Side side = this.combatUniScreen.mySide = mySideIndex == -1 ? null : this.w.combatInfo.combat.sides.get(mySideIndex);
            if (!this.w.isMultiplayer()) {
                this.g.s = this.combatUniScreen;
                return true;
            }
        }
        if (this.combatUniScreen == null) {
            this.time += ms;
        }
        return false;
    }

    @Override
    public void input(Input in, MyDraw.State drawState, Pt cursor, Pt click, int ms) {
        int mySideIndex;
        if (this.mrpd != null) {
            ModReloadProgressDialog myMrpd = this.mrpd;
            if (this.mrpd.tick(in) && myMrpd == this.mrpd) {
                this.mrpd = null;
            }
            return;
        }
        if (this.w == null || this.w.map == null) {
            this.leave();
            this.g.showError(Lang._t("world_gen_load_failed", new Object[0]));
            return;
        }
        if (this.w.combatInfo == null) {
            this.combatUniScreen = null;
        }
        if (this.w.isMultiplayer() && !this.g.isConnected()) {
            this.emergencySave("disconnected");
            this.leave();
            this.g.showError(Lang._t("Connection_lost", new Object[0]));
            return;
        }
        if (!this.w.disconnectedPlayers.isEmpty()) {
            StringBuilder reason = new StringBuilder("disconnected");
            for (StrategicPlayerInfo spi : this.w.disconnectedPlayers) {
                this.disconnectedPlayers.add(spi.name);
                reason.append(AGame.makeFileSafe(spi.name));
            }
            this.emergencySave(reason.toString());
            this.w.disconnectedPlayers.clear();
        }
        if (this.selectedFleet != null && this.selectedFleet.actives.isEmpty() && this.selectedFleet.reserve.isEmpty()) {
            this.selectedFleet = null;
        }
        if (this.w.map.resistance != null) {
            this.w.map.resistance = null;
            this.w.map.approxCityDist = null;
            this.w.map.locPairs = null;
            Runtime.getRuntime().gc();
        }
        if (this.time == 0 && this.w.player != null) {
            this.scrollX = -this.w.player.cities.get((int)0).x;
            this.scrollY = -this.w.player.cities.get((int)0).y;
        }
        if (this.baseTick(ms)) {
            return;
        }
        if (this.w.combatInfo != null && this.combatUniScreen != null && (mySideIndex = this.w.combatInfo.playerCombatSideIndex(this.w)) != -1) {
            this.g.s = this.combatUniScreen;
            return;
        }
        ScreenMode sm = in.mode();
        Pt mouseDown = in.mouseDown();
        if (mouseDown != null && in.mouseDownButton() > 1) {
            if (this.dragging) {
                this.scrollX = (int)(this.dragStartScrollX + (mouseDown.x - this.dragStartX) / this.zoom);
                this.scrollY = (int)(this.dragStartScrollY + (mouseDown.y - this.dragStartY) / this.zoom);
            } else {
                this.dragStartX = mouseDown.x;
                this.dragStartY = mouseDown.y;
                this.dragStartScrollX = this.scrollX;
                this.dragStartScrollY = this.scrollY;
                this.dragging = true;
            }
        } else {
            this.dragging = false;
        }
        if (in.keyDown("ADD")) {
            this.zoom *= 1.0 + (double)AirshipGame.zoomSpeed * 0.01;
        }
        if (in.keyDown("SUBTRACT")) {
            this.zoom /= 1.0 + (double)AirshipGame.zoomSpeed * 0.01;
        }
        if (this.w.isMultiplayer()) {
            int y = MyDraw.TOP_BAR_H;
            int x = MyDraw.SIDE_CLEARANCE;
            int width = StrictMath.max(200, sm.width / 4);
            int height = StrictMath.max(150, sm.height / 4);
            this.chatScrollBar.tick(in, x, y, width, height);
            if (this.shipNameDialog == null && (cursor.x < (double)x || cursor.x > (double)(x + width) || cursor.y < (double)y || cursor.y > (double)(y + height)) && (this.selectedFleet == null || cursor.x < (double)(sm.width - this.fleetListWidth))) {
                this.adjScrollX = this.scrollX + (double)(sm.width / 2) / this.zoom;
                this.adjScrollY = this.scrollY + (double)(sm.height / 2) / this.zoom;
                double targetX = this.screenToWorldX(cursor.x);
                double targetY = this.screenToWorldY(cursor.y);
                this.zoom *= StrictMath.pow(1.0 + (double)AirshipGame.mouseWheelZoomSpeed * 1.0E-4, in.scrollAmount());
                this.zoom = StrictMath.max(4.0, StrictMath.min(32.0, this.zoom));
                this.scrollX = -targetX + (cursor.x - (double)(sm.width / 2)) / this.zoom;
                this.scrollY = -targetY + (cursor.y - (double)(sm.height / 2)) / this.zoom;
            }
        } else if (this.shipNameDialog == null && (this.selectedFleet == null || cursor.x < (double)(sm.width - this.fleetListWidth)) && in.scrollAmount() != 0) {
            this.adjScrollX = this.scrollX + (double)(sm.width / 2) / this.zoom;
            this.adjScrollY = this.scrollY + (double)(sm.height / 2) / this.zoom;
            double targetX = this.screenToWorldX(cursor.x);
            double targetY = this.screenToWorldY(cursor.y);
            this.zoom *= StrictMath.pow(1.0 + (double)AirshipGame.mouseWheelZoomSpeed * 1.0E-4, in.scrollAmount());
            this.zoom = StrictMath.max(4.0, StrictMath.min(32.0, this.zoom));
            this.scrollX = -targetX + (cursor.x - (double)(sm.width / 2)) / this.zoom;
            this.scrollY = -targetY + (cursor.y - (double)(sm.height / 2)) / this.zoom;
        }
        this.zoom = StrictMath.max(4.0, StrictMath.min(32.0, this.zoom));
        if (SimplePref.SIDE_BUMP_TO_SCROLL.get()) {
            if (cursor.y < 2.0) {
                this.scrollY += (double)AirshipGame.scrollSpeed / this.zoom;
            }
            if (cursor.y > (double)(in.mode().height - 2)) {
                this.scrollY -= (double)AirshipGame.scrollSpeed / this.zoom;
            }
            if (cursor.x < 2.0) {
                this.scrollX += (double)AirshipGame.scrollSpeed / this.zoom;
            }
            if (cursor.x > (double)(in.mode().width - 2)) {
                this.scrollX -= (double)AirshipGame.scrollSpeed / this.zoom;
            }
        }
        if (!this.chatField.focus) {
            if (in.keyDown("UP") || in.keyDown(Keys.get("up", "W"))) {
                this.scrollY += (double)AirshipGame.scrollSpeed / this.zoom;
            }
            if (in.keyDown("DOWN") || in.keyDown(Keys.get("down", "S"))) {
                this.scrollY -= (double)AirshipGame.scrollSpeed / this.zoom;
            }
            if (in.keyDown("LEFT") || in.keyDown(Keys.get("left", "A"))) {
                this.scrollX += (double)AirshipGame.scrollSpeed / this.zoom;
            }
            if (in.keyDown("RIGHT") || in.keyDown(Keys.get("right", "D"))) {
                this.scrollX -= (double)AirshipGame.scrollSpeed / this.zoom;
            }
        }
        this.scrollX = Math.max((double)(-this.w.map.cityOwnership.length), Math.min(0.0, this.scrollX));
        this.scrollY = Math.max((double)(-this.w.map.cityOwnership.length), Math.min(0.0, this.scrollY));
        this.adjScrollX = this.scrollX + (double)(sm.width / 2) / this.zoom;
        this.adjScrollY = this.scrollY + (double)(sm.height / 2) / this.zoom;
        if (this.w.combatInfo != null && !this.combatConfirmed && !this.w.isMultiplayer()) {
            if (in.keyPressed("ENTER") || in.clickButton() == 1) {
                this.combatConfirmed = true;
            }
            return;
        }
        if (this.checkLeave) {
            if (this.w.isMultiplayer()) {
                this.w.tick(ms);
            }
            return;
        }
        if (this.shipNameDialog != null) {
            this.shipNameDialog.input(in, drawState, cursor, click, ms);
            if (this.w.isMultiplayer()) {
                this.w.tick(ms);
            }
            return;
        }
        if (this.highlitTravelConnectionTime++ > 2) {
            this.highlitTravelConnection = null;
        }
        if (this.selectedFleet != null) {
            this.fleetListWidth = StrictMath.max(sm.width / 6, StrictMath.max(200, MyDraw.BUTTON_H * 3 + MyDraw.BUTTON_SPACING * 2 + MyDraw.WINDOW_INSET + MyDraw.BUTTON_SPACING + ScrollBar.SCROLL_BAR_W + MyDraw.PANEL_INSET + MyDraw.UI_SPACING));
            int x = sm.width - this.fleetListWidth;
            this.fleetScrollBar.tick(in, x, MyDraw.TOP_BAR_H + MyDraw.WINDOW_INSET, this.fleetListWidth, sm.height - MyDraw.TOP_BAR_H - MyDraw.WINDOW_INSET * 2);
        }
        if (!this.w.isMultiplayer() && this.g.strategicHelp && this.w.player != null) {
            this.helpMsg = this.w.help.getMessage(this);
        }
        if (!this.disconnectedPlayers.isEmpty()) {
            return;
        }
        if (this.w.victory() || this.w.defeat()) {
            if (this.w.isMultiplayer()) {
                this.w.tick(ms);
            }
            return;
        }
        if (this.combatOutcome != null) {
            if (this.w.player != null && this.w.player.rewardGiven != null) {
                this.combatOutcome = null;
            }
            if (this.w.isMultiplayer()) {
                this.w.tick(ms);
            }
            return;
        }
        if (this.askForScrap != null) {
            if (in.keyPressed("ENTER") && drawState.canClick()) {
                this.doScrap();
                drawState.hasClicked();
            }
            if (in.keyPressed("ESCAPE") && drawState.canClick()) {
                this.askForScrap = null;
                drawState.hasClicked();
            }
            if (this.w.isMultiplayer()) {
                this.w.tick(ms);
            }
            return;
        }
        if (this.askForScuttle != null) {
            if (in.keyPressed("ENTER") && drawState.canClick()) {
                this.doScuttle();
                drawState.hasClicked();
            }
            if (in.keyPressed("ESCAPE") && drawState.canClick()) {
                this.askForScuttle = null;
                drawState.hasClicked();
            }
            if (this.w.isMultiplayer()) {
                this.w.tick(ms);
            }
            return;
        }
        if (this.w.player != null) {
            if (this.selectedFleet == null || !this.selectedFleet.fleeDestinationNeeded) {
                for (Fleet fl : this.w.player.getFleets()) {
                    if (!fl.fleeDestinationNeeded) continue;
                    this.selectedFleet = fl;
                    this.fleetSelection = new ArrayList<Airship>(fl.actives);
                    this.fleetSelection.addAll(fl.reserve);
                    this.menuCity = null;
                }
            }
            if (this.selectedFleet != null && !this.w.player.getFleets().contains(this.selectedFleet)) {
                Fleet oldF = this.selectedFleet;
                this.selectedFleet = null;
                for (Fleet fl : this.w.player.getFleets()) {
                    if (!fl.containsAny(oldF)) continue;
                    this.selectedFleet = fl;
                    ArrayList<Airship> both = new ArrayList<Airship>(fl.actives);
                    both.addAll(fl.reserve);
                    this.fleetSelection.retainAll(both);
                    break;
                }
            }
        } else if (this.w.map.owner(this.selectedFleet) == null) {
            this.selectedFleet = null;
        }
        if (this.menu && drawState.canClick()) {
            if (in.keyPressed(Keys.get("strategic_menu_quit", "Q"))) {
                this.checkedLeave();
                drawState.hasClicked();
                return;
            }
            if (!this.w.isMultiplayer() && in.keyPressed(Keys.get("strategic_menu_open", "O"))) {
                drawState.hasClicked();
                this.open(false);
                return;
            }
            if (in.keyPressed(Keys.get("strategic_menu_save", "V"))) {
                drawState.hasClicked();
                this.save();
                return;
            }
            if (in.keyPressed(Keys.get("strategic_menu_back_to_game", "B")) || in.keyPressed("ESCAPE")) {
                this.menu = false;
                drawState.hasClicked();
            }
        }
        if (this.w.isMultiplayer() && this.chatField.focus && !this.menu) {
            this.chatField.input(in, drawState, cursor, click, ms);
            if (in.keyPressed("ENTER")) {
                this.sendChat();
            } else if (in.keyPressed("ESCAPE")) {
                this.chatField.focus = false;
            }
            this.w.tick(ms);
            return;
        }
        if (!this.menu && this.w.player != null && this.w.player.researchedTech != null) {
            if (in.keyPressed("ENTER")) {
                this.w.player.researchedTech = null;
                if (!this.w.player.isAllResearchDone(this.w.map)) {
                    this.g.s = new TechScreen(this);
                }
            } else if (in.keyPressed("ESCAPE")) {
                this.w.player.researchedTech = null;
            }
            if (this.w.isMultiplayer()) {
                this.w.tick(ms);
            }
            return;
        }
        if (this.selectedNest != null && this.selectedNest.type == null) {
            this.selectedNest = null;
        }
        if (this.selectedNest != null || this.w.player != null && this.w.player.rewardGiven != null) {
            if (in.keyPressed("ENTER") || in.keyPressed("ESCAPE")) {
                if (this.w.player != null && this.w.player.rewardGiven != null) {
                    this.w.player.rewardGiven = null;
                } else {
                    this.selectedNest = null;
                }
            }
            if (this.w.isMultiplayer()) {
                this.w.tick(ms);
            }
            return;
        }
        if (this.upgradeStartedNest != null && (in.keyPressed("ENTER") || in.keyPressed("ESCAPE"))) {
            this.upgradeStartedNest.showUpgradeStartDialog = false;
            this.upgradeStartedNest = null;
            if (this.w.isMultiplayer()) {
                this.w.tick(ms);
            }
            return;
        }
        if (this.upgradeNearingCompletionNest != null && (in.keyPressed("ENTER") || in.keyPressed("ESCAPE"))) {
            this.upgradeNearingCompletionNest.showUpgradeNearingCompletionDialog = false;
            this.upgradeNearingCompletionNest = null;
            if (this.w.isMultiplayer()) {
                this.w.tick(ms);
            }
            return;
        }
        if (this.upgradeCompleteNest != null && (in.keyPressed("ENTER") || in.keyPressed("ESCAPE"))) {
            this.upgradeCompleteNest.showUpgradeCompleteDialog = false;
            this.upgradeCompleteNest = null;
            if (this.w.isMultiplayer()) {
                this.w.tick(ms);
            }
            return;
        }
        if (this.upgradeStartedNest != null && this.upgradeStartedNest.type == null) {
            this.upgradeStartedNest = null;
        } else if (this.upgradeNearingCompletionNest != null && this.upgradeNearingCompletionNest.type == null) {
            this.upgradeNearingCompletionNest = null;
        } else if (this.upgradeCompleteNest != null && this.upgradeCompleteNest.type == null) {
            this.upgradeCompleteNest = null;
        }
        if (this.w.player != null) {
            block3: for (City c : this.w.player.cities) {
                for (MonsterNest n : c.nestsInTerritory(this.w.map)) {
                    if (n.showUpgradeStartDialog()) {
                        this.upgradeStartedNest = n;
                        break block3;
                    }
                    if (n.showUpgradeNearingCompletionDialog()) {
                        this.upgradeNearingCompletionNest = n;
                        break block3;
                    }
                    if (!n.showUpgradeCompleteDialog()) continue;
                    this.upgradeCompleteNest = n;
                    break block3;
                }
            }
        }
        if (!this.menu && in.keyPressed(Keys.get("strategic_menu", "M")) && drawState.canClick()) {
            this.menu = true;
            drawState.hasClicked();
        }
        if (this.selectedFleet != null && in.keyPressed("ESCAPE")) {
            this.selectedFleet = null;
        } else if (this.menuCity != null && in.keyPressed("ESCAPE")) {
            this.menuCity = null;
        } else if (!this.menu && !this.showEmpireDetails && this.selectedFleet == null && this.menuCity == null && in.keyPressed("ESCAPE") && drawState.canClick()) {
            this.menu = true;
            drawState.hasClicked();
        }
        if (this.w.player != null) {
            if (!this.menu && !this.w.player.spyActionResults.isEmpty()) {
                if (in.keyPressed("ENTER") || in.keyPressed("ESCAPE")) {
                    this.w.player.spyActionResults.remove(this.w.player.spyActionResults.size() - 1);
                }
                if (!this.w.isMultiplayer()) {
                    return;
                }
            } else if (!this.menu && !this.w.player.messages.isEmpty()) {
                if (in.keyPressed("ENTER") || in.keyPressed("ESCAPE")) {
                    this.w.player.messages.remove(this.w.player.messages.size() - 1);
                }
                if (!this.w.isMultiplayer()) {
                    return;
                }
            }
            if (!this.menu && in.keyPressed(Keys.get("strategic_pause", "SPACE")) && drawState.canClick()) {
                CampaignWorld.Speed newSpeed;
                CampaignWorld.Speed oldSpeed = this.w.isMultiplayer() ? (this.w.speedVoters.containsKey(this.w.player.id) ? this.w.speedVoters.get(this.w.player.id) : this.w.speed) : this.w.speed;
                if (oldSpeed == CampaignWorld.Speed.STOP) {
                    newSpeed = this.lastNonStopSpeed;
                } else {
                    newSpeed = CampaignWorld.Speed.STOP;
                    this.lastNonStopSpeed = oldSpeed;
                }
                this.w.giveCommand(Client.msg("setCampaignSpeed").put("voterID", this.w.player.id).put("speed", newSpeed.name()));
                drawState.hasClicked();
            }
        }
        if (!this.menu && this.w.player != null && this.w.map.techSpeed.speedMultiplier != 0.0 && in.keyPressed(Keys.get("strategic_research", "R"))) {
            this.g.s = new TechScreen(this);
        }
        if (!this.menu && !this.showEmpireDetails && in.keyPressed(Keys.get("strategic_empire_details", "E"))) {
            this.showEmpireDetails = true;
        }
        if (!this.menu && this.showEmpireDetails && (in.keyPressed("ESCAPE") || in.keyPressed("ENTER"))) {
            this.showEmpireDetails = false;
        }
        if (!this.menu && this.menuCity != null) {
            if (this.w.player == null) {
                if (in.keyPressed(Keys.get("strategic_city_view", Keys.get("strategic_city_view", "V"))) && drawState.canClick()) {
                    UniScreen us = new UniScreen(this.g, new ViewCityIntent(this));
                    us.cw = this.w;
                    us.wm = this.w.map;
                    us.city = this.menuCity;
                    this.g.s = us;
                }
            } else if (this.w.player.cities.contains(this.menuCity)) {
                if (in.keyPressed(Keys.get("strategic_city_create_ship", "C")) && drawState.canClick() && !this.w.isMultiplayer() && this.menuCity.canBuild(ShipType.AIRSHIP)) {
                    drawState.hasClicked();
                    this.createShip(ShipType.AIRSHIP);
                }
                if (in.keyPressed(Keys.get("strategic_city_build_ship", "B")) && drawState.canClick() && this.menuCity.canBuild(ShipType.AIRSHIP)) {
                    drawState.hasClicked();
                    this.buildSavedShip(ShipType.AIRSHIP);
                }
                if (in.keyPressed(Keys.get("strategic_city_create_landship", "N")) && drawState.canClick() && !this.w.isMultiplayer() && this.menuCity.canBuild(ShipType.LANDSHIP)) {
                    drawState.hasClicked();
                    this.createShip(ShipType.LANDSHIP);
                }
                if (in.keyPressed(Keys.get("strategic_city_build_landship", "L")) && drawState.canClick() && this.menuCity.canBuild(ShipType.LANDSHIP)) {
                    drawState.hasClicked();
                    this.buildSavedShip(ShipType.LANDSHIP);
                }
                if (in.keyPressed(Keys.get("strategic_city_defences", "F")) && drawState.canClick() && this.menuCity.canBuild(ShipType.BUILDING)) {
                    drawState.hasClicked();
                    this.defenses();
                }
            } else {
                Spy spy = this.w.player.getSpyFor(this.menuCity);
                if (in.keyPressed(Keys.get("strategic_city_spy", "P")) && drawState.canClick()) {
                    if (spy == null) {
                        if (this.w.player.money >= 100) {
                            this.w.giveCommand(Client.msg("sendSpy").put("empire", this.w.player.id).put("city", this.menuCity.id));
                        }
                    } else {
                        this.w.giveCommand(Client.msg("recallSpy").put("empire", this.w.player.id).put("city", this.menuCity.id));
                    }
                }
                if (in.keyPressed(Keys.get("strategic_city_view", "V")) && drawState.canClick() && (spy != null && spy.infiltrationTimeout == 0 || this.debug)) {
                    UniScreen us = new UniScreen(this.g, new EspionageIntent(this));
                    us.cw = this.w;
                    us.wm = this.w.map;
                    us.city = this.menuCity;
                    this.g.s = us;
                }
            }
        }
        if (this.w.isMultiplayer() && !this.chatField.focus && !this.menu && in.keyPressed("ENTER")) {
            this.chatField.focus = true;
        }
        if (!this.menu && !this.modalUp() && !this.showEmpireDetails || this.w.isMultiplayer()) {
            this.w.tick(ms);
        }
        this.hoverCity = this.nextHoverCity;
        this.nextHoverCity = null;
        this.hoverFleet = this.nextHoverFleet;
        this.nextHoverFleet = null;
    }

    public boolean loadMapBG() {
        if (MAP_BG == null) {
            MAP_BG = SpriteUtils.loadImage("map_bg4.png");
            if (MAP_BG == null) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                MAP_BG = SpriteUtils.loadImage("map_bg4.png");
            }
            if (MAP_BG == null) {
                this.g.reportError("Unable to load map background.", null, SpriteUtils.loadImageReport("map_bg4.png"), true, false);
                return false;
            }
        }
        return true;
    }

    public static String getShipTooltip(Airship ship) {
        StringBuilder statsB = new StringBuilder();
        for (Utils.Pair<String, String> s : ShipEditorUtils.getStats(ship, 0, null)) {
            statsB.append(Lang._t((String)s.a, new Object[0])).append((String)s.b).append("\n");
        }
        String stats = statsB.toString();
        return stats.substring(0, stats.length() - 1);
    }

    private void renderFleetList(MyDraw d, ScreenMode sm, Hooks hs, Pt cursor) {
        this.currentCursor = cursor;
        int width = StrictMath.max(sm.width / 6, StrictMath.max(200, MyDraw.BUTTON_H * 3 + MyDraw.BUTTON_SPACING * 2 + MyDraw.WINDOW_INSET + MyDraw.BUTTON_SPACING + ScrollBar.SCROLL_BAR_W + MyDraw.PANEL_INSET + MyDraw.UI_SPACING));
        int y = MyDraw.TOP_BAR_H;
        int x = sm.width - width;
        d.drawRightSideWindow(sm, x, y);
        int height = sm.height - y - MyDraw.BUTTON_SPACING * 2;
        if (StrategicScreen.checked(sm, x += MyDraw.WINDOW_INSET, y += MyDraw.BUTTON_SPACING, width -= MyDraw.WINDOW_INSET + MyDraw.BUTTON_SPACING, height)) {
            d.hook(x, y, width, height, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED, Hook.Type.MOUSE_1_DOWN}){

                public void run(Input in, Pt p, Hook.Type type) {
                }
            });
        }
        if (this.selectedFleet.size() > 2) {
            final boolean selectAll = this.selectedFleet.getAllShips().size() != this.fleetSelection.size();
            d.button(x, y, width, selectAll ? Lang._t("Select_All", new Object[0]) : Lang._t("Deselect_All", new Object[0]), new Runnable(){

                @Override
                public void run() {
                    if (StrategicScreen.this.selectedFleet == null) {
                        return;
                    }
                    StrategicScreen.this.fleetSelection.clear();
                    if (selectAll) {
                        StrategicScreen.this.fleetSelection.addAll(StrategicScreen.this.selectedFleet.getAllShips());
                    }
                }
            });
            y += MyDraw.BUTTON_H + MyDraw.UI_SPACING;
            height -= MyDraw.BUTTON_H + MyDraw.UI_SPACING;
        }
        this.fleetScrollBar.drawNaked(d, x, y, width, height, this.selectedFleet.getAllShips(), this.fea);
    }

    void refitShip(City c, Airship original) {
        if (this.w.player == null) {
            return;
        }
        if (this.w.isMultiplayer()) {
            ShipHelperWidget shw = ShipHelperWidget.get(original.type, this.w.player.arms, this.w.player.bonuses(), original, this.w.player.money);
            ConstructionBackend cbe = ShipEditorUtils.shipsList(original.type, shw);
            FileScreen fs = new FileScreen(cbe, new RefitShipMission(this.g, this, original, c, cbe), shw, new PriceInlineInfo(shw, original), original.type.name());
            fs.enabledFilter = new AffordableFilter(this.w.player.money, shw, original);
            fs.backgroundTask = this;
            this.g.s = fs;
        } else {
            UniScreen us = new UniScreen(this.g, new RefitFromStrategicIntent(this, original, c));
            us.cw = this.w;
            us.standaloneEditShip = original.clone();
            this.g.s = us;
        }
    }

    public void repairShip(City c, Airship ship) {
        if (this.w.player == null) {
            return;
        }
        if (!this.w.giveCommandWithSizeCheck(this.w.shipMsg("rebuildShip", ship).put("newShip", Compression.compressToString(ship.getOriginalDesign().toJSON(null).toString())).put("city", c.id).put("constructionType", MapLocation.ConstructionEntry.Type.REPAIR.name()))) {
            this.g.showError(Lang._t("sent_construction_too_large", new Object[0]));
        }
    }

    private void doIntercept(Fleet target) {
        if (this.w.player == null) {
            return;
        }
        JSONArray ships = new JSONArray();
        for (Airship s : this.fleetSelection) {
            ships.put(s.networkID);
        }
        this.w.giveCommand(Client.msg("intercept").put("fleet", this.selectedFleet.id).put("ships", ships).put("target", target.id));
    }

    private boolean canTravelTo(MapLocation destination) {
        if (this.w.player == null) {
            return false;
        }
        if (this.selectedFleet == null || this.fleetSelection.isEmpty()) {
            return false;
        }
        boolean selectionCanFly = true;
        for (Airship ship : this.fleetSelection) {
            if (!ship.type.onGround) continue;
            selectionCanFly = false;
            break;
        }
        if (selectionCanFly) {
            return true;
        }
        return this.selectedFleet.canTravelTo(destination, this.w.map, this.w.player);
    }

    private void travelTo(MapLocation destination) {
        if (this.w.player == null) {
            return;
        }
        JSONObject msg = Client.msg("sendFleet");
        msg.put("destination", destination.id);
        msg.put("id", this.selectedFleet.id);
        JSONArray a = new JSONArray();
        for (Airship s : this.fleetSelection) {
            a.put(s.networkID);
        }
        msg.put("ships", a);
        this.w.giveCommand(msg);
        this.selectedFleet = null;
    }

    private void renderMenu(MyDraw d, ScreenMode sm, Hooks hs, Pt cursor) {
        int width = 100;
        width = StrictMath.max(width, d.bw(Lang._t("Save", new Object[0])));
        width = StrictMath.max(width, d.bw(Lang._t("Open", new Object[0])));
        width = StrictMath.max(width, d.bw(Lang._t("Quit", new Object[0])));
        width = StrictMath.max(width, d.bw(Lang._t("Back_to_game", new Object[0])));
        int height = (MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING) * 3 + MyDraw.BUTTON_H + MyDraw.WINDOW_INSET * 2;
        int x = sm.width / 2 - (width += MyDraw.WINDOW_INSET * 2) / 2;
        int y = sm.height / 2 - height / 2;
        d.drawShadowedWindow(x, y, width, height);
        d.button(x += MyDraw.WINDOW_INSET, y += MyDraw.WINDOW_INSET, width -= MyDraw.WINDOW_INSET * 2, Lang._t("Save", new Object[0]), Keys.get("strategic_menu_save", "V"), new Runnable(){

            @Override
            public void run() {
                StrategicScreen.this.save();
            }
        });
        y += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING;
        if (this.w.isMultiplayer()) {
            d.button(x, y, width, Lang._t("Surrender", new Object[0]), null, new Runnable(){

                @Override
                public void run() {
                    StrategicScreen.this.surrender();
                }
            }, this.w.player != null);
        } else {
            d.button(x, y, width, Lang._t("Open", new Object[0]), Keys.get("strategic_menu_open", "O"), new Runnable(){

                @Override
                public void run() {
                    StrategicScreen.this.open(false);
                }
            });
        }
        d.button(x, y += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING, width, Lang._t("Quit", new Object[0]), Keys.get("strategic_menu_quit", "Q"), new Runnable(){

            @Override
            public void run() {
                StrategicScreen.this.checkedLeave();
            }
        });
        d.button(x, y += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING, width, Lang._t("Back_to_game", new Object[0]), Keys.get("strategic_menu_back_to_game", "B"), new Runnable(){

            @Override
            public void run() {
                StrategicScreen.this.menu = false;
            }
        });
        if (CampaignWorld.MAGIC_WIN_ENABLED) {
            d.button(x, y += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING, width, "Win", null, new Runnable(){

                @Override
                public void run() {
                    if (StrategicScreen.this.w.player == null) {
                        return;
                    }
                    StrategicScreen.this.w.giveCommand(Client.msg("magicWinStrategic").put("empire", StrategicScreen.this.w.player.id));
                }
            }, this.w.player != null);
        }
    }

    private void renderCityTakeoverOptions(MyDraw d, final City c) {
        int width = 80;
        for (TakeoverMethod tom : TakeoverMethod.values()) {
            width = StrictMath.max(width, d.bw(tom.getName()));
        }
        int x = (int)this.worldToScreenX(c.x) - width;
        int y = (int)this.worldToScreenY(c.y) - 16 - 20 - 5;
        int h = (MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING) * TakeoverMethod.values().length - MyDraw.BUTTON_SPACING + MyDraw.PANEL_INSET * 2;
        d.drawShadowedPanel(x, y - h, width + MyDraw.PANEL_INSET * 2, h);
        y = y - h + MyDraw.PANEL_INSET;
        x += MyDraw.PANEL_INSET;
        for (final TakeoverMethod tom : TakeoverMethod.values()) {
            d.button(x, y, width, tom.getName(), new Runnable(){

                @Override
                public void run() {
                    StrategicScreen.this.w.giveCommand(Client.msg("chooseTakeoverMethod").put("city", c.id).put("method", tom.name()));
                }
            });
            d.tooltip((double)x, (double)y, (double)width, (double)MyDraw.BUTTON_H, tom.getTooltip());
            y += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING;
        }
    }

    private void renderLocationMoveMenu(final MapLocation c, MyDraw d, ScreenMode sm, Hooks hs, Pt cursor) {
        int x = (int)this.worldToScreenX(c.x) - (c instanceof City ? 16 : 9);
        int y = (int)this.worldToScreenY(c.y) + (c instanceof City ? 25 : 13);
        if (this.selectedFleet.location != c && !this.fleetSelection.isEmpty() && this.canTravelTo(c)) {
            boolean invade;
            boolean bl = invade = this.w.map.defender(c) != this.w.map.owner(this.selectedFleet);
            if (this.w.map.defender(c) instanceof MonsterNest && ((MonsterNest)this.w.map.defender((MapLocation)c)).type == null) {
                invade = false;
            }
            if (this.w.player.money == 0 && (!this.selectedFleet.fleeDestinationNeeded || invade)) {
                d.heavilyBorderedText(invade ? Lang._t("no_money_hint_invade", new Object[0]) : Lang._t("no_money_hint_move", new Object[0]), AGame.FOUNT, AGame.FOUNT_OUTLINE, RED_INK, PARCHMENT, x, y, 10000);
            } else {
                String text = invade ? (c instanceof MonsterNest ? Lang._t("Attack", new Object[0]) : Lang._t("Invade", new Object[0])) : Lang._t("Move", new Object[0]);
                int width = d.bw(text);
                if (StrategicScreen.checked(sm, x, y, width, MyDraw.BUTTON_H)) {
                    d.button(x, y, width, text, new Runnable(){

                        @Override
                        public void run() {
                            StrategicScreen.this.travelTo(c);
                        }
                    });
                    d.hook(x, y, width, MyDraw.BUTTON_H, new Hook(new Hook.Type[]{Hook.Type.HOVER}){

                        public void run(Input in, Pt p, Hook.Type type) {
                            if (StrategicScreen.this.selectedFleet == null || StrategicScreen.this.selectedFleet.location == null) {
                                return;
                            }
                            StrategicScreen.this.highlitTravelConnection = c;
                            StrategicScreen.this.highlitTravelConnectionTime = 0;
                        }
                    });
                }
            }
        }
    }

    private void renderCityMenu(MyDraw d, ScreenMode sm, Hooks hs, Pt cursor) {
        int nButtons;
        City c = this.menuCity;
        final StrategicScreen ss = this;
        int x = (int)this.worldToScreenX(c.x) - 16;
        int y = (int)this.worldToScreenY(c.y) + 25;
        int width = 120;
        if (this.w.player == null) {
            d.button(x, y, width, Lang._t("View_City", new Object[0]), "V", new Runnable(){

                @Override
                public void run() {
                    UniScreen us = new UniScreen(StrategicScreen.this.g, new ViewCityIntent(ss));
                    us.cw = StrategicScreen.this.w;
                    us.wm = StrategicScreen.this.w.map;
                    us.city = StrategicScreen.this.menuCity;
                    StrategicScreen.this.g.s = us;
                }
            });
            y += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING;
            return;
        }
        int cancelW = d.bw(Lang._t("Cancel", new Object[0]));
        width = StrictMath.max(width, d.bw(Lang._t("Create_ship", new Object[0])));
        width = StrictMath.max(width, d.bw(Lang._t("Build_ship", new Object[0])));
        width = StrictMath.max(width, d.bw(Lang._t("Create_landship", new Object[0])));
        width = StrictMath.max(width, d.bw(Lang._t("Build_landship", new Object[0])));
        width = StrictMath.max(width, d.bw(Lang._t("Defenses", new Object[0])));
        width = StrictMath.max(width, d.bw(Lang._t("Send_Spy_Sx", 100)));
        width = StrictMath.max(width, d.bw(Lang._t("Recall_Spy", new Object[0])));
        width = StrictMath.max(width, d.bw(Lang._t("View_City", new Object[0])));
        if (this.w.player.cities.contains(c)) {
            for (Bonus b : this.w.player.bonuses().list()) {
                for (Airship design : b.getEnabledSpecialConstructions()) {
                    if (c.isTown && design.type.mobile) continue;
                    width = StrictMath.max(width, d.bw(Lang._t("Build_" + design.getName().replace(" ", "_"), new Object[0]) + " $" + design.getCost()));
                }
            }
        }
        int cIndex = 1;
        for (MapLocation.ConstructionEntry ce : this.menuCity.constructing) {
            width = StrictMath.max(width, (int)d.textSize((String)new StringBuilder().append((int)cIndex++).append((String)". ").append((String)ce.desc()).toString(), (Fount)AGame.FOUNT).x + MyDraw.UI_SPACING + cancelW);
        }
        Spy spy = this.w.player.getSpyFor(c);
        if (this.w.player.cities.contains(c)) {
            nButtons = c.constructing.size();
            if (c.canBuild(ShipType.AIRSHIP)) {
                nButtons += this.w.isMultiplayer() ? 1 : 2;
            }
            if (c.canBuild(ShipType.LANDSHIP)) {
                nButtons += this.w.isMultiplayer() ? 1 : 2;
            }
            if (c.canBuild(ShipType.BUILDING)) {
                ++nButtons;
            }
            for (Bonus b : this.w.player.bonuses().list()) {
                for (final Airship design : b.getEnabledSpecialConstructions()) {
                    if (c.isTown && design.type.mobile) continue;
                    ++nButtons;
                }
            }
        } else {
            nButtons = spy == null ? 1 : 2;
        }
        d.drawShadowedPanel(x, y, width + MyDraw.PANEL_INSET * 2, nButtons * (MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING) - MyDraw.BUTTON_SPACING + MyDraw.PANEL_INSET * 2 + (c.constructing.isEmpty() || !this.w.player.cities.contains(c) ? 0 : MyDraw.PROGRESS_BAR_H + MyDraw.UI_SPACING * 2 - MyDraw.BUTTON_SPACING));
        x += MyDraw.PANEL_INSET;
        y += MyDraw.PANEL_INSET;
        if (this.w.player.cities.contains(c)) {
            cIndex = 1;
            for (final MapLocation.ConstructionEntry ce : this.menuCity.constructing) {
                if (ce == this.menuCity.constructing.get(0)) {
                    d.progressBar(x, y, width, (double)c.constructionProgress * 1.0 / (double)c.constructionTimeCost());
                    y += MyDraw.PROGRESS_BAR_H + MyDraw.UI_SPACING;
                }
                d.text(cIndex++ + ". " + ce.desc(), AGame.FOUNT, x, y);
                d.tooltip((double)x, (double)y, (double)(width - cancelW), (double)MyDraw.BUTTON_H, StrategicScreen.getShipTooltip(ce.ship));
                d.button(x + width - cancelW, y, cancelW, Lang._t("Cancel", new Object[0]), null, new Runnable(){

                    @Override
                    public void run() {
                        StrategicScreen.this.cancelShip(ce);
                    }
                }, c.canBuild(ce.ship.type));
                y += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING;
            }
            if (!this.menuCity.constructing.isEmpty()) {
                y += MyDraw.UI_SPACING - MyDraw.BUTTON_SPACING;
            }
            if (!this.w.isMultiplayer() && c.canBuild(ShipType.AIRSHIP)) {
                d.button(x, y, width, Lang._t("Create_ship", new Object[0]), Keys.get("strategic_city_create_ship", "C"), new Runnable(){

                    @Override
                    public void run() {
                        StrategicScreen.this.createShip(ShipType.AIRSHIP);
                    }
                });
                y += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING;
            }
            if (c.canBuild(ShipType.AIRSHIP)) {
                d.button(x, y, width, Lang._t("Build_ship", new Object[0]), Keys.get("strategic_city_build_ship", "B"), new Runnable(){

                    @Override
                    public void run() {
                        StrategicScreen.this.buildSavedShip(ShipType.AIRSHIP);
                    }
                });
                y += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING;
            }
            if (!this.w.isMultiplayer() && c.canBuild(ShipType.LANDSHIP)) {
                d.button(x, y, width, Lang._t("Create_landship", new Object[0]), Keys.get("strategic_city_create_landship", "N"), new Runnable(){

                    @Override
                    public void run() {
                        StrategicScreen.this.createShip(ShipType.LANDSHIP);
                    }
                });
                y += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING;
            }
            if (c.canBuild(ShipType.LANDSHIP)) {
                d.button(x, y, width, Lang._t("Build_landship", new Object[0]), Keys.get("strategic_city_build_landship", "L"), new Runnable(){

                    @Override
                    public void run() {
                        StrategicScreen.this.buildSavedShip(ShipType.LANDSHIP);
                    }
                });
                y += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING;
            }
            for (Bonus b : this.w.player.bonuses().list()) {
                for (final Airship design : b.getEnabledSpecialConstructions()) {
                    if (c.isTown && design.type.mobile) continue;
                    d.button(x, y, width, Lang._t("Build_" + design.getName().replace(" ", "_"), new Object[0]) + " $" + design.getCost(), null, new Runnable(){

                        @Override
                        public void run() {
                            StrategicScreen.this.build(design.clone());
                        }
                    }, c.canBuild(design.type) && design.getCost() <= this.w.player.money);
                    y += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING;
                }
            }
            d.button(x, y, width, Lang._t("Defenses", new Object[0]), Keys.get("strategic_city_defences", "F"), new Runnable(){

                @Override
                public void run() {
                    StrategicScreen.this.defenses();
                }
            }, c.canBuild(ShipType.BUILDING));
        } else if (c != null) {
            final City theCity = c;
            if (spy == null && !this.debug) {
                d.button(x, y, width, Lang._t("Send_Spy_Sx", 100), Keys.get("strategic_city_spy", "P"), new Runnable(){

                    @Override
                    public void run() {
                        if (StrategicScreen.this.w.player == null) {
                            return;
                        }
                        StrategicScreen.this.w.giveCommand(Client.msg("sendSpy").put("empire", StrategicScreen.this.w.player.id).put("city", theCity.id));
                    }
                }, this.w.player.money >= 100);
            } else {
                if (spy != null) {
                    d.button(x, y, width, Lang._t("Recall_Spy", new Object[0]), Keys.get("strategic_city_spy", "P"), new Runnable(){

                        @Override
                        public void run() {
                            if (StrategicScreen.this.w.player == null) {
                                return;
                            }
                            StrategicScreen.this.w.giveCommand(Client.msg("recallSpy").put("empire", StrategicScreen.this.w.player.id).put("city", StrategicScreen.this.menuCity.id));
                        }
                    });
                    y += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING;
                }
                d.button(x, y, width, Lang._t("View_City", new Object[0]), Keys.get("strategic_city_view", "V"), new Runnable(){

                    @Override
                    public void run() {
                        UniScreen us = new UniScreen(StrategicScreen.this.g, new EspionageIntent(ss));
                        us.cw = StrategicScreen.this.w;
                        us.wm = StrategicScreen.this.w.map;
                        us.city = theCity;
                        StrategicScreen.this.g.s = us;
                    }
                }, this.debug || spy.infiltrationTimeout == 0);
            }
        }
    }

    private void sendChat() {
        if (!this.chatField.getText().isEmpty()) {
            this.g.sendMessage(Client.msg("chat").put("text", this.chatField.getText()).put("id", this.g.playerID()));
            this.chatField.setText("");
        }
        this.chatField.focus = false;
    }

    private void buildSavedShip(ShipType st) {
        if (this.w.player == null) {
            return;
        }
        ShipHelperWidget shw = ShipHelperWidget.get(st, this.w.player.arms, this.w.player.bonuses(), null, this.w.player.money);
        ConstructionBackend cbe = ShipEditorUtils.shipsList(st, shw);
        FileScreen fs = new FileScreen(cbe, new BuildShipMission(this.g, this, st, cbe), shw, new PriceInlineInfo(shw, null), st.name());
        fs.enabledFilter = new AffordableFilter(this.w.player.money, shw, null);
        fs.backgroundTask = this;
        this.g.s = fs;
    }

    public void build(final Airship a) {
        if (this.w.player == null) {
            return;
        }
        a.constructionBonuses = this.w.player.bonuses();
        a.currentBonuses = this.w.player.bonuses();
        a.repair();
        a.updateOriginalDesign();
        this.shipNameDialog = new ShipNameDialog(this.w, a, this.w.player, new ShipNameDialog.ShipNameCallback(){

            @Override
            public void run(String name, int n) {
                a.setName(name);
                for (int i = 0; i < n; ++i) {
                    if (StrategicScreen.this.w.giveCommandWithSizeCheck(Client.msg("buildShip").put("ship", Compression.compressToString(a.toJSON(null).toString())).put("city", StrategicScreen.this.menuCity.id))) continue;
                    StrategicScreen.this.g.showError(Lang._t("sent_construction_too_large", new Object[0]));
                }
                StrategicScreen.this.shipNameDialog = null;
            }

            @Override
            public boolean canHaveMultiple() {
                return true;
            }

            @Override
            public boolean multipleAllowed(int n) {
                return n > 0 && a.getCost() * n <= StrategicScreen.this.w.player.money;
            }
        }, new Runnable(){

            @Override
            public void run() {
                StrategicScreen.this.shipNameDialog = null;
            }
        });
    }

    public void rebuild(City c, Airship original, Airship newShip) {
        if (this.w.player == null) {
            return;
        }
        newShip.constructionBonuses = this.w.player.bonuses();
        newShip.currentBonuses = this.w.player.bonuses();
        if (!this.w.giveCommandWithSizeCheck(this.w.shipMsg("rebuildShip", original).put("newShip", Compression.compressToString(newShip.toJSON(null).toString())).put("city", c.id).put("constructionType", MapLocation.ConstructionEntry.Type.REFIT.name()))) {
            this.g.showError(Lang._t("sent_construction_too_large", new Object[0]));
        }
    }

    private void createShip(ShipType st) {
        if (this.w.player == null) {
            return;
        }
        UniScreen us = new UniScreen(this.g, new DesignFromStrategicIntent(this));
        us.cw = this.w;
        us.standaloneEditShip = new Airship(st, this.w.map.lang, this.w.map.r);
        us.standaloneEditShip.constructionBonuses = this.w.player.bonuses();
        us.standaloneEditShip.currentBonuses = this.w.player.bonuses();
        this.g.s = us;
    }

    private void cancelShip(MapLocation.ConstructionEntry ce) {
        if (this.w.player == null) {
            return;
        }
        if (!this.menuCity.constructing.contains(ce)) {
            return;
        }
        this.w.giveCommand(Client.msg("cancelShipConstruction").put("city", this.menuCity.id).put("id", ce.id));
    }

    private void doEdit(ShipType st) {
        if (!this.mpEditors.containsKey((Object)st)) {
            UniScreen us = new UniScreen(this.g, new MultiplayerEditShipIntent(this));
            us.standaloneEditShip = new Airship(st, this.w.map.lang, AGame.ANIM_R);
            us.standaloneEditShip.constructionBonuses = this.w.player.bonuses();
            us.standaloneEditShip.currentBonuses = this.w.player.bonuses();
            us.cw = this.w;
            this.mpEditors.put(st, us);
        }
        this.g.s = this.mpEditors.get((Object)st);
    }

    private void defenses() {
        UniScreen us = new UniScreen(this.g, new DefencesIntent(this));
        us.city = this.menuCity;
        us.wm = this.w.map;
        us.cw = this.w;
        this.g.s = us;
    }

    private boolean hasSpy(City c) {
        if (this.w.player == null) {
            return false;
        }
        for (Spy s : this.w.player.spies) {
            if (s.location != c) continue;
            return s.infiltrationTimeout <= 0;
        }
        return false;
    }

    private void drawRoadLine(ScreenMode sm, Graphics g, Road road) {
        for (int i = 0; i < road.path.size() - 1; ++i) {
            ShapeUtils.P a = road.path.get(i);
            ShapeUtils.P b = road.path.get(i + 1);
            double ax = this.worldToScreenX(a.x);
            double ay = this.worldToScreenY(a.y);
            double bx = this.worldToScreenX(b.x);
            double by = this.worldToScreenY(b.y);
            if (ax < 0.0 && bx < 0.0 || ay < 0.0 && by < 0.0 || ax > (double)sm.width && bx > (double)sm.width || ay > (double)sm.height && by > (double)sm.height) continue;
            g.drawLine((float)ax, (float)ay, (float)bx, (float)by);
        }
    }

    private void highlightRoadLine(ScreenMode sm, Graphics g, Road road) {
        g.setColor(DARKER_INK_C);
        g.setLineWidth(4.0f);
        this.drawRoadLine(sm, g, road);
        g.setLineWidth(1.0f);
    }

    private void highlightItinerary(ScreenMode sm, Graphics g, Fleet.Itinerary it) {
        g.setColor(DARKER_INK_C);
        g.setLineWidth(4.0f);
        for (Fleet.Segment s : it.segments) {
            Road road = s.road;
            for (int i = s.startIndex; i < s.endIndex - 1; ++i) {
                ShapeUtils.P a = road.path.get(i);
                ShapeUtils.P b = road.path.get(i + 1);
                double ax = this.worldToScreenX(a.x);
                double ay = this.worldToScreenY(a.y);
                double bx = this.worldToScreenX(b.x);
                double by = this.worldToScreenY(b.y);
                if (ax < 0.0 && bx < 0.0 || ay < 0.0 && by < 0.0 || ax > (double)sm.width && bx > (double)sm.width || ay > (double)sm.height && by > (double)sm.height) continue;
                g.drawLine((float)ax, (float)ay, (float)bx, (float)by);
            }
        }
        g.setLineWidth(1.0f);
    }

    private void renderFleet(MyDraw d, ScreenMode sm, final Fleet fl, Empire eOwner, MonsterNest mOwner) {
        int x = (int)this.worldToScreenX(fl.realX());
        int y = (int)this.worldToScreenY(fl.realY());
        if (!fl.inTransit()) {
            x -= 32;
            if (mOwner != null) {
                return;
            }
        }
        Graphics g = (Graphics)d.frame().nativeRenderer();
        if (fl.inTransit() && (fl == this.selectedFleet || fl == this.hoverFleet)) {
            if (fl.interceptPoint != null) {
                d.dottedLine(DARKER_INK, 2, 7, this.worldToScreenX(fl.interceptPoint.x), this.worldToScreenY(fl.interceptPoint.y), x, y);
                if (fl.interceptTarget.interceptPoint != null) {
                    d.dottedLine(DARKER_INK, 2, 7, this.worldToScreenX(fl.interceptTarget.interceptPoint.x), this.worldToScreenY(fl.interceptTarget.interceptPoint.y), x, y);
                } else if (fl.interceptTarget.destination != null) {
                    d.dottedLine(DARKER_INK, 2, 7, this.worldToScreenX(fl.interceptTarget.destination.x), this.worldToScreenY(fl.interceptTarget.destination.y), x, y);
                }
            } else if (fl.interceptItinerary != null) {
                this.highlightItinerary(sm, g, fl.interceptItinerary);
            } else if (fl.usingRoad != null) {
                this.highlightRoadLine(sm, g, fl.usingRoad);
            } else {
                d.dottedLine(DARKER_INK, 2, 7, this.worldToScreenX(fl.destination.x), this.worldToScreenY(fl.destination.y), x, y);
            }
        }
        if (StrategicScreen.checked(sm, x - 16, y - 16, 32, 32)) {
            d.hook(x - 16, y - 16, 32.0, 32.0, new Hook(new Hook.Type[]{Hook.Type.HOVER}){

                public void run(Input in, Pt p, Hook.Type type) {
                    StrategicScreen.this.nextHoverFleet = fl;
                }
            });
        }
        if (eOwner != null) {
            Img fleetApp = this.airfleet;
            Img fleetAppOutline = this.airfleetOutline;
            if (!fl.canFly()) {
                if (fl.usingRoad != null && fl.usingRoad.seaRoute) {
                    if (fl.groundOnly()) {
                        fleetApp = this.convoy;
                        fleetAppOutline = this.convoyOutline;
                    } else {
                        fleetApp = this.escortedConvoy;
                        fleetAppOutline = this.escortedConvoyOutline;
                    }
                } else if (fl.groundOnly()) {
                    fleetApp = this.landfleet;
                    fleetAppOutline = this.landfleetOutline;
                } else {
                    fleetApp = this.mixedfleet;
                    fleetAppOutline = this.mixedfleetOutline;
                }
            }
            d.blit(fleetApp, fl == this.selectedFleet || fl == this.hoverFleet ? eOwner.getMainTincture().tint.mix(0.7, INK) : PARCHMENT, x - 16, y - 16);
            d.blit(fleetAppOutline, fl == this.selectedFleet || fl == this.hoverFleet ? PARCHMENT : eOwner.getMainTincture().tint.mix(0.7, INK), x - 16, y - 16);
            d.rect(PARCHMENT, x - 10, y - 16 - 16 - 2 - MyDraw.BUTTON_SPACING, 20.0, 20.0);
            d.rect(INK, x - 9, y - 16 - 16 - 1 - MyDraw.BUTTON_SPACING, 18.0, 18.0);
            eOwner.arms.draw(d, x - 8, y - 16 - 16 - MyDraw.BUTTON_SPACING, 16);
        } else if (mOwner != null) {
            if (mOwner.type.mapFleetImage == null) {
                d.rect(PARCHMENT, x - 10, y - 10, 20.0, 20.0);
                d.rect(INK, x - 9, y - 9, 18.0, 18.0);
                mOwner.getArms().draw(d, x - 8, y - 8, 16);
            } else {
                for (int dy = -1; dy <= 1; ++dy) {
                    for (int dx = -1; dx <= 1; ++dx) {
                        d.blit(mOwner.type.mapFleetBackground, fl == this.hoverFleet ? DARKER_INK : PARCHMENT, x + dx - 8, y + dy - 8);
                    }
                }
                d.blit(mOwner.type.mapFleetImage, fl == this.hoverFleet ? PARCHMENT : DARKER_INK, x - 8, y - 8);
            }
        }
        if (this.selectedFleet != null && eOwner != this.w.player && this.w.player != null && this.selectedFleet.interceptTarget != fl && this.selectedFleet.canIntercept(fl, this.fleetSelection, this.w.map)) {
            int tw = x - 16 - MyDraw.UI_SPACING - (int)d.textSize((String)Lang._t((String)"Click_to_intercept", (Object[])new Object[0]).toUpperCase(), (Fount)AGame.FOUNT).x;
            d.heavilyBorderedText(Lang._t("Click_to_intercept", new Object[0]).toUpperCase(), AGame.FOUNT, AGame.FOUNT_OUTLINE, DARKER_INK, PARCHMENT, tw, y - 16, 10000);
            if (StrategicScreen.checked(sm, tw, y - 16, tw, AGame.FOUNT_OUTLINE.height)) {
                d.hook(tw, y - 16, tw, AGame.FOUNT_OUTLINE.height, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED}){

                    public void run(Input in, Pt p, Hook.Type type) {
                        StrategicScreen.this.doIntercept(fl);
                    }
                });
            }
            if (StrategicScreen.checked(sm, x - 16, y - 16, 32, 32)) {
                d.hook(x - 16, y - 16, 32.0, 32.0, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED}){

                    public void run(Input in, Pt p, Hook.Type type) {
                        StrategicScreen.this.doIntercept(fl);
                    }
                });
            }
        }
    }

    private static boolean checked(ScreenMode sm, int x, int y, int w, int h) {
        return x + w > 0 && y + h > 0 && x <= sm.width && y <= sm.height;
    }

    private static void checkedBlit(MyDraw d, ScreenMode sm, Img img, Clr c, double x, double y) {
        if (img != null && x < (double)sm.width && y < (double)sm.height && x + (double)img.srcWidth > 0.0 && y + (double)img.srcHeight > 0.0) {
            d.blit(img, c, x, y);
        }
    }

    public static void checkedBorderedBlit(MyDraw d, ScreenMode sm, Img img, Clr c, Clr border, double x, double y) {
        if (img != null && x < (double)sm.width && y < (double)sm.height && x + (double)img.srcWidth > 0.0 && y + (double)img.srcHeight > 0.0) {
            d.borderedBlit(img, c, border, x, y);
        }
    }

    public static void checkedHeavilyBorderedText(MyDraw d, ScreenMode sm, String text, Fount f, Fount bg, Clr c, Clr border, int x, int y, int maxW) {
        if (x >= sm.width || y >= sm.height || x + maxW < 0) {
            return;
        }
        Pt sz = d.textSize(text, bg, maxW, 10000, 0, true);
        if ((double)x + sz.x < 0.0 || (double)y + sz.y < 0.0) {
            return;
        }
        d.heavilyBorderedText(text, f, bg, c, border, x, y, maxW);
    }

    @Override
    public void render(final MyDraw d, ScreenMode sm, Hooks hs, Pt cursor) {
        CoatOfArms coa;
        if (!this.loadMapBG()) {
            return;
        }
        if (this.upgradeStartedNest != null && this.upgradeStartedNest.type == null) {
            this.upgradeStartedNest = null;
        }
        if (this.upgradeNearingCompletionNest != null && this.upgradeNearingCompletionNest.type == null) {
            this.upgradeNearingCompletionNest = null;
        }
        if (this.upgradeCompleteNest != null && this.upgradeCompleteNest.type == null) {
            this.upgradeCompleteNest = null;
        }
        d.rect(MyDraw.DESK, 0.0, 0.0, sm.width, sm.height);
        if (this.mrpd != null) {
            this.mrpd.render(d, sm, hs, cursor);
            return;
        }
        if (this.w == null || this.w.map == null) {
            this.leave();
            this.g.showError(Lang._t("world_gen_load_failed", new Object[0]));
            return;
        }
        if (this.time == 0) {
            this.zoom = 10 * sm.width / 1000;
            if (this.w.player != null) {
                this.scrollX = -this.w.player.cities.get((int)0).x;
                this.scrollY = -this.w.player.cities.get((int)0).y;
            }
            this.adjScrollX = this.scrollX + (double)(sm.width / 2) / this.zoom;
            this.adjScrollY = this.scrollY + (double)(sm.height / 2) / this.zoom;
        }
        d.hook(0.0, 0.0, sm.width, sm.height, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED}){

            public void run(Input in, Pt p, Hook.Type type) {
                StrategicScreen.this.menuCity = null;
                StrategicScreen.this.selectedFleet = null;
            }
        });
        d.shift(sm.width / 2, sm.height / 2);
        d.scale(this.zoom, this.zoom);
        d.shift(this.scrollX, this.scrollY);
        for (Backdrop bd : this.backdrops) {
            if (bd.type.shadow) {
                d.blit(bd.type.img, BACKDROP_DARKENING, bd.x, bd.y, bd.type.img.srcWidth / 8 / 2, bd.type.img.srcHeight / 8 / 2, bd.rot);
                continue;
            }
            d.blit(bd.type.img, Clr.WHITE, bd.x, bd.y, bd.type.img.srcWidth / 8 / 2, bd.type.img.srcHeight / 8 / 2, bd.rot);
        }
        d.rect(INK, 0.0, 0.0, this.w.map.water[0].length + 1, this.w.map.water.length + 1);
        int mapBgSize = 32;
        for (int y = 0; y < this.w.map.water.length; y += mapBgSize) {
            for (int x = 0; x < this.w.map.water[0].length; x += mapBgSize) {
                MAP_BG.draw((float)x + 0.5f, (float)y + 0.5f, (float)mapBgSize, (float)mapBgSize);
            }
        }
        double worldScreenLeft = this.screenToWorldX(0.0);
        double worldScreenRight = this.screenToWorldX(sm.width);
        double worldScreenTop = this.screenToWorldY(0.0);
        double worldScreenBottom = this.screenToWorldY(sm.height);
        TextureImpl.bindNone();
        GL11.glBegin((int)4);
        for (ShapeUtils.Area area : this.w.map.cityOwnershipAreas) {
            City city = this.w.map.getCity(area.identifier);
            Empire e = this.w.map.owner(city);
            if (city.territoryPolygon == null) {
                city.territoryPolygon = new ShapeUtils.TrianglesArea(area);
            }
            if (!((double)city.territoryPolygon.polygon.getMaxX() >= worldScreenLeft) || !((double)city.territoryPolygon.polygon.getMinX() <= worldScreenRight) || !((double)city.territoryPolygon.polygon.getMaxY() >= worldScreenTop) || !((double)city.territoryPolygon.polygon.getMinY() <= worldScreenBottom)) continue;
            Color c = e.arms.getMixedColor();
            GL11.glColor4f((float)c.r, (float)c.g, (float)c.b, (float)0.33f);
            city.territoryPolygon.draw();
        }
        GL11.glEnd();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        TextureImpl.bindNone();
        d.resetTransforms();
        d.shift(sm.width / 2, sm.height / 2);
        d.scale(this.zoom, this.zoom);
        d.shift(this.scrollX, this.scrollY);
        Graphics graphics = (Graphics)d.frame().nativeRenderer();
        graphics.setLineWidth(this.zoom > 9.0 ? 3.0f : 2.0f);
        for (ShapeUtils.Area area : this.w.map.cityOwnershipAreas) {
            City city = this.w.map.getCity(area.identifier);
            Empire e = this.w.map.owner(city);
            if (!((double)city.territoryPolygon.polygon.getMaxX() >= worldScreenLeft) || !((double)city.territoryPolygon.polygon.getMinX() <= worldScreenRight) || !((double)city.territoryPolygon.polygon.getMaxY() >= worldScreenTop) || !((double)city.territoryPolygon.polygon.getMinY() <= worldScreenBottom)) continue;
            graphics.setColor(e.getSecondaryTincture().mapColor);
            graphics.draw((Shape)city.territoryPolygon.polygon);
        }
        d.resetTransforms();
        graphics.setLineWidth(this.zoom > 9.0 ? 3.0f : 2.0f);
        graphics.setColor(INK_C);
        for (ShapeUtils.Area area : this.w.map.landBoundaries) {
            for (int j = 0; j < area.points.size(); ++j) {
                ShapeUtils.P a = area.points.get(j);
                if (a.x < 1.0 || a.x > (double)this.w.map.water[0].length - 1.0 || a.y < 1.0 || a.y > (double)this.w.map.water.length - 1.0) continue;
                ShapeUtils.P b = area.points.get((j + 1) % area.points.size());
                if (b.x < 1.0 || b.x > (double)this.w.map.water[0].length - 1.0 || b.y < 1.0 || b.y > (double)this.w.map.water.length - 1.0) continue;
                double ax = this.worldToScreenX(a.x);
                double ay = this.worldToScreenY(a.y);
                double bx = this.worldToScreenX(b.x);
                double by = this.worldToScreenY(b.y);
                if (ax < 0.0 && bx < 0.0 || ay < 0.0 && by < 0.0 || ax > (double)sm.width && bx > (double)sm.width || ay > (double)sm.height && by > (double)sm.height) continue;
                graphics.drawLine((float)ax, (float)ay, (float)bx, (float)by);
            }
        }
        graphics.setLineWidth(this.zoom > 19.0 ? 2.0f : 1.0f);
        double waveLength = 5.0 / this.zoom + 0.1;
        for (int y = 0 - this.w.map.water[0].length / 10; y < this.w.map.water.length; y += 5) {
            for (double x = 0.0; x < (double)this.w.map.water[0].length - 1.1 - waveLength; x += waveLength) {
                int iy;
                double adjY = (double)y + x * 0.1;
                double sAdjY = this.worldToScreenY(adjY);
                if (sAdjY < 0.0 || sAdjY > (double)sm.height || (iy = (int)StrictMath.floor(adjY)) >= this.w.map.water.length || iy < 0) continue;
                double x2 = x + waveLength;
                int ix = (int)StrictMath.floor(x);
                int ix2 = (int)StrictMath.floor(x2);
                if (!this.w.map.water[iy][ix] || !this.w.map.water[iy][ix]) continue;
                double depth = 0.5 - this.w.map.height[iy][ix];
                double depth2 = 0.5 - this.w.map.height[iy][ix2];
                if (!(depth > 0.0) || !(depth2 > 0.0)) continue;
                double wy = adjY + StrictMath.sin(x + (double)y * 0.2) * (depth * 0.8 + 0.25);
                double wy2 = adjY + StrictMath.sin(x2 + (double)y * 0.2) * (depth2 * 0.8 + 0.25);
                if (x < 0.0 && x2 < 0.0 || wy < 0.0 && wy2 < 0.0 || x > (double)sm.width && x2 > (double)sm.width || wy > (double)sm.height && wy2 > (double)sm.height) continue;
                graphics.drawLine((float)this.worldToScreenX(x), (float)this.worldToScreenY(wy), (float)this.worldToScreenX(x2), (float)this.worldToScreenY(wy2));
            }
        }
        graphics.setLineWidth(this.zoom > 11.0 ? 2.0f : 1.0f);
        for (Road r : this.w.map.roads) {
            this.drawRoadLine(sm, graphics, r);
        }
        graphics.setLineWidth(1.0f);
        int tfImgI = 0;
        for (WorldMap.TerrainFeature f : this.w.map.features) {
            switch (f.type) {
                case MOUNTAIN: {
                    Img tfImg = this.mountains[tfImgI % this.mountains.length];
                    StrategicScreen.checkedBlit(d, sm, tfImg, DARKER_INK, this.worldToScreenX(f.x) - 8.0, this.worldToScreenY(f.y) - 10.0);
                    break;
                }
                case FOREST: {
                    Img tfImg = this.trees[tfImgI % this.trees.length];
                    StrategicScreen.checkedBlit(d, sm, tfImg, DARKER_INK, this.worldToScreenX(f.x) - 9.0, this.worldToScreenY(f.y) - 10.0);
                    break;
                }
                case SWAMP: {
                    Img tfImg = this.swamps[tfImgI % this.swamps.length];
                    StrategicScreen.checkedBlit(d, sm, tfImg, DARKER_INK, this.worldToScreenX(f.x), this.worldToScreenY(f.y));
                    break;
                }
                case SEA_CREATURES: {
                    Img tfImg = this.sea_creatures_bg[tfImgI % this.sea_creatures.length];
                    StrategicScreen.checkedBlit(d, sm, tfImg, PARCHMENT, this.worldToScreenX(f.x), this.worldToScreenY(f.y));
                    tfImg = this.sea_creatures[tfImgI % this.sea_creatures.length];
                    StrategicScreen.checkedBlit(d, sm, tfImg, DARKER_INK, this.worldToScreenX(f.x), this.worldToScreenY(f.y));
                }
            }
        }
        for (final MonsterNest n : this.w.map.nests) {
            int nx = (int)this.worldToScreenX(n.x);
            int ny = (int)this.worldToScreenY(n.y);
            String info = n.getDisplayName();
            if (n.type != null && this.w.player != null) {
                String bs = n.type.bonusSuffix(this.w.player);
                info = Lang._t(n.type.name + "_displayName" + bs, new Object[0]);
            }
            boolean inCity = false;
            if (this.w.player == null) {
                inCity = true;
            } else {
                for (City c : this.w.player.cities) {
                    if (!c.nestsInTerritory(this.w.map).contains(n)) continue;
                    inCity = true;
                    break;
                }
            }
            if (inCity && n.type != null && n.type.incomeModifierPercentage != 0) {
                info = info + "\n" + Lang._t("x_city_income", (n.type.incomeModifierPercentage > 0 ? "+" : "") + n.type.incomeModifierPercentage + "%");
            } else if (inCity && n.type != null && n.type.incomeModifier != 0) {
                info = info + "\n" + Lang._t("x_city_income", (n.type.incomeModifier > 0 ? "+" : "") + n.type.incomeModifier);
            }
            Clr inner = n.type == null ? DARK_INK : DARK_RED_INK;
            Clr outer = PARCHMENT;
            Rect r = d.textSize(info, AGame.FOUNT_OUTLINE, nx + 15, (double)ny * this.zoom - 6.0, 1000);
            if (n.type != null && cursor != null && (r.contains(cursor) || Rect.contains((double)(nx - 8), (double)(ny - 8), (double)16.0, (double)16.0, (Pt)cursor) || this.selectedFleet != null && this.selectedFleet.location != n && !this.fleetSelection.isEmpty() && this.canTravelTo(n) && Rect.contains((double)(this.scrollX + (double)n.x - 9.0), (double)(this.scrollY + (double)n.y + 13.0), (double)100.0, (double)MyDraw.BUTTON_H, (Pt)cursor))) {
                Clr tmp = inner;
                inner = outer;
                outer = tmp;
            }
            if (n.type != null && n.type.mapImage == null) {
                d.rect(PARCHMENT, nx - 10, ny - 10, 20.0, 20.0);
                d.rect(INK, nx - 9, ny - 9, 18.0, 18.0);
                n.getArms().draw(d, nx - 8, ny - 8, 16);
            } else {
                Img img = n.type == null ? this.emptyNestBG : n.type.mapBackground;
                for (int dy = -1; dy <= 1; ++dy) {
                    for (int dx = -1; dx <= 1; ++dx) {
                        StrategicScreen.checkedBlit(d, sm, img, outer, nx - 8 + dx, ny - 8 + dy);
                    }
                }
                img = n.type == null ? this.emptyNest : n.type.mapImage;
                StrategicScreen.checkedBlit(d, sm, img, inner, nx - 8, ny - 8);
            }
            if (this.zoom > 9.0) {
                StrategicScreen.checkedHeavilyBorderedText(d, sm, info, AGame.FOUNT, AGame.FOUNT_OUTLINE, DARK_RED_INK, PARCHMENT, nx + 15, ny - 6, 1000);
            }
            if (n.type == null) continue;
            if (StrategicScreen.checked(sm, nx - 8, ny - 8, 16, 16)) {
                d.hook(nx - 8, ny - 8, 16.0, 16.0, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED}){

                    public void run(Input in, Pt p, Hook.Type type) {
                        StrategicScreen.this.selectedNest = n;
                    }
                });
            }
            if (!StrategicScreen.checked(sm, nx + 15, ny - 6, (int)r.width, (int)r.height)) continue;
            d.hook(nx + 15, ny - 6, (int)r.width, (int)r.height, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED}){

                public void run(Input in, Pt p, Hook.Type type) {
                    StrategicScreen.this.selectedNest = n;
                }
            });
        }
        for (Empire em : this.w.map.empires) {
            for (final City c : em.cities) {
                Spy spy;
                boolean doesHover;
                int cx = (int)this.worldToScreenX(c.x);
                int cy = (int)this.worldToScreenY(c.y);
                Img img = c.isTown ? this.towns_bg[c.appearance] : this.cities_bg[c.appearance];
                for (int dy = -1; dy <= 1; ++dy) {
                    for (int dx = -1; dx <= 1; ++dx) {
                        if (!c.isTown) {
                            StrategicScreen.checkedBlit(d, sm, CoatOfArms.SHIELD_OUTLINE, PARCHMENT, cx - 18 + dx, cy - 16 - 41 + dy);
                        }
                        StrategicScreen.checkedBlit(d, sm, img, PARCHMENT, cx - 8 + dx, cy - 8 + dy);
                    }
                }
                boolean bl = doesHover = c == this.hoverCity;
                if (cursor != null && this.selectedFleet != null && this.selectedFleet.location != c && !this.fleetSelection.isEmpty() && this.canTravelTo(c) && Rect.contains((double)(cx - 16), (double)(cy + 25), (double)100.0, (double)MyDraw.BUTTON_H, (Pt)cursor)) {
                    doesHover = true;
                }
                StrategicScreen.checkedBlit(d, sm, img, doesHover ? INK : PARCHMENT, cx - 8, cy - 8);
                img = c.isTown ? this.towns[c.appearance] : this.cities[c.appearance];
                StrategicScreen.checkedBlit(d, sm, img, DARK_INK, cx - 8, cy - 8);
                if (!c.isTown || this.zoom > 9.0) {
                    StrategicScreen.checkedHeavilyBorderedText(d, sm, c.name, c.isTown ? AGame.FOUNT : AGame.MAP, c.isTown ? AGame.FOUNT_OUTLINE : AGame.MAP_OUTLINE, DARK_INK, PARCHMENT, cx + 20, cy - (c.isTown ? AGame.FOUNT : AGame.MAP).lineHeight / 2, 1000);
                }
                if (!c.isTown) {
                    em.arms.layout.drawShield(em.arms, d, cx - 18, cy - 16 - 41, 1.0, DARK_INK);
                } else if (this.zoom > 9.0) {
                    d.rect(PARCHMENT, cx - 9, cy - 16 - 9, 18.0, 18.0);
                    em.arms.draw(d, cx - 8, cy - 16 - 8, 16);
                }
                if (StrategicScreen.checked(sm, cx - 18, cy - 16 - 41, 36, 73)) {
                    Hook selectHook = new Hook(new Hook.Type[]{Hook.Type.HOVER, Hook.Type.MOUSE_1_CLICKED}){

                        public void run(Input in, Pt p, Hook.Type type) {
                            StrategicScreen.this.nextHoverCity = c;
                            if (type == Hook.Type.MOUSE_1_CLICKED) {
                                d.state.hasClicked();
                                StrategicScreen.this.selectedFleet = null;
                                StrategicScreen.this.menuCity = c;
                            }
                        }
                    };
                    if (c.isTown) {
                        if (this.zoom > 9.0) {
                            d.hook(cx - 9, cy - 16 - 9, 18.0, 43.0, selectHook);
                        } else {
                            d.hook(cx - 9, cy - 1, 18.0, 18.0, selectHook);
                        }
                    } else {
                        d.hook(cx - 18, cy - 16 - 41, 36.0, 73.0, selectHook);
                    }
                    d.hook(cx - 16, cy - 16, 32.0, 32.0, new Hook(new Hook.Type[]{Hook.Type.MOUSE_2_CLICKED}){

                        public void run(Input in, Pt p, Hook.Type type) {
                            d.state.hasClicked();
                            if (StrategicScreen.this.selectedFleet != null && !StrategicScreen.this.fleetSelection.isEmpty() && StrategicScreen.this.selectedFleet.location != c && StrategicScreen.this.canTravelTo(c)) {
                                StrategicScreen.this.travelTo(c);
                            }
                        }
                    });
                }
                int x = cx + 20;
                int y = cy - 9 + AGame.FOUNT.height * 3 / 2;
                int maxW = 10000;
                if ((this.w.player == null || this.w.player.cities.contains(c) || this.hasSpy(c) || this.debug) && (!c.isTown || this.zoom > 9.0)) {
                    int in;
                    if (this.w.player != null && this.hasSpy(c)) {
                        StrategicScreen.checkedHeavilyBorderedText(d, sm, Lang._t("Spy_Active", new Object[0]), AGame.FOUNT, AGame.FOUNT_OUTLINE, RED_INK, PARCHMENT, x, y, maxW);
                        y += AGame.FOUNT.height;
                    }
                    if (c.takeoverMethod != null) {
                        d.rect(RED_INK, x, y, 100.0, 6.0);
                        d.rect(PARCHMENT, x + 1, y + 1, 98.0, 4.0);
                        d.rect(RED_INK, x + 2, y + 2, 96 * c.takeoverAmount / c.takeoverMethod.takeoverTime, 2.0);
                        StrategicScreen.checkedHeavilyBorderedText(d, sm, c.takeoverMethod.getName(), AGame.FOUNT, AGame.FOUNT_OUTLINE, RED_INK, PARCHMENT, x, y += 8, maxW);
                        y += AGame.FOUNT.height;
                    } else if (!c.constructing.isEmpty()) {
                        d.rect(DARKER_INK, x, y, 100.0, 6.0);
                        d.rect(PARCHMENT, x + 1, y + 1, 98.0, 4.0);
                        d.rect(DARKER_INK, x + 2, y + 2, 96 * c.constructionProgress / c.constructionTimeCost(), 2.0);
                        StrategicScreen.checkedHeavilyBorderedText(d, sm, ((MapLocation.ConstructionEntry)c.constructing.get(0)).desc(), AGame.FOUNT, AGame.FOUNT_OUTLINE, DARKER_INK, PARCHMENT, x, y += 8, maxW);
                        y += AGame.FOUNT.height;
                    }
                    String incomeInfo = Lang._t("x_Income", c.adjustedIncome(this.w.map));
                    int icp = c.cityIncomeChangePercent(this.w.map);
                    if (icp != 0) {
                        incomeInfo = incomeInfo + (icp > 0 ? " (+" : " (") + icp + "%)";
                    }
                    if ((in = c.cityIncomeChangeFromNests(this.w.map)) != 0) {
                        incomeInfo = incomeInfo + (in > 0 ? " (+" : " (") + in + ")";
                    }
                    StrategicScreen.checkedHeavilyBorderedText(d, sm, incomeInfo, AGame.FOUNT, AGame.FOUNT_OUTLINE, DARKER_INK, PARCHMENT, x, y, maxW);
                    y += AGame.FOUNT.height;
                    if (!c.isTown) {
                        StrategicScreen.checkedHeavilyBorderedText(d, sm, Lang._t(City.SHIPYARD_SIZES[c.shipyardLevel], new Object[0]), AGame.FOUNT, AGame.FOUNT_OUTLINE, DARKER_INK, PARCHMENT, x, y, maxW);
                        StrategicScreen.checkedHeavilyBorderedText(d, sm, Lang._t("Secret_Police_", new Object[0]) + this.w.map.owner((City)c).policeLevel.getName(), AGame.FOUNT, AGame.FOUNT_OUTLINE, DARKER_INK, PARCHMENT, x, y += AGame.FOUNT.height, maxW);
                        y += AGame.FOUNT.height;
                    }
                    if (c.alertAmount > 0) {
                        int alertAmt = StrictMath.min(30000, c.alertAmount);
                        d.rect(RED_INK, x, y, 100.0, 6.0);
                        d.rect(PARCHMENT, x + 1, y + 1, 98.0, 4.0);
                        d.rect(RED_INK, x + 2, y + 2, 96 * alertAmt / 30000, 2.0);
                        StrategicScreen.checkedHeavilyBorderedText(d, sm, Lang._t("High_Alert_", new Object[0]), AGame.FOUNT, AGame.FOUNT_OUTLINE, RED_INK, PARCHMENT, x, y += 8, maxW);
                        y += AGame.FOUNT.height;
                    }
                    if (!this.debug) continue;
                    StrategicScreen.checkedHeavilyBorderedText(d, sm, "SpyActions: " + em.spyActionsDone, AGame.FOUNT, AGame.FOUNT_OUTLINE, DARKER_INK, PARCHMENT, x, y, maxW);
                    StrategicScreen.checkedHeavilyBorderedText(d, sm, "$" + em.money + " d" + em.incomeBalance(this.w.map), AGame.FOUNT, AGame.FOUNT_OUTLINE, DARKER_INK, PARCHMENT, x, y += AGame.FOUNT.height, maxW);
                    StrategicScreen.checkedHeavilyBorderedText(d, sm, em.constructionStrategy.name, AGame.FOUNT, AGame.FOUNT_OUTLINE, DARKER_INK, PARCHMENT, x, y += AGame.FOUNT.height, maxW);
                    y += AGame.FOUNT.height;
                    if (c.constructionTarget == null) continue;
                    StrategicScreen.checkedHeavilyBorderedText(d, sm, "Target: " + c.constructionTarget.getName() + " $" + c.constructionTarget.getCost(), AGame.FOUNT, AGame.FOUNT_OUTLINE, DARKER_INK, PARCHMENT, x, y, maxW);
                    continue;
                }
                if (this.w.player == null || (spy = this.w.player.getSpyFor(c)) == null || spy.infiltrationTimeout <= 0) continue;
                d.rect(RED_INK, x, y, 100.0, 6.0);
                d.rect(PARCHMENT, x + 1, y + 1, 98.0, 4.0);
                d.rect(RED_INK, x + 2, y + 2, 96 * (10000 - spy.infiltrationTimeout) / 10000, 2.0);
                StrategicScreen.checkedHeavilyBorderedText(d, sm, Lang._t("Infiltrating_City", new Object[0]), AGame.FOUNT, AGame.FOUNT_OUTLINE, RED_INK, PARCHMENT, x, y += 8, maxW);
                y += AGame.FOUNT.height;
            }
        }
        if (this.highlitTravelConnection != null && this.selectedFleet != null && this.selectedFleet.location != null) {
            Road road;
            Road road2 = road = Fleet.canFly(this.fleetSelection) ? null : this.w.map.getConnection(this.selectedFleet.location, this.highlitTravelConnection);
            if (road != null) {
                this.highlightRoadLine(sm, graphics, road);
            } else {
                d.dottedLine(DARKER_INK, 2, 7, this.highlitTravelConnection.x, this.highlitTravelConnection.y, this.selectedFleet.location.x, this.selectedFleet.location.y);
            }
        }
        for (MonsterNest mn : this.w.map.nests) {
            for (Fleet fl : mn.getFleets()) {
                this.renderFleet(d, sm, fl, null, mn);
            }
        }
        for (int passes = 0; passes < 2; ++passes) {
            for (Empire e : this.w.map.empires) {
                if (e == this.w.player != (passes == 1)) continue;
                for (final Fleet fl : e.getFleets()) {
                    this.renderFleet(d, sm, fl, e, null);
                    int x = (int)this.worldToScreenX(fl.realX());
                    int y = (int)this.worldToScreenY(fl.realY());
                    if (!fl.inTransit()) {
                        x -= 32;
                    }
                    if (e == this.w.player && fl.fleeDestinationNeeded && e == this.w.player) {
                        int tw = x - 16 - MyDraw.UI_SPACING - (int)d.textSize((String)Lang._t((String)"Select_destination_to_fly_to", (Object[])new Object[0]).toUpperCase(), (Fount)AGame.FOUNT).x;
                        StrategicScreen.checkedHeavilyBorderedText(d, sm, Lang._t("Select_destination_to_fly_to", new Object[0]).toUpperCase(), AGame.FOUNT, AGame.FOUNT_OUTLINE, Clr.RED, PARCHMENT, tw, y - 16, 10000);
                    }
                    if (e != this.w.player && this.w.player != null || !StrategicScreen.checked(sm, x - 16, y - 16, 32, 32)) continue;
                    d.hook(x - 16, y - 16, 32.0, 32.0, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED}){

                        public void run(Input in, Pt p, Hook.Type type) {
                            if (d.state.canClick()) {
                                StrategicScreen.this.menuCity = null;
                                StrategicScreen.this.selectedFleet = fl;
                                StrategicScreen.this.fleetSelection = new ArrayList<Airship>(fl.actives);
                                StrategicScreen.this.fleetSelection.addAll(fl.reserve);
                                ((StrategicScreen)StrategicScreen.this).fleetScrollBar.offset = 0;
                                d.state.hasClicked();
                            }
                        }
                    });
                }
            }
        }
        if (this.w.player != null) {
            for (MonsterNest n : this.w.map.nests) {
                if (this.selectedFleet == null || this.fleetSelection.isEmpty()) continue;
                this.renderLocationMoveMenu(n, d, sm, hs, cursor);
            }
            for (Empire em : this.w.map.empires) {
                for (City c : em.cities) {
                    if (this.w.player.cities.contains(c) && c.takeoverNeeded) {
                        this.renderCityTakeoverOptions(d, c);
                    }
                    if (this.selectedFleet == null || this.fleetSelection.isEmpty()) continue;
                    this.renderLocationMoveMenu(c, d, sm, hs, cursor);
                }
            }
            for (MonsterNest c : this.w.map.nests) {
                for (MapLocation.Message msg : c.messages) {
                    int cx = (int)this.worldToScreenX(c.x);
                    int cy = (int)this.worldToScreenY(c.y);
                    Img icon = null;
                    switch (msg.type) {
                        case COMBAT: {
                            icon = this.fight;
                            break;
                        }
                        case LOST_SHIP: {
                            icon = this.shipLoss;
                            break;
                        }
                        case REVOLT: {
                            icon = this.fight;
                        }
                    }
                    if (icon != null) {
                        StrategicScreen.checkedBorderedBlit(d, sm, icon, Clr.RED, Clr.WHITE, cx - 16, cy - msg.offset / 8 - 16);
                    }
                    if (!(this.zoom > 9.0)) continue;
                    StrategicScreen.checkedHeavilyBorderedText(d, sm, msg.getText(this.w.player), AGame.FOUNT, AGame.FOUNT_OUTLINE, Clr.RED, Clr.WHITE, cx + 20 - 16, cy - msg.offset / 8 - 16 + 2, 1000);
                }
            }
        }
        for (Empire em : this.w.map.empires) {
            for (City c : em.cities) {
                for (MapLocation.Message msg : c.messages) {
                    int cx = (int)this.worldToScreenX(c.x);
                    int cy = (int)this.worldToScreenY(c.y);
                    Img icon = null;
                    switch (msg.type) {
                        case COMBAT: {
                            icon = this.fight;
                            break;
                        }
                        case LOST_SHIP: {
                            icon = this.shipLoss;
                            break;
                        }
                        case REVOLT: {
                            icon = this.fight;
                        }
                    }
                    StrategicScreen.checkedBorderedBlit(d, sm, icon, Clr.RED, Clr.WHITE, cx - 16, cy - msg.offset / 8 - 16);
                    StrategicScreen.checkedHeavilyBorderedText(d, sm, msg.getText(this.w.player), AGame.FOUNT, AGame.FOUNT_OUTLINE, Clr.RED, Clr.WHITE, cx + 20 - 16, cy - msg.offset / 8 - 16 + 2, 1000);
                }
            }
        }
        d.drawTopBar(sm);
        CoatOfArms coatOfArms = coa = this.w.player == null ? CoatOfArms.spectatorArms() : this.w.player.arms;
        if (coa != null) {
            coa.draw(d, MyDraw.SIDE_CLEARANCE + 2, 5.0, MyDraw.TOP_BAR_H - 7);
        }
        d.drawPanelBorder(MyDraw.SIDE_CLEARANCE, 3, MyDraw.TOP_BAR_H - 3, MyDraw.TOP_BAR_H - 3);
        int x = MyDraw.SIDE_CLEARANCE + MyDraw.TOP_BAR_H - 3 + MyDraw.UI_SPACING;
        if (this.w.player != null) {
            StringBuilder moneyInfo = new StringBuilder();
            moneyInfo.append(this.w.player.money == 0 ? MyDraw.ERROR_C : "").append("$").append(this.w.player.money).append("[]");
            int inc = this.w.player.incomeBalance(this.w.map);
            if (inc > 0) {
                moneyInfo.append(" +").append(inc);
            } else if (inc < 0) {
                moneyInfo.append(" ").append(MyDraw.ERROR_C).append(inc);
            } else {
                moneyInfo.append(" 0");
            }
            d.text(moneyInfo.toString(), AGame.BIG_FOUNT, x, MyDraw.TOP_BAR_INSET);
            if (this.w.player.money == 0) {
                Pt ts = d.textSize(moneyInfo.toString(), AGame.BIG_FOUNT);
                d.tooltip((double)x, (double)MyDraw.TOP_BAR_INSET, ts.x, ts.y, Lang._t("no_money_tooltip", new Object[0]));
            }
            x = (int)((double)x + (d.textSize((String)"$10000 +10000", (Fount)AGame.FOUNT).x + (double)MyDraw.UI_SPACING));
            d.button(x, MyDraw.TOP_BAR_INSET, d.bw(Lang._t("Empire_Details", new Object[0])), Lang._t("Empire_Details", new Object[0]), "E", new Runnable(){

                @Override
                public void run() {
                    StrategicScreen.this.showEmpireDetails = true;
                }
            });
            final StrategicScreen self = this;
            x += d.bw(Lang._t("Empire_Details", new Object[0])) + MyDraw.BUTTON_SPACING;
            if (this.w.map.techSpeed.speedMultiplier != 0.0) {
                if (this.w.player.research == null) {
                    if (this.w.player.isAllResearchDone(this.w.map)) {
                        d.button(x, MyDraw.TOP_BAR_INSET, d.bw(Lang._t("Research", new Object[0])), Lang._t("Research", new Object[0]), "R", new InputRunnable(){

                            @Override
                            public void run(Input in) {
                                StrategicScreen.this.g.s = new TechScreen(self);
                            }
                        }, true);
                    } else {
                        d.goldbutton(x, MyDraw.TOP_BAR_INSET, d.bw(Lang._t("Research", new Object[0])), Lang._t("Research", new Object[0]), "R", new InputRunnable(){

                            @Override
                            public void run(Input in) {
                                StrategicScreen.this.g.s = new TechScreen(self);
                            }
                        }, true);
                    }
                } else {
                    d.progressBar(x, MyDraw.TOP_BAR_INSET + MyDraw.BUTTON_H / 2 - MyDraw.PROGRESS_BAR_H / 2, d.bw(Lang._t("Research", new Object[0])), (double)this.w.player.researchPoints * 1.0 / (double)this.w.player.research.tech.cost(this.w.player.bonuses()));
                    d.hook(x, MyDraw.TOP_BAR_INSET, d.bw(Lang._t("Research", new Object[0])), MyDraw.PROGRESS_BAR_H, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED}){

                        public void run(Input input, Pt pt, Hook.Type type) {
                            StrategicScreen.this.g.s = new TechScreen(self);
                        }
                    });
                    d.tooltip((double)x, (double)MyDraw.TOP_BAR_INSET, (double)d.bw(Lang._t("Research", new Object[0])), (double)MyDraw.PROGRESS_BAR_H, Lang._t("Research", new Object[0]) + ": " + Lang._t("tech_" + this.w.player.research.name, new Object[0]) + " " + this.w.player.researchPoints + "/" + this.w.player.research.tech.cost(this.w.player.bonuses()));
                }
                x += d.bw(Lang._t("Research", new Object[0])) + MyDraw.BUTTON_SPACING;
            }
        }
        if (this.w.player != null && this.w.isMultiplayer()) {
            d.iconButton(x, MyDraw.TOP_BAR_INSET, this.editAirship, new Runnable(){

                @Override
                public void run() {
                    StrategicScreen.this.doEdit(ShipType.AIRSHIP);
                }
            }, true);
            d.tooltip((double)x, (double)MyDraw.TOP_BAR_INSET, (double)MyDraw.ICON_BUTTON_SZ, (double)MyDraw.ICON_BUTTON_SZ, Lang._t("Airship_Editor", new Object[0]));
            d.iconButton(x += MyDraw.ICON_BUTTON_SZ + MyDraw.BUTTON_SPACING, MyDraw.TOP_BAR_INSET, this.editLandship, new Runnable(){

                @Override
                public void run() {
                    StrategicScreen.this.doEdit(ShipType.LANDSHIP);
                }
            }, true);
            d.tooltip((double)x, (double)MyDraw.TOP_BAR_INSET, (double)MyDraw.ICON_BUTTON_SZ, (double)MyDraw.ICON_BUTTON_SZ, Lang._t("Landship_Editor", new Object[0]));
            d.iconButton(x += MyDraw.ICON_BUTTON_SZ + MyDraw.BUTTON_SPACING, MyDraw.TOP_BAR_INSET, this.editBuilding, new Runnable(){

                @Override
                public void run() {
                    StrategicScreen.this.doEdit(ShipType.BUILDING);
                }
            }, true);
            d.tooltip((double)x, (double)MyDraw.TOP_BAR_INSET, (double)MyDraw.ICON_BUTTON_SZ, (double)MyDraw.ICON_BUTTON_SZ, Lang._t("Building_Editor", new Object[0]));
            x += MyDraw.ICON_BUTTON_SZ + MyDraw.BUTTON_SPACING;
        }
        if (this.w.combatInfo != null && this.combatUniScreen != null) {
            d.goldbutton(x, MyDraw.TOP_BAR_INSET, d.bw(Lang._t("Combat", new Object[0])), Lang._t("Combat", new Object[0]), null, new InputRunnable(){

                @Override
                public void run(Input in) {
                    StrategicScreen.this.g.s = StrategicScreen.this.combatUniScreen;
                }
            }, true);
            d.iconButton(x += d.bw(Lang._t("Combat", new Object[0])) + MyDraw.BUTTON_SPACING, MyDraw.TOP_BAR_INSET, this.mapGoto, new Runnable(){

                @Override
                public void run() {
                    StrategicScreen.this.scrollX = -StrategicScreen.this.w.combatInfo.attackingFleet.realX();
                    StrategicScreen.this.scrollY = -StrategicScreen.this.w.combatInfo.attackingFleet.realY();
                }
            }, true);
            d.tooltip((double)x, (double)MyDraw.TOP_BAR_INSET, (double)MyDraw.ICON_BUTTON_SZ, (double)MyDraw.ICON_BUTTON_SZ, Lang._t("Show_on_map", new Object[0]));
        }
        if (this.selectedFleet != null) {
            this.renderFleetList(d, sm, hs, cursor);
        }
        if (this.menuCity != null) {
            this.renderCityMenu(d, sm, hs, cursor);
        }
        int noticesMaxY = sm.height - MyDraw.SIDE_CLEARANCE;
        if (this.w.map.merger != null) {
            int myPanelInset = 2;
            int width = 256 + MyDraw.PANEL_INSET * 2 + myPanelInset * 4;
            int textH = (int)d.textSize((String)Lang._t((String)"merger_announce_x_y", (Object[])new Object[]{this.w.map.merger.nameA, this.w.map.merger.nameB}), (Fount)AGame.FOUNT, (double)0.0, (double)0.0, (int)(width - MyDraw.WINDOW_INSET * 2)).height;
            int height = 128 + textH + MyDraw.UI_SPACING + MyDraw.PANEL_INSET * 2 + myPanelInset * 4;
            x = MyDraw.SIDE_CLEARANCE;
            int y = sm.height - height - MyDraw.SIDE_CLEARANCE;
            noticesMaxY = y - MyDraw.UI_SPACING;
            d.hook(x, y, width, height, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED}){

                public void run(Input in, Pt p, Hook.Type type) {
                    StrategicScreen.this.w.map.merger = null;
                }
            });
            d.drawPanel(x, y, width, height);
            d.rect(MyDraw.PROGRESS_BAR_INSIDE, (x += MyDraw.PANEL_INSET) + 32 + myPanelInset, (y += MyDraw.PANEL_INSET) + 32 + myPanelInset, 192.0, 2.0);
            d.drawPanel(x, y, 64 + myPanelInset * 2, 64 + myPanelInset * 2);
            this.w.map.merger.armsA.draw(d, x + myPanelInset, y + myPanelInset, 64);
            d.drawPanel(x + 192 + myPanelInset * 2, y, 64 + myPanelInset * 2, 64 + myPanelInset * 2);
            this.w.map.merger.armsB.draw(d, x + 192 + myPanelInset * 3, y + myPanelInset, 64);
            d.drawPanel(x + 96 + myPanelInset, y + 64 + myPanelInset * 2, 64 + myPanelInset * 2, 64 + myPanelInset * 2);
            this.w.map.merger.armsM.draw(d, x + 96 + myPanelInset * 2, y + 64 + myPanelInset * 3, 64);
            d.text(Lang._t("merger_announce_x_y", this.w.map.merger.nameA, this.w.map.merger.nameB), AGame.FOUNT, x, y += 128 + MyDraw.UI_SPACING + myPanelInset * 4, width - MyDraw.WINDOW_INSET * 2);
            y += textH + MyDraw.UI_SPACING;
        }
        int noticesY = MyDraw.TOP_BAR_H + MyDraw.UI_SPACING;
        if (this.w.isMultiplayer()) {
            int y = MyDraw.TOP_BAR_H;
            x = MyDraw.SIDE_CLEARANCE;
            int width = StrictMath.max(200, sm.width / 4);
            int height = StrictMath.max(150, sm.height / 4);
            noticesY = y + height + MyDraw.BUTTON_SPACING + MyDraw.BUTTON_H + MyDraw.UI_SPACING;
            this.chatScrollBar.draw(d, x, y, width, height, this.w.chatMessages, this.chatAdapter);
            y += height + MyDraw.BUTTON_SPACING;
            if (this.chatField.focus) {
                int bw = d.bw(Lang._t("Send", new Object[0]));
                int h = (int)d.textSize((String)this.chatField.displayText(), (Fount)AGame.FOUNT, (int)(width - bw - MyDraw.BUTTON_SPACING - MyDraw.PANEL_INSET * 2), (int)10000, (int)0, (boolean)false).y - 2 + MyDraw.PANEL_INSET * 2;
                this.chatField.render(x, y, width - bw - MyDraw.BUTTON_SPACING, h, d, sm, hs, cursor);
                d.button(x + width - bw, y, bw, Lang._t("Send", new Object[0]), null, new Runnable(){

                    @Override
                    public void run() {
                        StrategicScreen.this.sendChat();
                    }
                }, !this.chatField.getText().isEmpty());
            } else {
                d.button(x, y, width, Lang._t("Chat", new Object[0]), new Runnable(){

                    @Override
                    public void run() {
                        StrategicScreen.this.chatField.focus = true;
                    }
                });
            }
        }
        if (this.w.player != null) {
            ArrayList<FleetOwner> fos = this.w.map.fleetOwners();
            int fosz = fos.size();
            block52: for (int foi = 0; foi < fosz; ++foi) {
                FleetOwner fo = fos.get(foi);
                if (fo == this.w.player) continue;
                int fsz = fo.getFleets().size();
                for (int fi = 0; fi < fsz; ++fi) {
                    final Fleet f = fo.getFleets().get(fi);
                    if (!this.w.player.cities.contains(f.destination)) continue;
                    String text = Lang._t("incoming_enemy_fleet", new Object[0]) + "\n" + fo.getName() + " > " + f.destination.getDisplayName();
                    int nw = (int)d.textSize((String)text, (Fount)AGame.FOUNT).x + 16 + MyDraw.UI_SPACING * 2 + MyDraw.ICON_BUTTON_SZ + MyDraw.PANEL_INSET * 2;
                    int nh = StrictMath.max(MyDraw.ICON_BUTTON_SZ, StrictMath.max(AGame.FOUNT.lineHeight * 2, 16)) + MyDraw.PANEL_INSET * 2;
                    if (noticesY + nh > noticesMaxY) break block52;
                    d.drawPanel(MyDraw.SIDE_CLEARANCE, noticesY, nw, nh);
                    d.blit(this.invader, MyDraw.SIDE_CLEARANCE + MyDraw.PANEL_INSET, noticesY + MyDraw.PANEL_INSET);
                    d.text(text, AGame.FOUNT, MyDraw.SIDE_CLEARANCE + MyDraw.PANEL_INSET + 16 + MyDraw.UI_SPACING, noticesY + MyDraw.PANEL_INSET);
                    d.iconButton(MyDraw.SIDE_CLEARANCE + nw - MyDraw.PANEL_INSET - MyDraw.ICON_BUTTON_SZ, noticesY + MyDraw.PANEL_INSET, this.mapGoto, new Runnable(){

                        @Override
                        public void run() {
                            StrategicScreen.this.scrollX = -f.realX();
                            StrategicScreen.this.scrollY = -f.realY();
                        }
                    }, true);
                    noticesY += nh + MyDraw.UI_SPACING;
                }
            }
        }
        int bw = d.bw("?");
        x = sm.width - bw - MyDraw.SIDE_CLEARANCE;
        d.button(x, MyDraw.TOP_BAR_INSET, bw, "?", new Runnable(){

            @Override
            public void run() {
                StrategicScreen.this.g.showHelp("strategic", null);
            }
        });
        bw = d.tw(Lang._t("Menu", new Object[0]));
        d.toggle(x -= bw + MyDraw.UI_SPACING, MyDraw.TOP_BAR_INSET, bw, Lang._t("Menu", new Object[0]), "M", new InputRunnable(){

            @Override
            public void run(Input in) {
                StrategicScreen.this.menu = true;
            }
        }, this.menu, !this.menu);
        x -= MyDraw.UI_SPACING;
        if (this.w.player != null) {
            for (int i = CampaignWorld.Speed.values().length - 1; i >= 0; --i) {
                boolean selected;
                final CampaignWorld.Speed sp = CampaignWorld.Speed.values()[i];
                x -= MyDraw.ICON_BUTTON_SZ + MyDraw.BUTTON_SPACING;
                boolean bl = selected = this.w.speed == sp;
                if (this.w.isMultiplayer()) {
                    selected = this.w.speedVoters.containsKey(this.g.playerID()) && this.w.speedVoters.get(this.g.playerID()) == sp;
                }
                d.iconToggle(x, MyDraw.TOP_BAR_INSET, sp.icon, null, new InputRunnable(){

                    @Override
                    public void run(Input in) {
                        if (sp != CampaignWorld.Speed.STOP) {
                            if (StrategicScreen.this.w.isMultiplayer()) {
                                StrategicScreen.this.lastNonStopSpeed = StrategicScreen.this.w.speedVoters.containsKey(StrategicScreen.this.g.playerID()) ? StrategicScreen.this.w.speedVoters.get(StrategicScreen.this.g.playerID()) : StrategicScreen.this.w.speed;
                            } else {
                                StrategicScreen.this.lastNonStopSpeed = StrategicScreen.this.w.speed;
                            }
                        }
                        StrategicScreen.this.w.giveCommand(Client.msg("setCampaignSpeed").put("voterID", StrategicScreen.this.g.playerID()).put("speed", sp.name()));
                    }
                }, selected, !this.menu, this.w.map.age == 0 && sp == CampaignWorld.Speed.NORMAL && this.w.player != null && (this.w.player.research != null || this.w.player.isAllResearchDone(this.w.map)));
                if (!this.w.isMultiplayer()) continue;
                if (this.w.speed == sp) {
                    d.blit(this.indicator, MyDraw.TITLE, x + MyDraw.ICON_BUTTON_SZ / 2 - this.indicator.srcWidth / 2, MyDraw.TOP_BAR_H);
                    continue;
                }
                if (!this.w.hasVoteForSpeed(sp)) continue;
                d.blit(this.indicator, MyDraw.WIN_SHADOW, x + MyDraw.ICON_BUTTON_SZ / 2 - this.indicator.srcWidth / 2, MyDraw.TOP_BAR_H);
            }
        }
        int speedX = x;
        if (this.w.player != null) {
            if (!this.w.player.messages.isEmpty()) {
                d.getHooks().list.clear();
                Empire.Message msg = this.w.player.messages.get(this.w.player.messages.size() - 1);
                String text = msg.text;
                d.messageDialog(sm.width / 2 - 200, sm.height / 2 - 150, 400, text, new Runnable(){

                    @Override
                    public void run() {
                        if (StrategicScreen.this.w.player == null) {
                            return;
                        }
                        StrategicScreen.this.w.player.messages.remove(StrategicScreen.this.w.player.messages.size() - 1);
                    }
                });
            }
            if (!this.w.player.spyActionResults.isEmpty()) {
                String text;
                final SpyActionResult sar = this.w.player.spyActionResults.get(this.w.player.spyActionResults.size() - 1);
                d.getHooks().list.clear();
                String string = text = sar.actor == this.w.player ? sar.actorText : sar.victimText;
                if (this.w.player == sar.victim && sar.success && this.w.player.policeLevel != SecretPoliceLevel.SEVERE) {
                    text = text + "\n\n" + Lang._t("secret_police_hint", new Object[0]);
                }
                Graphics g = (Graphics)d.frame().nativeRenderer();
                g.setColor(Color.black);
                g.setLineWidth(6.0f);
                g.drawLine((float)(sm.width / 2), (float)(sm.height / 2 - 145), (float)((int)this.worldToScreenX(sar.city.x)), (float)((int)this.worldToScreenY(sar.city.y)));
                g.setColor(new Color(245, 228, 116));
                g.setLineWidth(2.0f);
                g.drawLine((float)(sm.width / 2), (float)(sm.height / 2 - 145), (float)((int)this.worldToScreenX(sar.city.x)), (float)((int)this.worldToScreenY(sar.city.y)));
                g.setLineWidth(1.0f);
                d.messageDialog(sm.width / 2 - 200, sm.height / 2 - 150, 400, text, new Runnable(){

                    @Override
                    public void run() {
                        if (StrategicScreen.this.w.player == null) {
                            return;
                        }
                        StrategicScreen.this.w.player.spyActionResults.remove(sar);
                    }
                });
            }
        }
        if (this.w.combatInfo != null && !this.combatConfirmed && !this.w.isMultiplayer()) {
            d.getHooks().list.clear();
            hs.list.clear();
            String text = this.w.combatInfo.attacker(this.w.map).getName() + " vs " + this.w.combatInfo.defender(this.w.map).getName();
            Pt sz = d.textSize(text, AGame.BIG_FOUNT);
            int width = (int)sz.x + MyDraw.PANEL_INSET * 2;
            int height = (int)sz.y + MyDraw.PANEL_INSET * 2;
            int yy = sm.height / 3 - height / 2;
            int xx = sm.width / 2 - width / 2;
            StrategicScreen.checkedBlit(d, sm, this.fight_big, Clr.WHITE, sm.width / 2 - 32, yy - MyDraw.UI_SPACING - 64);
            Graphics g = (Graphics)d.frame().nativeRenderer();
            g.setColor(Color.black);
            g.setLineWidth(6.0f);
            g.drawLine((float)(xx + width / 2), (float)(yy + height / 2), (float)((int)this.worldToScreenX(this.w.combatInfo.attackingFleet.realX())), (float)((int)this.worldToScreenY(this.w.combatInfo.attackingFleet.realY())));
            g.setColor(new Color(245, 228, 116));
            g.setLineWidth(2.0f);
            g.drawLine((float)(xx + width / 2), (float)(yy + height / 2), (float)((int)this.worldToScreenX(this.w.combatInfo.attackingFleet.realX())), (float)((int)this.worldToScreenY(this.w.combatInfo.attackingFleet.realY())));
            g.setLineWidth(1.0f);
            d.drawPanel(xx, yy, width, height);
            d.text(text, AGame.BIG_FOUNT, xx += MyDraw.PANEL_INSET, yy += MyDraw.PANEL_INSET);
            return;
        }
        if (this.w.combatInfo != null) {
            int ix = (int)this.worldToScreenX(this.w.combatInfo.attackingFleet.realX());
            int iy = (int)this.worldToScreenY(this.w.combatInfo.attackingFleet.realY());
            StrategicScreen.checkedBlit(d, sm, this.fight_big, Clr.WHITE, ix - 32, iy - MyDraw.UI_SPACING - 64);
        }
        if (this.showEmpireDetails && this.w.player != null) {
            int contentW = 0;
            int contentH = 0;
            int lineItemsW = 0;
            int moneyW = (int)d.textSize((String)"10000", (Fount)AGame.FOUNT).x;
            int buttonsW = 0;
            String bonusString = null;
            lineItemsW = StrictMath.max(lineItemsW, (int)d.textSize((String)Lang._t((String)"Cities", (Object[])new Object[0]), (Fount)AGame.FOUNT).x);
            lineItemsW = StrictMath.max(lineItemsW, (int)d.textSize((String)Lang._t((String)"Defences_Maintenance", (Object[])new Object[0]), (Fount)AGame.FOUNT).x);
            lineItemsW = StrictMath.max(lineItemsW, (int)d.textSize((String)Lang._t((String)"Fleet_Maintenance", (Object[])new Object[0]), (Fount)AGame.FOUNT).x);
            lineItemsW = StrictMath.max(lineItemsW, (int)d.textSize((String)Lang._t((String)"Research", (Object[])new Object[0]), (Fount)AGame.FOUNT).x);
            lineItemsW = StrictMath.max(lineItemsW, (int)d.textSize((String)Lang._t((String)"Spy_Network", (Object[])new Object[0]), (Fount)AGame.FOUNT).x);
            lineItemsW = StrictMath.max(lineItemsW, (int)d.textSize((String)Lang._t((String)"Secret_Police", (Object[])new Object[0]), (Fount)AGame.FOUNT).x);
            for (SecretPoliceLevel spl : SecretPoliceLevel.values()) {
                buttonsW += MyDraw.BUTTON_SPACING + d.tw(spl.getName());
            }
            contentW = StrictMath.max(contentW, lineItemsW + MyDraw.UI_SPACING + moneyW + MyDraw.UI_SPACING + buttonsW);
            contentH = StrictMath.max(contentH, (AGame.FOUNT.height + MyDraw.SCROLL_EL_SPACING) * 6 + AGame.FOUNT.height);
            StringBuilder sb = new StringBuilder();
            ArrayList<Bonus> blist = this.w.player.bonuses().list();
            for (Tech.Choice t : this.w.player.techs) {
                blist.removeAll(t.bonusList);
            }
            for (Bonus b : blist) {
                if (b.name.equals("NO_BONUS")) continue;
                sb.append(b.getName());
                if (!b.getName().equals(b.getDesc())) {
                    sb.append(": ").append(b.getDesc());
                }
                if (b == blist.get(blist.size() - 1)) continue;
                sb.append("\n");
            }
            bonusString = sb.toString();
            Pt szP = d.textSize(bonusString, AGame.FOUNT);
            contentW = StrictMath.max(contentW, (int)szP.x);
            contentH = StrictMath.max(contentH, (int)szP.y);
            int width = contentW + MyDraw.WINDOW_INSET * 2;
            int height = 140 + AGame.BIGGER_FOUNT.height + MyDraw.UI_SPACING + MyDraw.BUTTON_H + MyDraw.UI_SPACING + contentH + MyDraw.UI_SPACING + MyDraw.BUTTON_H + MyDraw.WINDOW_INSET * 2;
            x = sm.width / 2 - width / 2;
            int y = sm.height / 2 - height / 2;
            d.drawShadowedWindow(x, y, width, height);
            d.drawPanel((x += MyDraw.WINDOW_INSET) + ((width -= MyDraw.WINDOW_INSET * 2) / 2 - 66), y += MyDraw.WINDOW_INSET, 132, 132);
            y += 2;
            ArrayList<CoatOfArms> coas = new ArrayList<CoatOfArms>();
            for (City c : this.w.player.cities) {
                if (c.originalEmpire == this.w.player) {
                    if (coas.contains(this.w.player.arms)) continue;
                    coas.add(0, this.w.player.arms);
                    continue;
                }
                if (coas.contains(c.originalArms)) continue;
                coas.add(c.originalArms);
            }
            if (coas.size() < 2) {
                this.w.player.arms.draw(d, x + (width / 2 - 64), y, 128);
            } else {
                Marshalling.marshal(coas, d, x + (width / 2 - 64), y, 128, MyDraw.DARK_BG);
            }
            Pt ts = d.textSize(Lang._t("The_Empire_of_x", this.w.player.name), AGame.BIGGER_FOUNT);
            d.text(Lang._t("The_Empire_of_x", this.w.player.name), AGame.BIGGER_FOUNT, x + (int)((double)(width / 2) - ts.x / 2.0), y += 140);
            y += AGame.BIGGER_FOUNT.height + MyDraw.UI_SPACING;
            int x2 = x;
            for (final EmpireDetailsMode edm : EmpireDetailsMode.values()) {
                int tw = d.tw(Lang._t(edm.name, new Object[0]));
                d.toggle(x2, y, tw, Lang._t(edm.name, new Object[0]), null, new InputRunnable(){

                    @Override
                    public void run(Input in) {
                        StrategicScreen.this.empireDetailsMode = edm;
                    }
                }, this.empireDetailsMode == edm, true);
                x2 += tw + MyDraw.BUTTON_SPACING;
            }
            y += MyDraw.BUTTON_H + MyDraw.UI_SPACING;
            switch (this.empireDetailsMode) {
                case BUDGET: {
                    int prevY = y;
                    d.text(Lang._t("Cities", new Object[0]), AGame.FOUNT, x, y);
                    d.text("" + this.w.player.totalIncome(this.w.map), AGame.FOUNT, x + lineItemsW + MyDraw.UI_SPACING + moneyW - (int)d.textSize((String)new StringBuilder().append((String)"").append((int)this.w.player.totalIncome((WorldMap)this.w.map)).toString(), (Fount)AGame.FOUNT).x, y);
                    d.text(Lang._t("Defences_Maintenance", new Object[0]), AGame.FOUNT, x, y += AGame.FOUNT.height + MyDraw.SCROLL_EL_SPACING);
                    d.text("" + -this.w.player.totalDefencesCost(), AGame.FOUNT, x + lineItemsW + MyDraw.UI_SPACING + moneyW - (int)d.textSize((String)new StringBuilder().append((String)"").append((int)(-this.w.player.totalDefencesCost())).toString(), (Fount)AGame.FOUNT).x, y);
                    d.text(Lang._t("Fleet_Maintenance", new Object[0]), AGame.FOUNT, x, y += AGame.FOUNT.height + MyDraw.SCROLL_EL_SPACING);
                    d.text("" + -this.w.player.totalFleetCosts(), AGame.FOUNT, x + lineItemsW + MyDraw.UI_SPACING + moneyW - (int)d.textSize((String)new StringBuilder().append((String)"").append((int)(-this.w.player.totalFleetCosts())).toString(), (Fount)AGame.FOUNT).x, y);
                    d.text(Lang._t("Research", new Object[0]), AGame.FOUNT, x, y += AGame.FOUNT.height + MyDraw.SCROLL_EL_SPACING);
                    d.text("" + -this.w.player.researchCost(this.w.player.researchSpeed, this.w.map), AGame.FOUNT, x + lineItemsW + MyDraw.UI_SPACING + moneyW - (int)d.textSize((String)new StringBuilder().append((String)"").append((int)(-this.w.player.researchCost((ResearchSpeed)this.w.player.researchSpeed, (WorldMap)this.w.map))).toString(), (Fount)AGame.FOUNT).x, y);
                    d.text(Lang._t("Spy_Network", new Object[0]), AGame.FOUNT, x, y += AGame.FOUNT.height + MyDraw.SCROLL_EL_SPACING);
                    d.text("" + -this.w.player.totalSpiesCost(), AGame.FOUNT, x + lineItemsW + MyDraw.UI_SPACING + moneyW - (int)d.textSize((String)new StringBuilder().append((String)"").append((int)(-this.w.player.totalSpiesCost())).toString(), (Fount)AGame.FOUNT).x, y);
                    d.text(Lang._t("Secret_Police", new Object[0]), AGame.FOUNT, x, y += AGame.FOUNT.height + MyDraw.SCROLL_EL_SPACING);
                    d.text("" + -this.w.player.totalPoliceCosts(), AGame.FOUNT, x + lineItemsW + MyDraw.UI_SPACING + moneyW - (int)d.textSize((String)new StringBuilder().append((String)"").append((int)(-this.w.player.totalPoliceCosts())).toString(), (Fount)AGame.FOUNT).x, y);
                    x2 = x + lineItemsW + MyDraw.UI_SPACING + moneyW + MyDraw.BUTTON_SPACING + MyDraw.UI_SPACING;
                    int y2 = y - MyDraw.BUTTON_H / 2 + AGame.FOUNT.height / 2;
                    for (final SecretPoliceLevel spl : SecretPoliceLevel.values()) {
                        d.toggle(x2, y2, d.tw(spl.getName()), spl.getName(), null, new InputRunnable(){

                            @Override
                            public void run(Input in) {
                                if (StrategicScreen.this.w.player == null) {
                                    return;
                                }
                                StrategicScreen.this.w.giveCommand(Client.msg("setSecretPoliceLevel").put("empire", StrategicScreen.this.w.player.id).put("level", spl.name()));
                            }
                        }, spl == this.w.player.policeLevel, true);
                        d.tooltip((double)x2, (double)y2, (double)d.tw(spl.getName()), (double)MyDraw.BUTTON_H, spl.getDesc());
                        x2 += d.tw(spl.getName()) + MyDraw.BUTTON_SPACING;
                    }
                    d.text(Lang._t("TOTAL", new Object[0]), AGame.FOUNT, x, y += AGame.FOUNT.height + MyDraw.SCROLL_EL_SPACING);
                    d.text("" + this.w.player.incomeBalance(this.w.map), AGame.FOUNT, x + lineItemsW + MyDraw.UI_SPACING + moneyW - (int)d.textSize((String)new StringBuilder().append((String)"").append((int)this.w.player.incomeBalance((WorldMap)this.w.map)).toString(), (Fount)AGame.FOUNT).x, y);
                    y += AGame.FOUNT.height;
                    y = prevY + contentH;
                    break;
                }
                case BONUSES: {
                    d.text(bonusString, AGame.FOUNT, x, y);
                    y += contentH;
                }
            }
            d.button(sm.width / 2 - d.bw(Lang._t("OK", new Object[0])) / 2, y += MyDraw.UI_SPACING, d.bw(Lang._t("OK", new Object[0])), Lang._t("OK", new Object[0]), new Runnable(){

                @Override
                public void run() {
                    StrategicScreen.this.showEmpireDetails = false;
                }
            });
        }
        if (this.selectedNest != null && this.selectedNest.type == null) {
            this.selectedNest = null;
        }
        if (this.selectedNest != null || this.w.player != null && (this.w.player.rewardGiven != null || this.upgradeStartedNest != null || this.upgradeNearingCompletionNest != null || this.upgradeCompleteNest != null)) {
            d.getHooks().list.clear();
            hs.list.clear();
            int width = 400;
            String infoTitle = "?";
            String infoText = "?";
            Img img = null;
            boolean ucn = false;
            if (this.w.player != null && this.w.player.rewardGiven != null) {
                MonsterNestType.Reward r = this.w.player.rewardGiven;
                infoTitle = Lang._t("VICTORY", new Object[0]);
                infoText = Lang._t(r.name + r.nestType.bonusSuffix(this.w.player), new Object[0]);
                int money = r.getMoney(this.w.player);
                int research = r.getResearch(this.w.player);
                if (money != 0 || research != 0 || r.bonus != null || r.tech != null) {
                    infoText = infoText + "\n" + MyDraw.SELECTED_C;
                }
                if (money != 0) {
                    infoText = infoText + "\n+ $" + money;
                }
                if (research != 0) {
                    infoText = infoText + "\n+ " + research + " " + Lang._t("Research", new Object[0]);
                }
                if (r.bonus != null) {
                    infoText = infoText + "\n+ " + r.bonus.getName();
                }
                if (r.tech != null) {
                    infoText = infoText + "\n+ " + Lang._t("Technology_", new Object[0]) + Lang._t("tech_" + r.tech.name, new Object[0]);
                }
                img = r.img;
            } else if (this.selectedNest != null) {
                infoTitle = Lang._t(this.selectedNest.type.name + "_displayName" + this.selectedNest.type.bonusSuffix(this.w.player), new Object[0]);
                infoText = Lang._t(this.selectedNest.type.name + "_description" + this.selectedNest.type.bonusSuffix(this.w.player), new Object[0]);
                img = this.selectedNest.type.img;
            } else if (this.upgradeStartedNest != null) {
                infoTitle = Lang._t(this.upgradeStartedNest.type.name + "_displayName" + this.selectedNest.type.bonusSuffix(this.w.player), new Object[0]);
                infoText = Lang._t(this.upgradeStartedNest.type.name + "_upgradeStartedDescription" + this.selectedNest.type.bonusSuffix(this.w.player), new Object[0]);
                img = this.upgradeStartedNest.type.img;
            } else if (this.upgradeNearingCompletionNest != null) {
                infoTitle = Lang._t(this.upgradeNearingCompletionNest.type.name + "_displayName" + this.selectedNest.type.bonusSuffix(this.w.player), new Object[0]);
                infoText = Lang._t(this.upgradeNearingCompletionNest.type.name + "_upgradeNearingCompletionDescription" + this.selectedNest.type.bonusSuffix(this.w.player), new Object[0]);
                img = this.upgradeNearingCompletionNest.type.img;
            } else if (this.upgradeCompleteNest != null) {
                infoTitle = Lang._t(this.upgradeCompleteNest.type.name + "_displayName" + this.selectedNest.type.bonusSuffix(this.w.player), new Object[0]);
                infoText = Lang._t(this.upgradeCompleteNest.type.name + "_upgradeCompleteDescription" + this.selectedNest.type.bonusSuffix(this.w.player), new Object[0]);
                img = this.upgradeCompleteNest.type.img;
                ucn = true;
            }
            int textH = (int)d.textSize((String)infoText, (Fount)AGame.FOUNT, (double)0.0, (double)0.0, (int)width).height;
            int height = AGame.BIGGER_FOUNT.height + MyDraw.BUTTON_SPACING + 300 + MyDraw.UI_SPACING + textH + MyDraw.UI_SPACING + MyDraw.BUTTON_H + MyDraw.WINDOW_INSET * 2;
            x = sm.width / 2 - (width += MyDraw.WINDOW_INSET * 2) / 2;
            int y = sm.height / 2 - height / 2;
            if (ucn) {
                Graphics g = (Graphics)d.frame().nativeRenderer();
                g.setColor(Color.black);
                g.setLineWidth(6.0f);
                g.drawLine((float)(x + width / 2), (float)(y + height), (float)((int)this.worldToScreenX(this.upgradeCompleteNest.x)), (float)((int)this.worldToScreenY(this.upgradeCompleteNest.y)));
                g.setColor(new Color(245, 228, 116));
                g.setLineWidth(2.0f);
                g.drawLine((float)(x + width / 2), (float)(y + height), (float)((int)this.worldToScreenX(this.upgradeCompleteNest.x)), (float)((int)this.worldToScreenY(this.upgradeCompleteNest.y)));
                g.setLineWidth(1.0f);
            }
            d.drawWindow(x, y, width, height);
            height -= MyDraw.WINDOW_INSET * 2;
            d.text(MyDraw.TITLE_C + infoTitle, AGame.BIGGER_FOUNT, sm.width / 2 - (int)d.textSize((String)infoTitle, (Fount)AGame.BIGGER_FOUNT).x / 2, y += MyDraw.WINDOW_INSET, width -= MyDraw.WINDOW_INSET * 2);
            d.blit(img, x += MyDraw.WINDOW_INSET, y += AGame.BIGGER_FOUNT.height + MyDraw.BUTTON_SPACING);
            d.drawPanelBorder(x, y, 400, 300);
            d.text(infoText, AGame.FOUNT, x, y += 300 + MyDraw.UI_SPACING, width);
            d.button(sm.width / 2 - d.bw(Lang._t("OK", new Object[0])) / 2, y += textH + MyDraw.UI_SPACING, d.bw(Lang._t("OK", new Object[0])), Lang._t("OK", new Object[0]), new Runnable(){

                @Override
                public void run() {
                    if (StrategicScreen.this.w.player != null && StrategicScreen.this.w.player.rewardGiven != null) {
                        StrategicScreen.this.w.player.rewardGiven = null;
                    } else if (StrategicScreen.this.selectedNest != null) {
                        StrategicScreen.this.selectedNest = null;
                    } else if (StrategicScreen.this.upgradeStartedNest != null) {
                        ((StrategicScreen)StrategicScreen.this).upgradeStartedNest.showUpgradeStartDialog = false;
                        StrategicScreen.this.upgradeStartedNest = null;
                    } else if (StrategicScreen.this.upgradeNearingCompletionNest != null) {
                        ((StrategicScreen)StrategicScreen.this).upgradeNearingCompletionNest.showUpgradeNearingCompletionDialog = false;
                        StrategicScreen.this.upgradeNearingCompletionNest = null;
                    } else if (StrategicScreen.this.upgradeCompleteNest != null) {
                        ((StrategicScreen)StrategicScreen.this).upgradeCompleteNest.showUpgradeCompleteDialog = false;
                        StrategicScreen.this.upgradeCompleteNest = null;
                    }
                }
            });
        }
        if (this.w.player != null && this.w.player.researchedTech != null) {
            d.getHooks().list.clear();
            int width = (int)d.textSize((String)Lang._t((String)"Research_complete_x", (Object[])new Object[]{Lang._t((String)new StringBuilder().append((String)"tech_").append((String)this.w.player.researchedTech.name).toString(), (Object[])new Object[0])}), (Fount)AGame.BIG_FOUNT).x;
            int bsz = this.w.player.researchedTech.bonusList.size();
            for (int bi = 0; bi < bsz; ++bi) {
                Bonus b = this.w.player.researchedTech.bonusList.get(bi);
                width = StrictMath.max(width, (int)d.textSize((String)Lang._t((String)new StringBuilder().append((String)"bonus_").append((String)b.name).toString(), (Object[])new Object[0]), (Fount)AGame.FOUNT).x);
            }
            int infoHeight = StrictMath.max(TechScreen.TECH_ICON_SIZE, AGame.BIG_FOUNT.lineHeight + this.w.player.researchedTech.bonusList.size() * AGame.FOUNT.lineHeight);
            int height = infoHeight + MyDraw.UI_SPACING + MyDraw.BUTTON_H + MyDraw.WINDOW_INSET * 2;
            x = sm.width / 2 - (width += TechScreen.TECH_ICON_SIZE + MyDraw.UI_SPACING + MyDraw.WINDOW_INSET * 2) / 2;
            int y = sm.height / 2 - height / 2;
            d.drawWindow(x, y, width, height);
            width -= MyDraw.WINDOW_INSET * 2;
            d.blit(this.w.player.researchedTech.img, x += MyDraw.WINDOW_INSET, y += MyDraw.WINDOW_INSET);
            int x2 = x + TechScreen.TECH_ICON_SIZE + MyDraw.UI_SPACING;
            int y2 = y;
            d.text(Lang._t("Research_complete_x", Lang._t("tech_" + this.w.player.researchedTech.name, new Object[0])), AGame.BIG_FOUNT, x2, y2);
            y2 += AGame.BIG_FOUNT.lineHeight;
            for (int bi = 0; bi < bsz; ++bi) {
                Bonus b = this.w.player.researchedTech.bonusList.get(bi);
                d.text(Lang._t("bonus_" + b.name, new Object[0]), AGame.FOUNT, x2, y2);
                y2 += AGame.FOUNT.lineHeight;
            }
            final boolean allDone = this.w.player.isAllResearchDone(this.w.map);
            final StrategicScreen self = this;
            d.button(x, y += infoHeight + MyDraw.UI_SPACING, width, allDone ? Lang._t("OK", new Object[0]) : Lang._t("Select_Research", new Object[0]), new Runnable(){

                @Override
                public void run() {
                    if (StrategicScreen.this.w.player == null) {
                        return;
                    }
                    StrategicScreen.this.w.player.researchedTech = null;
                    if (!allDone) {
                        StrategicScreen.this.g.s = new TechScreen(self);
                    }
                }
            });
        }
        if (this.menu) {
            this.renderMenu(d, sm, hs, cursor);
        }
        if (this.w.player != null && this.helpMsg != null) {
            int y = MyDraw.TOP_BAR_H + MyDraw.UI_SPACING;
            x = MyDraw.WINDOW_INSET;
            int w = StrictMath.min(500, sm.width - 300);
            Rect tsz = d.textSize(this.helpMsg.text, AGame.FOUNT, x, y, w - MyDraw.WINDOW_INSET * 2);
            Pt pointer = null;
            if (this.helpMsg.city != null) {
                pointer = new Pt(this.worldToScreenX(this.helpMsg.city.x), this.worldToScreenY(this.helpMsg.city.y));
            }
            if (this.helpMsg.fleet != null) {
                pointer = new Pt(this.worldToScreenX(this.helpMsg.fleet.realX()), this.worldToScreenY(this.helpMsg.fleet.realY()));
            }
            if (this.helpMsg.speedControls) {
                pointer = new Pt((double)speedX, (double)(MyDraw.TOP_BAR_H / 2));
            }
            if (pointer != null) {
                int y2 = y + (int)tsz.height + MyDraw.WINDOW_INSET * 2;
                Graphics g = (Graphics)d.frame().nativeRenderer();
                g.setColor(Color.black);
                g.setLineWidth(6.0f);
                g.drawLine((float)(x + w - 1), (float)(y2 - 1), (float)((int)pointer.x), (float)((int)pointer.y));
                g.setColor(new Color(245, 228, 116));
                g.setLineWidth(2.0f);
                g.drawLine((float)(x + w - 1), (float)(y2 - 1), (float)((int)pointer.x), (float)((int)pointer.y));
                g.setLineWidth(1.0f);
            }
            d.drawShadowedWindow(x, y, w, (int)tsz.height + MyDraw.WINDOW_INSET * 2);
            d.text(this.helpMsg.text, AGame.FOUNT, x + MyDraw.WINDOW_INSET, y + MyDraw.WINDOW_INSET, w - MyDraw.WINDOW_INSET * 2);
            final CampaignWorld cw = this.w;
            d.button(x, y += (int)tsz.height + MyDraw.WINDOW_INSET * 2 + MyDraw.UI_SPACING, d.bw(Lang._t("OK", new Object[0])), Lang._t("OK", new Object[0]), new Runnable(){

                @Override
                public void run() {
                    cw.help.clear(((StrategicScreen)StrategicScreen.this).helpMsg.type);
                }
            });
        }
        if (this.w.player != null && this.w.victory()) {
            d.getHooks().list.clear();
            d.rect(AirshipGame.ERR_BG_TINT, 0.0, 0.0, sm.width, sm.height);
            int width = 320;
            int height = 320;
            x = sm.width / 2 - width / 2;
            int textY = StrictMath.max(60, sm.height / 2 - 300);
            int y = textY - 60 + 140;
            d.blit(this.victoryUnderlay, GOLD, x, y, width, height);
            this.w.player.arms.draw(d, x + width / 4, y + height / 4 + 50, width / 2);
            Pt sz = d.textSize(Lang._t("VICTORY", new Object[0]), AGame.HUGE_FOUNT);
            d.borderedText(Lang._t("VICTORY", new Object[0]), AGame.HUGE_FOUNT, GOLD, Clr.BLACK, (int)((double)(sm.width / 2) - sz.x / 2.0), textY);
            bw = d.bw(Lang._t("Leave", new Object[0]));
            d.button(sm.width / 2 - bw / 2, y += height / 2 + AGame.HUGE_FOUNT.lineHeight + MyDraw.UI_SPACING * 2 + 50, bw, Lang._t("Leave", new Object[0]), new Runnable(){

                @Override
                public void run() {
                    StrategicScreen.this.leave();
                }
            });
        } else if (this.w.player != null && this.w.defeat()) {
            d.getHooks().list.clear();
            d.rect(AirshipGame.ERR_BG_TINT, 0.0, 0.0, sm.width, sm.height);
            int width = 320;
            int height = 320;
            x = sm.width / 2 - width / 2;
            int textY = StrictMath.max(60, sm.height / 2 - 300);
            int y = textY - 20;
            this.w.player.arms.draw(d, x + width / 4, y + height / 4 + 50, width / 2);
            d.rect(ROT, x + width / 4, y + height / 4 + 50, width / 2, height / 2);
            d.blit(this.defeatOverlay, INK, x, y, width, height);
            Pt sz = d.textSize(Lang._t("DEFEAT", new Object[0]), AGame.HUGE_FOUNT);
            d.borderedText(Lang._t("DEFEAT", new Object[0]), AGame.HUGE_FOUNT, PARCHMENT, Clr.BLACK, (int)((double)(sm.width / 2) - sz.x / 2.0), textY);
            bw = d.bw(Lang._t("Leave", new Object[0]));
            d.button(sm.width / 2 - bw / 2, y += height / 2 + AGame.HUGE_FOUNT.lineHeight + MyDraw.UI_SPACING * 2 + 50, bw, Lang._t("Leave", new Object[0]), new Runnable(){

                @Override
                public void run() {
                    StrategicScreen.this.leave();
                }
            });
            y += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING;
            if (!this.w.someoneWon()) {
                bw = d.bw(Lang._t("Spectate", new Object[0]));
                d.button(sm.width / 2 - bw / 2, y, bw, Lang._t("Spectate", new Object[0]), new Runnable(){

                    @Override
                    public void run() {
                        StrategicScreen.this.spectate();
                    }
                });
            }
        } else if (this.w.someoneWon()) {
            d.messageDialog(sm.width / 2 - 200, sm.height / 2 - 150, 400, Lang._t("x_has_won", this.w.winnerName()), new Runnable(){

                @Override
                public void run() {
                    StrategicScreen.this.leave();
                }
            });
        } else if (this.combatOutcome != null) {
            d.getHooks().list.clear();
            hs.list.clear();
            String what = this.combatOutcome.type.getName();
            String where = this.combatOutcome.loc == null ? "" : this.combatOutcome.loc.getDisplayName();
            String who = this.combatOutcome.opponentName;
            int width = (int)StrictMath.max(StrictMath.max(d.textSize((String)what, (Fount)AGame.HUGE_FOUNT).x, d.textSize((String)where, (Fount)AGame.FOUNT).x), d.textSize((String)who, (Fount)AGame.FOUNT).x) + MyDraw.PANEL_INSET * 2 + MyDraw.WINDOW_INSET * 2;
            int xx = sm.width / 2 - width / 2;
            int height = AGame.HUGE_FOUNT.lineHeight + MyDraw.UI_SPACING + AGame.FOUNT.lineHeight * 2 + MyDraw.PANEL_INSET * 2 + MyDraw.WINDOW_INSET;
            int yy = sm.height / 3 - height / 2;
            StrategicScreen.checkedBlit(d, sm, this.fight_big, Clr.WHITE, sm.width / 2 - 32, yy - MyDraw.UI_SPACING - 64);
            Graphics g = (Graphics)d.frame().nativeRenderer();
            g.setColor(Color.black);
            g.setLineWidth(6.0f);
            g.drawLine((float)(sm.width / 2), (float)(yy + height / 2), (float)((int)this.worldToScreenX(this.combatOutcome.x)), (float)((int)this.worldToScreenY(this.combatOutcome.y)));
            g.setColor(new Color(245, 228, 116));
            g.setLineWidth(2.0f);
            g.drawLine((float)(sm.width / 2), (float)(yy + height / 2), (float)((int)this.worldToScreenX(this.combatOutcome.x)), (float)((int)this.worldToScreenY(this.combatOutcome.y)));
            g.setLineWidth(1.0f);
            d.drawPanel(xx, yy, width, height);
            xx += MyDraw.PANEL_INSET;
            d.text(what, AGame.HUGE_FOUNT, sm.width / 2 - (int)d.textSize((String)what, (Fount)AGame.HUGE_FOUNT).x / 2, yy += MyDraw.PANEL_INSET);
            d.text(where, AGame.FOUNT, sm.width / 2 - (int)d.textSize((String)where, (Fount)AGame.FOUNT).x / 2, yy += AGame.HUGE_FOUNT.lineHeight + MyDraw.UI_SPACING);
            d.text(who, AGame.FOUNT, sm.width / 2 - (int)d.textSize((String)who, (Fount)AGame.FOUNT).x / 2, yy += AGame.FOUNT.lineHeight);
            yy += AGame.FOUNT.lineHeight;
            d.hook(0.0, 0.0, sm.width, sm.height, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED}){

                public void run(Input in, Pt p, Hook.Type type) {
                    StrategicScreen.this.combatOutcome = null;
                }
            });
        } else if (this.askForScrap != null) {
            d.getHooks().list.clear();
            int width = 300;
            d.confirmDialog(sm.width / 2 - width / 2, sm.height / 2 - 150, width, Lang._t("Scrap_x_for_y_gold", this.askForScrap.getName(), this.askForScrap.getCost() / 8), new Runnable(){

                @Override
                public void run() {
                    StrategicScreen.this.doScrap();
                }
            }, new Runnable(){

                @Override
                public void run() {
                    StrategicScreen.this.askForScrap = null;
                }
            });
        } else if (this.askForScuttle != null) {
            d.getHooks().list.clear();
            int width = 300;
            d.confirmDialog(sm.width / 2 - width / 2, sm.height / 2 - 150, width, Lang._t("Discard_x", this.askForScuttle.getName()), new Runnable(){

                @Override
                public void run() {
                    StrategicScreen.this.doScuttle();
                }
            }, new Runnable(){

                @Override
                public void run() {
                    StrategicScreen.this.askForScuttle = null;
                }
            });
        }
        if (this.shipNameDialog != null) {
            hs.list.clear();
            d.state.glowRects.clear();
            this.shipNameDialog.render(d, sm, hs, cursor);
        }
        if (this.w.defeatedPlayersSeenIndex < this.w.defeatedPlayers.size() && !this.w.someoneWon()) {
            hs.list.clear();
            d.state.glowRects.clear();
            StringBuilder msg = new StringBuilder(Lang._t("Lost_player_connections", new Object[0]));
            for (String dp : this.disconnectedPlayers) {
                msg.append("\n").append(dp);
            }
            d.messageDialog(sm.width / 2 - 200, sm.height / 2 - 150, 400, Lang._t("x_has_been_defeated", this.w.defeatedPlayers.get(this.w.defeatedPlayersSeenIndex).name()), new Runnable(){

                @Override
                public void run() {
                    ++StrategicScreen.this.w.defeatedPlayersSeenIndex;
                }
            });
        }
        if (!this.disconnectedPlayers.isEmpty() && !this.w.someoneWon()) {
            hs.list.clear();
            d.state.glowRects.clear();
            StringBuilder msg = new StringBuilder(Lang._t("Lost_player_connections", new Object[0]));
            for (String dp : this.disconnectedPlayers) {
                msg.append("\n").append(dp);
            }
            d.messageDialog(sm.width / 2 - 200, sm.height / 2 - 150, 400, msg.toString(), new Runnable(){

                @Override
                public void run() {
                    StrategicScreen.this.disconnectedPlayers.clear();
                }
            });
        }
        if (this.checkLeave) {
            hs.list.clear();
            d.state.glowRects.clear();
            d.confirmDialog(sm.width / 2 - 200, sm.height / 2 - 150, 400, Lang._t("mp_host_leave_warning", new Object[0]), new Runnable(){

                @Override
                public void run() {
                    StrategicScreen.this.leave();
                }
            }, new Runnable(){

                @Override
                public void run() {
                    StrategicScreen.this.checkLeave = false;
                }
            });
        }
        if (this.w.desyncPubliclyDetected()) {
            d.heavilyBorderedText(Lang._t("desync_notice", new Object[0]), AGame.BIG_FOUNT, AGame.BIG_FOUNT_OUTLINE, Clr.BLACK, Clr.WHITE, MyDraw.SIDE_CLEARANCE, sm.height / 2, 100000);
        } else if (this.showAutosaveNotice()) {
            d.heavilyBorderedText(Lang._t("autosave_notice", new Object[0]), AGame.BIG_FOUNT, AGame.BIG_FOUNT_OUTLINE, Clr.BLACK, Clr.WHITE, MyDraw.SIDE_CLEARANCE, sm.height / 2, 100000);
        } else if (this.w.isMultiplayer() && this.w.isAboutToChecksum()) {
            d.heavilyBorderedText(Lang._t("sync_check_notice", new Object[0]), AGame.BIG_FOUNT, AGame.BIG_FOUNT_OUTLINE, Clr.BLACK, Clr.WHITE, MyDraw.SIDE_CLEARANCE, sm.height / 2, 100000);
        }
        if (this.w.isMultiplayer()) {
            d.borderedText(this.g.isReconnecting() ? Lang._t("Reconnecting_", new Object[0]) : "ping " + this.g.ping() + (AGame.isDebug() ? " network queue size = " + this.w.frameQueueSize() + ", world processing queue size = " + this.g.inQueueSize() + ", outgoing networking queue size = " + this.g.outQueueSize() : ""), AGame.FOUNT, Clr.WHITE, Clr.BLACK, MyDraw.SIDE_CLEARANCE, sm.height - MyDraw.SIDE_CLEARANCE - AGame.FOUNT.height);
            if (this.g.inQueueSize() > 200 && this.w.map.age > 20000 && !this.tooSlowMessageShown) {
                this.showTooSlowMessage = true;
                this.tooSlowMessageShown = true;
                this.g.reportError("Too slow. Ping is " + this.g.ping() + " queue size is " + this.g.inQueueSize() + " map size is " + this.w.map.height.length + ".", null, null, false, true);
            }
            if (this.showTooSlowMessage) {
                hs.list.clear();
                d.state.glowRects.clear();
                d.messageDialog(sm.width / 2 - 200, sm.height / 2 - 150, 400, Lang._t("mp_too_slow_warning", new Object[0]), new Runnable(){

                    @Override
                    public void run() {
                        StrategicScreen.this.showTooSlowMessage = false;
                    }
                });
            }
        }
    }

    public static FileScreen.Backend savesList() {
        File f = new File(AGame.getGameDirectory(), "saves");
        f.mkdirs();
        return new JSONFileBackend(f);
    }

    public void save() {
        if (this.w.defeat() || this.w.victory()) {
            return;
        }
        FileScreen.Backend b = StrategicScreen.savesList();
        FileScreen fs = new FileScreen(b, new SaveGameMission(this.g, this, b), null, new DateInfo(b), "saves");
        fs.backgroundTask = this;
        this.g.s = fs;
    }

    public void open(boolean returnToMainMenu) {
        FileScreen.Backend b = StrategicScreen.savesList();
        FileScreen fs = new FileScreen(StrategicScreen.savesList(), new OpenGameMission(this.g, this, returnToMainMenu, b), null, new DateInfo(b), "saves");
        fs.backgroundTask = this;
        this.g.s = fs;
    }

    @Override
    public ArrayList<String> music() {
        return AGame.STRATEGIC_MUSIC;
    }

    @Override
    public String appearancePostfix() {
        return "DAY";
    }

    @Override
    public boolean alwaysUseAppearancePostfix() {
        return true;
    }

    static {
        MAP_SHADOW = new Clr(0, 0, 0, 30);
    }

    private strictfp static class Backdrop {
        BackdropType type;
        int x;
        int y;
        double rot;

        public Backdrop(BackdropType type, int x, int y, double rot) {
            this.type = type;
            this.x = x;
            this.y = y;
            this.rot = rot;
        }
    }

    private strictfp static class BackdropType {
        public final Img img;
        public final boolean shadow;

        public BackdropType(Img img, boolean shadow) {
            this.img = img;
            this.shadow = shadow;
        }
    }

    private strictfp static enum EmpireDetailsMode {
        BUDGET("Budget"),
        BONUSES("Bonuses");

        public final String name;

        private EmpireDetailsMode(String name) {
            this.name = name;
        }
    }
}

