/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.codedisaster.steamworks.SteamAPI;
import com.codedisaster.steamworks.SteamAPICall;
import com.codedisaster.steamworks.SteamAuth;
import com.codedisaster.steamworks.SteamException;
import com.codedisaster.steamworks.SteamFriends;
import com.codedisaster.steamworks.SteamFriendsCallback;
import com.codedisaster.steamworks.SteamID;
import com.codedisaster.steamworks.SteamLeaderboardEntriesHandle;
import com.codedisaster.steamworks.SteamLeaderboardHandle;
import com.codedisaster.steamworks.SteamPublishedFileID;
import com.codedisaster.steamworks.SteamRemoteStorage;
import com.codedisaster.steamworks.SteamRemoteStorageCallback;
import com.codedisaster.steamworks.SteamResult;
import com.codedisaster.steamworks.SteamUGC;
import com.codedisaster.steamworks.SteamUGCCallback;
import com.codedisaster.steamworks.SteamUGCDetails;
import com.codedisaster.steamworks.SteamUGCHandle;
import com.codedisaster.steamworks.SteamUGCQuery;
import com.codedisaster.steamworks.SteamUser;
import com.codedisaster.steamworks.SteamUserCallback;
import com.codedisaster.steamworks.SteamUserStats;
import com.codedisaster.steamworks.SteamUserStatsCallback;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.LoadingScreen;
import java.nio.ByteBuffer;

public strictfp class SteamBackend
implements SteamUserCallback,
SteamFriendsCallback,
SteamUserStatsCallback,
SteamRemoteStorageCallback,
SteamUGCCallback {
    public static final int APP_ID = 342560;
    public static boolean switchedOn = System.getProperty("steam", "false").equals("true");
    private static boolean loadTried = false;
    private static boolean loadFailed = false;
    private static SteamUser user = null;
    public static SteamFriends friends = null;
    private static SteamUserStats stats = null;
    public static SteamRemoteStorage storage = null;
    public static SteamRemoteStorageCallback remoteStorageCallback = null;
    public static SteamUGC ugc = null;
    public static SteamUGCCallback ugcCallback = null;
    private static final SteamBackend instance = new SteamBackend();
    private static String nick;

    private SteamBackend() {
    }

    public static boolean isSwitchedOn() {
        return switchedOn;
    }

    public static boolean hasBrokenSteam() {
        return switchedOn && loadFailed;
    }

    private static void init() {
        if (switchedOn && !loadTried) {
            loadTried = true;
            loadFailed = !SteamAPI.init();
            System.out.println("loadFailed " + loadFailed);
        }
    }

    public static void tick() {
        SteamBackend.init();
        if (SteamBackend.isEnabled()) {
            SteamAPI.runCallbacks();
            if (user == null) {
                user = new SteamUser((SteamUserCallback)instance);
                friends = new SteamFriends((SteamFriendsCallback)instance);
                stats = new SteamUserStats((SteamUserStatsCallback)instance);
                storage = new SteamRemoteStorage((SteamRemoteStorageCallback)instance);
                ugc = new SteamUGC((SteamUGCCallback)instance);
            }
        }
    }

    public static void sub(long id, final String modID) {
        SteamPublishedFileID spfi = new SteamPublishedFileID(id);
        SteamAPICall sac = ugc.subscribeItem(spfi);
        ugcCallback = new SteamUGCCallback(){

            public void onUGCQueryCompleted(SteamUGCQuery sugcq, int i, int i1, boolean bln, SteamResult sr) {
                System.out.println("sub onUGCQueryCompleted " + sr.name());
            }

            public void onSubscribeItem(SteamPublishedFileID spfid, SteamResult sr) {
                if (sr.equals((Object)SteamResult.OK)) {
                    AirshipGame.instance.s = new LoadingScreen(AirshipGame.instance, modID);
                } else {
                    AirshipGame.instance.showError(sr.name());
                }
            }

            public void onUnsubscribeItem(SteamPublishedFileID spfid, SteamResult sr) {
            }

            public void onRequestUGCDetails(SteamUGCDetails sugcd, SteamResult sr) {
            }

            public void onCreateItem(SteamPublishedFileID spfid, boolean bln, SteamResult sr) {
            }

            public void onSubmitItemUpdate(boolean bln, SteamResult sr) {
            }

            public void onDownloadItemResult(long l, SteamPublishedFileID spfid, SteamResult sr) {
                System.out.println("sub onDownloadItemResult");
            }

            public void onUserFavoriteItemsListChanged(SteamPublishedFileID spfid, boolean bln, SteamResult sr) {
            }

            public void onSetUserItemVote(SteamPublishedFileID spfid, boolean bln, SteamResult sr) {
            }

            public void onGetUserItemVote(SteamPublishedFileID spfid, boolean bln, boolean bln1, boolean bln2, SteamResult sr) {
            }
        };
    }

    public static boolean isEnabled() {
        return switchedOn && loadTried && !loadFailed && SteamAPI.isSteamRunning();
    }

    public static String getSteamNickname() {
        if (nick == null && friends != null) {
            nick = friends.getPersonaName();
        }
        return nick;
    }

    public static String getSteamNickDisplayName() {
        return SteamBackend.getSteamNickname().replace("[", "(").replace("]", ")").replace("{", "(").replace("}", ")");
    }

    public static boolean hasRealNickname() {
        return nick != null;
    }

    public static long getUserID() {
        return user == null ? -1L : user.getSteamID().getNativeHandle();
    }

    public static int getAccountID() {
        return user == null ? -1 : user.getSteamID().getAccountID();
    }

    public static boolean _achieve(String name) {
        if (stats == null) {
            return false;
        }
        try {
            if (!stats.isAchieved(name, false)) {
                stats.setAchievement(name);
                stats.storeStats();
                return true;
            }
        }
        catch (Exception e) {
            AirshipGame.instance.reportError("Can't achieve " + name, e, "", false, true);
            return true;
        }
        return false;
    }

    public static boolean _unAchieve(String name) {
        if (stats == null) {
            return false;
        }
        try {
            if (stats.isAchieved(name, false)) {
                stats.clearAchievement(name);
                stats.storeStats();
                return true;
            }
        }
        catch (Exception e) {
            AirshipGame.instance.reportError("Can't achieve " + name, e, "", false, true);
            return true;
        }
        return false;
    }

    public static boolean _isAchieved(String name) {
        if (stats == null) {
            return false;
        }
        return stats.isAchieved(name, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(String name, byte[] data) throws Exception {
        ByteBuffer bb = ByteBuffer.allocateDirect(data.length);
        bb.put(data);
        bb.rewind();
        try {
            System.out.println("datalength = " + data.length);
            System.out.println("filename = " + name);
            if (!storage.fileWrite(name, bb, data.length)) {
                throw new RuntimeException(Lang._t("unable_to_write_steam_file", new Object[0]));
            }
        }
        finally {
            bb.clear();
        }
    }

    public static byte[] readFile(String name) throws SteamException {
        int sz = storage.getFileSize(name);
        ByteBuffer bb = ByteBuffer.allocateDirect(sz);
        storage.fileRead(name, bb, sz);
        byte[] a = new byte[sz];
        bb.get(a);
        return a;
    }

    public void onValidateAuthTicketResponse(SteamID steamID, SteamAuth.AuthSessionResponse asr, SteamID ownerSteamID) {
        System.out.println("onValidateAuthTicketResponse");
    }

    public void onPersonaStateChange(SteamID sid, SteamFriends.PersonaChange pc) {
        System.out.println("onPersonaStateChange");
    }

    public void onGameOverlayActivated(boolean bln) {
        System.out.println("onGameOverlayActivated");
    }

    public void onGameLobbyJoinRequested(SteamID sid, SteamID sid1) {
        System.out.println("onGameLobbyJoinRequested");
    }

    public void onAvatarImageLoaded(SteamID sid, int i, int i1, int i2) {
        System.out.println("onAvatarImageLoaded");
    }

    public void onUserStatsReceived(long l, SteamID sid, SteamResult sr) {
        System.out.println("onUserStatsReceived");
    }

    public void onUserStatsStored(long l, SteamResult sr) {
        System.out.println("onUserStatsStored");
    }

    public void onUserStatsUnloaded(SteamID sid) {
        System.out.println("onUserStatsUnloaded");
    }

    public void onUserAchievementStored(long l, boolean bln, String string, int i, int i1) {
        System.out.println("onUserAchievementStored");
    }

    public void onLeaderboardFindResult(SteamLeaderboardHandle slh, boolean bln) {
        System.out.println("onLeaderboardFindResult");
    }

    public void onLeaderboardScoresDownloaded(SteamLeaderboardHandle slh, SteamLeaderboardEntriesHandle sleh, int i) {
        System.out.println("onLeaderboardScoresDownloaded");
    }

    public void onLeaderboardScoreUploaded(boolean bln, SteamLeaderboardHandle slh, int i, boolean bln1, int i1, int i2) {
        System.out.println("onLeaderboardScoreUploaded");
    }

    public void onFileShareResult(SteamUGCHandle sugch, String string, SteamResult sr) {
        System.out.println("onFileShareResult");
        if (remoteStorageCallback != null) {
            remoteStorageCallback.onFileShareResult(sugch, string, sr);
        }
    }

    public void onDownloadUGCResult(SteamUGCHandle sugch, SteamResult sr) {
        System.out.println("onDownloadUGCResult");
        if (remoteStorageCallback != null) {
            remoteStorageCallback.onDownloadUGCResult(sugch, sr);
        }
    }

    public void onPublishFileResult(SteamPublishedFileID spfid, boolean bln, SteamResult sr) {
        System.out.println("onPublishFileResult");
        if (remoteStorageCallback != null) {
            remoteStorageCallback.onPublishFileResult(spfid, bln, sr);
        }
    }

    public void onUpdatePublishedFileResult(SteamPublishedFileID spfid, boolean bln, SteamResult sr) {
        System.out.println("onUpdatePublishedFileResult");
        if (remoteStorageCallback != null) {
            remoteStorageCallback.onUpdatePublishedFileResult(spfid, bln, sr);
        }
    }

    public void onUGCQueryCompleted(SteamUGCQuery query, int numResultsReturned, int totalMatchingResults, boolean isCachedData, SteamResult result) {
        System.out.println("onUGCQueryCompleted");
        if (ugcCallback != null) {
            ugcCallback.onUGCQueryCompleted(query, numResultsReturned, totalMatchingResults, isCachedData, result);
        }
    }

    public void onSubscribeItem(SteamPublishedFileID spfid, SteamResult sr) {
        System.out.println("onSubscribeItem");
        if (ugcCallback != null) {
            ugcCallback.onSubscribeItem(spfid, sr);
        }
    }

    public void onUnsubscribeItem(SteamPublishedFileID spfid, SteamResult sr) {
        System.out.println("onUnsubscribeItem");
        if (ugcCallback != null) {
            ugcCallback.onUnsubscribeItem(spfid, sr);
        }
    }

    public void onRequestUGCDetails(SteamUGCDetails sugcd, SteamResult sr) {
        System.out.println("onRequestUGCDetails");
        if (ugcCallback != null) {
            ugcCallback.onRequestUGCDetails(sugcd, sr);
        }
    }

    public void onCreateItem(SteamPublishedFileID spfid, boolean bln, SteamResult sr) {
    }

    public void onSubmitItemUpdate(boolean bln, SteamResult sr) {
    }

    public void onDownloadItemResult(long l, SteamPublishedFileID spfid, SteamResult sr) {
        if (ugcCallback != null) {
            ugcCallback.onDownloadItemResult(l, spfid, sr);
        }
    }

    public void onUserFavoriteItemsListChanged(SteamPublishedFileID spfid, boolean bln, SteamResult sr) {
    }

    public void onSetUserItemVote(SteamPublishedFileID spfid, boolean bln, SteamResult sr) {
    }

    public void onGetUserItemVote(SteamPublishedFileID spfid, boolean bln, boolean bln1, boolean bln2, SteamResult sr) {
    }
}

