/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AIQuality;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.CampaignCombatIntent;
import com.zarkonnen.airships.CampaignCombatSetupIntent;
import com.zarkonnen.airships.City;
import com.zarkonnen.airships.Client;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.CombatIntent;
import com.zarkonnen.airships.CombatSettingsIntent;
import com.zarkonnen.airships.Compression;
import com.zarkonnen.airships.EditMissionIntent;
import com.zarkonnen.airships.Empire;
import com.zarkonnen.airships.InitCombatProcess;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MissionEditorPanel;
import com.zarkonnen.airships.MissionSequence;
import com.zarkonnen.airships.MissionSetupIntent;
import com.zarkonnen.airships.MonsterNest;
import com.zarkonnen.airships.MultiplayerCampaignCombatSetupIntent;
import com.zarkonnen.airships.PlayMissionCombatIntent;
import com.zarkonnen.airships.Recording;
import com.zarkonnen.airships.SingleCombatIntent;
import com.zarkonnen.airships.SingleCombatSetupIntent;
import com.zarkonnen.airships.TacticalAI;
import com.zarkonnen.airships.TryMissionCombatIntent;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;

public strictfp class StartCombatButton
extends UniScreen.Button {
    @Override
    public boolean visible(UniScreen us) {
        if (us.intent instanceof MultiplayerCampaignCombatSetupIntent) {
            return us.mySide != null;
        }
        return us.intent instanceof SingleCombatSetupIntent || us.intent instanceof CampaignCombatSetupIntent || us.intent instanceof EditMissionIntent || us.intent instanceof MissionSetupIntent;
    }

    @Override
    public boolean enabled(UniScreen us) {
        if (us.intent instanceof EditMissionIntent) {
            EditMissionIntent emi = (EditMissionIntent)us.intent;
            MissionSequence seq = emi.missionSequence;
            MissionSequence.Mission m = emi.mission;
            return MissionEditorPanel.getProblem(seq, m) == null;
        }
        if (us.intent instanceof MissionSetupIntent) {
            MissionSetupIntent pmsi = (MissionSetupIntent)us.intent;
            return pmsi.getBudgetLeft(us) >= 0 && !us.combat.sides.get((int)0).ships.isEmpty() && !us.combat.sides.get((int)1).ships.isEmpty();
        }
        if (us.intent instanceof SingleCombatSetupIntent) {
            return !us.combat.sides.get((int)0).ships.isEmpty() && !us.combat.sides.get((int)1).ships.isEmpty();
        }
        if (us.intent instanceof MultiplayerCampaignCombatSetupIntent) {
            return !((MultiplayerCampaignCombatSetupIntent)us.intent).readySent;
        }
        return true;
    }

    @Override
    public String text(UniScreen us) {
        if (us.intent instanceof EditMissionIntent) {
            return Lang._t("Play", new Object[0]);
        }
        if (us.intent instanceof MultiplayerCampaignCombatSetupIntent) {
            return Lang._t("Ready", new Object[0]);
        }
        return Lang._t("Start", new Object[0]);
    }

    @Override
    public boolean gold(UniScreen us) {
        return !(us.intent instanceof EditMissionIntent);
    }

    @Override
    public void click(Input in, UniScreen us) {
        if (us.intent instanceof MultiplayerCampaignCombatSetupIntent) {
            ((MultiplayerCampaignCombatSetupIntent)us.intent).readySent = true;
            us.combat.giveCommand(Client.msg("combatReady").put("side", us.combat.sides.indexOf(us.mySide)));
            return;
        }
        AIQuality aiq = AIQuality.NORMAL;
        if (us.intent instanceof CombatSettingsIntent) {
            aiq = ((CombatSettingsIntent)((Object)us.intent)).getAIQuality();
        }
        if (us.intent instanceof CampaignCombatSetupIntent) {
            aiq = ((CampaignCombatSetupIntent)us.intent).ci.aiQuality;
        }
        Combat.Side playerSide = null;
        Combat.Side computerSide = null;
        boolean doesSurrender = true;
        int surrenderFactor = 8;
        boolean assignNewNetworkIDs = false;
        if (us.intent instanceof SingleCombatSetupIntent) {
            us.intent = new SingleCombatIntent();
            playerSide = us.combat.sides.get(0);
            computerSide = us.combat.sides.get(1);
            doesSurrender = false;
            us.combat.recording.header.placeName = null;
            us.combat.recording.header.type = Recording.Header.Type.SINGLE_COMBAT;
            assignNewNetworkIDs = true;
        } else if (us.intent instanceof EditMissionIntent) {
            EditMissionIntent emi = (EditMissionIntent)us.intent;
            emi.mission.combat = emi.mission.combat.clone(us.g);
            emi.mission.combat.initWheelsLegsTentaclesAndBarrels();
            us.combat.recording.header.placeName = emi.missionSequence.getName();
            us.combat.recording.header.type = Recording.Header.Type.MISSION;
            us.combat.physics = null;
            if (emi.mission.playerBudget > 0) {
                us.intent = new MissionSetupIntent(true, emi.missionSequence, emi.mission);
                return;
            }
            us.intent = new TryMissionCombatIntent(false, emi.missionSequence, emi.mission);
            playerSide = us.combat.sides.get(emi.mission.playerSideIndex);
            computerSide = us.combat.sides.get(emi.mission.playerSideIndex == 0 ? 1 : 0);
            doesSurrender = false;
            assignNewNetworkIDs = true;
        } else if (us.intent instanceof MissionSetupIntent) {
            MissionSetupIntent pmsi = (MissionSetupIntent)us.intent;
            us.combat.recording.header.placeName = pmsi.seq.getName();
            us.combat.recording.header.type = Recording.Header.Type.MISSION;
            us.intent = pmsi.tryOnly ? new TryMissionCombatIntent(pmsi.startMessageShown, pmsi.seq, pmsi.mission) : new PlayMissionCombatIntent(pmsi.startMessageShown, pmsi.seq, pmsi.mission);
            playerSide = us.combat.sides.get(pmsi.mission.playerSideIndex);
            computerSide = us.combat.sides.get(pmsi.mission.playerSideIndex == 0 ? 1 : 0);
            doesSurrender = false;
            assignNewNetworkIDs = true;
        } else if (us.intent instanceof CampaignCombatSetupIntent) {
            CampaignCombatSetupIntent ccsi = (CampaignCombatSetupIntent)us.intent;
            us.intent = new CampaignCombatIntent(ccsi.ss, ccsi.ci);
            int psi = ccsi.ci.playerCombatSideIndex(ccsi.ss.w);
            if (psi == -1) {
                AirshipGame.instance.reportError("No player side", null, Compression.compressToString(ccsi.ss.w.toJSON().toString(4)), false, true);
                psi = 0;
            }
            playerSide = us.combat.sides.get(psi);
            computerSide = us.combat.otherSide(playerSide);
            us.combat.recording.header.placeName = ccsi.ci.defendingLoc != null ? ccsi.ci.defendingLoc.getDisplayName() : null;
            us.combat.recording.header.type = Recording.Header.Type.STRATEGIC;
            if (ccsi.ci.playerCombatSideIndex(ccsi.ss.w) == 0 && ccsi.ci.defendingLoc == null) {
                doesSurrender = false;
            }
            if (ccsi.ci.defendingLoc instanceof MonsterNest) {
                doesSurrender = false;
            }
            if (ccsi.ci.defender(ccsi.ss.w.map) instanceof Empire) {
                Empire e = (Empire)ccsi.ci.defender(ccsi.ss.w.map);
                if (e.cities.size() < 2 || ccsi.ci.defendingLoc instanceof City && !((City)ccsi.ci.defendingLoc).isTown) {
                    surrenderFactor = 60;
                }
            }
        }
        computerSide.usingAI = true;
        int shipI = 1;
        for (Airship as : computerSide.ships) {
            as.ai = new TacticalAI(as, us.combat, computerSide, playerSide);
            as.ai.quality = aiq;
            as.ai.doesSurrender = doesSurrender;
            as.ai.baseSurrenderFactor = surrenderFactor;
            if (!assignNewNetworkIDs) continue;
            as.networkID = "ai." + shipI++;
        }
        for (Airship as : computerSide.reserve) {
            as.ai = new TacticalAI(as, us.combat, computerSide, playerSide);
            as.ai.quality = aiq;
            as.ai.doesSurrender = doesSurrender;
            as.ai.baseSurrenderFactor = surrenderFactor;
            if (!assignNewNetworkIDs) continue;
            as.networkID = "ai." + shipI++;
        }
        if (assignNewNetworkIDs) {
            shipI = 1;
            for (Airship as : playerSide.ships) {
                as.networkID = "p." + shipI++;
            }
            for (Airship as : playerSide.reserve) {
                as.networkID = "p." + shipI++;
            }
        }
        us.tool = UniScreen.NAVIGATE;
        us.combat.repairAllShips();
        us.combat.initWheelsLegsTentaclesAndBarrels();
        us.combat.physics = null;
        ((CombatIntent)us.intent).initCombatProcess = new InitCombatProcess(us.combat);
    }

    @Override
    public String hotkey(UniScreen us) {
        return "T";
    }
}

