/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Loadable;
import com.zarkonnen.airships.SpriteUtils;
import java.util.HashMap;
import org.json.JSONObject;
import org.newdawn.slick.Image;
import org.newdawn.slick.opengl.Texture;

public strictfp class SpritesheetBundle
extends Loadable {
    public final String bump;
    public final String fragments;
    private final SpritesheetBundle damagedVersion;
    private final SpritesheetBundle fragmentsSheet;
    private boolean isDamaged;
    private boolean isFragments;
    private boolean closed;
    private final HashMap<String, Image> postfixToSheet = new HashMap();
    private final HashMap<String, Texture> postfixToTex = new HashMap();
    public Texture bumpTex;

    public boolean isClosed() {
        return this.closed;
    }

    public Image getSheet(String postfix) {
        if (this.closed) {
            throw new RuntimeException("Attempting to access closed sheet.");
        }
        if (this.bump == null || this.isFragments) {
            return this.postfixToSheet.get("");
        }
        if (!this.postfixToSheet.containsKey(postfix)) {
            return this.postfixToSheet.get("");
        }
        return this.postfixToSheet.get(postfix);
    }

    public Texture getTex(String postfix) {
        if (this.closed) {
            throw new RuntimeException("Attempting to access closed sheet.");
        }
        if (this.bump == null || this.isFragments) {
            return this.postfixToTex.get("");
        }
        if (!this.postfixToTex.containsKey(postfix)) {
            System.out.println("Cannot find postfix " + postfix + " for " + this.name + ".");
            return this.postfixToTex.get("");
        }
        return this.postfixToTex.get(postfix);
    }

    public SpritesheetBundle(JSONObject o) {
        super(o.getString("name"));
        this.bump = o.optString("bump", null);
        this.fragments = o.optString("fragments", null);
        if (this.bump != null && this.fragments != null) {
            this.damagedVersion = new SpritesheetBundle(this.name + "DAMAGED", this.bump + "DAMAGED");
            this.fragmentsSheet = new SpritesheetBundle(this.name + "FRAGMENTS", this.bump + "FRAGMENTS");
        } else {
            this.damagedVersion = null;
            this.fragmentsSheet = null;
        }
    }

    public void initBumps() {
        if (this.bump != null && this.bumpTex == null) {
            this.bumpTex = SpriteUtils.loadTexture(this.bump);
            if (this.bumpTex != null) {
                this.bumpTex.setTextureFilter(9728);
            }
        }
        if (this.damagedVersion != null) {
            this.damagedVersion.initBumps();
        }
        if (this.fragmentsSheet != null) {
            this.fragmentsSheet.initBumps();
        }
    }

    private SpritesheetBundle(String name, String bump) {
        super(name);
        this.bump = bump;
        this.fragments = null;
        this.damagedVersion = null;
        this.fragmentsSheet = null;
    }

    public void loadPostfix(String postfix) {
        if ((this.bump != null || postfix.equals("")) && !this.postfixToSheet.containsKey(postfix)) {
            Image sh = SpriteUtils.loadImage(this.name + postfix);
            if (sh == null) {
                System.err.println("No spritesheet \"" + this.name + postfix + "\" available.");
            } else {
                sh.setFilter(9728);
                this.postfixToSheet.put(postfix, sh);
                this.postfixToTex.put(postfix, sh.getTexture());
            }
        }
        if (this.damagedVersion != null && !postfix.equals("BLUEPRINT")) {
            this.damagedVersion.loadPostfix(postfix);
        }
        if (this.fragmentsSheet != null && postfix.equals("")) {
            this.fragmentsSheet.loadPostfix(postfix);
        }
        if (!postfix.equals("")) {
            this.loadPostfix("");
        }
    }

    public static SpritesheetBundle ofName(String name) {
        return Loadable.ofName(SpritesheetBundle.class, name);
    }

    public SpritesheetBundle getDamagedVersion() {
        if (this.damagedVersion != null) {
            this.damagedVersion.isDamaged = true;
        }
        return this.damagedVersion;
    }

    public SpritesheetBundle getFragmentsSheet() {
        if (this.fragmentsSheet != null) {
            this.fragmentsSheet.isFragments = true;
        }
        return this.fragmentsSheet;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        for (Texture texture : this.postfixToTex.values()) {
            texture.release();
        }
        for (Image image : this.postfixToSheet.values()) {
            try {
                image.destroy();
            }
            catch (Exception exception) {}
        }
        this.postfixToTex.clear();
        this.postfixToSheet.clear();
        if (this.bumpTex != null) {
            this.bumpTex.release();
            this.bumpTex = null;
        }
        if (this.damagedVersion != null) {
            this.damagedVersion.close();
        }
        if (this.fragmentsSheet != null) {
            this.fragmentsSheet.close();
        }
        this.closed = true;
    }
}

