/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Mod;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import javax.imageio.ImageIO;
import org.newdawn.slick.Image;
import org.newdawn.slick.opengl.ImageData;
import org.newdawn.slick.opengl.Texture;

public strictfp class SpriteUtils {
    private static int ctr = 1;
    private static final HashMap<String, ImageEntry> cachedImages = new HashMap();
    private static final String[] DO_NOT_CACHE = new String[]{"BLUEPRINT", "NIGHT", "DAWN", "DUSK", "SNOW", "RAIN", "FOG", "STORM"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage loadBufferedImage(String name) {
        if (!name.endsWith(".jpg") && !name.endsWith(".png")) {
            name = name + ".png";
        }
        for (Mod m : Mod.getEnabledMods()) {
            File f = new File(new File(m.dir, "images"), name);
            if (!f.exists()) continue;
            try {
                return ImageIO.read(f);
            }
            catch (Exception exception) {
            }
        }
        File f = new File(new File(new File(AGame.getStaticGameDirectory(), "data"), "images"), name);
        if (f.exists()) {
            FileInputStream fis = null;
            try {
                BufferedImage bufferedImage = ImageIO.read(f);
                return bufferedImage;
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    fis.close();
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    public static void ensureTexFilesInGeneratedDirectory(File imagesDirectory) {
        File generatedDirectory = new File(imagesDirectory.getAbsoluteFile().getParentFile(), "generated");
        File[] fs = imagesDirectory.listFiles();
        if (fs != null) {
            for (File f : fs) {
                if (!f.getName().endsWith(".tex")) continue;
                generatedDirectory.mkdirs();
                File f2 = new File(generatedDirectory, f.getName());
                if (f2.exists()) {
                    f.delete();
                    continue;
                }
                f.renameTo(f2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Image loadImageFromFile(String name, ImageEntry existingEntry, File f) {
        File f2 = new File(new File(f.getParentFile().getParentFile(), "generated"), f.getName() + ".tex");
        if (f2.exists() && f2.lastModified() >= f.lastModified()) {
            if (existingEntry != null && existingEntry.modification == f2.lastModified() && !existingEntry.image.isDestroyed() && existingEntry.image.getTexture().getTextureID() != 0) {
                return existingEntry.image;
            }
            try {
                FileChannel inChannel = new RandomAccessFile(f2, "r").getChannel();
                MappedByteBuffer buf = inChannel.map(FileChannel.MapMode.READ_ONLY, 0L, inChannel.size());
                buf.load();
                Image img = new Image((ImageData)new ChanneledImageData(buf));
                inChannel.close();
                if (existingEntry != null) {
                    try {
                        existingEntry.image.destroy();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                cachedImages.put(name, new ImageEntry(img, f.lastModified()));
                return img;
            }
            catch (Exception e) {
                System.err.println("Failed to load cached image " + name + " from file " + f2.getAbsolutePath());
                e.printStackTrace();
            }
        }
        if (f.exists()) {
            if (existingEntry != null && existingEntry.modification == f.lastModified() && !existingEntry.image.isDestroyed() && existingEntry.image.getTexture().getTextureID() != 0) {
                return existingEntry.image;
            }
            FileInputStream fis = null;
            Image img = null;
            try {
                fis = new FileInputStream(f);
                img = new Image((InputStream)fis, name + ctr++, false);
            }
            catch (Exception e) {
                System.err.println("Failed to load PNG image " + name + " from file " + f.getAbsolutePath());
            }
            finally {
                try {
                    fis.close();
                }
                catch (Exception e) {}
            }
            if (img != null) {
                if (existingEntry != null) {
                    try {
                        existingEntry.image.destroy();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                cachedImages.put(name, new ImageEntry(img, f.lastModified()));
                if (SpriteUtils.doCacheRaw(name, img)) {
                    try {
                        f2.getParentFile().mkdirs();
                        FileOutputStream fos = new FileOutputStream(f2);
                        fos.write(img.getTexture().getTextureData());
                        fos.flush();
                        fos.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return img;
            }
        }
        return null;
    }

    private static boolean doCacheRaw(String name, Image img) {
        if (name.endsWith(".jpg")) {
            return false;
        }
        for (String dnc : DO_NOT_CACHE) {
            if (!name.contains(dnc)) continue;
            return false;
        }
        return img.getWidth() == 1024 && img.getHeight() == 1024;
    }

    public static Image loadImage(String name) {
        ImageEntry existingEntry;
        if (!name.endsWith(".jpg") && !name.endsWith(".png")) {
            name = name + ".png";
        }
        if ((existingEntry = cachedImages.get(name)) != null && (existingEntry.image.isDestroyed() || existingEntry.image.getTexture().getTextureID() == 0)) {
            try {
                existingEntry.image.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
            cachedImages.remove(name);
            existingEntry = null;
        }
        for (Mod m : Mod.getEnabledMods()) {
            File f = new File(new File(m.dir, "images"), name);
            Image img = SpriteUtils.loadImageFromFile(name, existingEntry, f);
            if (img != null) {
                return img;
            }
            f = new File(new File(m.dir, "generated"), name);
            img = SpriteUtils.loadImageFromFile(name, existingEntry, f);
            if (img == null) continue;
            return img;
        }
        File f = new File(new File(new File(AGame.getStaticGameDirectory(), "data"), "images"), name);
        Image img = SpriteUtils.loadImageFromFile(name, existingEntry, f);
        if (img != null) {
            return img;
        }
        return null;
    }

    public static String loadImageReport(String name) {
        if (!name.endsWith(".jpg") && !name.endsWith(".png")) {
            name = name + ".png";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(name).append("\n");
        if (cachedImages.containsKey(name)) {
            sb.append("cached\n");
        }
        for (Mod m : Mod.getEnabledMods()) {
            File f = new File(new File(m.dir, "images"), name);
            sb.append(f.getAbsolutePath()).append(f.exists() ? " exists\n" : "\n");
            f = new File(new File(m.dir, "generated"), name);
            sb.append(f.getAbsolutePath()).append(f.exists() ? " exists\n" : "\n");
        }
        File f = new File(new File(new File(AGame.getStaticGameDirectory(), "data"), "images"), name);
        sb.append(f.getAbsolutePath()).append(f.exists() ? " exists" : "");
        return sb.toString();
    }

    public static Texture loadTexture(String name) {
        Image img = SpriteUtils.loadImage(name);
        if (img == null) {
            return null;
        }
        return img.getTexture();
    }

    private strictfp static class ChanneledImageData
    implements ImageData {
        private final ByteBuffer buf;

        public ChanneledImageData(ByteBuffer buf) {
            this.buf = buf;
        }

        public ImageData.Format getFormat() {
            return ImageData.Format.RGBA;
        }

        public int getWidth() {
            return 1024;
        }

        public int getHeight() {
            return 1024;
        }

        public int getTexWidth() {
            return 1024;
        }

        public int getTexHeight() {
            return 1024;
        }

        public ByteBuffer getImageBufferData() {
            return this.buf;
        }
    }

    private strictfp static class ImageEntry {
        public final Image image;
        public final long modification;

        public ImageEntry(Image image, long modification) {
            this.image = image;
            this.modification = modification;
        }
    }
}

