/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.LandFormation;

public strictfp class Spring {
    private static final double NO = 1000000.0;
    public final double xOffset;
    public final int baseLength;
    public final int minCompressedLength;
    public final double k;
    public final double xFriction;
    public final double yFriction;

    public Spring(double xOffset, int length, int minCompressedLength, double k, double xFriction, double yFriction) {
        this.xOffset = xOffset;
        this.baseLength = length;
        this.minCompressedLength = minCompressedLength;
        this.k = k;
        this.xFriction = xFriction;
        this.yFriction = yFriction;
    }

    public double getMaxForce() {
        return (double)(this.baseLength - this.minCompressedLength) * this.k;
    }

    public double getForce(double l, double currentLength) {
        return (currentLength - l) * this.k;
    }

    public double getForce(double l) {
        return ((double)this.baseLength - StrictMath.max((double)this.minCompressedLength, l)) * this.k;
    }

    public double getLength(double x, double y, Combat c, Airship myShip) {
        return this.getLength(x, y, c, this.xOffset, myShip);
    }

    public double getLength(double x, double y, Combat c, double xOffset, Airship myShip) {
        double l = this.baseLength;
        x += xOffset * 16.0;
        for (LandFormation lf : c.landFormations) {
            l = StrictMath.min(l, Spring.lengthTo(lf, x, y));
        }
        for (Combat.Side s : c.sides) {
            for (Airship ship : s.ships) {
                if (ship == myShip) continue;
                l = StrictMath.min(l, Spring.lengthTo(ship, x, y));
            }
        }
        return l;
    }

    public static double lengthTo(LandFormation lf, double x, double y) {
        int xIndex = (int)StrictMath.floor(x - lf.getX()) / 16;
        if (xIndex < 0 || xIndex >= lf.grid[0].length) {
            return 1000000.0;
        }
        int yIndex = StrictMath.max(0, (int)StrictMath.floor(y - lf.getY()) / 16);
        if (yIndex >= lf.grid.length) {
            return 1000000.0;
        }
        for (int y2 = yIndex; y2 < lf.grid.length; ++y2) {
            if (!lf.grid[y2][xIndex].solid) continue;
            return lf.getY() + (double)(y2 * 16) - y;
        }
        System.err.println("Failure to crop LF?");
        return 1000000.0;
    }

    public static double lengthTo(Airship ship, double x, double y) {
        int xIndex = (int)StrictMath.floor(x - ship.getX()) / 16;
        if (ship.flipped) {
            xIndex = ship.getWidth() - 1 - xIndex;
        }
        if (xIndex < 0 || xIndex >= ship.getWidth()) {
            return 1000000.0;
        }
        int yIndex = (int)StrictMath.floor(y - ship.getY()) / 16;
        if (yIndex >= ship.getHeight()) {
            return 1000000.0;
        }
        for (int y2 = yIndex; y2 < ship.getHeight(); ++y2) {
            if (ship.tileAt(xIndex, y2) == null) continue;
            return ship.getY() + (double)(y2 * 16) - y;
        }
        return 1000000.0;
    }
}

