/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.Lang;
import java.util.Locale;

public enum SimplePref {
    SIDE_BUMP_TO_SCROLL(false),
    SYSTEM_CURSOR(false),
    WINDOW_BORDER(true),
    SCREEN_SHAKE(true),
    VLAMBEER_MODE(false),
    REDUCED_FLASHING(false),
    EDITOR_TOOLS(false),
    SEND_ANALYTICS(true);

    public final boolean def;
    private boolean cachedValue;
    private boolean valueLoaded;

    private SimplePref(boolean def) {
        this.def = def;
    }

    public boolean get() {
        if (!this.valueLoaded) {
            this.load();
        }
        return this.cachedValue;
    }

    public void set(boolean value) {
        this.cachedValue = value;
    }

    public void onToggle() {
    }

    public void save() {
        boolean oldValue = AirshipGame.PREFS.getBoolean(this.getKey(), this.def);
        AirshipGame.PREFS.putBoolean(this.getKey(), this.cachedValue);
        if (oldValue != this.cachedValue) {
            this.onToggle();
        }
    }

    public void load() {
        this.cachedValue = AirshipGame.PREFS.getBoolean(this.getKey(), this.def);
        this.valueLoaded = true;
    }

    public String getName() {
        return Lang._t("pref_" + this.name(), new Object[0]);
    }

    public String getTooltip() {
        return Lang._t("pref_tooltip_" + this.name(), new Object[0]);
    }

    public String getKey() {
        return this.name().toLowerCase(Locale.ENGLISH);
    }
}

