/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.Rect2D;
import com.zarkonnen.airships.RotatingShader;
import com.zarkonnen.airships.Shot;
import com.zarkonnen.airships.SpritesheetBundle;
import com.zarkonnen.airships.TimeOfDay;
import com.zarkonnen.airships.Trail;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.airships.WeaponAppearance;
import com.zarkonnen.catengine.Img;
import com.zarkonnen.catengine.Input;
import java.util.HashSet;
import org.newdawn.slick.Color;
import org.newdawn.slick.Graphics;

public strictfp class ShotVisualLayer
implements UniScreen.VisualLayer {
    private final HashSet<SpritesheetBundle> additionalSSBs = new HashSet();

    @Override
    public void tick(Input in, int ms, UniScreen us) {
    }

    @Override
    public void draw(MyDraw d, UniScreen us, double cropX, double cropY, double cropW, double cropH) {
        if (us.combat == null) {
            return;
        }
        TimeOfDay tod = us.getTimeOfDay();
        Graphics g = (Graphics)d.frame().nativeRenderer();
        float ambient = us.getTimeOfDay().ambientAmt;
        g.setColor(new Color(255, 255, 255, (int)(10.0f + 40.0f * ambient)));
        for (Trail t : us.combat.trails) {
            double trailHeight;
            double trailWidth;
            double trailTop;
            double shotX = t.shot.sX + (t.shot.tX - t.shot.sX) * (double)t.shot.time / (double)t.shot.travelTime;
            double shotY = t.shot.sY + (t.shot.tY - t.shot.sY) * (double)t.shot.time / (double)t.shot.travelTime;
            double trailLeft = StrictMath.min(shotX, t.shot.sX);
            if (!Rect2D.intersects(cropX, cropY, cropW, cropH, trailLeft, trailTop = StrictMath.min(shotY, t.shot.sY), trailWidth = StrictMath.max(shotX, t.shot.sX) - trailLeft, trailHeight = StrictMath.max(shotY, t.shot.sY) - trailTop)) continue;
            g.setLineWidth((float)(t.baseWidth * (1.0 - (double)t.age * 1.0 / 500.0)));
            g.drawLine((float)t.shot.sX, (float)t.shot.sY, (float)shotX, (float)shotY);
        }
        g.setLineWidth(1.0f);
        SpritesheetBundle baseSSB = SpritesheetBundle.ofName("spritesheet");
        this.additionalSSBs.clear();
        RotatingShader.lockShader(baseSSB, d, us.lightingMap, tod.lightStrength, tod.ambient, tod.ambientSaturation);
        for (Shot s : us.combat.shots) {
            Img img = null;
            if (s.weaponType != null) {
                WeaponAppearance wapp = s.weaponType.weaponAppearance(s.weaponBonuses);
                Img[] imgs = wapp.shot;
                if (imgs == null) continue;
                img = imgs[s.time / wapp.shotAnimationInterval % imgs.length];
            } else if (s.shooterType != null) {
                img = s.shooterType.shot;
            }
            if (img == null || img.srcWidth == 0 || img.srcHeight == 0) continue;
            if (!img.src.equals(baseSSB.name)) {
                this.additionalSSBs.add(SpritesheetBundle.ofName(img.src));
                continue;
            }
            double sx = s.sX + (s.tX - s.sX) * (double)s.time / (double)s.travelTime - (double)(img.srcWidth / 2);
            double sy = s.sY + (s.tY - s.sY) * (double)s.time / (double)s.travelTime - (double)(img.srcHeight / 2);
            double sAngle = StrictMath.atan2(s.tY - s.sY, s.tX - s.sX);
            RotatingShader.draw(img, d, sx, sy, sAngle, false, us.lightingMap, tod.lightStrength, tod.ambient, tod.ambientSaturation, tod.ambientTint);
        }
        RotatingShader.unlockShader();
        for (SpritesheetBundle ssb : this.additionalSSBs) {
            RotatingShader.lockShader(ssb, d, us.lightingMap, tod.lightStrength, tod.ambient, tod.ambientSaturation);
            for (Shot s : us.combat.shots) {
                Img img = null;
                if (s.weaponType != null) {
                    WeaponAppearance wapp = s.weaponType.weaponAppearance(s.weaponBonuses);
                    Img[] imgs = wapp.shot;
                    if (imgs == null) continue;
                    img = imgs[s.time / wapp.shotAnimationInterval % imgs.length];
                } else if (s.shooterType != null) {
                    img = s.shooterType.shot;
                }
                if (img == null || img.srcWidth == 0 || img.srcHeight == 0 || !img.src.equals(ssb.name)) continue;
                double sx = s.sX + (s.tX - s.sX) * (double)s.time / (double)s.travelTime - (double)(img.srcWidth / 2);
                double sy = s.sY + (s.tY - s.sY) * (double)s.time / (double)s.travelTime - (double)(img.srcHeight / 2);
                double sAngle = StrictMath.atan2(s.tY - s.sY, s.tX - s.sX);
                RotatingShader.draw(img, d, sx, sy, sAngle, false, us.lightingMap, tod.lightStrength, tod.ambient, tod.ambientSaturation, tod.ambientTint);
            }
            RotatingShader.unlockShader();
        }
    }
}

