/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.ArmourType;
import com.zarkonnen.airships.BonusSet;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.ConstructionBackend;
import com.zarkonnen.airships.CrewType;
import com.zarkonnen.airships.Fleet;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.Loadable;
import com.zarkonnen.airships.Module;
import com.zarkonnen.airships.ModuleType;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.ShipHelperWidget;
import com.zarkonnen.airships.ShipType;
import com.zarkonnen.airships.Tile;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.util.Utils;
import java.util.ArrayList;

public strictfp class ShipEditorUtils {
    public static final int MAX_COST = 20000;
    public static final int MAX_CREW = 120;
    public static final int STAT_LINES = 12;

    public static ArrayList<Utils.Pair<String, String>> getStats(Airship ship, int budget, Airship original) {
        ArrayList<Utils.Pair<String, String>> l = new ArrayList<Utils.Pair<String, String>>();
        int cost = original == null ? ship.getCost() : ship.getRefitCostFrom(original);
        String costName = original == null ? "Cost_" : "Rebuild_cost_";
        String maxCostInfo = "";
        if ((double)ship.getCost() > 16000.0) {
            maxCostInfo = " [ffce6d](" + Lang._t("max", new Object[0]) + " " + 20000 + ")";
        }
        if (budget > 0) {
            l.add(Utils.p((Object)costName, (Object)((cost > budget ? MyDraw.ERROR_C : "") + "$" + cost + " / " + budget + maxCostInfo)));
        } else {
            l.add(Utils.p((Object)costName, (Object)("$" + cost + "[]" + maxCostInfo)));
        }
        l.add(Utils.p((Object)"Maintenance_", (Object)("$" + ship.maintenanceCost())));
        if (ship.type.mobile) {
            if (ship.type.onGround) {
                l.add(Utils.p((Object)"Weight_", (Object)((ship.maxCarryWeight() < ship.getWeight() ? MyDraw.ERROR_C : "") + ship.getWeight() + "/" + ship.maxCarryWeight())));
            } else {
                l.add(Utils.p((Object)"Service_ceiling_", (Object)((ship.realServiceCeiling() <= 0 ? MyDraw.ERROR_C : "") + ship.realServiceCeiling() / 7 + "m")));
            }
            l.add(Utils.p((Object)"Speed_", (Object)("" + (int)StrictMath.ceil(ship.getMainMapSpeed() * 3600.0 / 7.0) + Lang._t("kmperhour", new Object[0]))));
        }
        int n = ship.getQuartered(CrewType.onlyWorkers);
        String maxCrewMsg = "";
        if ((double)n > 96.0) {
            maxCrewMsg = " [ffce6d](" + Lang._t("max", new Object[0]) + " " + 120 + ")";
        }
        int m = ship.getRequiredCrew();
        l.add(Utils.p((Object)"Crew_", (Object)((n < m ? MyDraw.ERROR_C : "") + n + maxCrewMsg)));
        if (n < m) {
            l.add(Utils.p((Object)"Min_crew_", (Object)("" + m)));
        } else {
            l.add(Utils.p((Object)"Recommended_crew_", (Object)("" + ship.getRecommendedCrew())));
        }
        l.add(Utils.p((Object)"Coal_", (Object)("" + ship.getCoalCapacity())));
        l.add(Utils.p((Object)"Ammo_", (Object)("" + ship.getAmmoCapacity())));
        l.add(Utils.p((Object)"Water_", (Object)("" + ship.getWaterCapacity())));
        l.add(Utils.p((Object)"Repair_supplies_", (Object)("" + ship.getRepairCapacity())));
        l.add(Utils.p((Object)"Supply_", (Object)((ship.getSupplyRequired() > ship.getSupplyProvided() ? MyDraw.ERROR_C : "") + ship.getSupplyRequired() + "/" + ship.getSupplyProvided())));
        if (ship.commandPointsGenerated() == 0) {
            l.add(Utils.p((Object)"Cannot_issue_commands", (Object)""));
        } else {
            l.add((Utils.Pair<String, String>)Utils.p((Object)"Can_issue_a_command_every_", (Object)("" + ship.commandPointsRequired() / ship.commandPointsGenerated() / 1000 + " " + Lang._t("seconds", new Object[0]))));
        }
        return l;
    }

    public static boolean isModuleAFixer(Airship ship, ModuleType type, BonusSet bonuses) {
        if (ship.modules.isEmpty()) {
            return false;
        }
        if (type.getCommand(ship.constructionBonuses) > 0 && ship.commandPointsGenerated() == 0) {
            return true;
        }
        if (type == ModuleType.ofName("CORRIDOR") && !ship.isPathingFullyConnected()) {
            return true;
        }
        if (!ship.type.onGround && type.getLift(bonuses) > 0 && ship.realServiceCeiling() <= 0) {
            return true;
        }
        if (ship.type.mobile && type.getPropulsion(ship.currentBonuses) > 0.0 && ship.getSpeed() == 0.0) {
            return true;
        }
        if (type.getCoal(ship.currentBonuses) > 0 && ship.getCoalCapacity() == 0 && ship.requiresCoal()) {
            return true;
        }
        if (type.getAmmo(ship.currentBonuses) > 0 && ship.requiresAmmo() && ship.getAmmoCapacity() == 0) {
            return true;
        }
        if (type.getQuarters(ship.currentBonuses) > 0 && ship.getQuartered(CrewType.onlyWorkers) < ship.getRequiredCrew() && CrewType.onlyWorkers.contains(type.getQuartersType(ship.currentBonuses))) {
            return true;
        }
        return type.getSupplyProvided(ship.currentBonuses) > 0 && ship.getSupplyProvided() < ship.getSupplyRequired();
    }

    public static boolean checkForOverlaps(Airship ship, UniScreen us) {
        if (us.city != null) {
            for (Airship s : us.city.getDefences()) {
                if (s == ship || !s.overlapsWith(ship)) continue;
                return true;
            }
            Fleet gar = us.wm.getGarrison(us.city);
            if (gar != null) {
                for (Airship s : gar.actives) {
                    if (s == ship || !s.overlapsWith(ship)) continue;
                    return true;
                }
            }
            if (ship.overlapsWith(us.city.ground, false)) {
                return true;
            }
        }
        if (us.combat != null) {
            for (Combat.Side side : us.combat.sides) {
                for (Airship s : side.ships) {
                    if (s == ship || !s.overlapsWith(ship)) continue;
                    return true;
                }
            }
            if (ship.overlapsWith(us.combat.landFormations.get(0), false)) {
                return true;
            }
        }
        if (us.setupFleet != null) {
            for (Airship s : us.setupFleet) {
                if (s == ship || !s.overlapsWith(ship)) continue;
                return true;
            }
            if (us.setupGround != null && ship.overlapsWith(us.setupGround, false)) {
                return true;
            }
        }
        return false;
    }

    public static ArrayList<String> shipWarnings(Airship ship) {
        ArrayList<String> ws = new ArrayList<String>();
        if (ship.commandPointsGenerated() == 0 && !ship.modules.isEmpty()) {
            ws.add(Lang._t("Cannot_give_commands_to_" + ship.type.name(), new Object[0]));
        }
        if (!ship.type.onGround && ship.realServiceCeiling() < 112 && ship.realServiceCeiling() > 0) {
            ws.add(Lang._t("Ship_service_ceiling_low", new Object[0]));
        }
        if (ship.type.mobile && ship.type.onGround && ship.getWeight() > ship.optimalCarryWeight()) {
            ws.add(Lang._t("The_ship_is_heavy", new Object[0]));
        }
        if (ship.getStructuralStressHPMultiplier() < 1.0) {
            if (ship.getStructuralStressHPMultiplier() < 0.75) {
                if (ship.getStructuralStressHPMultiplier() < 0.4) {
                    ws.add(Lang._t("Ship_structural_integrity_super_low", new Object[0]));
                } else {
                    ws.add(Lang._t("Ship_structural_integrity_very_low", new Object[0]));
                }
            } else {
                ws.add(Lang._t("Ship_structural_integrity_low", new Object[0]));
            }
        }
        return ws;
    }

    public static ArrayList<String> shipErrors(Airship ship, boolean checkBudget, boolean checkBonuses, int budget, BonusSet bonuses, Airship original, UniScreen checkForOverlaps) {
        ArrayList<String> es = new ArrayList<String>();
        if (ship.modules.isEmpty()) {
            es.add(Lang._t("edit_get_started", new Object[0]));
            return es;
        }
        if (checkForOverlaps != null && ShipEditorUtils.checkForOverlaps(ship, checkForOverlaps)) {
            es.add(Lang._t("The_" + ship.type.name() + "_cannot_be_placed_here", new Object[0]));
        }
        if (!ship.isFullyConnected()) {
            es.add(Lang._t("disconnected_" + ship.type.name(), new Object[0]));
        } else if (!ship.isPathingFullyConnected()) {
            es.add(Lang._t("inaccessible_" + ship.type.name(), new Object[0]));
        }
        if (!ship.type.onGround && ship.realServiceCeiling() <= 0) {
            es.add(Lang._t("The_ship_is_too_heavy_to_fly", new Object[0]));
        }
        if (ship.type.mobile) {
            if (ship.getSpeed() == 0.0) {
                es.add(Lang._t("The_ship_has_no_propulsion", new Object[0]));
            }
            if (ship.type.onGround && ship.getWeight() > ship.maxCarryWeight()) {
                es.add(Lang._t("The_ship_is_too_heavy", new Object[0]));
            }
        }
        if (ship.getCoalCapacity() == 0 && ship.requiresCoal()) {
            es.add(Lang._t("The_ship_has_no_coal", new Object[0]));
        }
        if (!ship.type.mobile) {
            int baseWidth = 0;
            for (int tx = 0; tx < ship.getWidth(); ++tx) {
                if (ship.tileAt(tx, ship.getHeight() - 1) == null) continue;
                ++baseWidth;
            }
            double dmg = 2.56E-4 * (double)(ship.getCollisionMass() + 5000) * 0.8 / (double)baseWidth - 1.0;
            if (dmg >= 0.3) {
                es.add(Lang._t("collapse_warning", new Object[0]));
            }
        }
        if (ship.requiresAmmo() && ship.getAmmoCapacity() == 0) {
            es.add(Lang._t("The_" + ship.type.name() + "_has_no_ammunition", new Object[0]));
        }
        if (ship.getRequiredCrew() > 0 && ship.getQuartered(CrewType.onlyWorkers) == 0) {
            es.add(Lang._t("The_" + ship.type.name() + "_has_no_crew", new Object[0]));
        } else if (ship.getQuartered(CrewType.onlyWorkers) < ship.getRequiredCrew()) {
            es.add(Lang._t("The_" + ship.type.name() + "_has_insufficient_crew", new Object[0]));
        }
        if (ship.getSupplyProvided() < ship.getSupplyRequired()) {
            es.add(Lang._t("The_" + ship.type.name() + "_needs_more_supply_hatches", new Object[0]));
        }
        if (checkBudget) {
            if (original == null) {
                if (ship.getCost() > budget) {
                    es.add(Lang._t("Insufficient_funds_to_build_this_" + ship.type.name(), new Object[0]));
                }
            } else if (ship.getRefitCostFrom(original) > budget) {
                es.add(Lang._t("Insufficient_funds_to_refit_this_" + ship.type.name(), new Object[0]));
            }
        }
        if (checkBonuses) {
            block1: for (ModuleType mt : Loadable.all(ModuleType.class)) {
                if (mt.getRequired() == null || bonuses.contains[mt.getRequired().ordinal()]) continue;
                for (Module m : ship.modules) {
                    if (m.type != mt) continue;
                    es.add(Lang._t("x_is_not_available", mt.getName()));
                    continue block1;
                }
            }
            block3: for (ArmourType at : Loadable.all(ArmourType.class)) {
                if (at.required == null || bonuses.contains[at.required.ordinal()]) continue;
                for (Tile t : ship.tiles) {
                    if (t.armour.type != at) continue;
                    es.add(Lang._t("x_is_not_available", at.getName()));
                    continue block3;
                }
            }
        }
        return es;
    }

    public static ConstructionBackend shipsList(ShipType st, ShipHelperWidget shw) {
        return new ConstructionBackend(st, shw);
    }
}

