/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Perlin;
import com.zarkonnen.airships.Road;
import com.zarkonnen.catengine.util.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import org.lwjgl.opengl.GL11;
import org.newdawn.slick.geom.Polygon;
import org.newdawn.slick.geom.Triangulator;

public strictfp class ShapeUtils {
    public static final int MAX_INFLUENCE_DIST = 3;
    public static final int MAX_ROAD_INFLUENCE_DIST = 3;
    public static final int RIGHT = 0;
    public static final int DOWN = 1;
    public static final int LEFT = 2;
    public static final int UP = 3;
    public static final int[][] WALL_DELTAS = new int[][]{{0, 0}, {-1, 0}, {-1, -1}, {0, -1}};
    public static final int[][] MOVE_DELTAS = new int[][]{{1, 0}, {0, 1}, {-1, 0}, {0, -1}};

    public static void smooth(ArrayList<Area> areas, ArrayList<P> allPoints, int maxInfluenceDist) {
        for (P p : allPoints) {
            double xAccum = 0.0;
            double yAccum = 0.0;
            double totalWeight = 0.0;
            for (Area a : p.areas) {
                int pIndex = a.points.indexOf(p);
                if (pIndex == -1) {
                    throw new RuntimeException("Point claims to be in area it's not in.");
                }
                int aSize = a.points.size();
                for (int i = pIndex - maxInfluenceDist; i < pIndex + maxInfluenceDist + 1; ++i) {
                    int index = (i + aSize) % aSize;
                    int dist = StrictMath.min(StrictMath.abs(pIndex + aSize - index) % aSize, StrictMath.abs(index + aSize - pIndex) % aSize);
                    double weight = 1.0 / (double)(dist * dist + 1);
                    xAccum += a.points.get((int)index).x * weight;
                    yAccum += a.points.get((int)index).y * weight;
                    totalWeight += weight;
                }
            }
            p.x = xAccum / totalWeight;
            p.y = yAccum / totalWeight;
        }
    }

    public static void perturb(ArrayList<P> ps) {
        Perlin perlin = new Perlin();
        for (int i = 0; i < ps.size(); ++i) {
            P p = ps.get(i);
            p.x += perlin.pnoise(p.x, p.y, 77.0) * 1.5;
            p.y += perlin.pnoise(p.x + 22.0, p.y + 903.0, 304.0) * 1.5;
        }
    }

    public static Utils.Pair<ArrayList<Area>, ArrayList<Area>> allAreas(boolean[][] water, int[][] cityOwnership) {
        Utils.Pair areas = new Utils.Pair(new ArrayList(), new ArrayList());
        ArrayList<P> allPoints = new ArrayList<P>();
        HashMap<IntP, P> canonicalPs = new HashMap<IntP, P>();
        ShapeUtils.landBoundaryAreas(water, canonicalPs, allPoints, (ArrayList)areas.a);
        ShapeUtils.cityOwnershipAreas(cityOwnership, canonicalPs, allPoints, (ArrayList)areas.b);
        ArrayList<Area> all = new ArrayList<Area>();
        all.addAll((Collection)areas.a);
        all.addAll((Collection)areas.b);
        ShapeUtils.smooth(all, allPoints, 3);
        ShapeUtils.perturb(allPoints);
        ShapeUtils.smooth(all, allPoints, 3);
        return areas;
    }

    public static void landBoundaryAreas(boolean[][] water, HashMap<IntP, P> canonicalPs, ArrayList<P> allPoints, ArrayList<Area> areas) {
        byte[][] visited = new byte[water.length][water[0].length];
        LinkedList<int[]> q = new LinkedList<int[]>();
        byte id = 0;
        for (int y = 0; y < water.length; ++y) {
            for (int x = 0; x < water[0].length; ++x) {
                if (water[y][x] || visited[y][x] != 0) continue;
                visited[y][x] = id = (byte)((byte)(id + 1));
                q.add(new int[]{x, y});
                while (!q.isEmpty()) {
                    int[] xy = (int[])q.pop();
                    int qx = xy[0];
                    int qy = xy[1];
                    for (int dy = -1; dy < 2; ++dy) {
                        if (qy + dy < 0 || qy + dy >= water.length) continue;
                        for (int dx = -1; dx < 2; ++dx) {
                            if (dx != 0 && dy != 0 || qx + dx < 0 || qx + dx >= water[0].length || water[qy + dy][qx + dx] || visited[qy + dy][qx + dx] != 0) continue;
                            visited[qy + dy][qx + dx] = id;
                            q.add(new int[]{qx + dx, qy + dy});
                        }
                    }
                }
                Area area = new Area(-1);
                int xPos = x;
                int yPos = y;
                int dir = 0;
                do {
                    IntP ip;
                    P p;
                    if ((p = canonicalPs.get(ip = new IntP(xPos, yPos))) == null) {
                        p = new P(xPos, yPos);
                        allPoints.add(p);
                        canonicalPs.put(ip, p);
                    }
                    p.areas.add(area);
                    area.points.add(p);
                    boolean found = false;
                    for (int dirDelta = -1; dirDelta < 2; ++dirDelta) {
                        int lookDir = (dir + dirDelta + 4) % 4;
                        int lookX = xPos + WALL_DELTAS[lookDir][0];
                        int lookY = yPos + WALL_DELTAS[lookDir][1];
                        if (lookY < 0 || lookY >= water.length || lookX < 0 || lookX >= water[0].length || visited[lookY][lookX] != id) continue;
                        xPos += MOVE_DELTAS[lookDir][0];
                        yPos += MOVE_DELTAS[lookDir][1];
                        dir = lookDir;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    throw new RuntimeException("Got lost!");
                } while (xPos != x || yPos != y);
                areas.add(area);
            }
        }
    }

    public static void cityOwnershipAreas(int[][] cityOwnership, HashMap<IntP, P> canonicalPs, ArrayList<P> allPoints, ArrayList<Area> areas) {
        int visitingCity = -1;
        boolean progress = true;
        while (progress) {
            progress = false;
            for (int y = 0; y < cityOwnership.length; ++y) {
                for (int x = 0; x < cityOwnership[0].length; ++x) {
                    if (cityOwnership[y][x] != visitingCity + 1) continue;
                    progress = true;
                    Area area = new Area(++visitingCity);
                    int xPos = x;
                    int yPos = y;
                    int dir = 0;
                    do {
                        IntP ip;
                        P p;
                        if ((p = canonicalPs.get(ip = new IntP(xPos, yPos))) == null) {
                            p = new P(xPos, yPos);
                            allPoints.add(p);
                            canonicalPs.put(ip, p);
                        }
                        if (!p.areas.contains(area)) {
                            p.areas.add(area);
                            area.points.add(p);
                        }
                        boolean found = false;
                        for (int dirDelta = -1; dirDelta < 2; ++dirDelta) {
                            int lookDir = (dir + dirDelta + 4) % 4;
                            int lookX = xPos + WALL_DELTAS[lookDir][0];
                            int lookY = yPos + WALL_DELTAS[lookDir][1];
                            if (lookY < 0 || lookY >= cityOwnership.length || lookX < 0 || lookX >= cityOwnership[0].length || cityOwnership[lookY][lookX] != visitingCity) continue;
                            xPos += MOVE_DELTAS[lookDir][0];
                            yPos += MOVE_DELTAS[lookDir][1];
                            dir = lookDir;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        throw new RuntimeException("Got lost!");
                    } while (xPos != x || yPos != y);
                    areas.add(area);
                }
            }
        }
    }

    public static void smoothRoads(ArrayList<Road> roads) {
        for (Road r : roads) {
            for (int pIndex = 0; pIndex < r.path.size(); ++pIndex) {
                double xAccum = 0.0;
                double yAccum = 0.0;
                double totalWeight = 0.0;
                for (Road r2 : roads) {
                    if (r2 != r && !r.overlaps.get(pIndex).containsKey(r2)) continue;
                    int r2Size = r2.path.size();
                    int r2Index = r2 == r ? pIndex : r.overlaps.get(pIndex).get(r2);
                    for (int i = StrictMath.max(0, r2Index - 3); i < StrictMath.min(r2Index + 3 + 1, r2Size); ++i) {
                        int dist = StrictMath.abs(i - r2Index);
                        double weight = 1.0 / (double)(dist * dist + 1);
                        xAccum += (double)r2.intPath.get(i)[0] * weight;
                        yAccum += (double)r2.intPath.get(i)[1] * weight;
                        totalWeight += weight;
                    }
                }
                r.path.get((int)pIndex).x = xAccum / totalWeight;
                r.path.get((int)pIndex).y = yAccum / totalWeight;
            }
        }
    }

    public strictfp static class TrianglesArea {
        public float[] triData;
        public Polygon polygon;

        public TrianglesArea(Area area) {
            float[] points = new float[area.points.size() * 2];
            for (int i = 0; i < area.points.size(); ++i) {
                points[i * 2] = (float)area.points.get((int)i).x;
                points[i * 2 + 1] = (float)area.points.get((int)i).y;
            }
            this.polygon = new Polygon(points);
            Triangulator t = this.polygon.getTriangles();
            int count = t.getTriangleCount();
            this.triData = new float[count * 6];
            for (int i = 0; i < count; ++i) {
                for (int p = 0; p < 3; ++p) {
                    float[] xy = t.getTrianglePoint(i, p);
                    this.triData[i * 6 + p * 2] = xy[0];
                    this.triData[i * 6 + p * 2 + 1] = xy[1];
                }
            }
        }

        public void draw() {
            for (int i = 0; i < this.triData.length; i += 2) {
                GL11.glVertex2f((float)this.triData[i], (float)this.triData[i + 1]);
            }
        }
    }

    public strictfp static class Area {
        public int identifier;
        public ArrayList<P> points = new ArrayList();

        public Area(int identifier) {
            this.identifier = identifier;
        }
    }

    public strictfp static class P {
        double x;
        double y;
        ArrayList<Area> areas = new ArrayList();

        public P(double x, double y) {
            this.x = x;
            this.y = y;
        }
    }

    public strictfp static final class IntP {
        int x;
        int y;

        public IntP(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public boolean equals(Object o) {
            if (!(o instanceof IntP)) {
                return false;
            }
            return this.x == ((IntP)o).x && this.y == ((IntP)o).y;
        }

        public int hashCode() {
            return 29 + this.x * 37 + this.y * 1029;
        }
    }
}

