/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.Appearance;
import com.zarkonnen.airships.GUIScale;
import com.zarkonnen.airships.InputRunnable;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MainMenu;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.ResChooserScreen;
import com.zarkonnen.airships.Screen;
import com.zarkonnen.airships.ScrollBar;
import com.zarkonnen.airships.SimplePref;
import com.zarkonnen.catengine.Fount;
import com.zarkonnen.catengine.Hooks;
import com.zarkonnen.catengine.Img;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;

public strictfp class SettingsScreen
implements Screen,
ScrollBar.ScrollElementAdapter<ScreenMode> {
    public final AirshipGame g;
    private int time;
    public static Img COG = new Img("cog", 0, 0, 512, 512, false);
    private final ArrayList<ScreenMode> modes = new ArrayList();
    private final ScrollBar modeSB = new ScrollBar();
    private boolean modesScrolledTo = false;
    private final ArrayList<Locale> locales = Lang.availableLocales();
    private final MyDraw.SliderModel volumeModel = new MyDraw.SliderModel(){

        @Override
        public int min() {
            return 0;
        }

        @Override
        public int max() {
            return 10;
        }

        @Override
        public int getValue() {
            return (int)(SettingsScreen.this.g.volume * 10.0);
        }

        @Override
        public void setValue(int value) {
            SettingsScreen.this.g.volume = (double)value * 1.0 / 10.0;
        }
    };
    private final MyDraw.SliderModel musicVolumeModel = new MyDraw.SliderModel(){

        @Override
        public int min() {
            return 0;
        }

        @Override
        public int max() {
            return 10;
        }

        @Override
        public int getValue() {
            return (int)(SettingsScreen.this.g.musicVolume * 5.0);
        }

        @Override
        public void setValue(int value) {
            SettingsScreen.this.g.musicVolume = (double)value * 2.0 / 10.0;
        }
    };
    private final MyDraw.SliderModel scrollModel = new MyDraw.SliderModel(){

        @Override
        public int min() {
            return 1;
        }

        @Override
        public int max() {
            return 20;
        }

        @Override
        public int getValue() {
            AirshipGame cfr_ignored_0 = SettingsScreen.this.g;
            return AirshipGame.scrollSpeed / 2;
        }

        @Override
        public void setValue(int value) {
            AirshipGame cfr_ignored_0 = SettingsScreen.this.g;
            AirshipGame.scrollSpeed = value * 2;
        }
    };
    private final MyDraw.SliderModel zoomModel = new MyDraw.SliderModel(){

        @Override
        public int min() {
            return 1;
        }

        @Override
        public int max() {
            return 12;
        }

        @Override
        public int getValue() {
            AirshipGame cfr_ignored_0 = SettingsScreen.this.g;
            return AirshipGame.zoomSpeed;
        }

        @Override
        public void setValue(int value) {
            AirshipGame cfr_ignored_0 = SettingsScreen.this.g;
            AirshipGame.zoomSpeed = value;
        }
    };
    private final MyDraw.SliderModel mouseZoomModel = new MyDraw.SliderModel(){

        @Override
        public int min() {
            return 1;
        }

        @Override
        public int max() {
            return 12;
        }

        @Override
        public int getValue() {
            AirshipGame cfr_ignored_0 = SettingsScreen.this.g;
            return AirshipGame.mouseWheelZoomSpeed;
        }

        @Override
        public void setValue(int value) {
            AirshipGame cfr_ignored_0 = SettingsScreen.this.g;
            AirshipGame.mouseWheelZoomSpeed = value;
        }
    };

    public static void postLoad() {
        COG = new Img("cog", 0, 0, 512, 512, false);
    }

    public SettingsScreen(AirshipGame g) {
        this.g = g;
    }

    @Override
    public void input(Input in, MyDraw.State drawState, Pt cursor, Pt click, int ms) {
        this.time += ms;
        if (this.modes.isEmpty()) {
            this.modes.addAll((Collection)ResChooserScreen.getModes((Input)in).b);
        }
        if (in.keyPressed("ENTER")) {
            this.g.saveSettings();
            this.g.s = new MainMenu(this.g, MainMenu.Submenu.SETTINGS_AND_INFO);
        }
        if (in.keyPressed("ESCAPE")) {
            this.g.loadSettings();
            this.g.s = new MainMenu(this.g, MainMenu.Submenu.SETTINGS_AND_INFO);
        }
        ScreenMode sm = in.mode();
        int winW = 650 + MyDraw.UI_SPACING * 2 + MyDraw.WINDOW_INSET * 2;
        int winH = StrictMath.max((SimplePref.values().length + 6) * (MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING), (this.locales.size() + 1) * (MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING)) + MyDraw.WINDOW_INSET * 2 - MyDraw.BUTTON_SPACING;
        int y = sm.height / 2 - winH / 2;
        int x = sm.width / 2 - winW / 2;
        int y2 = y += MyDraw.WINDOW_INSET;
        int x2 = (x += MyDraw.WINDOW_INSET) + 150 + MyDraw.UI_SPACING;
        this.modeSB.tick(in, x2, y2, 250, winH - MyDraw.WINDOW_INSET * 2 - MyDraw.BUTTON_H - MyDraw.UI_SPACING);
    }

    @Override
    public void render(MyDraw d, ScreenMode sm, Hooks hs, Pt cursor) {
        d.rect(AGame.SKY, 0.0, 0.0, sm.width, sm.height);
        d.drawBG(MyDraw.SCREEN_BG, sm);
        int col1W = 80;
        for (Locale l : this.locales) {
            col1W = StrictMath.max(col1W, d.tw(l.getDisplayName(l)));
        }
        int col2W = 80;
        for (ScreenMode m : this.modes) {
            col2W = StrictMath.max(col2W, d.tw(ResChooserScreen.mToString(m)));
        }
        col2W += MyDraw.WINDOW_INSET * 2;
        col2W = StrictMath.max(col2W, d.tw("gui_scale_AUTO"));
        for (GUIScale gs : GUIScale.values()) {
            col2W = StrictMath.max(col2W, d.tw("gui_scale_" + gs.name()));
        }
        int textW = (int)StrictMath.max(StrictMath.max(d.textSize((String)Lang._t((String)"Sound_Volume", (Object[])new Object[0]), (Fount)AGame.FOUNT).x, d.textSize((String)Lang._t((String)"Music_Volume", (Object[])new Object[0]), (Fount)AGame.FOUNT).x), d.textSize((String)Lang._t((String)"Scroll_Speed", (Object[])new Object[0]), (Fount)AGame.FOUNT).x);
        int col3W = textW + 100;
        col3W = StrictMath.max(col3W, d.tw(Lang._t("Send_back_bug_reports_automatically", new Object[0])));
        col3W = StrictMath.max(col3W, d.tw(Lang._t("Graphics_compatibility_mode", new Object[0])));
        col3W = StrictMath.max(col3W, d.tw(Lang._t("Lighting_effects", new Object[0])));
        for (SimplePref sp : SimplePref.values()) {
            col3W = StrictMath.max(col3W, d.tw(sp.getName()));
        }
        int winW = MyDraw.WINDOW_INSET + col1W + MyDraw.UI_SPACING + col2W + MyDraw.UI_SPACING + col3W + MyDraw.WINDOW_INSET;
        int winH = StrictMath.max((SimplePref.values().length + 8) * (MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING), (this.locales.size() + 1) * (MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING)) + MyDraw.WINDOW_INSET * 2 - MyDraw.BUTTON_SPACING;
        int y = sm.height / 2 - winH / 2;
        int x = sm.width / 2 - winW / 2;
        d.blit(COG, x - 110, y - 50, (double)this.time * 1.0E-4);
        int titleW = (int)d.textSize((String)Lang._t((String)"Settings", (Object[])new Object[0]), (Fount)AGame.HUGE_FOUNT).x;
        d.text(MyDraw.TITLE_C + Lang._t("Settings", new Object[0]), AGame.HUGE_FOUNT, sm.width / 2 - titleW / 2, y - AGame.HUGE_FOUNT.height);
        d.drawWindow(x, y, winW, winH);
        x += MyDraw.WINDOW_INSET;
        int y2 = y += MyDraw.WINDOW_INSET;
        for (final Locale l : this.locales) {
            d.toggle(x, y2, col1W, l.getDisplayName(l), null, new InputRunnable(){

                @Override
                public void run(Input in) {
                    Lang.setCurrentLocale(l);
                }
            }, Lang.currentLocale.equals(l), true);
            y2 += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING;
        }
        y2 = y;
        int x2 = x + col1W + MyDraw.UI_SPACING;
        d.toggle(x2, y2, col2W, Lang._t("gui_scale_AUTO", new Object[0]), null, new InputRunnable(){

            @Override
            public void run(Input in) {
                SettingsScreen.this.g.guiScaleOverride = null;
            }
        }, this.g.guiScaleOverride == null, true);
        y2 += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING;
        for (final GUIScale gs : GUIScale.values()) {
            d.toggle(x2, y2, col2W, Lang._t("gui_scale_" + gs.name(), new Object[0]), null, new InputRunnable(){

                @Override
                public void run(Input in) {
                    SettingsScreen.this.g.guiScaleOverride = gs;
                }
            }, this.g.guiScaleOverride == gs, true);
            y2 += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING;
        }
        y2 += MyDraw.UI_SPACING - MyDraw.BUTTON_SPACING;
        if (!this.modesScrolledTo) {
            this.modeSB.scrollTo(false, d, x, y, col2W, winH - MyDraw.WINDOW_INSET * 2 - (GUIScale.values().length + 1) * (MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING) + MyDraw.BUTTON_SPACING - MyDraw.UI_SPACING - MyDraw.UI_SPACING - MyDraw.BUTTON_H, this.modes, this, sm);
            this.modesScrolledTo = true;
        }
        this.modeSB.draw(d, x2, y2, col2W, winH - MyDraw.WINDOW_INSET * 2 - (GUIScale.values().length + 1) * (MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING) + MyDraw.BUTTON_SPACING - MyDraw.UI_SPACING - MyDraw.UI_SPACING - MyDraw.BUTTON_H, this.modes, this);
        int bw = d.bw(Lang._t("OK", new Object[0]));
        d.button(x, y + winH - MyDraw.WINDOW_INSET * 2 - MyDraw.BUTTON_H, bw, Lang._t("OK", new Object[0]), null, new Runnable(){

            @Override
            public void run() {
                SettingsScreen.this.g.saveSettings();
                SettingsScreen.this.g.s = new MainMenu(SettingsScreen.this.g, MainMenu.Submenu.SETTINGS_AND_INFO);
            }
        });
        d.button(x + bw + MyDraw.BUTTON_SPACING, y + winH - MyDraw.WINDOW_INSET * 2 - MyDraw.BUTTON_H, d.bw(Lang._t("Cancel", new Object[0])), Lang._t("Cancel", new Object[0]), null, new Runnable(){

            @Override
            public void run() {
                SettingsScreen.this.g.loadSettings();
                SettingsScreen.this.g.s = new MainMenu(SettingsScreen.this.g, MainMenu.Submenu.SETTINGS_AND_INFO);
            }
        });
        y2 = y;
        d.text(Lang._t("Sound_Volume", new Object[0]), AGame.FOUNT, x2 += col2W + MyDraw.UI_SPACING, y2);
        d.slider(x2 + textW + MyDraw.UI_SPACING, y2, col3W - textW - MyDraw.UI_SPACING, this.volumeModel);
        d.text(Lang._t("Music_Volume", new Object[0]), AGame.FOUNT, x2, y2 += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING);
        d.slider(x2 + textW + MyDraw.UI_SPACING, y2, col3W - textW - MyDraw.UI_SPACING, this.musicVolumeModel);
        d.text(Lang._t("Scroll_Speed", new Object[0]), AGame.FOUNT, x2, y2 += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING);
        d.slider(x2 + textW + MyDraw.UI_SPACING, y2, col3W - textW - MyDraw.UI_SPACING, this.scrollModel);
        d.text(Lang._t("Zoom_Speed", new Object[0]), AGame.FOUNT, x2, y2 += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING);
        d.slider(x2 + textW + MyDraw.UI_SPACING, y2, col3W - textW - MyDraw.UI_SPACING, this.zoomModel);
        d.text(Lang._t("Mouse_Zoom_Speed", new Object[0]), AGame.FOUNT, x2, y2 += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING);
        d.slider(x2 + textW + MyDraw.UI_SPACING, y2, col3W - textW - MyDraw.UI_SPACING, this.mouseZoomModel);
        d.toggle(x2, y2 += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING, col3W, Lang._t("Send_back_bug_reports_automatically", new Object[0]), null, new InputRunnable(){

            @Override
            public void run(Input in) {
                SettingsScreen.this.g.phoneHomeWithErrors = !SettingsScreen.this.g.phoneHomeWithErrors;
            }
        }, this.g.phoneHomeWithErrors, true);
        d.tooltip((double)x2, (double)y2, (double)col3W, (double)MyDraw.BUTTON_H, Lang._t("bug_report_info", new Object[0]));
        d.toggle(x2, y2 += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING, col3W, Lang._t("Graphics_compatibility_mode", new Object[0]), null, new InputRunnable(){

            @Override
            public void run(Input in) {
                Appearance.useSimpleGraphics = !Appearance.useSimpleGraphics;
                Appearance.switchSpritesheet("");
            }
        }, Appearance.useSimpleGraphics, true);
        d.tooltip((double)x2, (double)y2, (double)col3W, (double)MyDraw.BUTTON_H, Lang._t("gfx_compat_tooltip", new Object[0]));
        d.toggle(x2, y2 += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING, col3W, Lang._t("Lighting_effects", new Object[0]), null, new InputRunnable(){

            @Override
            public void run(Input in) {
                Appearance.useLighting = !Appearance.useLighting;
                Appearance.switchSpritesheet("");
            }
        }, Appearance.useLighting && !Appearance.useSimpleGraphics, !Appearance.useSimpleGraphics && Appearance.canUseLighting);
        y2 += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING;
        for (final SimplePref sp : SimplePref.values()) {
            d.toggle(x2, y2, col3W, sp.getName(), null, new InputRunnable(){

                @Override
                public void run(Input in) {
                    sp.set(!sp.get());
                }
            }, sp.get(), true);
            d.tooltip((double)x2, (double)y2, (double)col3W, (double)MyDraw.BUTTON_H, sp.getTooltip());
            y2 += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING;
        }
        if (winH > sm.height) {
            this.g.guiScaleOverride = null;
        }
    }

    @Override
    public ArrayList<String> music() {
        return AGame.MENU_MUSIC;
    }

    @Override
    public String appearancePostfix() {
        return "DAY";
    }

    @Override
    public boolean alwaysUseAppearancePostfix() {
        return false;
    }

    @Override
    public int getHeight(ScreenMode t, MyDraw d, int availableWidth) {
        return MyDraw.BUTTON_H + MyDraw.SCROLL_EL_SPACING;
    }

    @Override
    public void draw(final ScreenMode m, MyDraw d, int x, int y, int width) {
        d.toggle(x, y, width, ResChooserScreen.mToString(m), null, new InputRunnable(){

            @Override
            public void run(Input in) {
                try {
                    AirshipGame.PREFS.putInt("screenModeW", m.width);
                    AirshipGame.PREFS.putInt("screenModeH", m.height);
                    AirshipGame.PREFS.putBoolean("screenModeF", m.fullscreen);
                    AirshipGame.PREFS.putBoolean("screenModeFW", m.fullscreenWindow);
                    AirshipGame.PREFS.flush();
                }
                catch (Exception e) {
                    SettingsScreen.this.g.reportError(Lang._t("Unable_to_store_prefs", new Object[0]), e, null, false);
                }
                in.setMode(m);
            }
        }, m.equals((Object)d.frame().mode()), true);
    }
}

