/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.GridBody;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.PlaybackIntent;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Clr;
import java.util.ArrayList;

public strictfp class SelectionVisualLayer
implements UniScreen.VisualLayer {
    private final ArrayList<Airship> multiTargets = new ArrayList();
    public static Clr SHIP_SELECT = Clr.fromHex((String)"c8b84f");
    public static Clr SHIP_SELECT2 = Clr.fromHex((String)"726534");
    public static Clr SHIP_TARGET = Clr.fromHex((String)"bb421d");
    public static Clr SHIP_TARGET2 = Clr.fromHex((String)"613f2d");
    public static Clr TROOPS_MOVE = Clr.fromHex((String)"6e9511");
    public static Clr TROOPS_MOVE2 = Clr.fromHex((String)"613f2d");
    public static Clr TROOPS_BOARD = Clr.fromHex((String)"d59b7f");
    public static Clr TROOPS_BOARD2 = Clr.fromHex((String)"613f2d");

    @Override
    public void tick(Input in, int ms, UniScreen us) {
    }

    public static void drawGridBodyOutline(MyDraw d, double zoom, GridBody sel, Clr inner, Clr outer) {
        SelectionVisualLayer.drawGridBodyOutline(d, zoom, sel, sel.getX(), sel.getY(), inner, outer);
    }

    public static void drawGridBodyOutline(MyDraw d, double zoom, GridBody sel, double selX, double selY, Clr inner, Clr outer) {
        int outlineWidth = 2;
        switch (AirshipGame.instance.currentGUIScale) {
            case SMALL: {
                outlineWidth = 2;
                break;
            }
            case MEDIUM: {
                outlineWidth = 4;
                break;
            }
            case LARGE: {
                outlineWidth = 4;
            }
        }
        double border = (double)outlineWidth / zoom;
        Clr c = outer;
        for (int i = 0; i < 2; ++i) {
            for (int gy = 0; gy < sel.getGridHeight(); ++gy) {
                for (int gx = 0; gx < sel.getGridWidth(); ++gx) {
                    if (!sel.solidAt(gx, gy)) continue;
                    int tx = (int)selX + gx * 16;
                    int ty = (int)selY + gy * 16;
                    if (!sel.solidAt(gx, gy - 1)) {
                        d.rect(c, (double)tx - border, (double)ty - border, 16.0 + border * 2.0, border);
                    }
                    if (!sel.solidAt(gx, gy + 1)) {
                        d.rect(c, (double)tx - border, ty + 16, 16.0 + border * 2.0, border);
                    }
                    if (!sel.solidAt(gx - 1, gy)) {
                        d.rect(c, (double)tx - border, (double)ty - border, border, 16.0 + border * 2.0);
                    }
                    if (sel.solidAt(gx + 1, gy)) continue;
                    d.rect(c, tx + 16, (double)ty - border, border, 16.0 + border * 2.0);
                }
            }
            border /= 2.0;
            c = inner;
        }
    }

    @Override
    public void draw(MyDraw d, UniScreen us, double cropX, double cropY, double cropW, double cropH) {
        GridBody sel;
        if (us.combat == null || us.selectedShip == null && us.selectedLF == null && us.selectedShips.isEmpty() || us.hideUI) {
            return;
        }
        if (us.intent instanceof PlaybackIntent) {
            return;
        }
        GridBody gridBody = sel = us.selectedShip == null ? us.selectedLF : us.selectedShip;
        if (sel != null) {
            SelectionVisualLayer.drawGridBodyOutline(d, us.zoom, sel, SHIP_SELECT, SHIP_SELECT2);
            if (sel instanceof Airship && ((Airship)sel).fireAt != null) {
                SelectionVisualLayer.drawGridBodyOutline(d, us.zoom, ((Airship)sel).fireAt, SHIP_TARGET, SHIP_TARGET2);
            }
        } else if (!us.selectedShips.isEmpty() && us.intent.allowMultiSelect()) {
            this.multiTargets.clear();
            for (Airship s : us.selectedShips) {
                SelectionVisualLayer.drawGridBodyOutline(d, us.zoom, s, SHIP_SELECT, SHIP_SELECT2);
                if (s.fireAt == null || this.multiTargets.contains(s.fireAt)) continue;
                this.multiTargets.add(s.fireAt);
            }
            for (Airship t : this.multiTargets) {
                SelectionVisualLayer.drawGridBodyOutline(d, us.zoom, t, SHIP_TARGET, SHIP_TARGET2);
            }
        }
    }
}

