/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.HasName;
import com.zarkonnen.airships.Lang;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;

public class SearchMatcher {
    private static final Comparator<String> lengthComparator = new Comparator<String>(){

        @Override
        public int compare(String t, String t1) {
            return t1.length() - t.length();
        }
    };

    public static <T extends HasName> ArrayList<T> match(ArrayList<T> candidates, Comparator<T> comparator, String search) {
        ArrayList<HasName> matchesStartsInOrderFromStart = new ArrayList<HasName>();
        ArrayList<HasName> matchesStartsInOrder = new ArrayList<HasName>();
        ArrayList<HasName> matchesStarts = new ArrayList<HasName>();
        ArrayList<HasName> matchesPreciselyAsInitialism = new ArrayList<HasName>();
        ArrayList<HasName> matchesParts = new ArrayList<HasName>();
        ArrayList<HasName> matchesAsInitialism = new ArrayList<HasName>();
        ArrayList<HasName> matchesAsSubstring = new ArrayList<HasName>();
        for (HasName o : candidates) {
            if (SearchMatcher.matchesParts(o.getName(), search)) {
                if (SearchMatcher.matchesStarts(o.getName(), search)) {
                    if (SearchMatcher.matchesStartsInOrder(o.getName(), search)) {
                        if (SearchMatcher.matchesStartsInOrderFromStart(o.getName(), search)) {
                            matchesStartsInOrderFromStart.add(o);
                            continue;
                        }
                        matchesStartsInOrder.add(o);
                        continue;
                    }
                    matchesStarts.add(o);
                    continue;
                }
                if (SearchMatcher.matchesPreciselyAsInitialism(o.getName(), search)) {
                    matchesPreciselyAsInitialism.add(o);
                    continue;
                }
                matchesParts.add(o);
                continue;
            }
            if (SearchMatcher.matchesPartlyAsInitialism(o.getName(), search)) {
                if (SearchMatcher.matchesPreciselyAsInitialism(o.getName(), search)) {
                    matchesPreciselyAsInitialism.add(o);
                    continue;
                }
                matchesAsInitialism.add(o);
                continue;
            }
            if (!SearchMatcher.matchesAsSubstring(o.getName(), search)) continue;
            matchesAsSubstring.add(o);
        }
        if (comparator != null) {
            Collections.sort(matchesStartsInOrderFromStart, comparator);
            Collections.sort(matchesStartsInOrder, comparator);
            Collections.sort(matchesStarts, comparator);
            Collections.sort(matchesPreciselyAsInitialism, comparator);
            Collections.sort(matchesParts, comparator);
            Collections.sort(matchesAsInitialism, comparator);
            Collections.sort(matchesAsSubstring, comparator);
        }
        matchesStartsInOrderFromStart.addAll(matchesStartsInOrder);
        matchesStartsInOrderFromStart.addAll(matchesStarts);
        matchesStartsInOrderFromStart.addAll(matchesPreciselyAsInitialism);
        matchesStartsInOrderFromStart.addAll(matchesParts);
        matchesStartsInOrderFromStart.addAll(matchesAsInitialism);
        matchesStartsInOrderFromStart.addAll(matchesAsSubstring);
        return matchesStartsInOrderFromStart;
    }

    private static boolean matchesPartlyAsInitialism(String text, String search) {
        search = search.toLowerCase(Lang.currentLocale);
        String[] textBits = text.toLowerCase(Lang.currentLocale).split(" ");
        if (search.length() > textBits.length) {
            return false;
        }
        for (int i = 0; i < StrictMath.min(search.length(), textBits.length); ++i) {
            if (textBits[i].length() == 0 || textBits[i].substring(0, 1).equals(search.substring(i, i + 1))) continue;
            return false;
        }
        return true;
    }

    private static boolean matchesPreciselyAsInitialism(String text, String search) {
        search = search.toLowerCase(Lang.currentLocale);
        String[] textBits = text.toLowerCase(Lang.currentLocale).split(" ");
        if (search.length() != textBits.length) {
            return false;
        }
        for (int i = 0; i < textBits.length; ++i) {
            if (textBits[i].length() == 0 || textBits[i].substring(0, 1).equals(search.substring(i, i + 1))) continue;
            return false;
        }
        return true;
    }

    private static boolean matchesAsSubstring(String text, String search) {
        return text.toLowerCase(Lang.currentLocale).contains(search.toLowerCase(Lang.currentLocale));
    }

    private static boolean matchesParts(String text, String search) {
        search = search.toLowerCase(Lang.currentLocale);
        String[] searchBits = search.split(" ");
        Arrays.sort(searchBits, lengthComparator);
        text = text.toLowerCase(Lang.currentLocale);
        boolean[] claimed = new boolean[text.length()];
        for (String bit : searchBits) {
            int i;
            int startIndex = 0;
            block1: while (true) {
                int index;
                if ((index = text.indexOf(bit, startIndex)) == -1) {
                    return false;
                }
                for (i = 0; i < bit.length(); ++i) {
                    if (!claimed[index + i]) continue;
                    startIndex = index + 1;
                    continue block1;
                }
                break;
            }
            for (i = 0; i < bit.length(); ++i) {
                claimed[index + i] = true;
            }
        }
        return true;
    }

    private static boolean matchesStarts(String text, String search) {
        search = search.toLowerCase(Lang.currentLocale);
        String[] searchBits = search.split(" ");
        Arrays.sort(searchBits, lengthComparator);
        String[] textBits = text.toLowerCase(Lang.currentLocale).split(" ");
        for (String bit : searchBits) {
            block3: {
                for (int i = 0; i < textBits.length; ++i) {
                    if (textBits[i] == null || !textBits[i].startsWith(bit)) {
                        continue;
                    }
                    break block3;
                }
                return false;
            }
            textBits[i] = null;
        }
        return true;
    }

    private static boolean matchesStartsInOrder(String text, String search) {
        search = search.toLowerCase(Lang.currentLocale);
        String[] searchBits = search.split(" ");
        Arrays.sort(searchBits, lengthComparator);
        String[] textBits = text.toLowerCase(Lang.currentLocale).split(" ");
        block0: for (String bit : searchBits) {
            for (int i = 0; i < textBits.length; ++i) {
                if (textBits[i] == null || !textBits[i].startsWith(bit)) continue;
                for (int j = 0; j <= i; ++j) {
                    textBits[j] = null;
                }
                continue block0;
            }
            return false;
        }
        return true;
    }

    private static boolean matchesStartsInOrderFromStart(String text, String search) {
        return SearchMatcher.matchesStartsInOrder(text, search) && text.toLowerCase(Lang.currentLocale).startsWith(search.toLowerCase(Lang.currentLocale));
    }
}

