/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.catengine.Hook;
import com.zarkonnen.catengine.Img;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Pt;
import java.util.List;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;

public strictfp class ScrollBar {
    public int offset;
    public int prevRange = 0;
    public boolean stickToBottom = false;
    public int clipX;
    public int clipY;
    public int clipW;
    public int clipH;
    public static int SCROLL_BAR_W = 24;
    public static int SMALL_SCROLL_BAR_W = 24;
    public static int MEDIUM_SCROLL_BAR_W = 24;
    public static int LARGE_SCROLL_BAR_W = 24;
    public static Img UP_BUTTON = new Img("ui", 116, 827, 26, 25, false);
    public static Img SMALL_UP_BUTTON = new Img("ui", 116, 827, 26, 25, false);
    public static Img MEDIUM_UP_BUTTON = new Img("ui", 116, 827, 26, 25, false);
    public static Img LARGE_UP_BUTTON = new Img("ui", 116, 827, 26, 25, false);
    public static Img DOWN_BUTTON = new Img("ui", 116, 853, 26, 25, false);
    public static Img SMALL_DOWN_BUTTON = new Img("ui", 116, 853, 26, 25, false);
    public static Img MEDIUM_DOWN_BUTTON = new Img("ui", 116, 853, 26, 25, false);
    public static Img LARGE_DOWN_BUTTON = new Img("ui", 116, 853, 26, 25, false);
    public static Img UP_BUTTON_LIT = new Img("ui", 89, 827, 26, 25, false);
    public static Img SMALL_UP_BUTTON_LIT = new Img("ui", 89, 827, 26, 25, false);
    public static Img MEDIUM_UP_BUTTON_LIT = new Img("ui", 89, 827, 26, 25, false);
    public static Img LARGE_UP_BUTTON_LIT = new Img("ui", 89, 827, 26, 25, false);
    public static Img DOWN_BUTTON_LIT = new Img("ui", 89, 853, 26, 25, false);
    public static Img SMALL_DOWN_BUTTON_LIT = new Img("ui", 89, 853, 26, 25, false);
    public static Img MEDIUM_DOWN_BUTTON_LIT = new Img("ui", 89, 853, 26, 25, false);
    public static Img LARGE_DOWN_BUTTON_LIT = new Img("ui", 89, 853, 26, 25, false);
    public static Img UP_BUTTON_DISABLED = new Img("ui", 251, 827, 26, 25, false);
    public static Img SMALL_UP_BUTTON_DISABLED = new Img("ui", 251, 827, 26, 25, false);
    public static Img MEDIUM_UP_BUTTON_DISABLED = new Img("ui", 251, 827, 26, 25, false);
    public static Img LARGE_UP_BUTTON_DISABLED = new Img("ui", 251, 827, 26, 25, false);
    public static Img DOWN_BUTTON_DISABLED = new Img("ui", 251, 853, 26, 25, false);
    public static Img SMALL_DOWN_BUTTON_DISABLED = new Img("ui", 251, 853, 26, 25, false);
    public static Img MEDIUM_DOWN_BUTTON_DISABLED = new Img("ui", 251, 853, 26, 25, false);
    public static Img LARGE_DOWN_BUTTON_DISABLED = new Img("ui", 251, 853, 26, 25, false);
    public static Img SCROLL_THUMB_TOP = new Img("ui", 143, 827, 20, 6, false);
    public static Img SMALL_SCROLL_THUMB_TOP = new Img("ui", 143, 827, 20, 6, false);
    public static Img MEDIUM_SCROLL_THUMB_TOP = new Img("ui", 143, 827, 20, 6, false);
    public static Img LARGE_SCROLL_THUMB_TOP = new Img("ui", 143, 827, 20, 6, false);
    public static Img SCROLL_THUMB_MIDDLE = new Img("ui", 143, 833, 20, 8, false);
    public static Img SMALL_SCROLL_THUMB_MIDDLE = new Img("ui", 143, 833, 20, 8, false);
    public static Img MEDIUM_SCROLL_THUMB_MIDDLE = new Img("ui", 143, 833, 20, 8, false);
    public static Img LARGE_SCROLL_THUMB_MIDDLE = new Img("ui", 143, 833, 20, 8, false);
    public static Img SCROLL_THUMB_BOTTOM = new Img("ui", 143, 841, 20, 6, false);
    public static Img SMALL_SCROLL_THUMB_BOTTOM = new Img("ui", 143, 841, 20, 6, false);
    public static Img MEDIUM_SCROLL_THUMB_BOTTOM = new Img("ui", 143, 841, 20, 6, false);
    public static Img LARGE_SCROLL_THUMB_BOTTOM = new Img("ui", 143, 841, 20, 6, false);
    public static Img LEFT_BORDER = new Img("ui", 80, 846, 2, 20, false);
    public static Img SMALL_LEFT_BORDER = new Img("ui", 80, 846, 2, 20, false);
    public static Img MEDIUM_LEFT_BORDER = new Img("ui", 80, 846, 2, 20, false);
    public static Img LARGE_LEFT_BORDER = new Img("ui", 80, 846, 2, 20, false);
    public static Img RIGHT_BORDER = new Img("ui", 83, 846, 2, 20, false);
    public static Img SMALL_RIGHT_BORDER = new Img("ui", 83, 846, 2, 20, false);
    public static Img MEDIUM_RIGHT_BORDER = new Img("ui", 83, 846, 2, 20, false);
    public static Img LARGE_RIGHT_BORDER = new Img("ui", 83, 846, 2, 20, false);
    public static Clr BAR_BG = Clr.fromHex((String)"4f442f");

    public void tick(Input in, int x, int y, int w, int h) {
        if (in.scrollAmount() != 0 && MyDraw.in(x, y, w, h, in.cursor())) {
            this.offset = StrictMath.max(0, this.offset - in.scrollAmount() * AirshipGame.scrollSpeed / 60);
        }
    }

    public void draw(MyDraw d, int x, int y, final int h, final int panelH, final int range) {
        boolean barHover;
        this.offset = this.prevRange != 0 && (this.offset >= this.prevRange - panelH || this.prevRange < panelH && range > panelH) ? StrictMath.max(0, range - panelH) : StrictMath.min(StrictMath.max(range - panelH, 0), this.offset);
        this.prevRange = range;
        boolean upHover = range > panelH && MyDraw.in(x, y, SCROLL_BAR_W, SCROLL_BAR_W, d.state.cursor);
        boolean downHover = range > panelH && MyDraw.in(x, y + h - SCROLL_BAR_W, SCROLL_BAR_W, SCROLL_BAR_W, d.state.cursor);
        boolean bl = barHover = range > panelH && MyDraw.in(x, y + SCROLL_BAR_W, SCROLL_BAR_W, h - SCROLL_BAR_W * 2, d.state.cursor);
        d.blit(this.offset > 0 ? (upHover ? UP_BUTTON_LIT : UP_BUTTON) : UP_BUTTON_DISABLED, x - 1, y - 1);
        d.hook(x, y, SCROLL_BAR_W, SCROLL_BAR_W, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_DOWN}){

            public void run(Input in, Pt p, Hook.Type type) {
                ScrollBar.this.offset = StrictMath.max(0, ScrollBar.this.offset - AirshipGame.scrollSpeed);
            }
        });
        d.rect(barHover ? MyDraw.PROGRESS_BAR_DEEP_INSIDE : BAR_BG, x + 1, y + SCROLL_BAR_W, SCROLL_BAR_W - 2, h - SCROLL_BAR_W * 2);
        for (int y2 = y + SCROLL_BAR_W; y2 < y + h - SCROLL_BAR_W; y2 += ScrollBar.LEFT_BORDER.srcHeight) {
            d.blit(LEFT_BORDER, x, y2);
            d.blit(RIGHT_BORDER, x + SCROLL_BAR_W - 2, y2);
        }
        d.blit(this.offset < range - panelH ? (downHover ? DOWN_BUTTON_LIT : DOWN_BUTTON) : DOWN_BUTTON_DISABLED, x - 1, y + h - SCROLL_BAR_W);
        d.hook(x, y + h - SCROLL_BAR_W, SCROLL_BAR_W, SCROLL_BAR_W, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_DOWN}){

            public void run(Input in, Pt p, Hook.Type type) {
                ScrollBar.this.offset = StrictMath.min(range, ScrollBar.this.offset + AirshipGame.scrollSpeed);
            }
        });
        if (range > panelH) {
            final int thumbH = StrictMath.max(ScrollBar.SCROLL_THUMB_TOP.srcHeight + ScrollBar.SCROLL_THUMB_MIDDLE.srcHeight + ScrollBar.SCROLL_THUMB_BOTTOM.srcHeight, (h - SCROLL_BAR_W * 2) * panelH / range);
            int thumbY = y + SCROLL_BAR_W + 1 + (h - SCROLL_BAR_W * 2 - 2 - thumbH) * this.offset / (range - panelH);
            int tx = x + SCROLL_BAR_W / 2 - ScrollBar.SCROLL_THUMB_TOP.srcWidth / 2;
            d.blit(SCROLL_THUMB_TOP, tx, thumbY);
            int ty = thumbY + ScrollBar.SCROLL_THUMB_TOP.srcHeight;
            d.blit(SCROLL_THUMB_MIDDLE, tx, ty);
            ty += ScrollBar.SCROLL_THUMB_MIDDLE.srcHeight;
            while (ty < thumbY + thumbH - ScrollBar.SCROLL_THUMB_BOTTOM.srcHeight) {
                if (ScrollBar.SCROLL_THUMB_MIDDLE.machineImgCache != null) {
                    ((Image)ScrollBar.SCROLL_THUMB_MIDDLE.machineImgCache).draw((float)tx, (float)ty, (float)(tx + ScrollBar.SCROLL_THUMB_MIDDLE.srcWidth), (float)(ty + StrictMath.min(ScrollBar.SCROLL_THUMB_MIDDLE.srcHeight, thumbY + thumbH - ScrollBar.SCROLL_THUMB_BOTTOM.srcHeight - ty)), 0.0f, 0.0f, (float)ScrollBar.SCROLL_THUMB_MIDDLE.srcWidth, (float)StrictMath.min(ScrollBar.SCROLL_THUMB_MIDDLE.srcHeight, thumbY + thumbH - ScrollBar.SCROLL_THUMB_BOTTOM.srcHeight - ty));
                }
                ty += ScrollBar.SCROLL_THUMB_MIDDLE.srcHeight;
            }
            d.blit(SCROLL_THUMB_BOTTOM, tx, thumbY + thumbH - ScrollBar.SCROLL_THUMB_BOTTOM.srcHeight);
            d.hook(x, y + SCROLL_BAR_W, SCROLL_BAR_W, h - SCROLL_BAR_W * 2, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED, Hook.Type.MOUSE_1_DOWN}){

                public void run(Input in, Pt p, Hook.Type type) {
                    ScrollBar.this.offset = StrictMath.max(0, ((int)p.y - thumbH / 2) * (range - panelH) / StrictMath.max(1, h - SCROLL_BAR_W * 2 - 2 - thumbH));
                }
            });
        }
    }

    public <T> void draw(MyDraw d, int x, int y, int w, int h, List<T> els, ScrollElementAdapter<T> ad) {
        int panelW = w - SCROLL_BAR_W - MyDraw.PANEL_INSET * 2;
        int range = 0;
        for (int i = 0; i < els.size(); ++i) {
            range += ad.getHeight(els.get(i), d, panelW);
        }
        int panelH = h - MyDraw.PANEL_INSET * 2;
        this.offset = this.stickToBottom && this.prevRange != 0 && this.offset >= this.prevRange - panelH ? StrictMath.max(0, range - panelH) : (this.prevRange != 0 && this.prevRange < panelH && range > panelH ? StrictMath.min(this.offset, StrictMath.max(0, range - panelH)) : StrictMath.min(StrictMath.max(range - panelH, 0), this.offset));
        this.prevRange = range;
        d.drawPanel(x, y, w - SCROLL_BAR_W + MyDraw.PANEL_INSET, h);
        this.draw(d, x + w - SCROLL_BAR_W, y, h, panelH, range);
        int endY = y + h - MyDraw.PANEL_INSET;
        int startY = y + MyDraw.PANEL_INSET;
        y = y + MyDraw.PANEL_INSET - this.offset;
        x += MyDraw.PANEL_INSET;
        Graphics g = (Graphics)d.frame().nativeRenderer();
        for (int i = 0; i < els.size(); ++i) {
            int elH = ad.getHeight(els.get(i), d, panelW);
            if (y + elH > startY && y < endY) {
                this.clipX = x;
                this.clipY = startY;
                this.clipW = panelW;
                this.clipH = endY - startY;
                g.setClip(x, startY, panelW, endY - startY);
                ad.draw(els.get(i), d, x, y, panelW);
                g.clearClip();
            }
            y += elH;
        }
    }

    public <T> void drawNaked(MyDraw d, int x, int y, int w, int h, List<T> els, ScrollElementAdapter<T> ad) {
        int areaW = w - SCROLL_BAR_W;
        int range = 0;
        for (int i = 0; i < els.size(); ++i) {
            range += ad.getHeight(els.get(i), d, areaW);
        }
        int areaH = h;
        this.offset = this.prevRange != 0 && (this.offset >= this.prevRange - areaH || this.prevRange < areaH && range > areaH) ? StrictMath.max(0, range - areaH) : StrictMath.min(StrictMath.max(range - areaH, 0), this.offset);
        this.prevRange = range;
        this.draw(d, x + w - SCROLL_BAR_W, y, h, areaH, range);
        int endY = y + h - MyDraw.PANEL_INSET;
        int startY = y + MyDraw.PANEL_INSET;
        y = y + MyDraw.PANEL_INSET - this.offset;
        x += MyDraw.PANEL_INSET;
        areaW -= MyDraw.PANEL_INSET;
        Graphics g = (Graphics)d.frame().nativeRenderer();
        for (int i = 0; i < els.size(); ++i) {
            int elH = ad.getHeight(els.get(i), d, areaW);
            if (y + elH > startY && y < endY) {
                this.clipX = x;
                this.clipY = startY;
                this.clipW = areaW;
                this.clipH = endY - startY;
                g.setClip(x, startY, areaW, endY - startY);
                ad.draw(els.get(i), d, x, y, areaW);
                g.clearClip();
            }
            y += elH;
        }
    }

    public <T> void scrollTo(boolean naked, MyDraw d, int x, int y, int w, int h, List<T> els, ScrollElementAdapter<T> ad, T scrollTo) {
        int panelW = w - SCROLL_BAR_W - (naked ? 0 : MyDraw.PANEL_INSET * 2);
        int panelH = h - (naked ? 0 : MyDraw.PANEL_INSET * 2);
        int range = 0;
        int scrollToY = 0;
        int scrollToH = 0;
        boolean scrollToFound = false;
        for (int i = 0; i < els.size(); ++i) {
            int eH = ad.getHeight(els.get(i), d, panelW);
            range += eH;
            if (els.get(i).equals(scrollTo)) {
                scrollToFound = true;
                scrollToH = eH;
            }
            if (scrollToFound) continue;
            scrollToY += eH;
        }
        this.offset = StrictMath.max(0, scrollToY + scrollToH / 2 - h / 2);
    }

    public static interface ScrollElementAdapter<T> {
        public int getHeight(T var1, MyDraw var2, int var3);

        public void draw(T var1, MyDraw var2, int var3, int var4, int var5);
    }
}

