/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.Analytics;
import com.zarkonnen.airships.EditMissionIntent;
import com.zarkonnen.airships.FileScreen;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MissionBackend;
import com.zarkonnen.airships.MissionEditorPanel;
import com.zarkonnen.airships.MissionInlineInfo;
import com.zarkonnen.airships.MissionSequence;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Fount;
import com.zarkonnen.catengine.Hooks;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.FileSystemUtils;

public class SaveMissionButton
extends UniScreen.Button {
    @Override
    public boolean visible(UniScreen us) {
        return us.intent instanceof EditMissionIntent;
    }

    @Override
    public String text(UniScreen us) {
        return Lang._t("Save", new Object[0]);
    }

    @Override
    public boolean enabled(UniScreen us) {
        return true;
    }

    @Override
    public void click(Input in, UniScreen us) {
        EditMissionIntent emi = (EditMissionIntent)us.intent;
        MissionSequence seq = emi.missionSequence;
        MissionSequence.Mission m = emi.mission;
        boolean bl = MissionEditorPanel.getProblem(seq, m) == null;
        seq.playableHeader = bl;
        MissionBackend backend = new MissionBackend(us.g, true);
        us.g.s = new FileScreen(backend, new SaveMissionMission(us.g, seq, m, emi.justSaved, backend), new MissionHelperWidget(backend), new MissionInlineInfo(), "mission");
    }

    private strictfp static class SaveMissionMission
    implements FileScreen.Mission {
        private final AirshipGame g;
        private final MissionSequence seq;
        private final MissionSequence.Mission m;
        private final boolean savedAlready;
        private final MissionBackend backend;

        public SaveMissionMission(AirshipGame g, MissionSequence seq, MissionSequence.Mission m, boolean savedAlready, MissionBackend backend) {
            this.g = g;
            this.seq = seq;
            this.m = m;
            this.savedAlready = savedAlready;
            this.backend = backend;
        }

        @Override
        public FileScreen.Mode mode() {
            return FileScreen.Mode.SAVE;
        }

        @Override
        public String text() {
            return Lang._t("Save_Mission_", new Object[0]);
        }

        @Override
        public String initialInput() {
            return AGame.makeFileSafe(this.seq.getIdeallyEnglishName());
        }

        @Override
        public String fileSelectionText() {
            return Lang._t("Save", new Object[0]);
        }

        @Override
        public void fileSelected(String path) {
            try {
                this.seq.saveTo(this.backend.getRawFile(FileScreen.splitPath(path)));
                Analytics.missionSave();
            }
            catch (IOException e) {
                long space = -1L;
                try {
                    space = FileSystemUtils.freeSpaceKb((String)this.backend.getRawFile(FileScreen.splitPath(path)).getAbsolutePath(), (long)3000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (space != -1L && space < 10240L) {
                    this.g.showError(Lang._t("Insufficient_space_on_disk", new Object[0]));
                }
                this.g.reportError(Lang._t("Unable_to_save_mission", new Object[0]), e, null, false);
            }
            this.returnToEditing(true);
        }

        @Override
        public void cancelled() {
            this.returnToEditing(this.savedAlready);
        }

        private void returnToEditing(boolean justSaved) {
            EditMissionIntent emi = new EditMissionIntent(this.seq, this.m);
            emi.justSaved = justSaved;
            UniScreen us2 = new UniScreen(this.g, emi);
            us2.combat = this.m.combat;
            us2.mySide = this.m.combat.sides.get(this.m.playerSideIndex);
            this.g.s = us2;
        }
    }

    private strictfp static class MissionHelperWidget
    implements FileScreen.HelperWidget {
        private final HashMap<String, MissionSequence> cache = new HashMap();
        private final MissionBackend backend;
        private String selected;
        private MissionSequence selectedSeq;

        public MissionHelperWidget(MissionBackend backend) {
            this.backend = backend;
        }

        @Override
        public void setSelectedFile(List<String> path) {
            if (path == null) {
                this.selectedSeq = null;
                this.selected = null;
                return;
            }
            this.selected = FileScreen.joinPath(path);
            if (!this.cache.containsKey(this.selected)) {
                File f = this.backend.getFile(path);
                if (f == null || !f.exists()) {
                    this.cache.put(this.selected, null);
                } else {
                    MissionSequence seq = new MissionSequence(this.backend.isLocal(path), f);
                    seq.loadMetadata();
                    this.cache.put(this.selected, seq);
                }
            }
            this.selectedSeq = this.cache.get(this.selected);
        }

        @Override
        public void clearCacheFor(List<String> path) {
            this.cache.clear();
        }

        @Override
        public void tick(Input in, MyDraw.State drawState, Pt cursor, Pt click, int ms, ArrayList<String> dirPath) {
        }

        @Override
        public void render(MyDraw d, ScreenMode sm, Hooks hs, Pt cursor, int x, int y, int w, int h) {
            if (this.selected == null) {
                return;
            }
            String name = this.selectedSeq != null && this.selectedSeq.loaded ? this.selectedSeq.getName() : this.selected;
            d.text(MyDraw.TITLE_C + name, AGame.BIGGER_FOUNT, x, y, w);
            int titleH = (int)d.textSize((String)name, (Fount)AGame.BIGGER_FOUNT, (double)((double)x), (double)((double)y), (int)w).height;
            y += titleH + MyDraw.UI_SPACING;
            if (this.selectedSeq != null && this.selectedSeq.loaded) {
                d.text(this.selectedSeq.getDescriptionAndMods(), AGame.FOUNT, x, y, w);
            }
        }

        @Override
        public void close() {
        }

        @Override
        public boolean blocking() {
            return false;
        }

        @Override
        public boolean popUpdateNeeded() {
            return false;
        }
    }
}

