/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.FileScreen;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.StrategicScreen;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public strictfp class SaveGameMission
implements FileScreen.Mission {
    private final AirshipGame g;
    private final StrategicScreen ss;
    private final FileScreen.Backend backend;

    public SaveGameMission(AirshipGame g, StrategicScreen ss, FileScreen.Backend backend) {
        this.g = g;
        this.ss = ss;
        this.backend = backend;
    }

    @Override
    public FileScreen.Mode mode() {
        return FileScreen.Mode.SAVE;
    }

    @Override
    public String text() {
        return Lang._t("Save_game_", new Object[0]);
    }

    @Override
    public String fileSelectionText() {
        return Lang._t("Save", new Object[0]);
    }

    @Override
    public String initialInput() {
        return AGame.makeFileSafe((this.ss.w.player == null ? Lang._t("Spectator", new Object[0]) : this.ss.w.player.name).toUpperCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fileSelected(String path) {
        this.g.s = this.ss;
        File f = this.backend.getFile(FileScreen.splitPath(path));
        f.getParentFile().mkdirs();
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF-8"));
            this.ss.w.toJSON().write(bw);
            bw.flush();
            this.ss.menu = false;
        }
        catch (Exception e) {
            this.g.reportError(Lang._t("Unable_to_save_game", new Object[0]), e, null, false);
        }
        finally {
            try {
                bw.close();
            }
            catch (Exception exception) {}
        }
        Runtime.getRuntime().gc();
    }

    @Override
    public void cancelled() {
        this.g.s = this.ss;
    }
}

