/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.Analytics;
import com.zarkonnen.airships.ChallengeEditShipIntent;
import com.zarkonnen.airships.ConstructionBackend;
import com.zarkonnen.airships.FileScreen;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.PriceInlineInfo;
import com.zarkonnen.airships.ShipEditorUtils;
import com.zarkonnen.airships.ShipHelperWidget;
import com.zarkonnen.airships.SingleShipIntent;
import com.zarkonnen.airships.Tech;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;
import java.io.File;
import org.apache.commons.io.FileSystemUtils;
import org.apache.commons.io.FileUtils;

public strictfp class SaveDesignButton
extends UniScreen.Button {
    @Override
    public boolean visible(UniScreen us) {
        return us.intent instanceof SingleShipIntent && !(us.intent instanceof ChallengeEditShipIntent);
    }

    @Override
    public String text(UniScreen us) {
        return Lang._t("Save_design", new Object[0]);
    }

    @Override
    public void click(Input in, UniScreen us) {
        ShipHelperWidget shw = ShipHelperWidget.get(((SingleShipIntent)((Object)us.intent)).type(us), us.g.getBestCOA(), Tech.getStandardBonuses(), null, 0);
        ConstructionBackend cbe = ShipEditorUtils.shipsList(((SingleShipIntent)((Object)us.intent)).type(us), shw);
        us.g.s = new FileScreen(cbe, new SaveShipMission(us.g, us, cbe), shw, new PriceInlineInfo(shw, null), ((SingleShipIntent)((Object)us.intent)).type(us).name());
    }

    @Override
    public String hotkey(UniScreen us) {
        return "V";
    }

    private strictfp static class SaveShipMission
    implements FileScreen.Mission {
        private final AirshipGame g;
        private final UniScreen us;
        private final ConstructionBackend backend;

        public SaveShipMission(AirshipGame g, UniScreen us, ConstructionBackend backend) {
            this.g = g;
            this.us = us;
            this.backend = backend;
        }

        @Override
        public FileScreen.Mode mode() {
            return FileScreen.Mode.SAVE;
        }

        @Override
        public String text() {
            return Lang._t("Save_", new Object[0]);
        }

        @Override
        public String fileSelectionText() {
            return Lang._t("Save", new Object[0]);
        }

        @Override
        public String initialInput() {
            return AGame.makeFileSafe(this.ship().getName());
        }

        private Airship ship() {
            return ((SingleShipIntent)((Object)this.us.intent)).getShip(this.us);
        }

        @Override
        public void fileSelected(String path) {
            this.g.s = this.us;
            try {
                this.ship().setName(FileScreen.getDefaultDisplayName(path, this.backend));
                FileUtils.write((File)this.backend.getFile(FileScreen.splitPath(path)), (CharSequence)this.ship().toJSON(null).toString(4), (String)"UTF-8");
                ((SingleShipIntent)((Object)this.us.intent)).justSaved(this.us);
                Analytics.shipSave(this.ship().type);
            }
            catch (Exception e) {
                long space = -1L;
                try {
                    space = FileSystemUtils.freeSpaceKb((String)this.backend.getFile(FileScreen.splitPath(path)).getAbsolutePath(), (long)3000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (space != -1L && space < 10240L) {
                    this.g.showError(Lang._t("Insufficient_space_on_disk", new Object[0]));
                }
                this.g.reportError(Lang._t("Unable_to_save_ship_or_building", new Object[0]), e, null, false);
            }
        }

        @Override
        public void cancelled() {
            this.g.s = this.us;
        }
    }
}

