/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.City;
import com.zarkonnen.airships.Empire;
import com.zarkonnen.airships.MapLocation;
import com.zarkonnen.airships.MonsterNest;
import com.zarkonnen.airships.ShapeUtils;
import com.zarkonnen.airships.WorldMap;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONObject;

public strictfp class Road {
    public MapLocation src;
    public MapLocation dst;
    public boolean seaRoute;
    public ArrayList<int[]> intPath = new ArrayList();
    public ArrayList<ShapeUtils.P> path = new ArrayList();
    public transient ArrayList<HashMap<Road, Integer>> overlaps = new ArrayList();
    public transient int hopDist;

    public Road(MapLocation src, MapLocation dst) {
        this.src = src;
        this.dst = dst;
    }

    public Road(JSONObject o, WorldMap wm) {
        int i;
        this.seaRoute = o.getBoolean("seaRoute");
        this.src = o.has("srcEmpire") ? (MapLocation)wm.empires.get((int)o.getInt((String)"srcEmpire")).cities.get(o.getInt("srcIndex")) : (MapLocation)wm.nests.get(o.getInt("srcNest"));
        this.dst = o.has("dstEmpire") ? (MapLocation)wm.empires.get((int)o.getInt((String)"dstEmpire")).cities.get(o.getInt("dstIndex")) : (MapLocation)wm.nests.get(o.getInt("dstNest"));
        JSONArray pathA = o.getJSONArray("path");
        for (i = 0; i < pathA.length(); i += 2) {
            this.path.add(new ShapeUtils.P(pathA.getDouble(i), pathA.getDouble(i + 1)));
        }
        pathA = o.getJSONArray("intPath");
        for (i = 0; i < pathA.length(); i += 2) {
            this.intPath.add(new int[]{pathA.getInt(i), pathA.getInt(i + 1)});
        }
    }

    public JSONObject toJSON(WorldMap wm) {
        JSONObject o = new JSONObject().put("seaRoute", this.seaRoute);
        if (this.src instanceof City) {
            Empire srcOwner = wm.owner((City)this.src);
            o.put("srcEmpire", wm.empires.indexOf(srcOwner));
            o.put("srcIndex", srcOwner.cities.indexOf(this.src));
        } else if (this.src instanceof MonsterNest) {
            o.put("srcNest", wm.nests.indexOf(this.src));
        }
        if (this.dst instanceof City) {
            Empire dstOwner = wm.owner((City)this.dst);
            o.put("dstEmpire", wm.empires.indexOf(dstOwner));
            o.put("dstIndex", dstOwner.cities.indexOf(this.dst));
        } else if (this.dst instanceof MonsterNest) {
            o.put("dstNest", wm.nests.indexOf(this.dst));
        }
        JSONArray pathA = new JSONArray();
        o.put("path", pathA);
        for (ShapeUtils.P p : this.path) {
            pathA.put(p.x).put(p.y);
        }
        pathA = new JSONArray();
        o.put("intPath", pathA);
        for (int[] nArray : this.intPath) {
            pathA.put(nArray[0]).put(nArray[1]);
        }
        return o;
    }

    public String toString() {
        return this.src.getDisplayName() + " " + (this.seaRoute ? "~" : "-") + this.path.size() + (this.seaRoute ? "~" : "-") + "> " + this.dst.getDisplayName();
    }
}

