/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.CampaignWorld;
import com.zarkonnen.airships.FileScreen;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MetaLobbyScreen;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.json.JSONObject;

public strictfp class ResumeConquestMission
implements FileScreen.Mission {
    private final AirshipGame g;
    private final FileScreen.Backend backend;
    private final MetaLobbyScreen mls;

    public ResumeConquestMission(AirshipGame g, FileScreen.Backend backend, MetaLobbyScreen mls) {
        this.g = g;
        this.backend = backend;
        this.mls = mls;
    }

    @Override
    public FileScreen.Mode mode() {
        return FileScreen.Mode.OPEN;
    }

    @Override
    public String text() {
        return Lang._t("Open_save_", new Object[0]);
    }

    @Override
    public String fileSelectionText() {
        return Lang._t("Open", new Object[0]);
    }

    @Override
    public String initialInput() {
        return "";
    }

    private void setup(JSONObject gameData) {
        this.mls.prepareForResumingConquestGame(gameData);
        this.g.s = this.mls;
    }

    @Override
    public void fileSelected(String path) {
        Object r = null;
        int retry = 0;
        while (true) {
            try {
                JSONObject o = new JSONObject(FileUtils.readFileToString((File)this.backend.getFile(FileScreen.splitPath(path)), (String)"UTF-8"));
                int version = o.optInt("version", 0);
                if (!CampaignWorld.READABLE_VERSIONS.contains(version)) {
                    this.g.showError(Lang._t("Save_out_of_date", new Object[0]));
                    this.g.s = this.mls;
                    return;
                }
                this.setup(o);
            }
            catch (Exception e) {
                if (retry++ < 3) continue;
                this.g.showError(Lang._t("Unable_to_load_game", new Object[0]));
                this.g.s = this.mls;
                return;
            }
            break;
        }
    }

    @Override
    public void cancelled() {
        this.g.s = this.mls;
    }
}

