/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.City;
import com.zarkonnen.airships.CoatOfArms;
import com.zarkonnen.airships.EspionageIntent;
import com.zarkonnen.airships.Fleet;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.PlaceShipTool;
import com.zarkonnen.airships.ScrollBar;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Hooks;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;
import java.util.ArrayList;
import org.newdawn.slick.Color;

public strictfp class ReservePanel
implements UniScreen.InfoPanel {
    public boolean visible = false;
    public boolean snapOpen = true;
    public boolean leftSide = false;
    public int width = 0;
    private final ScrollBar reserveScrollBar = new ScrollBar();
    private UniScreen us;
    private CoatOfArms coa;
    private final ReserveAdapter reserveAdapter = new ReserveAdapter();

    @Override
    public void draw(MyDraw d, Pt cursor, ScreenMode sm, Hooks hs, UniScreen us) {
        int x;
        this.us = us;
        if (us.hideUI) {
            return;
        }
        if (this.visible) {
            this.snapOpen = false;
        }
        if (!this.visible && !this.snapOpen) {
            return;
        }
        ArrayList<Object> reserve = new ArrayList();
        this.coa = null;
        if (us.mySide != null) {
            reserve = us.mySide.reserve;
            this.coa = us.mySide.arms;
        } else if (us.wm != null) {
            Fleet fl = us.wm.getGarrison(us.city);
            if (fl != null) {
                reserve = fl.reserve;
            }
            this.coa = us.wm.owner((City)us.city).arms;
        }
        if (this.coa == null) {
            return;
        }
        if (!reserve.isEmpty() && this.snapOpen) {
            this.visible = true;
            this.snapOpen = false;
        }
        if (!this.visible) {
            return;
        }
        this.leftSide = us.mySide != null && us.combat.sides.indexOf(us.mySide) == 0;
        this.width = StrictMath.max(150, sm.width / 4);
        if (us.tool instanceof PlaceShipTool) {
            return;
        }
        int y = MyDraw.TOP_BAR_H;
        int height = sm.height - y;
        int n = x = this.leftSide ? 0 : sm.width - this.width;
        if (this.leftSide) {
            d.drawLeftSideWindow(sm, this.width, y);
        } else {
            d.drawRightSideWindow(sm, sm.width - this.width, y);
        }
        this.reserveScrollBar.draw(d, x += MyDraw.WINDOW_INSET, y += MyDraw.WINDOW_INSET, this.width - MyDraw.WINDOW_INSET * 2, height -= MyDraw.WINDOW_INSET * 2, reserve, this.reserveAdapter);
    }

    public void add(UniScreen us, Airship ship) {
        us.tool = us.combat != null ? new PlaceShipTool(ship, us.mySide, us.combat.sides.indexOf(us.mySide), true) : new PlaceShipTool(ship, true);
    }

    @Override
    public void tick(Input in, int ms, UniScreen us) {
        if (!this.visible || us.hideUI) {
            return;
        }
        this.leftSide = us.mySide != null && us.combat.sides.indexOf(us.mySide) == 0;
        ScreenMode sm = in.mode();
        this.width = sm.width / 4;
        if (us.tool instanceof PlaceShipTool) {
            return;
        }
        int y = MyDraw.TOP_BAR_H;
        int height = sm.height - y;
        int x = this.leftSide ? 0 : sm.width - this.width;
        this.reserveScrollBar.tick(in, x += MyDraw.WINDOW_INSET, y += MyDraw.WINDOW_INSET, this.width - MyDraw.WINDOW_INSET * 2, height -= MyDraw.WINDOW_INSET * 2);
    }

    @Override
    public boolean chatEnabled(UniScreen us) {
        return false;
    }

    @Override
    public boolean doScroll(UniScreen us, int scrollAmt, Pt cursor, ScreenMode sm) {
        if (us.hideUI || !this.visible) {
            return false;
        }
        boolean bl = this.leftSide = us.mySide != null && us.combat.sides.indexOf(us.mySide) == 0;
        return this.leftSide ? cursor.x <= (double)this.width : cursor.x >= (double)(sm.width - this.width);
    }

    @Override
    public boolean arrowKeysInUse(UniScreen us) {
        return false;
    }

    private strictfp class ReserveAdapter
    implements ScrollBar.ScrollElementAdapter<Airship> {
        private ReserveAdapter() {
        }

        @Override
        public int getHeight(Airship t, MyDraw d, int availableWidth) {
            if (((ReservePanel)ReservePanel.this).us.intent instanceof EspionageIntent) {
                return availableWidth + MyDraw.UI_SPACING + AGame.FOUNT.lineHeight + MyDraw.SCROLL_EL_SPACING;
            }
            return availableWidth + MyDraw.UI_SPACING + AGame.FOUNT.lineHeight + MyDraw.BUTTON_SPACING + MyDraw.BUTTON_H + MyDraw.SCROLL_EL_SPACING;
        }

        @Override
        public void draw(final Airship ship, MyDraw d, int x, int y, int width) {
            double scale = StrictMath.min((double)width * 1.0 / (double)ship.getWidth() / 16.0, (double)width * 1.0 / (double)ship.getHeight() / 16.0);
            d.shift(x, y);
            d.scale(scale, scale);
            ship.draw(d, (double)width / scale / 2.0 - (double)(ship.getWidth() * 16 / 2), (double)width / scale / 2.0 - (double)(ship.getHeight() * 16 / 2), 0, true, false, true, ReservePanel.this.coa, true, null, 1.0f, Color.white, 1.0f, Clr.WHITE);
            d.resetTransforms();
            d.text(ship.getName(), AGame.FOUNT, x, y += width + MyDraw.UI_SPACING);
            y += AGame.FOUNT.lineHeight + MyDraw.BUTTON_SPACING;
            if (!(((ReservePanel)ReservePanel.this).us.intent instanceof EspionageIntent)) {
                d.button(x, y, 130, Lang._t("Activate", new Object[0]), new Runnable(){

                    @Override
                    public void run() {
                        ReservePanel.this.add(ReservePanel.this.us, ship);
                    }
                });
                d.tooltip((double)x, (double)y, 130.0, (double)MyDraw.BUTTON_H, Lang._t("Move_ship_into_the_combat_area", new Object[0]));
            }
        }
    }
}

