/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.Appearance;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.ShipNameDialog;
import com.zarkonnen.airships.StrategicScreen;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Hooks;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;

public strictfp class RenameShipPanel
implements UniScreen.InfoPanel {
    private ShipNameDialog snd = null;

    public void doRename(final Airship ship, final StrategicScreen ss, final Runnable ok, final Runnable cancel) {
        this.snd = new ShipNameDialog(ss.w, ship, ss.w.player, new ShipNameDialog.ShipNameCallback(){

            @Override
            public void run(String newName, int n) {
                ss.w.giveCommand(ss.w.shipMsg("renameShip", ship).put("newName", newName));
                RenameShipPanel.this.snd = null;
                ok.run();
            }

            @Override
            public boolean canHaveMultiple() {
                return false;
            }

            @Override
            public boolean multipleAllowed(int n) {
                return n == 1;
            }
        }, new Runnable(){

            @Override
            public void run() {
                RenameShipPanel.this.snd = null;
                cancel.run();
            }
        });
    }

    @Override
    public void draw(MyDraw d, Pt cursor, ScreenMode sm, Hooks hs, UniScreen us) {
        if (this.snd == null) {
            return;
        }
        String currentPostfix = Appearance.currentPostfix;
        if (!currentPostfix.equals("DAY")) {
            Appearance.switchSpritesheet("DAY");
        }
        this.snd.render(d, sm, d.hs, cursor);
        if (!currentPostfix.equals(Appearance.currentPostfix)) {
            Appearance.switchSpritesheet(currentPostfix);
        }
    }

    @Override
    public void tick(Input in, int ms, UniScreen us) {
        if (this.snd == null) {
            return;
        }
        this.snd.input(in, null, in.cursor(), in.clicked(), ms);
    }

    @Override
    public boolean chatEnabled(UniScreen us) {
        return this.snd != null;
    }

    @Override
    public boolean doScroll(UniScreen us, int scrollAmt, Pt cursor, ScreenMode sm) {
        return this.snd != null;
    }

    @Override
    public boolean arrowKeysInUse(UniScreen us) {
        return this.snd != null;
    }
}

