/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.City;
import com.zarkonnen.airships.ConstructionBackend;
import com.zarkonnen.airships.FileScreen;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.Loadable;
import com.zarkonnen.airships.StrategicScreen;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.json.JSONObject;

public strictfp class RefitShipMission
implements FileScreen.Mission {
    private final AirshipGame g;
    private final StrategicScreen ss;
    private final Airship original;
    private final ConstructionBackend backend;
    private final City c;

    public RefitShipMission(AirshipGame g, StrategicScreen ss, Airship original, City c, ConstructionBackend backend) {
        this.g = g;
        this.ss = ss;
        this.original = original;
        this.backend = backend;
        this.c = c;
    }

    @Override
    public FileScreen.Mode mode() {
        return FileScreen.Mode.OPEN;
    }

    @Override
    public String text() {
        return Lang._t("Select_ship_design_to_build", new Object[0]);
    }

    @Override
    public String fileSelectionText() {
        return Lang._t("Refit", new Object[0]);
    }

    @Override
    public String initialInput() {
        return "";
    }

    @Override
    public void fileSelected(String path) {
        this.g.s = this.ss;
        try {
            Airship a = new Airship(new JSONObject(FileUtils.readFileToString((File)this.backend.getFile(FileScreen.splitPath(path)), (String)"UTF-8")));
            a.setFlipped(true, null);
            this.ss.rebuild(this.c, this.original, a);
        }
        catch (Loadable.NotFoundException e) {
            this.g.showError(e.getMessage());
        }
        catch (Exception e) {
            this.g.reportError(Lang._t("Unable_to_load_ship_or_building", new Object[0]), e, null, false);
        }
    }

    @Override
    public void cancelled() {
        this.g.s = this.ss;
    }
}

