/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.CrewType;
import com.zarkonnen.airships.Crewman;
import com.zarkonnen.airships.ExceptionalCombatEvent;
import com.zarkonnen.airships.Loadable;
import com.zarkonnen.catengine.Img;
import org.json.JSONArray;
import org.json.JSONObject;

public class PortraitMessageType
extends Loadable {
    public String eventInfoPrefix;
    public Img[] messageImages;
    public CrewType victimCrewType;
    public CrewType observingCrewType;
    public boolean observerInSameShip;
    public int maxDistanceSq;
    public int numberOfMessages;
    public double minZoom;
    public double maxZoom;

    public PortraitMessageType(JSONObject o) {
        super(o.getString("name"), o.getString("eventInfoPrefix").length());
        this.eventInfoPrefix = o.getString("eventInfoPrefix");
        JSONArray a = o.getJSONArray("messageImages");
        this.messageImages = new Img[a.length()];
        for (int i = 0; i < a.length(); ++i) {
            this.messageImages[i] = new Img(a.getString(i));
        }
        if (o.has("victimCrewType")) {
            this.victimCrewType = CrewType.ofName(o.getString("victimCrewType"));
        }
        if (o.has("observingCrewType")) {
            this.observingCrewType = CrewType.ofName(o.getString("observingCrewType"));
        }
        this.observerInSameShip = o.optBoolean("observerInSameShip", false);
        this.maxDistanceSq = o.optInt("maxDistance", 0) * o.optInt("maxDistance", 0);
        this.numberOfMessages = this.messageImages.length;
        this.minZoom = o.optDouble("minZoom", 1.0E-4);
        this.maxZoom = o.optDouble("maxZoom", 10000.0);
    }

    public boolean matchesNoObserverNeeded(ExceptionalCombatEvent e) {
        return this.victimCrewType == null || this.victimCrewType == e.victimType;
    }

    public boolean matches(ExceptionalCombatEvent e, Crewman observer, double crewX, double crewY, Airship observerShip) {
        if (this.observingCrewType != observer.type) {
            return false;
        }
        if (this.victimCrewType != null && this.victimCrewType != e.victimType) {
            return false;
        }
        if (this.observerInSameShip && (e.withinShip == null || observerShip == null || e.withinShip != observerShip)) {
            return false;
        }
        return this.maxDistanceSq == 0 || (e.x - crewX) * (e.x - crewX) + (e.y - crewY) * (e.y - crewY) > (double)this.maxDistanceSq;
    }

    public static PortraitMessageType ofName(String name) {
        return Loadable.ofName(PortraitMessageType.class, name);
    }
}

