/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.ChallengeCombatIntent;
import com.zarkonnen.airships.CommandButtonsPanel;
import com.zarkonnen.airships.Crewman;
import com.zarkonnen.airships.ExceptionalCombatEvent;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.Loadable;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.PortraitMessageType;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Fount;
import com.zarkonnen.catengine.Hooks;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;
import java.util.ArrayList;
import java.util.HashSet;

public class PortraitMessagePanel
implements UniScreen.InfoPanel {
    public static final int COOLDOWN = 6000;
    public static final int INTERVAL = 500;
    public HashSet<PortraitMessageType> used = new HashSet();
    public PortraitMessageType currentMsg;
    public int messageVariant;
    public int cooldown = -500;
    public String relatedShipName = "?";
    public String relatedWeaponName = "?";

    @Override
    public void draw(MyDraw d, Pt cursor, ScreenMode sm, Hooks hs, UniScreen us) {
        if (us.combat == null) {
            return;
        }
        if (this.cooldown <= 0) {
            return;
        }
        if (us.hideUI) {
            return;
        }
        if (us.intent instanceof ChallengeCombatIntent) {
            return;
        }
        int x = MyDraw.SIDE_CLEARANCE;
        CommandButtonsPanel cbp = us.panel(CommandButtonsPanel.class);
        int w = sm.width / 2 - cbp.panelW / 2 - x - MyDraw.UI_SPACING;
        int h = 150;
        int y = sm.height - h - MyDraw.SIDE_CLEARANCE;
        int minW = (int)d.textSize((String)"Mene mene tekel upharsin!", (Fount)AGame.FOUNT).x + 150 + MyDraw.BUTTON_SPACING;
        if (w < minW) {
            w = minW;
            y = sm.height - cbp.panelH - MyDraw.UI_SPACING - h;
        }
        d.blit(this.currentMsg.messageImages[this.messageVariant], x + 1, y + 1, h - 2, h - 2);
        d.drawPanelBorder(x, y, h, h);
        String text = Lang._t(this.currentMsg.name + this.messageVariant, AGame.makeFileSafe(this.relatedShipName), this.relatedWeaponName);
        int panelH = (int)d.textSize((String)text, (Fount)AGame.FOUNT, (double)((double)(x += h + MyDraw.BUTTON_SPACING)), (double)((double)y), (int)((w -= h + MyDraw.BUTTON_SPACING) - MyDraw.PANEL_INSET * 2)).height + MyDraw.PANEL_INSET * 2;
        d.drawPanel(x, y, w, panelH);
        d.text(text, AGame.FOUNT, x + MyDraw.PANEL_INSET, y + MyDraw.PANEL_INSET, w - MyDraw.PANEL_INSET * 2);
    }

    @Override
    public void tick(Input in, int ms, UniScreen us) {
        if (us.intent instanceof ChallengeCombatIntent) {
            return;
        }
        if (us.combat != null) {
            this.cooldown -= ms;
            if (this.cooldown > -500) {
                return;
            }
            double zoom = us.zoom;
            ScreenMode sm = in.mode();
            double top = us.screenToWorldY((double)sm.height * 0.15);
            double bottom = us.screenToWorldY((double)sm.height * 0.85);
            double left = us.screenToWorldX((double)sm.width * 0.15);
            double right = us.screenToWorldX((double)sm.width * 0.85);
            ArrayList<PortraitMessageType> pmts = Loadable.all(PortraitMessageType.class);
            block0: for (ExceptionalCombatEvent e : us.combat.exceptionalCombatEvents) {
                if (e.side != us.mySide || e.x < left || e.x > right || e.y < top || e.y > bottom) continue;
                for (PortraitMessageType pmt : pmts) {
                    if (!e.info.startsWith(pmt.eventInfoPrefix) || zoom > pmt.maxZoom || zoom < pmt.minZoom || this.used.contains(pmt)) continue;
                    if (pmt.observingCrewType == null) {
                        if (!pmt.matchesNoObserverNeeded(e)) continue;
                        this.currentMsg = pmt;
                        this.messageVariant = pmt.numberOfMessages > 1 ? AGame.ANIM_R.nextInt(pmt.numberOfMessages) : 0;
                        this.used.add(pmt);
                        this.cooldown = 6000;
                        if (e.withinShip != null) {
                            this.relatedShipName = e.withinShip.getName();
                        }
                        if (e.weapon == null) break block0;
                        this.relatedWeaponName = e.weapon.getName().toLowerCase(Lang.currentLocale);
                        break block0;
                    }
                    for (Airship s : us.mySide.ships) {
                        if (pmt.observerInSameShip && e.withinShip != s) continue;
                        for (Crewman obs : s.crew) {
                            double cy;
                            double cx;
                            if (!obs.alive() || !pmt.matches(e, obs, cx = s.getX() + (double)(s.gridXToWorldX(obs.currentTile.x, 1) * 16), cy = s.getY() + (double)(obs.currentTile.y * 16), s)) continue;
                            this.currentMsg = pmt;
                            this.messageVariant = pmt.numberOfMessages > 1 ? AGame.ANIM_R.nextInt(pmt.numberOfMessages) : 0;
                            this.used.add(pmt);
                            this.cooldown = 6000;
                            if (e.withinShip != null) {
                                this.relatedShipName = e.withinShip.getName();
                            }
                            if (e.weapon != null) {
                                this.relatedWeaponName = e.weapon.getName().toLowerCase(Lang.currentLocale);
                            }
                            obs.doShoutExplicitString(Lang._t(pmt.name + this.messageVariant, new Object[0]));
                            break block0;
                        }
                    }
                }
            }
            us.combat.exceptionalCombatEvents.clear();
        }
    }

    @Override
    public boolean chatEnabled(UniScreen us) {
        return false;
    }

    @Override
    public boolean doScroll(UniScreen us, int scrollAmt, Pt cursor, ScreenMode sm) {
        return false;
    }

    @Override
    public boolean arrowKeysInUse(UniScreen us) {
        return false;
    }
}

