/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.CampaignCombatIntent;
import com.zarkonnen.airships.CampaignWorld;
import com.zarkonnen.airships.Client;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.CombatIntent;
import com.zarkonnen.airships.CommandButtonsPanel;
import com.zarkonnen.airships.Compression;
import com.zarkonnen.airships.DefencesIntent;
import com.zarkonnen.airships.EditMissionIntent;
import com.zarkonnen.airships.Fleet;
import com.zarkonnen.airships.Keys;
import com.zarkonnen.airships.LandFormation;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MapLocation;
import com.zarkonnen.airships.MultiplayerCampaignCombatIntent;
import com.zarkonnen.airships.MultiplayerCampaignCombatSetupIntent;
import com.zarkonnen.airships.MultiplayerSetupIntent;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.Rect2D;
import com.zarkonnen.airships.RestrictsShipPlacement;
import com.zarkonnen.airships.ShipArrayList;
import com.zarkonnen.airships.ShipList;
import com.zarkonnen.airships.ShipType;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;
import com.zarkonnen.catengine.util.Utils;
import org.json.JSONObject;

public strictfp class PlaceShipTool
extends UniScreen.Tool {
    public Airship shipToPlace;
    public boolean cancelPutsBack;
    public boolean flipped;
    public boolean autoFlipped = false;
    public boolean autoFlipInited = false;
    public int sideIndex;
    public Combat.Side side;
    public boolean forConstruction;
    public boolean fromReserve;
    public boolean ignoreServiceCeiling;
    public LandFormation landscapedGround;
    public boolean multiPlace;
    public static final int EITHER_SIDE = -1;

    @Override
    public String getLabel() {
        return Lang._t("Add_" + this.shipToPlace.type.name(), new Object[0]);
    }

    public PlaceShipTool(Airship shipToPlace, boolean cancelPutsBack, int sideIndex, boolean ignoreServiceCeiling) {
        this.shipToPlace = shipToPlace;
        this.cancelPutsBack = cancelPutsBack;
        this.sideIndex = sideIndex;
        this.ignoreServiceCeiling = ignoreServiceCeiling;
        this.flipped = shipToPlace.flipped;
    }

    public PlaceShipTool(Airship shipToPlace, boolean cancelPutsBack, Combat.Side side, int sideIndex) {
        this.shipToPlace = shipToPlace;
        this.cancelPutsBack = cancelPutsBack;
        this.side = side;
        this.sideIndex = sideIndex;
        this.flipped = shipToPlace.flipped;
    }

    public PlaceShipTool(Airship shipToPlace, boolean cancelPutsBack, Combat.Side side, int sideIndex, boolean forConstruction) {
        this.shipToPlace = shipToPlace;
        this.cancelPutsBack = cancelPutsBack;
        this.side = side;
        this.sideIndex = sideIndex;
        this.forConstruction = forConstruction;
        this.flipped = shipToPlace.flipped;
    }

    public PlaceShipTool(Airship shipToPlace, boolean fromReserve) {
        this.shipToPlace = shipToPlace;
        this.fromReserve = fromReserve;
        this.flipped = shipToPlace.flipped;
    }

    public PlaceShipTool(Airship shipToPlace, Combat.Side side, int sideIndex, boolean fromReserve) {
        this.shipToPlace = shipToPlace;
        this.fromReserve = fromReserve;
        this.side = side;
        this.sideIndex = sideIndex;
        this.flipped = shipToPlace.flipped;
    }

    public static boolean intersects(Airship shipToPlace, double x, double y, LandFormation lf) {
        if (!Rect2D.intersects(x, y, shipToPlace.getBBWidth(), shipToPlace.getBBHeight(), lf.getX(), lf.getY(), lf.getBBWidth(), lf.getBBHeight())) {
            return false;
        }
        double ox = shipToPlace.getX();
        double oy = shipToPlace.getY();
        shipToPlace.setX(x);
        shipToPlace.setY(y);
        boolean iSects = shipToPlace.overlapsWith(lf, false);
        shipToPlace.setX(ox);
        shipToPlace.setY(oy);
        return iSects;
    }

    public static boolean intersects(Airship shipToPlace, double x, double y, Airship ship2) {
        if (!Rect2D.intersects(x, y, shipToPlace.getBBWidth(), shipToPlace.getBBHeight(), ship2.getX(), ship2.getY(), ship2.getBBWidth(), ship2.getBBHeight())) {
            return false;
        }
        double ox = shipToPlace.getX();
        double oy = shipToPlace.getY();
        shipToPlace.setX(x);
        shipToPlace.setY(y);
        boolean iSects = shipToPlace.overlapsWith(ship2);
        shipToPlace.setX(ox);
        shipToPlace.setY(oy);
        return iSects;
    }

    public static boolean canPlace(Airship shipToPlace, double x, double y, boolean flipped, Combat c, boolean ignoreServiceCeiling, LandFormation landscaped, int sideToRestrictTo) {
        if (landscaped == null) {
            y = PlaceShipTool.getPlacement((Airship)shipToPlace, (double)x, (double)y, (boolean)flipped, (LandFormation)c.landFormations.get((int)0), (ShipList)c, (boolean)ignoreServiceCeiling, (int)sideToRestrictTo).y;
        }
        for (Combat.Side s : c.sides) {
            for (Airship ship : s.ships) {
                if (ship == shipToPlace || !PlaceShipTool.intersects(shipToPlace, x, y, ship)) continue;
                return false;
            }
        }
        for (LandFormation lf : c.landFormations) {
            if (lf == landscaped || !PlaceShipTool.intersects(shipToPlace, x, y, lf)) continue;
            return false;
        }
        return true;
    }

    public static boolean canPlace(Airship shipToPlace, double x, double y, boolean flipped, int sideIndex, UniScreen us, boolean ignoreServiceCeiling, LandFormation landscaped, int landscapeSideToRestrictTo) {
        block19: {
            block18: {
                if (landscaped == null) {
                    y = PlaceShipTool.getPlacement((Airship)shipToPlace, (double)x, (double)y, (boolean)flipped, (UniScreen)us, (boolean)ignoreServiceCeiling).y;
                }
                if (us.intent instanceof RestrictsShipPlacement) {
                    if (sideIndex == -1) {
                        boolean allowed = false;
                        for (int si = 0; si < 2; ++si) {
                            Rect2D r = ((RestrictsShipPlacement)((Object)us.intent)).placementLimits(si, us);
                            if (r != null && !r.contains(x, y, shipToPlace.getBBWidth(), shipToPlace.getBBHeight())) continue;
                            allowed = true;
                        }
                        if (!allowed) {
                            return false;
                        }
                    } else {
                        Rect2D r = ((RestrictsShipPlacement)((Object)us.intent)).placementLimits(sideIndex, us);
                        if (r != null && !r.contains(x, y, shipToPlace.getBBWidth(), shipToPlace.getBBHeight())) {
                            return false;
                        }
                    }
                }
                if (us.combat != null) {
                    return PlaceShipTool.canPlace(shipToPlace, x, y, flipped, us.combat, ignoreServiceCeiling, landscaped, landscapeSideToRestrictTo);
                }
                if (us.city == null) break block18;
                for (Airship bld : us.city.getDefences()) {
                    if (bld == shipToPlace || !PlaceShipTool.intersects(shipToPlace, x, y, bld)) continue;
                    return false;
                }
                for (MapLocation.ConstructionEntry ce : us.city.constructing) {
                    Airship c = ce.ship;
                    if (c == shipToPlace || !PlaceShipTool.intersects(shipToPlace, x, y, c)) continue;
                    return false;
                }
                Fleet garrison = us.wm.getGarrison(us.city);
                if (garrison != null) {
                    for (Airship ship : garrison.actives) {
                        if (ship == shipToPlace || !PlaceShipTool.intersects(shipToPlace, x, y, ship)) continue;
                        return false;
                    }
                }
                if (shipToPlace.canFly() && Rect2D.intersects(x, y, shipToPlace.getBBWidth(), shipToPlace.getBBHeight(), us.city.ground.getX(), us.city.ground.getY(), us.city.ground.getBBWidth(), us.city.ground.getBBHeight())) {
                    return false;
                }
                for (LandFormation lf : us.city.floaters) {
                    if (!PlaceShipTool.intersects(shipToPlace, x, y, lf)) continue;
                    return false;
                }
                break block19;
            }
            if (us.setupFleet == null) break block19;
            for (Airship ship : us.setupFleet) {
                if (ship == shipToPlace || !PlaceShipTool.intersects(shipToPlace, x, y, ship)) continue;
                return false;
            }
            if (us.setupGround != null && landscaped != us.setupGround && shipToPlace.canFly() && PlaceShipTool.intersects(shipToPlace, x, y, us.setupGround)) {
                return false;
            }
            if (us.setupFloaters != null) {
                for (LandFormation lf : us.setupFloaters) {
                    if (!PlaceShipTool.intersects(shipToPlace, x, y, lf)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private void placeShip(Placement pl, UniScreen us, Input in) {
        double volume = StrictMath.max(0.1, StrictMath.min(1.0, (double)this.shipToPlace.getWeight() / 5000.0));
        in.play("place", 1.0 / volume, volume * us.g.volume, 0.0, 0.0);
        if (us.intent instanceof MultiplayerCampaignCombatSetupIntent || us.intent instanceof MultiplayerCampaignCombatIntent) {
            us.combat.giveCommand(Client.msg("placeShip").put("side", us.combat.sides.indexOf(us.mySide)).put("ship", pl.shipToPlace.networkID).put("x", pl.x).put("y", pl.y).put("flipped", pl.flipped));
            return;
        }
        if (us.intent instanceof DefencesIntent) {
            CampaignWorld w = ((DefencesIntent)us.intent).ss.w;
            if (this.forConstruction) {
                if (this.cancelPutsBack) {
                    JSONObject msg = w.shipMsg("placeConstructionShip", pl.shipToPlace).put("city", us.city.id).put("x", pl.x).put("y", pl.y).put("flipped", pl.flipped);
                    if (pl.landscapeTarget != null) {
                        msg.put("landscapeGY", pl.landscapeGY);
                        msg.put("landscapeCost", pl.landscapeCost);
                    }
                    w.giveCommand(msg);
                } else {
                    pl.shipToPlace.setX(pl.x);
                    pl.shipToPlace.setY(pl.y);
                    pl.shipToPlace.moveTo = new Pt(pl.x, pl.y);
                    pl.shipToPlace.setFlipped(pl.flipped, null);
                    pl.shipToPlace.flipTo = pl.flipped;
                    pl.shipToPlace.lastPlaced = new Pt(pl.x, pl.y);
                    pl.shipToPlace.lastPlacedFlipped = pl.flipped;
                    JSONObject msg = Client.msg("buildShip").put("ship", Compression.compressToString(pl.shipToPlace.toJSON(null).toString())).put("city", us.city.id);
                    if (pl.landscapeTarget != null) {
                        msg.put("landscapeGY", pl.landscapeGY);
                        msg.put("landscapeCost", pl.landscapeCost);
                    }
                    if (!w.giveCommandWithSizeCheck(msg)) {
                        us.g.showError(Lang._t("sent_construction_too_large", new Object[0]));
                        return;
                    }
                }
            } else {
                JSONObject msg = w.shipMsg("placeDefencesShip", pl.shipToPlace).put("city", us.city.id).put("x", pl.x).put("y", pl.y).put("flipped", pl.flipped);
                if (pl.landscapeTarget != null) {
                    msg.put("landscapeGY", pl.landscapeGY);
                    msg.put("landscapeCost", pl.landscapeCost);
                }
                w.giveCommand(msg);
            }
            return;
        }
        pl.shipToPlace.setX(pl.x);
        pl.shipToPlace.setY(pl.y);
        pl.shipToPlace.moveTo = new Pt(pl.x, pl.y);
        pl.shipToPlace.setFlipped(pl.flipped, null);
        pl.shipToPlace.flipTo = pl.flipped;
        pl.shipToPlace.lastPlaced = new Pt(pl.x, pl.y);
        pl.shipToPlace.lastPlacedFlipped = pl.flipped;
        pl.shipToPlace.resetWeaponBarrels();
        if (us.intent instanceof EditMissionIntent) {
            ((EditMissionIntent)us.intent).modified();
        }
        if (pl.landscapeTarget != null) {
            pl.landscapeTarget.doLandscapingForBuilding(pl.shipToPlace, pl.x, pl.landscapeGY, pl.flipped);
        }
        if (us.combat != null) {
            pl.shipToPlace.initWheelsLegsAndTentacles(null, us.combat.landFormations, us.combat);
        }
        if (us.combat != null && (this.side != null || this.sideIndex == -1)) {
            Combat.Side targetSide = this.sideIndex == -1 ? us.combat.sides.get(pl.x < 0.0 ? 0 : 1) : this.side;
            Combat.Side sourceSide = us.combat.sideOf(this.shipToPlace);
            if (sourceSide != targetSide && sourceSide != null) {
                sourceSide.ships.remove(pl.shipToPlace);
            }
            if (sourceSide != null) {
                sourceSide.reserve.remove(pl.shipToPlace);
            }
            if (!targetSide.ships.contains(pl.shipToPlace)) {
                targetSide.ships.add(pl.shipToPlace);
            }
        } else if (us.city != null) {
            System.out.println("placing in non defences intent city???");
        } else if (us.setupFleet != null) {
            if (us.intent instanceof MultiplayerSetupIntent) {
                ((MultiplayerSetupIntent)us.intent).landscapingCost += pl.landscapeCost;
            } else {
                throw new RuntimeException("setupfleet but no MPSI");
            }
            if (us.setupGround == null || us.setupFloaters == null) {
                return;
            }
            pl.shipToPlace.initWheelsLegsAndTentacles(us.setupGround, us.setupFloaters, new ShipArrayList(us.setupFleet));
            if (!us.setupFleet.contains(pl.shipToPlace)) {
                us.setupFleet.add(pl.shipToPlace);
            }
        }
    }

    public static Placement getPlacement(Airship shipToPlace, double x, double y, boolean flipped, UniScreen us, boolean ignoreServiceCeiling) {
        int sideToRestrictTo = -1;
        if (us.combat != null) {
            sideToRestrictTo = us.combat.sides.indexOf(us.mySide);
            return PlaceShipTool.getPlacement(shipToPlace, x, y, flipped, us.combat.landFormations.get(0), us.combat, ignoreServiceCeiling, sideToRestrictTo);
        }
        if (us.city != null) {
            sideToRestrictTo = 1;
            ShipArrayList l = new ShipArrayList(us.city.getDefences());
            for (MapLocation.ConstructionEntry ce : us.city.constructing) {
                l.add(ce.ship);
            }
            l.remove(shipToPlace);
            return PlaceShipTool.getPlacement(shipToPlace, x, y, flipped, us.city.ground, l, ignoreServiceCeiling, sideToRestrictTo);
        }
        if (us.setupGround != null) {
            if (us.intent instanceof MultiplayerSetupIntent) {
                sideToRestrictTo = ((MultiplayerSetupIntent)us.intent).flipped ? 1 : 0;
            }
            return PlaceShipTool.getPlacement(shipToPlace, x, y, flipped, us.setupGround, new ShipArrayList(us.setupFleet), ignoreServiceCeiling, sideToRestrictTo);
        }
        return PlaceShipTool.getPlacement(shipToPlace, x, y, flipped, null, null, ignoreServiceCeiling, sideToRestrictTo);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Placement getPlacement(Airship shipToPlace, double x, double y, boolean flipped, LandFormation ground, ShipList otherShips, boolean ignoreServiceCeiling, int sideToRestrictTo) {
        block6: {
            if (!shipToPlace.canFly()) {
                if (ground != null) {
                    if (shipToPlace.type.mobile) {
                        y = (double)ground.getVerticalPosition(shipToPlace, (int)x, flipped, false) - shipToPlace.groundOffset();
                        break block6;
                    } else {
                        Utils.Pair<Integer, Integer> gyAndCost = ground.getLandscapingPlacementGYandCost(shipToPlace, x, flipped, otherShips, sideToRestrictTo);
                        if (gyAndCost == null) {
                            y = 512.0 - shipToPlace.getBBHeight() - shipToPlace.groundOffset();
                            return new Placement(shipToPlace, x, y, flipped, false);
                        }
                        return new Placement(shipToPlace, x, ground.getY() + (double)(16 * (Integer)gyAndCost.a) - 1.0 - shipToPlace.getBBHeight(), flipped, ground, (Integer)gyAndCost.a, (Integer)gyAndCost.b, sideToRestrictTo);
                    }
                }
                y = 512.0 - shipToPlace.getBBHeight() - shipToPlace.groundOffset();
            }
        }
        if (shipToPlace.canFly() && !ignoreServiceCeiling) {
            y = StrictMath.max(y, (double)(512 - shipToPlace.availableServiceCeiling()));
        }
        return new Placement(shipToPlace, x, y, flipped);
    }

    @Override
    public void draw(MyDraw d, Pt cursor, ScreenMode sm, UniScreen us) {
        boolean canPlace;
        Rect2D limits = null;
        if (us.intent instanceof RestrictsShipPlacement) {
            limits = ((RestrictsShipPlacement)((Object)us.intent)).placementLimits(this.sideIndex, us);
        }
        double x = us.screenToWorldX(cursor.x);
        Placement pl = PlaceShipTool.getPlacement(this.shipToPlace, x, us.screenToWorldY(cursor.y), this.flipped ^ this.autoFlipped, us, this.ignoreServiceCeiling);
        double y = pl.y;
        if (this.fromReserve && (us.intent instanceof CampaignCombatIntent || us.intent instanceof MultiplayerCampaignCombatIntent)) {
            x = this.sideIndex == 0 ? -3200.0 : 3200.0 - this.shipToPlace.getBBWidth();
        }
        boolean bl = canPlace = pl.succeeded && PlaceShipTool.canPlace(this.shipToPlace, x, y, this.flipped ^ this.autoFlipped, this.sideIndex, us, this.ignoreServiceCeiling, pl.landscapeTarget, pl.landscapeSideToRestrictTo);
        if (this.shipToPlace.type == ShipType.BUILDING && canPlace && pl.landscapeTarget != null) {
            this.landscapedGround = pl.landscapeTarget.faithfulClone();
            this.landscapedGround.doLandscapingForBuilding(this.shipToPlace, pl.x, pl.landscapeGY, pl.flipped);
        } else {
            this.landscapedGround = null;
        }
        d.scale(us.zoom, us.zoom);
        d.shift(us.adjScrollX, us.adjScrollY);
        if (limits != null) {
            d.rect(Clr.WHITE, limits.x - 2.0, limits.y - 2.0, limits.w + 4.0, 2.0);
            d.rect(Clr.WHITE, limits.x - 2.0, limits.y + limits.h, limits.w + 4.0, 2.0);
            d.rect(Clr.WHITE, limits.x - 2.0, limits.y - 2.0, 2.0, limits.h + 4.0);
            d.rect(Clr.WHITE, limits.x + limits.w, limits.y - 2.0, 2.0, limits.h + 4.0);
        }
        this.shipToPlace.drawOutline(d, x, y, this.flipped ^ this.autoFlipped, canPlace ? Clr.WHITE : Clr.RED);
        if (pl.landscapeCost > 0) {
            d.state.cursorText = "[333333]$" + pl.landscapeCost;
            if (!us.textInputOccurring()) {
                d.state.cursorText = d.state.cursorText + "\n" + Lang._t("F_to_flip", new Object[0]) + "\n" + Lang._t("Press_x_to_cancel", "ESCAPE");
            }
        } else if (!us.textInputOccurring()) {
            d.state.cursorText = "[333333]" + Lang._t("F_to_flip", new Object[0]) + "\n" + Lang._t("Press_x_to_cancel", "ESCAPE");
        }
        d.resetTransforms();
        double sx = this.shipToPlace.getX();
        double sy = this.shipToPlace.getY();
        boolean sf = this.shipToPlace.flipped;
        this.shipToPlace.setX(x);
        this.shipToPlace.setY(y);
        this.shipToPlace.setFlipped(this.flipped ^ this.autoFlipped, null);
        this.shipToPlace.drawFireArcs(d, us.adjScrollX, us.adjScrollY, us.zoom, true);
        this.shipToPlace.setX(sx);
        this.shipToPlace.setY(sy);
        this.shipToPlace.setFlipped(sf, null);
        if (this.shipToPlace.canFly() && !this.ignoreServiceCeiling) {
            int sc = (int)us.worldToScreenY(512 - this.shipToPlace.serviceCeiling());
            d.rect(Clr.WHITE, 0.0, sc, sm.width, 2.0);
            d.rect(Clr.WHITE, 0.0, sc + 4, sm.width, 1.0);
            d.text(Lang._t("Service_Ceiling", new Object[0]), AGame.BIG_FOUNT, 5.0, sc - 20);
        }
    }

    @Override
    public boolean click(Input in, Pt click, ScreenMode sm, UniScreen us) {
        CommandButtonsPanel cbp = us.panel(CommandButtonsPanel.class);
        if (us.intent instanceof CombatIntent && click.x > (double)cbp.panelX && click.x < (double)(cbp.panelX + cbp.panelW) && click.y > (double)(sm.height - cbp.panelH)) {
            return false;
        }
        double x = us.screenToWorldX(click.x);
        if (this.fromReserve && (us.intent instanceof CampaignCombatIntent || us.intent instanceof MultiplayerCampaignCombatIntent)) {
            x = this.sideIndex == 0 ? -3200.0 : 3200.0 - this.shipToPlace.getBBWidth();
        }
        Airship multiPlaceShip = this.multiPlace ? this.shipToPlace.clone() : null;
        Placement pl = PlaceShipTool.getPlacement(this.shipToPlace, x, us.screenToWorldY(click.y), this.flipped ^ this.autoFlipped, us, this.ignoreServiceCeiling);
        double y = pl.y;
        if (pl.succeeded && PlaceShipTool.canPlace(this.shipToPlace, x, y, this.flipped ^ this.autoFlipped, this.sideIndex, us, this.ignoreServiceCeiling, pl.landscapeTarget, pl.landscapeSideToRestrictTo)) {
            this.placeShip(pl, us, in);
            if (this.multiPlace) {
                this.shipToPlace = multiPlaceShip;
                multiPlaceShip.repair();
            } else {
                us.tool = UniScreen.NAVIGATE;
            }
            return true;
        }
        return false;
    }

    public void cancel(UniScreen us, Input in) {
        if (this.cancelPutsBack) {
            this.placeShip(new Placement(this.shipToPlace, this.shipToPlace.getX(), this.shipToPlace.getY(), this.shipToPlace.flipped), us, in);
        }
        us.tool = UniScreen.NAVIGATE;
    }

    @Override
    public boolean rightClick(Input in, Pt click, ScreenMode sm, UniScreen us) {
        this.cancel(us, in);
        return true;
    }

    @Override
    public void tick(Input in, int ms, UniScreen us) {
        if (!us.textInputOccurring() && in.keyPressed(Keys.get("place_tool_flip", "F"))) {
            this.flipped = !this.flipped;
        }
        boolean bl = this.autoFlipped = this.sideIndex == -1 && us.screenToWorldX(in.cursor().x) > 0.0;
        if (!this.autoFlipInited) {
            if (this.autoFlipped) {
                this.flipped = !this.flipped;
            }
            this.autoFlipInited = true;
        }
        if (in.keyPressed("ESCAPE")) {
            if (this.cancelPutsBack) {
                this.placeShip(new Placement(this.shipToPlace, this.shipToPlace.getX(), this.shipToPlace.getY(), this.shipToPlace.flipped), us, in);
            }
            us.tool = UniScreen.NAVIGATE;
        }
    }

    public strictfp static class Placement {
        public final Airship shipToPlace;
        public final double x;
        public final double y;
        public final boolean flipped;
        public final LandFormation landscapeTarget;
        public final int landscapeGY;
        public final int landscapeCost;
        public final int landscapeSideToRestrictTo;
        public final boolean succeeded;

        public Placement(Airship shipToPlace, double x, double y, boolean flipped, LandFormation landscapeTarget, int landscapeGY, int landscapeCost, int landscapeSideToRestrictTo) {
            this.shipToPlace = shipToPlace;
            this.x = x;
            this.y = y;
            this.flipped = flipped;
            this.landscapeTarget = landscapeTarget;
            this.landscapeGY = landscapeGY;
            this.landscapeCost = landscapeCost;
            this.landscapeSideToRestrictTo = landscapeSideToRestrictTo;
            this.succeeded = true;
        }

        public Placement(Airship shipToPlace, double x, double y, boolean flipped) {
            this.shipToPlace = shipToPlace;
            this.x = x;
            this.y = y;
            this.flipped = flipped;
            this.landscapeTarget = null;
            this.landscapeGY = -1;
            this.landscapeCost = 0;
            this.landscapeSideToRestrictTo = -1;
            this.succeeded = true;
        }

        public Placement(Airship shipToPlace, double x, double y, boolean flipped, boolean succeeded) {
            this.shipToPlace = shipToPlace;
            this.x = x;
            this.y = y;
            this.flipped = flipped;
            this.succeeded = succeeded;
            this.landscapeTarget = null;
            this.landscapeGY = -1;
            this.landscapeCost = 0;
            this.landscapeSideToRestrictTo = -1;
        }
    }
}

