/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.Analytics;
import com.zarkonnen.airships.BonusSet;
import com.zarkonnen.airships.ChallengeEditShipIntent;
import com.zarkonnen.airships.ChallengeInfoFloat;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.EditInfoPanel;
import com.zarkonnen.airships.EditPalettePanel;
import com.zarkonnen.airships.EditShipIntent;
import com.zarkonnen.airships.ExternalApp;
import com.zarkonnen.airships.Fleet;
import com.zarkonnen.airships.Keys;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.Module;
import com.zarkonnen.airships.ModuleType;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.OverlayChooserPanel;
import com.zarkonnen.airships.PlaceTool;
import com.zarkonnen.airships.Rect2D;
import com.zarkonnen.airships.RotatingShader;
import com.zarkonnen.airships.SpritesheetBundle;
import com.zarkonnen.airships.Tile;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.airships.WeaponAppearance;
import com.zarkonnen.catengine.Img;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;
import java.util.Collections;
import org.newdawn.slick.Color;
import org.newdawn.slick.Image;

public strictfp class PlaceModuleTool
extends PlaceTool {
    public static final Img REMOVE = new Img("ui", 64, 256, 16, 16, false);
    public ModuleType mt;
    public ModuleType flippedMT;
    public int ms = 0;
    public boolean dragMode;
    public static final Clr NO_OBSTRUCTION = new Clr(90, 255, 90, 100);
    public static final Clr OBSTRUCTED = new Clr(255, 90, 90, 100);
    public static final Clr OBSTRUCTED_BORDER = new Clr(255, 25, 25);
    public int ticksSinceRightClick = 0;

    @Override
    public String getLabel() {
        return Lang._t("Modules", new Object[0]);
    }

    public PlaceModuleTool(ModuleType mt, boolean dragMode) {
        this.mt = mt;
        this.flippedMT = mt == null ? null : mt.getFlippedIfAvailable();
        this.dragMode = dragMode;
    }

    private boolean checkLimits(ModuleType mt, UniScreen us) {
        Airship ship = this.ship(us);
        return mt.getQuarters(ship.constructionBonuses) + ship.getAllQuartered() <= 120 && mt.getCost(ship.constructionBonuses) + ship.getCost() <= 20000;
    }

    private void drawHorizontalBeam(MyDraw d, UniScreen us, Clr inner, Clr outer, double x, double y, double w, double h) {
        d.rect(inner, x, y + 2.0, w, h - 4.0);
        d.rect(outer, x, y + 2.0, w, 1.0 / us.zoom);
        d.rect(outer, x, y + h - 2.0 - 1.0 / us.zoom, w, 1.0 / us.zoom);
    }

    private void drawVerticalBeam(MyDraw d, UniScreen us, Clr inner, Clr outer, double x, double y, double w, double h) {
        d.rect(inner, x + 2.0, y, w - 4.0, h);
        d.rect(outer, x + 2.0, y, 1.0 / us.zoom, h);
        d.rect(outer, x + w - 2.0 - 1.0 / us.zoom, y, 1.0 / us.zoom, h);
    }

    private boolean canFlip(UniScreen us) {
        if (this.flippedMT == null) {
            return false;
        }
        if (us.intent instanceof ChallengeEditShipIntent) {
            ChallengeEditShipIntent cesi = (ChallengeEditShipIntent)us.intent;
            return cesi.challenge.editTypes.contains(this.flippedMT);
        }
        return true;
    }

    private boolean canFlipVertically(UniScreen us) {
        if (this.mt.getVerticalFlippedIfAvailable() == null) {
            return false;
        }
        if (us.intent instanceof ChallengeEditShipIntent) {
            ChallengeEditShipIntent cesi = (ChallengeEditShipIntent)us.intent;
            return cesi.challenge.editTypes.contains(this.mt.getVerticalFlippedIfAvailable());
        }
        return true;
    }

    @Override
    public void scaledDraw(MyDraw d, double x, double y, int modX, int modY, UniScreen us) {
        if (this.mt != null) {
            WeaponAppearance wa;
            if (this.canFlip(us)) {
                d.state.cursorText = this.canFlipVertically(us) ? Lang._t("Press_x_to_flip_module_c_to_flip_vertically", Keys.get("module_flip", "X"), Keys.get("module_flip_vertical", "C")) : Lang._t("Press_x_to_flip_module", Keys.get("module_flip", "X"));
            } else if (this.canFlipVertically(us)) {
                d.state.cursorText = Lang._t("Press_c_to_flip_module_vertically", Keys.get("module_flip_vertical", "C"));
            }
            for (ExternalApp ea : this.mt.getExternalApps(this.bonuses(us), false, false)) {
                if (ea.dx != 0 || ea.dy != 0 || ea.app.width() != this.mt.getApp(this.bonuses(us)).width() || ea.app.height() != this.mt.getApp(this.bonuses(us)).height()) continue;
                ea.app.draw(d, x + (double)(ea.dx * 16), y + (double)(ea.dy * 16), 0, this.ship((UniScreen)us).flipped);
            }
            Airship ship = this.ship(us);
            boolean modPermitted = this.checkLimits(this.mt, us) && this.noOverlapsOrObstructions(ship, us, this.mt, ship.gridXToWorldX(modX, this.mt.getW()), modY);
            int flippedModX = ship.gridXToWorldX(modX, this.mt.getW());
            if (this.checkLimits(this.mt, us) && this.noOverlaps(ship, us, this.mt, ship.gridXToWorldX(modX, this.mt.getW()), modY)) {
                int extent;
                int i;
                int obX;
                boolean isObstructing = false;
                Module obstructing = ship.moduleWhoseFrontIsObstructed(this.mt, flippedModX, modY, Collections.EMPTY_LIST);
                if (obstructing != null) {
                    obX = ship.gridXToWorldX(obstructing.x, obstructing.type.getW());
                    isObstructing = true;
                    for (i = 0; i < obstructing.type.getH(); ++i) {
                        if (!obstructing.type.isFrontOnly()[i]) continue;
                        extent = 1;
                        while (i + extent < obstructing.type.getH() && obstructing.type.isFrontOnly()[i + extent]) {
                            ++extent;
                        }
                        if (ship.flipped) {
                            this.drawHorizontalBeam(d, us, OBSTRUCTED, OBSTRUCTED_BORDER, ship.getX() + (double)((modX + this.mt.getW()) * 16), ship.getY() + (double)((obstructing.y + i) * 16), (ship.getWidth() - modX - this.mt.getW() - obstructing.x - obstructing.type.getW()) * 16, extent * 16);
                        } else {
                            this.drawHorizontalBeam(d, us, OBSTRUCTED, OBSTRUCTED_BORDER, ship.getX() + (double)((obX + obstructing.type.getW()) * 16), ship.getY() + (double)((obstructing.y + i) * 16), (flippedModX - obX - obstructing.type.getW()) * 16, extent * 16);
                        }
                        i += extent - 1;
                    }
                }
                if ((obstructing = ship.moduleWhoseBackIsObstructed(this.mt, flippedModX, modY, Collections.EMPTY_LIST)) != null) {
                    isObstructing = true;
                    obX = ship.gridXToWorldX(obstructing.x, obstructing.type.getW());
                    for (i = 0; i < obstructing.type.getH(); ++i) {
                        if (!obstructing.type.isBackOnly()[i]) continue;
                        extent = 1;
                        while (i + extent < obstructing.type.getH() && obstructing.type.isBackOnly()[i + extent]) {
                            ++extent;
                        }
                        if (ship.flipped) {
                            this.drawHorizontalBeam(d, us, OBSTRUCTED, OBSTRUCTED_BORDER, ship.getX() + (double)((obX + obstructing.type.getW()) * 16), ship.getY() + (double)((obstructing.y + i) * 16), (ship.getWidth() - flippedModX - obstructing.type.getW() - obX - this.mt.getW()) * 16, extent * 16);
                        } else {
                            this.drawHorizontalBeam(d, us, OBSTRUCTED, OBSTRUCTED_BORDER, ship.getX() + (double)((this.mt.getW() + flippedModX) * 16), ship.getY() + (double)((obstructing.y + i) * 16), (obX - this.mt.getW() - flippedModX) * 16, extent * 16);
                        }
                        i += extent - 1;
                    }
                }
                if ((obstructing = ship.moduleWhoseBottomIsObstructed(this.mt, flippedModX, modY, Collections.EMPTY_LIST)) != null) {
                    isObstructing = true;
                    obX = ship.gridXToWorldX(obstructing.x, obstructing.type.getW());
                    for (i = 0; i < obstructing.type.getW(); ++i) {
                        if (!obstructing.type.isBottomOnly()[i]) continue;
                        extent = 1;
                        while (i + extent < obstructing.type.getW() && obstructing.type.isBottomOnly()[i + extent]) {
                            ++extent;
                        }
                        this.drawVerticalBeam(d, us, OBSTRUCTED, OBSTRUCTED_BORDER, ship.getX() + (double)((obX + i) * 16), ship.getY() + (double)((obstructing.y + obstructing.type.getH()) * 16), extent * 16, (modY - obstructing.y - obstructing.type.getH()) * 16);
                        i += extent - 1;
                    }
                }
                if ((obstructing = ship.moduleWhoseTopIsObstructed(this.mt, flippedModX, modY, Collections.EMPTY_LIST)) != null) {
                    isObstructing = true;
                    obX = ship.gridXToWorldX(obstructing.x, obstructing.type.getW());
                    for (i = 0; i < obstructing.type.getW(); ++i) {
                        if (!obstructing.type.isTopOnly()[i]) continue;
                        extent = 1;
                        while (i + extent < obstructing.type.getW() && obstructing.type.isTopOnly()[i + extent]) {
                            ++extent;
                        }
                        this.drawVerticalBeam(d, us, OBSTRUCTED, OBSTRUCTED_BORDER, ship.getX() + (double)((obX + i) * 16), ship.getY() + (double)((modY + this.mt.getH()) * 16), extent * 16, (obstructing.y - modY - this.mt.getH()) * 16);
                        i += extent - 1;
                    }
                }
                if (!isObstructing) {
                    int obX2;
                    int extent2;
                    int i2;
                    obstructing = ship.moduleThatObstructsFront(this.mt, flippedModX, modY, Collections.EMPTY_LIST);
                    for (i2 = 0; i2 < this.mt.getH(); ++i2) {
                        if (!this.mt.isFrontOnly()[i2]) continue;
                        extent2 = 1;
                        while (i2 + extent2 < this.mt.getH() && this.mt.isFrontOnly()[i2 + extent2]) {
                            ++extent2;
                        }
                        if (obstructing == null) {
                            if (ship.flipped) {
                                this.drawHorizontalBeam(d, us, NO_OBSTRUCTION, Clr.WHITE, ship.getX() + (double)(modX * 16), ship.getY() + (double)((modY + i2) * 16), -16000.0, extent2 * 16);
                            } else {
                                this.drawHorizontalBeam(d, us, NO_OBSTRUCTION, Clr.WHITE, ship.getX() + (double)((this.mt.getW() + flippedModX) * 16), ship.getY() + (double)((modY + i2) * 16), 16000.0, extent2 * 16);
                            }
                        } else {
                            obX2 = ship.gridXToWorldX(obstructing.x, obstructing.type.getW());
                            if (ship.flipped) {
                                this.drawHorizontalBeam(d, us, OBSTRUCTED, OBSTRUCTED_BORDER, ship.getX() + (double)((obX2 + obstructing.type.getW()) * 16), ship.getY() + (double)((modY + i2) * 16), (ship.getWidth() - flippedModX - obstructing.type.getW() - obX2 - this.mt.getW()) * 16, extent2 * 16);
                            } else {
                                this.drawHorizontalBeam(d, us, OBSTRUCTED, OBSTRUCTED_BORDER, ship.getX() + (double)((this.mt.getW() + flippedModX) * 16), ship.getY() + (double)((modY + i2) * 16), (obX2 - this.mt.getW() - flippedModX) * 16, extent2 * 16);
                            }
                        }
                        i2 += extent2 - 1;
                    }
                    obstructing = ship.moduleThatObstructsBack(this.mt, flippedModX, modY, Collections.EMPTY_LIST);
                    for (i2 = 0; i2 < this.mt.getH(); ++i2) {
                        if (!this.mt.isBackOnly()[i2]) continue;
                        extent2 = 1;
                        while (i2 + extent2 < this.mt.getH() && this.mt.isBackOnly()[i2 + extent2]) {
                            ++extent2;
                        }
                        if (obstructing == null) {
                            if (ship.flipped) {
                                this.drawHorizontalBeam(d, us, NO_OBSTRUCTION, Clr.WHITE, ship.getX() + (double)((this.mt.getW() + modX) * 16), ship.getY() + (double)((modY + i2) * 16), 16000.0, extent2 * 16);
                            } else {
                                this.drawHorizontalBeam(d, us, NO_OBSTRUCTION, Clr.WHITE, ship.getX() + (double)(modX * 16), ship.getY() + (double)((modY + i2) * 16), -16000.0, extent2 * 16);
                            }
                        } else {
                            obX2 = ship.gridXToWorldX(obstructing.x, obstructing.type.getW());
                            if (ship.flipped) {
                                this.drawHorizontalBeam(d, us, OBSTRUCTED, OBSTRUCTED_BORDER, ship.getX() + (double)((this.mt.getW() - flippedModX) * 16), ship.getY() + (double)((modY + i2) * 16), (obX2 - this.mt.getW() + flippedModX) * 16, extent2 * 16);
                            } else {
                                this.drawHorizontalBeam(d, us, OBSTRUCTED, OBSTRUCTED_BORDER, ship.getX() + (double)((obX2 + obstructing.type.getW()) * 16), ship.getY() + (double)((modY + i2) * 16), (flippedModX - obX2 - obstructing.type.getW()) * 16, extent2 * 16);
                            }
                        }
                        i2 += extent2 - 1;
                    }
                    obstructing = ship.moduleThatObstructsBottom(this.mt, flippedModX, modY, Collections.EMPTY_LIST);
                    for (i2 = 0; i2 < this.mt.getW(); ++i2) {
                        if (!this.mt.isBottomOnly()[i2]) continue;
                        extent2 = 1;
                        while (i2 + extent2 < this.mt.getW() && this.mt.isBottomOnly()[i2 + extent2]) {
                            ++extent2;
                        }
                        if (obstructing == null) {
                            this.drawVerticalBeam(d, us, NO_OBSTRUCTION, Clr.WHITE, ship.getX() + (double)((modX + i2) * 16), ship.getY() + (double)((modY + this.mt.getH()) * 16), extent2 * 16, 16000.0);
                        } else {
                            this.drawVerticalBeam(d, us, OBSTRUCTED, OBSTRUCTED_BORDER, ship.getX() + (double)((modX + i2) * 16), ship.getY() + (double)((modY + this.mt.getH()) * 16), extent2 * 16, (obstructing.y - modY - this.mt.getH()) * 16);
                        }
                        i2 += extent2 - 1;
                    }
                    obstructing = ship.moduleThatObstructsTop(this.mt, flippedModX, modY, Collections.EMPTY_LIST);
                    for (i2 = 0; i2 < this.mt.getW(); ++i2) {
                        if (!this.mt.isTopOnly()[i2]) continue;
                        extent2 = 1;
                        while (i2 + extent2 < this.mt.getW() && this.mt.isTopOnly()[i2 + extent2]) {
                            ++extent2;
                        }
                        if (obstructing == null) {
                            this.drawVerticalBeam(d, us, NO_OBSTRUCTION, Clr.WHITE, ship.getX() + (double)((modX + i2) * 16), ship.getY() + (double)((modY - 1000) * 16), extent2 * 16, 16000.0);
                        } else {
                            this.drawVerticalBeam(d, us, OBSTRUCTED, OBSTRUCTED_BORDER, ship.getX() + (double)((modX + i2) * 16), ship.getY() + (double)((obstructing.y + obstructing.type.getH()) * 16), extent2 * 16, (modY - obstructing.y - obstructing.type.getH()) * 16);
                        }
                        i2 += extent2 - 1;
                    }
                }
            }
            if ((wa = this.mt.weaponAppearance(this.bonuses(us))) != null && (wa.barrel != null || wa.barrelAnimation != null)) {
                Img barrel;
                double angle;
                double d2 = angle = ship.flipped ? -this.mt.getFireArc((BonusSet)this.bonuses((UniScreen)us)).getMiddle().radians : this.mt.getFireArc((BonusSet)this.bonuses((UniScreen)us)).getMiddle().radians;
                if (this.mt.isFlipped()) {
                    angle += Math.PI;
                }
                Img img = barrel = ship.flipped ? wa.flippedbarrel : wa.barrel;
                if (wa.barrelAnimation != null) {
                    Img img2 = barrel = ship.flipped ? wa.flippedBarrelAnimation.frames.get(0) : wa.barrelAnimation.frames.get(0);
                }
                if (barrel.machineImgCache != null) {
                    ((Image)barrel.machineImgCache).setFilter(9728);
                }
                Pt offset = ship.flipped ? wa.flippedBarrelOffset : wa.barrelOffset;
                double bx = x + offset.x;
                double by = y + offset.y;
                if (modPermitted) {
                    d.blit(barrel, null, bx, by, angle);
                } else {
                    RotatingShader.drawAsRedOutline(SpritesheetBundle.ofName(barrel.src), barrel, d, bx, by, angle, 1.0, false);
                }
            }
            if (modPermitted) {
                this.mt.draw(d, x, y, this.ms, null, ship.flipped, 0, this.bonuses(us), null, 1.0f, Color.white, 1.0f);
            } else {
                this.mt.drawAsRedOutline(d, x, y, this.ms, ship.flipped, 0, this.bonuses(us));
            }
            int lineWidth = 2;
            switch (AirshipGame.instance.currentGUIScale) {
                case SMALL: {
                    lineWidth = 1;
                    break;
                }
                case MEDIUM: {
                    lineWidth = 2;
                    break;
                }
                case LARGE: {
                    lineWidth = 4;
                }
            }
            Clr c = new Clr(255, 255, 255, 80);
            if (modPermitted) {
                int i;
                for (i = 0; i < this.mt.getH(); ++i) {
                    Tile adjTile;
                    if (this.mt.getLeftDoors()[i] && !this.mt.isBackOnly()[i] && this.mt.canOccupy(0, i)) {
                        adjTile = ship.tileAt(flippedModX - 1, modY + i);
                        if (adjTile == null) {
                            if (ship.flipped) {
                                d.rect(c, ship.getX() + (double)(modX * 16) + (double)(16 * this.mt.getW()), ship.getY() + (double)((modY + i) * 16) + 16.0 - 1.0, 6.0, 1.0);
                            } else {
                                d.rect(c, ship.getX() + (double)(ship.gridXToWorldX(modX, this.mt.getW()) * 16) - 6.0, ship.getY() + (double)((modY + i) * 16) + 16.0 - 1.0, 6.0, 1.0);
                            }
                        } else if (modPermitted && adjTile.canOccupy && !adjTile.module.type.isFrontOnly()[adjTile.y - adjTile.module.y] && adjTile.module.type.canOccupy(adjTile.module.type.getW() - 1, modY - adjTile.module.y + i)) {
                            if (ship.flipped) {
                                d.rect(Clr.BLACK, ship.getX() + (double)(modX * 16) - 8.0 + (double)(16 * this.mt.getW()), ship.getY() + (double)(modY * 16) + 8.0 - 1.5 * (double)lineWidth / us.zoom + (double)(i * 16), 16.0, (double)(3 * lineWidth) / us.zoom);
                                d.rect(Clr.WHITE, ship.getX() + (double)(modX * 16) - 8.0 + (double)(16 * this.mt.getW()), ship.getY() + (double)(modY * 16) + 8.0 - 0.5 * (double)lineWidth / us.zoom + (double)(i * 16), 16.0, (double)(1 * lineWidth) / us.zoom);
                            } else {
                                d.rect(Clr.BLACK, ship.getX() + (double)(modX * 16) - 8.0, ship.getY() + (double)(modY * 16) + 8.0 - 1.5 * (double)lineWidth / us.zoom + (double)(i * 16), 16.0, (double)(3 * lineWidth) / us.zoom);
                                d.rect(Clr.WHITE, ship.getX() + (double)(modX * 16) - 8.0, ship.getY() + (double)(modY * 16) + 8.0 - 0.5 * (double)lineWidth / us.zoom + (double)(i * 16), 16.0, (double)(1 * lineWidth) / us.zoom);
                            }
                        }
                    }
                    if (!this.mt.getRightDoors()[i] || this.mt.isFrontOnly()[i] || !this.mt.canOccupy(this.mt.getW() - 1, i)) continue;
                    adjTile = ship.tileAt(flippedModX + this.mt.getW(), modY + i);
                    if (adjTile == null) {
                        if (ship.flipped) {
                            d.rect(c, ship.getX() + (double)(modX * 16) - 6.0, ship.getY() + (double)((modY + i) * 16) + 16.0 - 1.0, 6.0, 1.0);
                            continue;
                        }
                        d.rect(c, ship.getX() + (double)(ship.gridXToWorldX(modX, this.mt.getW()) * 16) + (double)(16 * this.mt.getW()), ship.getY() + (double)((modY + i) * 16) + 16.0 - 1.0, 6.0, 1.0);
                        continue;
                    }
                    if (!modPermitted || !adjTile.canOccupy || adjTile.module.type.isBackOnly()[adjTile.y - adjTile.module.y] || !adjTile.module.type.canOccupy(0, modY - adjTile.module.y + i)) continue;
                    if (ship.flipped) {
                        d.rect(Clr.BLACK, ship.getX() + (double)(modX * 16) - 8.0, ship.getY() + (double)(modY * 16) + 8.0 - 1.5 * (double)lineWidth / us.zoom + (double)(i * 16), 16.0, (double)(3 * lineWidth) / us.zoom);
                        d.rect(Clr.WHITE, ship.getX() + (double)(modX * 16) - 8.0, ship.getY() + (double)(modY * 16) + 8.0 - 0.5 * (double)lineWidth / us.zoom + (double)(i * 16), 16.0, (double)(1 * lineWidth) / us.zoom);
                        continue;
                    }
                    d.rect(Clr.BLACK, ship.getX() + (double)((modX + this.mt.getW()) * 16) - 8.0, ship.getY() + (double)(modY * 16) + 8.0 - 1.5 * (double)lineWidth / us.zoom + (double)(i * 16), 16.0, (double)(3 * lineWidth) / us.zoom);
                    d.rect(Clr.WHITE, ship.getX() + (double)((modX + this.mt.getW()) * 16) - 8.0, ship.getY() + (double)(modY * 16) + 8.0 - 0.5 * (double)lineWidth / us.zoom + (double)(i * 16), 16.0, (double)(1 * lineWidth) / us.zoom);
                }
                for (i = 0; i < this.mt.getW(); ++i) {
                    Tile adjTile;
                    if (!this.mt.isTopOnly()[i] && this.mt.getUpDoors()[i] && this.mt.canOccupy(i, 0)) {
                        adjTile = ship.tileAt(flippedModX + i, modY - 1);
                        if (adjTile == null) {
                            if (ship.flipped) {
                                d.rect(c, ship.getX() + (double)(modX * 16) + 13.0 + (double)(16 * (this.mt.getW() - i - 1)), ship.getY() + (double)(modY * 16) - 6.0, 1.0, 6.0);
                                d.rect(c, ship.getX() + (double)(modX * 16) + 9.0 + (double)(16 * (this.mt.getW() - i - 1)), ship.getY() + (double)(modY * 16) - 6.0, 1.0, 6.0);
                                d.rect(c, ship.getX() + (double)(modX * 16) + 10.0 + (double)(16 * (this.mt.getW() - i - 1)), ship.getY() + (double)(modY * 16) - 2.0, 3.0, 1.0);
                                d.rect(c, ship.getX() + (double)(modX * 16) + 10.0 + (double)(16 * (this.mt.getW() - i - 1)), ship.getY() + (double)(modY * 16) - 4.0, 3.0, 1.0);
                            } else {
                                d.rect(c, ship.getX() + (double)(modX * 16) + 13.0 + (double)(16 * i), ship.getY() + (double)(modY * 16) - 6.0, 1.0, 6.0);
                                d.rect(c, ship.getX() + (double)(modX * 16) + 9.0 + (double)(16 * i), ship.getY() + (double)(modY * 16) - 6.0, 1.0, 6.0);
                                d.rect(c, ship.getX() + (double)(modX * 16) + 10.0 + (double)(16 * i), ship.getY() + (double)(modY * 16) - 2.0, 3.0, 1.0);
                                d.rect(c, ship.getX() + (double)(modX * 16) + 10.0 + (double)(16 * i), ship.getY() + (double)(modY * 16) - 4.0, 3.0, 1.0);
                            }
                        } else if (adjTile.canOccupy) {
                            if (ship.flipped) {
                                d.rect(Clr.BLACK, ship.getX() + (double)(modX * 16) + 8.0 + (double)(16 * (this.mt.getW() - i - 1)) - 1.5 * (double)lineWidth / us.zoom, ship.getY() + (double)(modY * 16) - 8.0, (double)(3 * lineWidth) / us.zoom, 16.0);
                                d.rect(Clr.WHITE, ship.getX() + (double)(modX * 16) + 8.0 + (double)(16 * (this.mt.getW() - i - 1)) - 0.5 * (double)lineWidth / us.zoom, ship.getY() + (double)(modY * 16) - 8.0, (double)(1 * lineWidth) / us.zoom, 16.0);
                            } else {
                                d.rect(Clr.BLACK, ship.getX() + (double)(modX * 16) + 8.0 + (double)(16 * i) - 1.5 * (double)lineWidth / us.zoom, ship.getY() + (double)(modY * 16) - 8.0, (double)(3 * lineWidth) / us.zoom, 16.0);
                                d.rect(Clr.WHITE, ship.getX() + (double)(modX * 16) + 8.0 + (double)(16 * i) - 0.5 * (double)lineWidth / us.zoom, ship.getY() + (double)(modY * 16) - 8.0, (double)(1 * lineWidth) / us.zoom, 16.0);
                            }
                        }
                    }
                    if (this.mt.isBottomOnly()[i] || !this.mt.canOccupy(i, this.mt.getH() - 1)) continue;
                    adjTile = ship.tileAt(flippedModX + i, modY + this.mt.getH());
                    if (adjTile == null) {
                        if (ship.flipped) {
                            d.rect(c, ship.getX() + (double)(modX * 16) + 9.0 + (double)(16 * (this.mt.getW() - i - 1)), ship.getY() + (double)(modY * 16) + (double)(this.mt.getH() * 16), 1.0, 6.0);
                            d.rect(c, ship.getX() + (double)(modX * 16) + 13.0 + (double)(16 * (this.mt.getW() - i - 1)), ship.getY() + (double)(modY * 16) + (double)(this.mt.getH() * 16), 1.0, 6.0);
                            d.rect(c, ship.getX() + (double)(modX * 16) + 10.0 + (double)(16 * (this.mt.getW() - i - 1)), ship.getY() + (double)(modY * 16) + (double)(this.mt.getH() * 16) + 1.0, 3.0, 1.0);
                            d.rect(c, ship.getX() + (double)(modX * 16) + 10.0 + (double)(16 * (this.mt.getW() - i - 1)), ship.getY() + (double)(modY * 16) + (double)(this.mt.getH() * 16) + 3.0, 3.0, 1.0);
                            continue;
                        }
                        d.rect(c, ship.getX() + (double)(modX * 16) + 9.0 + (double)(16 * i), ship.getY() + (double)(modY * 16) + (double)(this.mt.getH() * 16), 1.0, 6.0);
                        d.rect(c, ship.getX() + (double)(modX * 16) + 13.0 + (double)(16 * i), ship.getY() + (double)(modY * 16) + (double)(this.mt.getH() * 16), 1.0, 6.0);
                        d.rect(c, ship.getX() + (double)(modX * 16) + 10.0 + (double)(16 * i), ship.getY() + (double)(modY * 16) + (double)(this.mt.getH() * 16) + 1.0, 3.0, 1.0);
                        d.rect(c, ship.getX() + (double)(modX * 16) + 10.0 + (double)(16 * i), ship.getY() + (double)(modY * 16) + (double)(this.mt.getH() * 16) + 3.0, 3.0, 1.0);
                        continue;
                    }
                    if (!adjTile.module.type.getUpDoors()[adjTile.x - adjTile.module.x]) continue;
                    if (ship.flipped) {
                        d.rect(Clr.BLACK, ship.getX() + (double)(modX * 16) + 8.0 + (double)(16 * (this.mt.getW() - i - 1)) - 1.5 * (double)lineWidth / us.zoom, ship.getY() + (double)((modY + this.mt.getH()) * 16) - 8.0, (double)(3 * lineWidth) / us.zoom, 16.0);
                        d.rect(Clr.WHITE, ship.getX() + (double)(modX * 16) + 8.0 + (double)(16 * (this.mt.getW() - i - 1)) - 0.5 * (double)lineWidth / us.zoom, ship.getY() + (double)((modY + this.mt.getH()) * 16) - 8.0, (double)(1 * lineWidth) / us.zoom, 16.0);
                        continue;
                    }
                    d.rect(Clr.BLACK, ship.getX() + (double)(modX * 16) + 8.0 + (double)(16 * i) - 1.5 * (double)lineWidth / us.zoom, ship.getY() + (double)((modY + this.mt.getH()) * 16) - 8.0, (double)(3 * lineWidth) / us.zoom, 16.0);
                    d.rect(Clr.WHITE, ship.getX() + (double)(modX * 16) + 8.0 + (double)(16 * i) - 0.5 * (double)lineWidth / us.zoom, ship.getY() + (double)((modY + this.mt.getH()) * 16) - 8.0, (double)(1 * lineWidth) / us.zoom, 16.0);
                }
            }
        } else {
            if (PlaceModuleTool.REMOVE.machineImgCache != null) {
                ((Image)PlaceModuleTool.REMOVE.machineImgCache).setFilter(9728);
            }
            d.blit(REMOVE, x, y);
        }
    }

    public boolean noOverlaps(Airship shipToPlace, UniScreen us, ModuleType mt, int modX, int modY) {
        block8: {
            int worldH;
            int worldW;
            int worldY;
            int worldX;
            block9: {
                block7: {
                    if (!shipToPlace.noModuleOverlapsOrObstructions(mt, modX, modY, false)) {
                        return false;
                    }
                    worldX = shipToPlace.getIntX() + modX * 16;
                    worldY = shipToPlace.getIntY() + modY * 16;
                    worldW = mt.getW() * 16;
                    worldH = mt.getH() * 16;
                    if (us.combat == null) break block7;
                    for (Combat.Side side : us.combat.sides) {
                        for (Airship ship : side.ships) {
                            if (ship == shipToPlace || !this.overlaps(ship, worldX, worldY, worldW, worldH)) continue;
                            return false;
                        }
                    }
                    break block8;
                }
                if (us.city == null) break block9;
                Fleet garrison = us.wm.getGarrison(us.city);
                for (Airship bld : us.city.getDefences()) {
                    if (bld == shipToPlace || !this.overlaps(bld, worldX, worldY, worldW, worldH)) continue;
                    return false;
                }
                if (garrison == null) break block8;
                for (Airship ship : garrison.actives) {
                    if (ship == shipToPlace || !this.overlaps(ship, worldX, worldY, worldW, worldH)) continue;
                    return false;
                }
                break block8;
            }
            if (us.setupFleet != null) {
                for (Airship ship : us.setupFleet) {
                    if (ship == shipToPlace || !this.overlaps(ship, worldX, worldY, worldW, worldH)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean noOverlapsOrObstructions(Airship shipToPlace, UniScreen us, ModuleType mt, int modX, int modY) {
        block8: {
            int worldH;
            int worldW;
            int worldY;
            int worldX;
            block9: {
                block7: {
                    if (!shipToPlace.noModuleOverlapsOrObstructions(mt, modX, modY, true)) {
                        return false;
                    }
                    worldX = shipToPlace.getIntX() + modX * 16;
                    worldY = shipToPlace.getIntY() + modY * 16;
                    worldW = mt.getW() * 16;
                    worldH = mt.getH() * 16;
                    if (us.combat == null) break block7;
                    for (Combat.Side side : us.combat.sides) {
                        for (Airship ship : side.ships) {
                            if (ship == shipToPlace || !this.overlaps(ship, worldX, worldY, worldW, worldH)) continue;
                            return false;
                        }
                    }
                    break block8;
                }
                if (us.city == null) break block9;
                Fleet garrison = us.wm.getGarrison(us.city);
                for (Airship bld : us.city.getDefences()) {
                    if (bld == shipToPlace || !this.overlaps(bld, worldX, worldY, worldW, worldH)) continue;
                    return false;
                }
                if (garrison == null) break block8;
                for (Airship ship : garrison.actives) {
                    if (ship == shipToPlace || !this.overlaps(ship, worldX, worldY, worldW, worldH)) continue;
                    return false;
                }
                break block8;
            }
            if (us.setupFleet != null) {
                for (Airship ship : us.setupFleet) {
                    if (ship == shipToPlace || !this.overlaps(ship, worldX, worldY, worldW, worldH)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean overlaps(Airship ship, int worldX, int worldY, int worldW, int worldH) {
        return Rect2D.intersects(ship.getIntX(), ship.getIntY(), ship.getBBWidth(), ship.getBBHeight(), worldX, worldY, worldW, worldH);
    }

    @Override
    public void unscaledDraw(MyDraw d, Pt cursor, ScreenMode sm, UniScreen us) {
        Pt sz = d.textSize(Lang._t("Left_click_to_place_right_click_to_pick_up", new Object[0]), AGame.FOUNT);
        d.text(Lang._t("Left_click_to_place_right_click_to_pick_up", new Object[0]), AGame.FOUNT, (int)((double)sm.width - sz.x - 5.0), (double)sm.height - sz.y - 3.0);
    }

    @Override
    public boolean click(Input in, Pt click, ScreenMode sm, UniScreen us) {
        if (!this.dragMode) {
            return this.doClick(in, click, sm, us);
        }
        return true;
    }

    public boolean doClick(Input in, Pt click, ScreenMode sm, UniScreen us) {
        OverlayChooserPanel ocp = us.panel(OverlayChooserPanel.class);
        if (click.x < (double)us.panel(EditInfoPanel.class).myWidth || click.x >= (double)ocp.left && click.y < (double)ocp.bottom) {
            return false;
        }
        if (AirshipGame.metaLobbyOverlay != null && click.x >= (double)(sm.width - MyDraw.SIDE_CLEARANCE - MyDraw.BUTTON_H - 2) && click.x <= (double)(sm.width - MyDraw.SIDE_CLEARANCE + 2) && click.y >= (double)(sm.height - MyDraw.SIDE_CLEARANCE - MyDraw.BUTTON_H - 2) && click.y <= (double)(sm.height - MyDraw.SIDE_CLEARANCE + 2)) {
            return false;
        }
        if (us.intent instanceof ChallengeEditShipIntent) {
            ChallengeInfoFloat cif = us.findFloat(ChallengeInfoFloat.class);
            if (click.x >= (double)cif.minX && click.x <= (double)cif.maxX && click.y <= (double)cif.maxY) {
                return false;
            }
        }
        if (this.ms < 100) {
            return true;
        }
        Airship ship = this.ship(us);
        int[] sp = this.localShipPt(click, us, this.mt == null ? 1 : this.mt.getW());
        if (this.mt == null) {
            ModuleType remMt = null;
            Tile t = ship.tileAt(sp[0], sp[1]);
            if (t != null) {
                remMt = t.module.type;
            }
            if (us.intent instanceof ChallengeEditShipIntent && !((ChallengeEditShipIntent)us.intent).challenge.editTypes.contains(remMt)) {
                return true;
            }
            if (ship.removeModuleAt(sp[0], sp[1]) != null) {
                in.play("remove", 1.0, 1.0 * us.g.volume, 0.0, 0.0);
                this.modified(us, true);
                if (us.intent instanceof EditShipIntent) {
                    EditShipIntent esi = (EditShipIntent)us.intent;
                    if (!esi.hasRemovedModule) {
                        Analytics.report("hasRemovedModule");
                        esi.hasRemovedModule = true;
                    }
                }
                return true;
            }
        } else if (this.noOverlapsOrObstructions(ship, us, this.mt, sp[0], sp[1])) {
            Module m = ship.addModule(this.mt, sp[0], sp[1], us.panel(EditPalettePanel.class).lastArmourType);
            if (this.mt.hasColoration()) {
                m.externalPaint = us.panel(EditPalettePanel.class).moduleAndDecalPaintSel;
            }
            double volume = StrictMath.min(1.0, StrictMath.sqrt((double)(this.mt.getW() * this.mt.getH()) * 0.2));
            in.play("place", 1.0 / volume, volume * us.g.volume, 0.0, 0.0);
            this.modified(us, true);
            if (us.intent instanceof EditShipIntent) {
                EditShipIntent esi = (EditShipIntent)us.intent;
                if (!esi.hasPlacedModule) {
                    Analytics.report("hasPlacedModule");
                    esi.hasPlacedModule = true;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean rightClick(Input in, Pt click, ScreenMode sm, UniScreen us) {
        OverlayChooserPanel ocp = us.panel(OverlayChooserPanel.class);
        if (click.x < (double)us.panel(EditInfoPanel.class).myWidth || click.x >= (double)ocp.left && click.y < (double)ocp.bottom) {
            return false;
        }
        if (us.intent instanceof ChallengeEditShipIntent) {
            ChallengeInfoFloat cif = us.findFloat(ChallengeInfoFloat.class);
            if (click.x >= (double)cif.minX && click.x <= (double)cif.maxX && click.y <= (double)cif.maxY) {
                return false;
            }
        }
        if (this.ms < 100) {
            return true;
        }
        Airship ship = this.ship(us);
        int[] sp = this.localShipPt(click, us, 1);
        if (us.intent instanceof ChallengeEditShipIntent && !((ChallengeEditShipIntent)us.intent).challenge.editTypes.contains(ship.moduleTypeAt(sp[0], sp[1]))) {
            return true;
        }
        Module victim = ship.removeModuleAt(sp[0], sp[1]);
        if (victim != null) {
            this.mt = victim.type;
            this.flippedMT = this.mt.getFlippedIfAvailable();
            in.play("paper_lift", 1.0, 1.0 * us.g.volume, 0.0, 0.0);
            this.modified(us, true);
            if (us.intent instanceof EditShipIntent) {
                EditShipIntent esi = (EditShipIntent)us.intent;
                if (!esi.hasRemovedModule) {
                    Analytics.report("hasRemovedModule");
                    esi.hasRemovedModule = true;
                }
            }
        } else if (this.ticksSinceRightClick > 2) {
            us.tool = UniScreen.NAVIGATE;
        }
        this.ticksSinceRightClick = 0;
        return true;
    }

    @Override
    public boolean mouseDown(Input in, Pt click, ScreenMode sm, UniScreen us) {
        if (in.mouseDownButton() == 1) {
            return this.ship((UniScreen)us).modules.size() < 1 ? false : this.click(in, click, sm, us);
        }
        return super.mouseDown(in, click, sm, us);
    }

    @Override
    public void tick(Input in, int ms, UniScreen us) {
        if (us.intent instanceof EditShipIntent) {
            EditShipIntent esi = (EditShipIntent)us.intent;
            if (!esi.hasSelectedModule) {
                Analytics.report("hasSelectedModule");
                esi.hasSelectedModule = true;
            }
        }
        this.ms += ms;
        ++this.ticksSinceRightClick;
        if (this.dragMode && in.mouseDown() == null) {
            this.doClick(in, in.cursor(), in.mode(), us);
            us.tool = UniScreen.NAVIGATE;
        }
        if (in.keyPressed(Keys.get("module_flip", "X")) && this.mt != null && this.canFlip(us) && !us.textInputOccurring()) {
            ModuleType tmp = this.mt;
            this.mt = this.mt.getFlippedIfAvailable();
            this.flippedMT = tmp;
            boolean bl = us.panel(EditPalettePanel.class).showFlippedModules = !us.panel(EditPalettePanel.class).showFlippedModules;
        }
        if (in.keyPressed(Keys.get("module_flip_vertical", "C")) && this.mt != null && this.canFlipVertically(us) && !us.textInputOccurring()) {
            this.mt = this.mt.getVerticalFlippedIfAvailable();
            this.flippedMT = this.mt.getFlippedIfAvailable();
            us.panel(EditPalettePanel.class).showVerticallyFlippedModules = !us.panel(EditPalettePanel.class).showVerticallyFlippedModules;
        }
    }
}

