/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.City;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.DefencesIntent;
import com.zarkonnen.airships.EditMissionIntent;
import com.zarkonnen.airships.EditPalettePanel;
import com.zarkonnen.airships.LandBlockType;
import com.zarkonnen.airships.LandFormation;
import com.zarkonnen.airships.LandFormationTool;
import com.zarkonnen.airships.LandscapeEditorPanel;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.SingleCombatSetupIntent;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Pt;
import java.util.ArrayList;

public strictfp class PlaceLandBlockTool
extends LandFormationTool {
    public LandBlockType type;

    @Override
    public String getLabel() {
        if (this.type == LandBlockType.ofName("AIR")) {
            return Lang._t("Remove", new Object[0]);
        }
        return Lang._t("Place_x", this.type.getName());
    }

    public PlaceLandBlockTool(LandBlockType type) {
        this.type = type;
    }

    public boolean canPlace(LandFormationTool.LFTarget lft, boolean canPlaceAnywhere) {
        if (lft == null) {
            return false;
        }
        LandBlockType lbt = lft.lf.typeAt(lft.x, lft.y);
        if (lbt == LandBlockType.ofName("BEDROCK")) {
            return false;
        }
        if (!lft.lf.immobile && !canPlaceAnywhere && lft.lf.getX() + (double)(lft.x * 16) < 100.0) {
            return false;
        }
        LandBlockType air = LandBlockType.ofName("AIR");
        if (this.type == air) {
            if (lbt == null || lbt == air) {
                return false;
            }
            return lft.lf.typeAt(lft.x - 1, lft.y) == null || lft.lf.typeAt(lft.x - 1, lft.y) == air || lft.lf.typeAt(lft.x + 1, lft.y) == null || lft.lf.typeAt(lft.x + 1, lft.y) == air || lft.lf.typeAt(lft.x, lft.y - 1) == null || lft.lf.typeAt(lft.x, lft.y - 1) == air || lft.lf.typeAt(lft.x, lft.y + 1) == null || lft.lf.typeAt(lft.x, lft.y + 1) == air;
        }
        if (!this.type.canOverhang && lft.lf.typeAt(lft.x, lft.y + 1) == LandBlockType.ofName("AIR")) {
            return false;
        }
        if (!canPlaceAnywhere && lft.lf.typeAt(lft.x, lft.y - 1) != null && lft.lf.typeAt((int)lft.x, (int)(lft.y - 1)).opaque) {
            return false;
        }
        if (lft.lf.immobile && (lft.y >= lft.lf.grid.length || lft.x < 0 || lft.x >= lft.lf.grid[0].length)) {
            return false;
        }
        if (lft.lf.immobile && (lft.x == 0 || lft.x == lft.lf.grid[0].length - 1)) {
            return true;
        }
        return canPlaceAnywhere || this.type.canOverhang || lft.lf.typeAt(lft.x - 1, lft.y + 1) != null && lft.lf.typeAt(lft.x + 1, lft.y + 1) != null && lft.lf.typeAt((int)(lft.x - 1), (int)(lft.y + 1)).solid && lft.lf.typeAt((int)(lft.x + 1), (int)(lft.y + 1)).solid;
    }

    public int placeCost(ArrayList<LandFormationTool.LFTarget> lfts, boolean canPlaceAnywhere) {
        int c = 0;
        for (LandFormationTool.LFTarget t : lfts) {
            if (!this.canPlace(t, canPlaceAnywhere)) continue;
            c += this.placeCost(t);
        }
        return c;
    }

    public int placeCost(LandFormationTool.LFTarget lft) {
        LandBlockType replacing = lft.lf.typeAt(lft.x, lft.y);
        if (replacing == this.type) {
            return 0;
        }
        return this.type.addCost + (replacing == null ? 0 : replacing.removeCost);
    }

    public boolean freeToPlaceNewFloater(UniScreen us, double wx, double wy) {
        if (wx > -3200.0 && wx < 3200.0 && wy < 512.0) {
            for (int dy = -3; dy < 4; ++dy) {
                for (int dx = -3; dx < 4; ++dx) {
                    if (this.target(us, new Pt(us.worldToScreenX(wx + (double)(dx * 16)), us.worldToScreenY(wy + (double)(dy * 16)))).isEmpty()) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void drawScaled(MyDraw d, UniScreen us, ArrayList<LandFormationTool.LFTarget> lfts, Pt cursor) {
        double worldY;
        double worldX;
        for (LandFormationTool.LFTarget lft : lfts) {
            boolean allowed;
            if (!this.canPlace(lft, us.intent instanceof EditMissionIntent || us.intent instanceof SingleCombatSetupIntent)) continue;
            double x = lft.lf.getX() + (double)(lft.x * 16);
            double y = lft.lf.getY() + (double)(lft.y * 16);
            boolean bl = allowed = us.intent instanceof SingleCombatSetupIntent || us.intent instanceof EditMissionIntent || us.intent instanceof DefencesIntent && us.wm.owner((City)us.city).money >= this.placeCost(lft);
            if (this.type.app != null) {
                this.type.app.draw(d, x, y, 16.0, 16.0, 0, allowed ? AGame.HIGHLIGHT : AGame.FORBIDDEN, false);
                continue;
            }
            if (this.type != LandBlockType.ofName("AIR")) continue;
            d.blit(EditPalettePanel.REMOVE, allowed ? AGame.HIGHLIGHT : AGame.FORBIDDEN, x, y);
        }
        if (lfts.isEmpty() && us.intent instanceof EditMissionIntent && this.type != LandBlockType.ofName("AIR") && this.freeToPlaceNewFloater(us, worldX = us.screenToWorldX(cursor.x) - 8.0, worldY = us.screenToWorldY(cursor.y) - 8.0) && this.type.app != null) {
            this.type.app.draw(d, worldX, worldY, 16.0, 16.0, 0, AGame.HIGHLIGHT, false);
        }
    }

    @Override
    public void drawUnscaled(MyDraw d, UniScreen us, ArrayList<LandFormationTool.LFTarget> lfts, Pt cursor) {
        double worldY;
        double worldX;
        boolean canPlaceAny = false;
        for (LandFormationTool.LFTarget lft : lfts) {
            canPlaceAny |= this.canPlace(lft, us.intent instanceof EditMissionIntent || us.intent instanceof SingleCombatSetupIntent);
        }
        int placeCost = this.placeCost(lfts, us.intent instanceof EditMissionIntent || us.intent instanceof SingleCombatSetupIntent);
        if (canPlaceAny) {
            boolean allowed;
            boolean bl = allowed = us.intent instanceof SingleCombatSetupIntent || us.intent instanceof EditMissionIntent || us.intent instanceof DefencesIntent && us.wm.owner((City)us.city).money >= placeCost;
            if (this.type == LandBlockType.ofName("AIR") && lfts.size() == 1) {
                LandFormationTool.LFTarget lft = lfts.get(0);
                d.text(allowed ? Lang._t("Remove_x_Sy", lft.lf.typeAt(lft.x, lft.y).getName(), placeCost) : MyDraw.ERROR_C + Lang._t("Remove_x_Sy", lft.lf.typeAt(lft.x, lft.y).getName(), this.placeCost(lft)), AGame.FOUNT, (int)cursor.x + 16, (int)cursor.y);
            } else {
                d.text(allowed ? Lang._t("Place_x_Sy", this.type.getName(), placeCost) : MyDraw.ERROR_C + Lang._t("Place_x_Sy", this.type.getName(), placeCost), AGame.FOUNT, (int)cursor.x + 16, (int)cursor.y);
            }
        } else if (lfts.isEmpty() && us.intent instanceof EditMissionIntent && this.type != LandBlockType.ofName("AIR") && this.freeToPlaceNewFloater(us, worldX = us.screenToWorldX(cursor.x) - 8.0, worldY = us.screenToWorldY(cursor.y) - 8.0)) {
            d.text(Lang._t("Place_x_Sy", this.type.getName(), this.type.addCost), AGame.FOUNT, (int)cursor.x + 16, (int)cursor.y);
        }
    }

    @Override
    public boolean click(Input in, UniScreen us, ArrayList<LandFormationTool.LFTarget> lfts, Pt click) {
        LandscapeEditorPanel lep = us.panel(LandscapeEditorPanel.class);
        if (click.x < (double)(MyDraw.SIDE_CLEARANCE + lep.width) && click.y < (double)(MyDraw.TOP_BAR_H + MyDraw.UI_SPACING + lep.height)) {
            return false;
        }
        return this.place(in, us, lfts, click, true);
    }

    private boolean place(Input in, UniScreen us, ArrayList<LandFormationTool.LFTarget> lfts, Pt click, boolean canCreateNew) {
        double worldY;
        double worldX;
        if (us.intent instanceof EditMissionIntent) {
            ((EditMissionIntent)us.intent).modified();
        }
        for (LandFormationTool.LFTarget lft : lfts) {
            if (!this.canPlace(lft, us.intent instanceof EditMissionIntent || us.intent instanceof SingleCombatSetupIntent) || !(us.intent instanceof SingleCombatSetupIntent) && !(us.intent instanceof EditMissionIntent) && (!(us.intent instanceof DefencesIntent) || us.wm.owner((City)us.city).money < this.placeCost(lft))) continue;
            int placeCost = this.placeCost(lft);
            if (lft.lf.typeAt(lft.x, lft.y + 1) == LandBlockType.ofName("GRASS")) {
                lft.lf.grid[lft.y + 1][lft.x] = LandBlockType.ofName("SOIL");
            }
            lft.lf.setTileType(this.type, lft.x, lft.y);
            if (lft.lf.grid.length == 0) {
                this.destroyLandFormation(us, lft.lf);
            }
            PlaceLandBlockTool.adjustBuildingVerticals(us);
            if (!(us.intent instanceof DefencesIntent)) continue;
            us.wm.owner((City)us.city).money -= placeCost;
        }
        if (lfts.isEmpty() && (us.intent instanceof EditMissionIntent || us.intent instanceof SingleCombatSetupIntent) && this.type != LandBlockType.ofName("AIR") && this.freeToPlaceNewFloater(us, worldX = us.screenToWorldX(click.x) - 8.0, worldY = us.screenToWorldY(click.y) - 8.0)) {
            LandFormation lf = new LandFormation(worldX, worldY, 1, 1, us.landscapeType());
            lf.grid[0][0] = this.type;
            this.createLandFormation(us, lf);
            PlaceLandBlockTool.adjustBuildingVerticals(us);
            if (us.intent instanceof DefencesIntent) {
                us.wm.owner((City)us.city).money -= this.type.addCost;
            }
        }
        return false;
    }

    public static void adjustBuildingVerticals(UniScreen us) {
        if (us.intent instanceof DefencesIntent) {
            for (Airship bld : us.city.getDefences()) {
                bld.setY(us.city.ground.getVerticalPosition(bld, (int)bld.getX(), bld.flipped, false));
            }
        }
        if (us.intent instanceof SingleCombatSetupIntent || us.intent instanceof EditMissionIntent) {
            for (Combat.Side side : us.combat.sides) {
                for (Airship a : side.ships) {
                    if (!a.type.onGround) continue;
                    a.setY((double)us.combat.landFormations.get(0).getVerticalPosition(a, (int)a.getX(), a.flipped, false) - a.groundOffset());
                }
            }
        }
    }

    @Override
    public boolean rightClick(Input in, UniScreen us, ArrayList<LandFormationTool.LFTarget> lfts, Pt click) {
        if (us.intent instanceof EditMissionIntent) {
            ((EditMissionIntent)us.intent).modified();
        }
        LandscapeEditorPanel lep = us.panel(LandscapeEditorPanel.class);
        if (click.x < (double)(MyDraw.SIDE_CLEARANCE + lep.width) && click.y < (double)(MyDraw.TOP_BAR_H + MyDraw.UI_SPACING + lep.height)) {
            return false;
        }
        LandBlockType orig = this.type;
        this.type = LandBlockType.ofName("AIR");
        boolean result = this.click(in, us, lfts, click);
        this.type = orig;
        return result;
    }

    @Override
    public boolean mouseDown(Input in, UniScreen us, ArrayList<LandFormationTool.LFTarget> lfts, Pt click) {
        LandscapeEditorPanel lep = us.panel(LandscapeEditorPanel.class);
        if (click.x < (double)(MyDraw.SIDE_CLEARANCE + lep.width) && click.y < (double)(MyDraw.TOP_BAR_H + MyDraw.UI_SPACING + lep.height)) {
            return false;
        }
        return in.mouseDownButton() == 1 ? this.place(in, us, lfts, click, false) : this.rightClick(in, us, lfts, click);
    }

    @Override
    public void tick(Input in, int ms, UniScreen us) {
        if (!(us.intent instanceof SingleCombatSetupIntent || us.intent instanceof EditMissionIntent || us.intent instanceof DefencesIntent)) {
            us.tool = UniScreen.NAVIGATE;
        }
    }
}

