/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.Analytics;
import com.zarkonnen.airships.CoatOfArms;
import com.zarkonnen.airships.CombatIntent;
import com.zarkonnen.airships.CommandButtonsPanel;
import com.zarkonnen.airships.Decal;
import com.zarkonnen.airships.DecalType;
import com.zarkonnen.airships.EditInfoPanel;
import com.zarkonnen.airships.EditPalettePanel;
import com.zarkonnen.airships.EditShipIntent;
import com.zarkonnen.airships.Keys;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.OverlayChooserPanel;
import com.zarkonnen.airships.PaintType;
import com.zarkonnen.airships.PlaceModuleTool;
import com.zarkonnen.airships.PlaceTool;
import com.zarkonnen.airships.SingleShipIntent;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;
import java.util.Collections;
import org.newdawn.slick.Color;
import org.newdawn.slick.Image;

public strictfp class PlaceDecalTool
extends PlaceTool {
    public DecalType dt;

    @Override
    public String getLabel() {
        return Lang._t("Decals", new Object[0]);
    }

    public PlaceDecalTool(DecalType dt) {
        this.dt = dt;
    }

    public CoatOfArms coa(UniScreen us) {
        if (us.intent instanceof EditShipIntent) {
            return ((EditShipIntent)us.intent).getArms(us);
        }
        return us.g.getBestCOA();
    }

    @Override
    public void scaledDraw(MyDraw d, double x, double y, int gridX, int gridY, UniScreen us) {
        if (this.dt == null) {
            if (PlaceModuleTool.REMOVE.machineImgCache != null) {
                ((Image)PlaceModuleTool.REMOVE.machineImgCache).setFilter(9728);
            }
            d.blit(PlaceModuleTool.REMOVE, x, y);
        } else {
            if (this.dt.flipped != null) {
                d.state.cursorText = this.dt.verticalFlipped != null ? Lang._t("Press_x_to_flip_module_c_to_flip_vertically", Keys.get("module_flip", "X"), Keys.get("module_flip_vertical", "C")) : Lang._t("Press_x_to_flip_module", Keys.get("module_flip", "X"));
            } else if (this.dt.verticalFlipped != null) {
                d.state.cursorText = Lang._t("Press_c_to_flip_module_vertically", Keys.get("module_flip_vertical", "C"));
            }
            String shipName = "NAME";
            boolean flipped = false;
            if (us.intent instanceof SingleShipIntent) {
                shipName = ((SingleShipIntent)((Object)us.intent)).getShip(us).getName();
                flipped = ((SingleShipIntent)((Object)us.intent)).getShip((UniScreen)us).flipped;
            }
            PaintType pt = us.panel(EditPalettePanel.class).moduleAndDecalPaintSel;
            int dx = flipped ? (this.dt.w - this.dt.imgW) * 16 : 0;
            this.dt.drawBase(d, x + (double)dx, y, 0, flipped, this.coa(us), shipName, null, 1.0f, Color.white, 1.0f, null, null, pt == null ? null : pt.getPaintType(us.getBestOverallCOA()));
            this.dt.drawCharges(d, x + (double)dx, y, 0, flipped, this.coa(us), shipName, null, 1.0f, Color.white, 1.0f, null, null);
            this.dt.drawUnlitCharges(d, x + (double)dx, y, 0, flipped, this.coa(us));
            this.dt.drawNonShader(d, x + (double)dx, y, 0, flipped, this.coa(us), shipName, null);
        }
    }

    @Override
    public void unscaledDraw(MyDraw d, Pt cursor, ScreenMode sm, UniScreen us) {
        if (this.dt != null && this.dt.canPlaceBelow()) {
            Pt sz = d.textSize(Lang._t("Hold_space_to_place_underneath", new Object[0]), AGame.FOUNT);
            d.text(Lang._t("Hold_space_to_place_underneath", new Object[0]), AGame.FOUNT, (int)((double)sm.width - sz.x - 5.0), (double)sm.height - sz.y - 3.0);
        }
    }

    @Override
    public boolean click(Input in, Pt click, ScreenMode sm, UniScreen us) {
        CommandButtonsPanel cbp = us.panel(CommandButtonsPanel.class);
        if (us.intent instanceof CombatIntent && click.x > (double)cbp.panelX && click.x < (double)(cbp.panelX + cbp.panelW) && click.y > (double)(sm.height - cbp.panelH)) {
            return false;
        }
        OverlayChooserPanel ocp = us.panel(OverlayChooserPanel.class);
        if (click.x < (double)us.panel(EditInfoPanel.class).myWidth || click.x >= (double)ocp.left && click.y < (double)ocp.bottom) {
            return false;
        }
        if (AirshipGame.metaLobbyOverlay != null && click.x >= (double)(sm.width - MyDraw.SIDE_CLEARANCE - MyDraw.BUTTON_H - 2) && click.x <= (double)(sm.width - MyDraw.SIDE_CLEARANCE + 2) && click.y >= (double)(sm.height - MyDraw.SIDE_CLEARANCE - MyDraw.BUTTON_H - 2) && click.y <= (double)(sm.height - MyDraw.SIDE_CLEARANCE + 2)) {
            return false;
        }
        Airship ship = this.ship(us);
        int[] sp = this.localShipPt(click, us, this.dt == null ? 1 : this.dt.w);
        if (this.dt == null) {
            if (ship.removeDecalAt(sp[0], sp[1]) != null) {
                in.play("remove", 1.0, 1.0 * us.g.volume, 0.0, 0.0);
                this.modified(us, true);
                if (us.intent instanceof EditShipIntent) {
                    EditShipIntent esi = (EditShipIntent)us.intent;
                    if (!esi.hasRemovedDecal) {
                        Analytics.report("hasRemovedDecal");
                        esi.hasRemovedDecal = true;
                    }
                }
                return true;
            }
        } else {
            int layer = 1;
            if (in.keyDown("SPACE") && this.dt.canPlaceBelow()) {
                layer = 0;
            }
            if (ship.canAddDecal(this.dt, sp[0], sp[1], layer, Collections.EMPTY_LIST)) {
                Decal d = ship.addDecal(this.dt, sp[0], sp[1], layer);
                if (this.dt.hasColoration()) {
                    d.paint = us.panel(EditPalettePanel.class).moduleAndDecalPaintSel;
                }
                in.play("place", 1.0, 1.0 * us.g.volume, 0.0, 0.0);
                this.modified(us, true);
                if (us.intent instanceof EditShipIntent) {
                    EditShipIntent esi = (EditShipIntent)us.intent;
                    if (!esi.hasPlacedDecal) {
                        Analytics.report("hasPlacedDecal");
                        esi.hasPlacedDecal = true;
                    }
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean rightClick(Input in, Pt click, ScreenMode sm, UniScreen us) {
        OverlayChooserPanel ocp = us.panel(OverlayChooserPanel.class);
        if (click.x < (double)us.panel(EditInfoPanel.class).myWidth || click.x >= (double)ocp.left && click.y < (double)ocp.bottom) {
            return false;
        }
        Airship ship = this.ship(us);
        int[] sp = this.localShipPt(click, us, this.dt == null ? 1 : this.dt.w);
        this.dt = ship.removeDecalAt(sp[0], sp[1]);
        if (this.dt != null) {
            in.play("paper_lift", 1.0, 1.0 * us.g.volume, 0.0, 0.0);
            this.modified(us, true);
            if (us.intent instanceof EditShipIntent) {
                EditShipIntent esi = (EditShipIntent)us.intent;
                if (!esi.hasRemovedDecal) {
                    Analytics.report("hasRemovedDecal");
                    esi.hasRemovedDecal = true;
                }
            }
        } else {
            us.tool = UniScreen.NAVIGATE;
        }
        return this.dt != null;
    }

    @Override
    public void tick(Input in, int ms, UniScreen us) {
        if (us.intent instanceof EditShipIntent) {
            EditShipIntent esi = (EditShipIntent)us.intent;
            if (!esi.hasSelectedDecal) {
                Analytics.report("hasSelectedDecal");
                esi.hasSelectedDecal = true;
            }
        }
        if (in.keyPressed(Keys.get("module_flip", "X")) && this.dt != null && this.dt.flipped != null && !us.textInputOccurring()) {
            this.dt = this.dt.flipped;
            boolean bl = us.panel(EditPalettePanel.class).showFlippedDecals = !us.panel(EditPalettePanel.class).showFlippedDecals;
        }
        if (in.keyPressed(Keys.get("module_flip_vertical", "C")) && this.dt != null && this.dt.verticalFlipped != null && !us.textInputOccurring()) {
            this.dt = this.dt.verticalFlipped;
            us.panel(EditPalettePanel.class).showVerticallyFlippedDecals = !us.panel(EditPalettePanel.class).showVerticallyFlippedDecals;
        }
    }
}

