/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Body;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.Rect2D;
import java.util.ArrayList;

public strictfp class Physics {
    public static final double AT_SPEED_BOUNDARY = 0.005;
    public double gravity = 0.0;
    public ArrayList<Body> bodies = new ArrayList();

    public void tickRepeatedly(int iters, int msPerIter, Combat combat) {
        for (int i = 0; i < iters; ++i) {
            this.tick(msPerIter, combat);
        }
    }

    private boolean addToColliderGroup(Body a, Body b, ArrayList<ArrayList<Body>> groups) {
        if (a.colliderGroup != null) {
            if (b.colliderGroup != null) {
                if (a.colliderGroup != b.colliderGroup) {
                    a.colliderGroup.addAll(b.colliderGroup);
                    for (Body body : b.colliderGroup) {
                        body.colliderGroup = a.colliderGroup;
                    }
                    return true;
                }
                return false;
            }
            b.colliderGroup = a.colliderGroup;
            b.colliderGroup.add(b);
            return true;
        }
        if (b.colliderGroup != null) {
            a.colliderGroup = b.colliderGroup;
            a.colliderGroup.add(a);
            return true;
        }
        ArrayList<Body> newGroup = new ArrayList<Body>();
        groups.add(newGroup);
        newGroup.add(a);
        newGroup.add(b);
        a.colliderGroup = newGroup;
        b.colliderGroup = newGroup;
        return true;
    }

    public void tick(int ms, Combat combat) {
        int sz = this.bodies.size();
        for (int i = 0; i < sz; ++i) {
            Body b = this.bodies.get(i);
            b.particlesTick(ms, combat);
            if (b.removeMe()) {
                this.bodies.remove(i);
                --sz;
                --i;
                continue;
            }
            if (b.getX() < -3200.0) {
                b.setxForce(b.getxForce() + (double)b.getMass() * (-3200.0 - b.getX()) * 1.0E-4);
                continue;
            }
            if (!(b.getX() + b.getBBWidth() > 3200.0)) continue;
            b.setxForce(b.getxForce() - (double)b.getMass() * (b.getX() + b.getBBWidth() - 3200.0) * 1.0E-4);
        }
        this.tick2(ms, combat);
    }

    private void tick2(int ms, Combat combat) {
        for (Body b : this.bodies) {
            b.colliderGroup = null;
            if (b.isImmobile()) {
                b.setxSpeed(0.0);
                b.setySpeed(0.0);
                b.oldX = b.getX();
                b.newX = b.getX();
                b.oldY = b.getY();
                b.newY = b.getY();
                b.postCollideXSpeed = 0.0;
                b.postCollideYSpeed = 0.0;
                b.groupXSpeed = 0.0;
                b.groupYSpeed = 0.0;
            } else {
                b.setxSpeed(b.getxSpeed() + b.getxForce() * (double)ms / (double)b.getMass());
                b.setySpeed(b.getySpeed() + b.getyForce() * (double)ms / (double)b.getMass());
                b.setySpeed(b.getySpeed() + this.gravity * (double)ms);
                double airSlowdownX = b.getxSpeed() * b.getxSpeed() * b.horizontalAirFriction() * (double)ms;
                if (b.getxSpeed() > 0.0) {
                    b.setxSpeed(StrictMath.max(b.getxSpeed() - airSlowdownX, 0.0));
                }
                if (b.getxSpeed() < 0.0) {
                    b.setxSpeed(StrictMath.min(0.0, b.getxSpeed() + airSlowdownX));
                }
                double airSlowdownY = b.getySpeed() * b.getySpeed() * b.verticalAirFriction() * (double)ms;
                if (b.getySpeed() > 0.0) {
                    b.setySpeed(StrictMath.max(b.getySpeed() - airSlowdownY, 0.0));
                }
                if (b.getySpeed() < 0.0) {
                    b.setySpeed(StrictMath.min(0.0, b.getySpeed() + airSlowdownY));
                }
                b.oldX = b.getX();
                b.oldY = b.getY();
                b.newX = b.getX() + b.getxSpeed() * (double)ms;
                b.newY = b.getY() + b.getySpeed() * (double)ms;
                b.postCollideXSpeed = b.getxSpeed();
                b.postCollideYSpeed = b.getySpeed();
                b.groupXSpeed = b.getxSpeed();
                b.groupYSpeed = b.getySpeed();
            }
            b.setxForce(0.0);
            b.setyForce(0.0);
            b.lastExertedXForce = b.exertedXForce;
            b.lastExertedYForce = b.exertedYForce;
            b.exertedXForce = 0.0;
            b.exertedYForce = 0.0;
        }
        for (Body b1 : this.bodies) {
            for (Body b2 : this.bodies) {
                if (b1 == b2) continue;
                b1.setX(b1.newX);
                b1.setY(b1.newY);
                b2.setX(b2.newX);
                b2.setY(b2.newY);
                if (!Rect2D.intersects(b1.getX(), b1.getY(), b1.getBBWidth(), b1.getBBHeight(), b2.getX(), b2.getY(), b2.getBBWidth(), b2.getBBHeight()) || !b1.collidesWith(b2) && !b2.collidesWith(b1)) continue;
                double speedDeltaSquared = (b1.getxSpeed() - b2.getxSpeed()) * (b1.getxSpeed() - b2.getxSpeed()) + (b1.getySpeed() - b2.getySpeed()) * (b1.getySpeed() - b2.getySpeed());
                b1.doCollision(b2, speedDeltaSquared * (double)(b1.getCollisionMass() + b2.getCollisionMass()), combat, (b1.isAtSpeed() || b2.isAtSpeed()) && speedDeltaSquared > 2.5E-5);
                if (b1.isImmobile()) continue;
                if (b2.isImmobile()) {
                    b1.postCollideXSpeed = b1.getxSpeed() * -1.0 * b1.elasticity() * b2.elasticity();
                    b1.postCollideYSpeed = b1.getySpeed() * -1.0 * b1.elasticity() * b2.elasticity();
                } else {
                    b1.postCollideXSpeed = (b1.elasticity() * b2.elasticity() * (double)b2.getMass() * (b2.getxSpeed() - b1.getxSpeed()) + (double)b1.getMass() * b1.getxSpeed() + (double)b2.getMass() * b2.getxSpeed()) / (double)(b1.getMass() + b2.getMass());
                    b1.postCollideYSpeed = (b1.elasticity() * b2.elasticity() * (double)b2.getMass() * (b2.getySpeed() - b1.getySpeed()) + (double)b1.getMass() * b1.getySpeed() + (double)b2.getMass() * b2.getySpeed()) / (double)(b1.getMass() + b2.getMass());
                }
                b1.groupXSpeed = b1.postCollideXSpeed;
                b1.groupYSpeed = b1.postCollideYSpeed;
            }
        }
        this.tick3(ms, combat);
    }

    private void tick3(int ms, Combat combat) {
        boolean newGroups = true;
        ArrayList<ArrayList<Body>> colliderGroups = new ArrayList<ArrayList<Body>>();
        while (newGroups) {
            newGroups = false;
            for (Body body : this.bodies) {
                if (body.isImmobile()) {
                    body.setX(body.oldX);
                    body.setY(body.oldY);
                    continue;
                }
                body.setX(body.oldX + body.groupXSpeed * (double)ms);
                body.setY(body.oldY + body.groupYSpeed * (double)ms);
            }
            for (Body body : this.bodies) {
                for (Body b2 : this.bodies) {
                    if (body == b2 || body.colliderGroup != null && body.colliderGroup.contains(b2) || !Rect2D.intersects(body.getX(), body.getY(), body.getBBWidth(), body.getBBHeight(), b2.getX(), b2.getY(), b2.getBBWidth(), b2.getBBHeight()) || !body.collidesWith(b2)) continue;
                    newGroups |= this.addToColliderGroup(body, b2, colliderGroups);
                }
            }
            for (ArrayList arrayList : colliderGroups) {
                double sumOfXMomenta = 0.0;
                double sumOfYMomenta = 0.0;
                double sumOfMasses = 0.0;
                boolean immobile = false;
                for (Body b : arrayList) {
                    sumOfXMomenta += b.postCollideXSpeed * (double)b.getMass();
                    sumOfYMomenta += b.postCollideYSpeed * (double)b.getMass();
                    sumOfMasses += (double)b.getMass();
                    immobile |= b.isImmobile();
                }
                double groupXSpeed = sumOfXMomenta / sumOfMasses;
                double groupYSpeed = immobile ? 0.0 : sumOfYMomenta / sumOfMasses;
                for (Body b : arrayList) {
                    b.groupXSpeed = groupXSpeed;
                    b.groupYSpeed = groupYSpeed;
                }
            }
        }
        this.tick4(ms, combat);
    }

    private void tick4(int ms, Combat combat) {
        for (Body b : this.bodies) {
            if (b.isImmobile()) {
                b.setX(b.oldX);
                b.setY(b.oldY);
                continue;
            }
            b.setX(b.oldX + b.groupXSpeed * (double)ms);
            b.setY(b.oldY + b.groupYSpeed * (double)ms);
            b.setxSpeed(b.groupXSpeed);
            b.setySpeed(b.groupYSpeed);
        }
    }

    public boolean isClean() {
        for (Body b1 : this.bodies) {
            for (Body b2 : this.bodies) {
                if (b1 == b2 || !Rect2D.intersects(b1.getX(), b1.getY(), b1.getBBWidth(), b1.getBBHeight(), b2.getX(), b2.getY(), b2.getBBWidth(), b2.getBBHeight()) || !b1.collidesWith(b2)) continue;
                return false;
            }
        }
        return true;
    }
}

