/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.Appearance;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.catengine.util.ScreenMode;
import org.json.JSONArray;
import org.json.JSONObject;

public strictfp class PerfReport {
    public static final int[] FRAME_TIME_BOUNDARIES = new int[]{2, 4, 8, 16, 32, 64, 128, 256};
    public final int[] tickTimeCounts = new int[FRAME_TIME_BOUNDARIES.length + 1];
    public final int[] renderTimeCounts = new int[FRAME_TIME_BOUNDARIES.length + 1];
    public int totalTickMs;
    public int totalRenderMs;
    public int totalTickFrames;
    public int totalRenderFrames;
    public int numShips;
    public int numModules;
    public int screenW;
    public int screenH;

    public PerfReport(Combat c, ScreenMode sm) {
        for (Combat.Side s : c.sides) {
            this.numShips += s.ships.size();
            for (Airship ship : s.ships) {
                this.numModules += ship.modules.size();
            }
        }
        this.screenW = sm.width;
        this.screenH = sm.height;
    }

    public void countTickTime(int ms) {
        this.totalTickMs += ms;
        ++this.totalTickFrames;
        for (int i = 0; i < FRAME_TIME_BOUNDARIES.length; ++i) {
            if (ms >= FRAME_TIME_BOUNDARIES[i]) continue;
            int n = i;
            this.tickTimeCounts[n] = this.tickTimeCounts[n] + 1;
            return;
        }
        int n = this.tickTimeCounts.length - 1;
        this.tickTimeCounts[n] = this.tickTimeCounts[n] + 1;
    }

    public void countRenderTime(int ms) {
        this.totalRenderMs += ms;
        ++this.totalRenderFrames;
        for (int i = 0; i < FRAME_TIME_BOUNDARIES.length; ++i) {
            if (ms >= FRAME_TIME_BOUNDARIES[i]) continue;
            int n = i;
            this.renderTimeCounts[n] = this.renderTimeCounts[n] + 1;
            return;
        }
        int n = this.tickTimeCounts.length - 1;
        this.renderTimeCounts[n] = this.renderTimeCounts[n] + 1;
    }

    public String toString() {
        JSONObject o = new JSONObject();
        String tcReport = "";
        JSONArray tickCounts = new JSONArray();
        for (int i = 0; i < this.tickTimeCounts.length; ++i) {
            tickCounts.put(this.tickTimeCounts[i]);
            tcReport = tcReport + (i == this.tickTimeCounts.length - 1 ? "+" : FRAME_TIME_BOUNDARIES[i] + "") + ": " + this.tickTimeCounts[i] + ", ";
        }
        o.put("tickCounts", tickCounts);
        o.put("tickCountReport", tcReport.substring(0, tcReport.length() - 2));
        String rcReport = "";
        JSONArray renderCounts = new JSONArray();
        for (int i = 0; i < this.renderTimeCounts.length; ++i) {
            renderCounts.put(this.renderTimeCounts[i]);
            rcReport = rcReport + (i == this.renderTimeCounts.length - 1 ? "+" : FRAME_TIME_BOUNDARIES[i] + "") + ": " + this.renderTimeCounts[i] + ", ";
        }
        o.put("renderCounts", renderCounts);
        o.put("renderCountReport", rcReport.substring(0, rcReport.length() - 2));
        o.put("numShips", this.numShips);
        o.put("numModules", this.numModules);
        o.put("avgTickTime", this.totalTickMs / (this.totalTickFrames + 1));
        o.put("avgRenderTime", this.totalRenderMs / (this.totalRenderFrames + 1));
        o.put("tickFrames", this.totalTickFrames);
        o.put("renderFrames", this.totalRenderFrames);
        o.put("screenW", this.screenW);
        o.put("screenH", this.screenH);
        o.put("lighting", Appearance.useLighting && !Appearance.useSimpleGraphics && !Appearance.shaderLoadFailed);
        return o.toString(4);
    }

    public boolean hasBadPerformance() {
        if (this.totalTickFrames < 10 || this.totalRenderFrames < 10 || this.totalRenderMs == 0 || this.totalTickMs == 0) {
            return false;
        }
        return this.totalTickMs / (this.totalTickFrames + 1) > 500 || this.totalRenderMs / (this.totalRenderFrames + 1) > 500;
    }
}

