/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Loadable;
import com.zarkonnen.airships.Particle;
import com.zarkonnen.catengine.util.Clr;
import org.json.JSONObject;

public strictfp class ParticleType
extends Loadable {
    public final boolean directional;
    public final Particle.PictureType pt;
    public final boolean lit;
    public final int maxSize;
    public final boolean dissolveWhenStuck;
    public final double stickSpeed;
    public final double grav;
    public final double windMult;
    public final double offset;
    public final double minDx;
    public final double maxDx;
    public final double minDy;
    public final double maxDy;
    public final int minLifespan;
    public final int maxLifespan;
    public final int startSize;
    public final int endSize;
    public final Clr startClr;
    public final Clr earlyClr;
    public final Clr endClr;
    public final Clr tintStartClr;
    public final Clr tintEndClr;
    public final float[][] gradient = new float[30][4];
    public final Clr[] tintGradient = new Clr[30];
    public final Clr lightClr;
    public final int lightRadius;
    public final double haloStrength;
    public final boolean strongLight;
    public final boolean accumulates;

    public ParticleType(JSONObject o) {
        super(o.getString("name"));
        Clr c;
        int i;
        this.pt = o.has("pictureType") ? Particle.PictureType.valueOf(o.getString("pictureType")) : null;
        this.directional = o.optBoolean("directional", false);
        this.lit = o.optBoolean("lit", false);
        this.stickSpeed = o.optDouble("stickSpeed", 0.0);
        this.dissolveWhenStuck = o.optBoolean("dissolveWhenStuck", false);
        this.grav = o.getDouble("grav");
        this.windMult = o.optDouble("windMult", 1.0);
        this.offset = o.getDouble("offset");
        this.minDx = o.getDouble("minDx");
        this.maxDx = o.getDouble("maxDx");
        this.minDy = o.getDouble("minDy");
        this.maxDy = o.getDouble("maxDy");
        this.minLifespan = StrictMath.max(10, o.getInt("minLifespan"));
        this.maxLifespan = StrictMath.max(10, o.getInt("maxLifespan"));
        this.startSize = o.getInt("startSize");
        this.endSize = o.getInt("endSize");
        this.startClr = o.has("startClr") ? new Clr(o.getJSONObject("startClr").getInt("r"), o.getJSONObject("startClr").getInt("g"), o.getJSONObject("startClr").getInt("b"), o.getJSONObject("startClr").getInt("a")) : null;
        this.earlyClr = o.has("earlyClr") ? new Clr(o.getJSONObject("earlyClr").getInt("r"), o.getJSONObject("earlyClr").getInt("g"), o.getJSONObject("earlyClr").getInt("b"), o.getJSONObject("earlyClr").getInt("a")) : null;
        this.endClr = o.has("endClr") ? new Clr(o.getJSONObject("endClr").getInt("r"), o.getJSONObject("endClr").getInt("g"), o.getJSONObject("endClr").getInt("b"), o.getJSONObject("endClr").getInt("a")) : null;
        this.tintStartClr = o.has("tintStartClr") ? new Clr(o.getJSONObject("tintStartClr").getInt("r"), o.getJSONObject("tintStartClr").getInt("g"), o.getJSONObject("tintStartClr").getInt("b"), o.getJSONObject("tintStartClr").getInt("a")) : null;
        this.tintEndClr = o.has("tintEndClr") ? new Clr(o.getJSONObject("tintEndClr").getInt("r"), o.getJSONObject("tintEndClr").getInt("g"), o.getJSONObject("tintEndClr").getInt("b"), o.getJSONObject("tintEndClr").getInt("a")) : null;
        this.haloStrength = o.optDouble("haloStrength", 1.0);
        if (this.earlyClr != null) {
            for (i = 0; i < 3; ++i) {
                c = this.startClr.mix(1.0 * (double)i / 5.0, this.earlyClr);
                this.gradient[i] = new float[]{(float)c.r / 255.0f, (float)c.g / 255.0f, (float)c.b / 255.0f, (float)c.a / 255.0f};
            }
            for (i = 3; i < this.gradient.length; ++i) {
                c = this.earlyClr.mix(1.0 * (double)(i - 3) / (double)(this.gradient.length - 3), this.endClr);
                this.gradient[i] = new float[]{(float)c.r / 255.0f, (float)c.g / 255.0f, (float)c.b / 255.0f, (float)c.a / 255.0f};
            }
        } else {
            for (i = 0; i < this.gradient.length; ++i) {
                c = this.startClr.mix(1.0 * (double)i / (double)this.gradient.length, this.endClr);
                this.gradient[i] = new float[]{(float)c.r / 255.0f, (float)c.g / 255.0f, (float)c.b / 255.0f, (float)c.a / 255.0f};
            }
        }
        if (this.tintStartClr != null) {
            for (i = 0; i < this.tintGradient.length; ++i) {
                this.tintGradient[i] = this.tintStartClr.mix(1.0 * (double)i / (double)this.tintGradient.length, this.tintEndClr);
            }
        }
        this.maxSize = StrictMath.max(this.startSize, this.endSize);
        this.lightClr = o.has("lightClr") ? new Clr(o.getJSONObject("lightClr").getInt("r"), o.getJSONObject("lightClr").getInt("g"), o.getJSONObject("lightClr").getInt("b"), o.getJSONObject("lightClr").getInt("a")) : null;
        this.lightRadius = o.optInt("lightRadius", 0);
        this.strongLight = o.optBoolean("strongLight", false);
        this.accumulates = o.optBoolean("accumulates", false);
    }

    public static ParticleType ofName(String name) {
        return Loadable.ofName(ParticleType.class, name);
    }
}

