/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.CampaignWorld;
import com.zarkonnen.airships.FileScreen;
import com.zarkonnen.airships.HostOrJoinStrategicScreen;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MainMenu;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.json.JSONObject;

public strictfp class OpenMPGameMission
implements FileScreen.Mission {
    private final AirshipGame g;
    private final FileScreen.Backend backend;

    public OpenMPGameMission(AirshipGame g, FileScreen.Backend backend) {
        this.g = g;
        this.backend = backend;
    }

    @Override
    public FileScreen.Mode mode() {
        return FileScreen.Mode.OPEN;
    }

    @Override
    public String text() {
        return Lang._t("Open_save_", new Object[0]);
    }

    @Override
    public String fileSelectionText() {
        return Lang._t("Open", new Object[0]);
    }

    @Override
    public String initialInput() {
        return "";
    }

    private void setup(JSONObject gameData) {
        this.g.s = new HostOrJoinStrategicScreen(true, this.g, gameData);
    }

    @Override
    public void fileSelected(String path) {
        int retry = 0;
        while (true) {
            try {
                JSONObject o = new JSONObject(FileUtils.readFileToString((File)this.backend.getFile(FileScreen.splitPath(path)), (String)"UTF-8"));
                int version = o.optInt("version", 0);
                if (!CampaignWorld.READABLE_VERSIONS.contains(version)) {
                    this.g.showError(Lang._t("Save_out_of_date", new Object[0]));
                    this.g.s = new MainMenu(this.g, MainMenu.Submenu.MULTIPLAYER);
                    return;
                }
                this.setup(o);
            }
            catch (Exception e) {
                if (retry++ < 3) continue;
                this.g.showError(Lang._t("Unable_to_load_game", new Object[0]));
                this.g.s = new MainMenu(this.g, MainMenu.Submenu.MULTIPLAYER);
                return;
            }
            break;
        }
    }

    @Override
    public void cancelled() {
        this.g.s = new MainMenu(this.g, MainMenu.Submenu.MULTIPLAYER);
    }
}

