/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.ChatAdapter;
import com.zarkonnen.airships.Client;
import com.zarkonnen.airships.DefencesIntent;
import com.zarkonnen.airships.EditInfoPanel;
import com.zarkonnen.airships.EditShipIntent;
import com.zarkonnen.airships.EspionageIntent;
import com.zarkonnen.airships.GenericChatMsg;
import com.zarkonnen.airships.IntRect;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MultiplayerCampaignCombatIntent;
import com.zarkonnen.airships.MultiplayerCampaignCombatSetupIntent;
import com.zarkonnen.airships.MultiplayerCombatIntent;
import com.zarkonnen.airships.MultiplayerEditShipIntent;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.RaidPanel;
import com.zarkonnen.airships.ReservePanel;
import com.zarkonnen.airships.ScrollBar;
import com.zarkonnen.airships.StrategicScreen;
import com.zarkonnen.airships.TextField;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Fount;
import com.zarkonnen.catengine.Hooks;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;
import java.util.ArrayList;

public strictfp class MultiplayerChat
implements UniScreen.InfoPanel {
    public TextField chatField = null;
    private final ScrollBar chatScrollBar = new ScrollBar();
    private final ChatAdapter<GenericChatMsg> chatAdapter = new ChatAdapter();
    private final IntRect chatScrollBarRect = new IntRect();

    public MultiplayerChat() {
        this.chatScrollBar.stickToBottom = true;
        this.chatScrollBar.offset = 100000;
    }

    @Override
    public void draw(MyDraw d, Pt cursor, ScreenMode sm, Hooks hs, final UniScreen us) {
        if (!(us.intent instanceof MultiplayerCombatIntent) && !(us.intent instanceof MultiplayerCampaignCombatIntent) && !(us.intent instanceof MultiplayerCampaignCombatSetupIntent) && !(us.intent instanceof EspionageIntent) && !(us.intent instanceof DefencesIntent) && !(us.intent instanceof MultiplayerEditShipIntent) || us.combat == null && us.cw == null) {
            return;
        }
        if (us.hideUI) {
            return;
        }
        if (us.cw != null && !us.cw.isMultiplayer()) {
            return;
        }
        if (this.chatField == null) {
            return;
        }
        int y = MyDraw.TOP_BAR_H + us.panel(RaidPanel.class).h;
        int x = MyDraw.SIDE_CLEARANCE;
        ReservePanel rp = us.panel(ReservePanel.class);
        if (rp.visible && rp.leftSide) {
            x = rp.width + MyDraw.UI_SPACING;
        }
        if (us.intent instanceof EditShipIntent) {
            EditInfoPanel eip = us.panel(EditInfoPanel.class);
            x = eip.myWidth + MyDraw.UI_SPACING;
        }
        int width = StrictMath.max(200, sm.width / 4);
        int height = StrictMath.max(150, sm.height / 4);
        this.chatScrollBarRect.x = x;
        this.chatScrollBarRect.y = y;
        this.chatScrollBarRect.w = width;
        this.chatScrollBarRect.h = height;
        ArrayList<GenericChatMsg> chatMessages = us.cw != null ? us.cw.chatMessages : us.combat.chatMessages;
        this.chatScrollBar.draw(d, x, y, width, height, chatMessages, this.chatAdapter);
        y += height + MyDraw.BUTTON_SPACING;
        if (this.chatField.focus) {
            int bw = d.bw(Lang._t("Send", new Object[0]));
            int h = (int)d.textSize((String)this.chatField.displayText(), (Fount)AGame.FOUNT, (int)(width - bw - MyDraw.BUTTON_SPACING - MyDraw.PANEL_INSET * 2), (int)10000, (int)0, (boolean)false).y - 2 + MyDraw.PANEL_INSET * 2;
            this.chatField.render(x, y, width - bw - MyDraw.BUTTON_SPACING, h, d, sm, hs, cursor);
            d.button(x + width - bw, y, bw, Lang._t("Send", new Object[0]), null, new Runnable(){

                @Override
                public void run() {
                    MultiplayerChat.this.sendChat(us);
                }
            }, !this.chatField.getText().isEmpty());
        } else {
            d.button(x, y, width, Lang._t("Chat", new Object[0]), new Runnable(){

                @Override
                public void run() {
                    MultiplayerChat.this.chatField.focus = true;
                }
            });
        }
    }

    private void sendChat(UniScreen us) {
        if (!this.chatField.getText().isEmpty()) {
            us.g.sendMessage(Client.msg("chat").put("text", this.chatField.getText()).put("id", us.g.playerID()));
            this.chatField.setText("");
        }
        this.chatField.focus = false;
    }

    @Override
    public void tick(Input in, int ms, UniScreen us) {
        if (!(us.intent instanceof MultiplayerCombatIntent) && !(us.intent instanceof MultiplayerCampaignCombatIntent) && !(us.intent instanceof MultiplayerCampaignCombatSetupIntent) && !(us.intent instanceof EspionageIntent) && !(us.intent instanceof DefencesIntent) || us.combat == null && us.cw == null) {
            return;
        }
        if (us.hideUI) {
            return;
        }
        if (us.cw != null && !us.cw.isMultiplayer()) {
            return;
        }
        if (this.chatField == null) {
            StrategicScreen ss = null;
            if (us.intent instanceof MultiplayerCampaignCombatIntent) {
                ss = ((MultiplayerCampaignCombatIntent)us.intent).ss;
            }
            if (us.intent instanceof MultiplayerCampaignCombatSetupIntent) {
                ss = ((MultiplayerCampaignCombatSetupIntent)us.intent).ss;
            }
            if (us.intent instanceof EspionageIntent) {
                ss = ((EspionageIntent)us.intent).ss;
            }
            if (us.intent instanceof DefencesIntent) {
                ss = ((DefencesIntent)us.intent).ss;
            }
            if (ss != null) {
                this.chatField = ss.chatField;
            } else {
                this.chatField = new TextField();
                this.chatField.focus = false;
            }
        }
        if (!(!in.keyPressed("ENTER") || AirshipGame.multiplayerChatOverlay && AirshipGame.metaLobbyOverlay != null && AirshipGame.instance.mpChatOverlayActive)) {
            if (this.chatField.focus && !this.chatField.getText().isEmpty()) {
                us.g.sendMessage(Client.msg("chat").put("text", this.chatField.getText()).put("id", us.g.playerID()));
                this.chatField.setText("");
            }
            boolean bl = this.chatField.focus = !this.chatField.focus;
        }
        if (this.chatField.focus) {
            this.chatField.input(in, null, in.cursor(), in.clicked(), ms);
        }
        this.chatScrollBar.tick(in, this.chatScrollBarRect.x, this.chatScrollBarRect.y, this.chatScrollBarRect.w, this.chatScrollBarRect.h);
    }

    @Override
    public boolean chatEnabled(UniScreen us) {
        return this.chatField != null && this.chatField.focus;
    }

    @Override
    public boolean doScroll(UniScreen us, int scrollAmt, Pt cursor, ScreenMode sm) {
        return this.chatScrollBarRect.contains(cursor);
    }

    @Override
    public boolean arrowKeysInUse(UniScreen us) {
        return this.chatEnabled(us);
    }
}

