/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.City;
import com.zarkonnen.airships.Client;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.CombatInfo;
import com.zarkonnen.airships.CombatIntent;
import com.zarkonnen.airships.Empire;
import com.zarkonnen.airships.FleetOwner;
import com.zarkonnen.airships.HasCombatInfo;
import com.zarkonnen.airships.InitCombatProcess;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MainMenu;
import com.zarkonnen.airships.MultiplayerCampaignCombatIntent;
import com.zarkonnen.airships.Rect2D;
import com.zarkonnen.airships.RestrictsShipPlacement;
import com.zarkonnen.airships.SingleCombatSetupIntent;
import com.zarkonnen.airships.StrategicScreen;
import com.zarkonnen.airships.TacticalAI;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.airships.ZoomToFitButton;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Pt;
import org.json.JSONObject;

public strictfp class MultiplayerCampaignCombatSetupIntent
implements UniScreen.Intent,
RestrictsShipPlacement,
HasCombatInfo {
    public static final int COUNTDOWN_LENGTH = 30000;
    public StrategicScreen ss;
    public CombatInfo ci;
    public boolean spectate;
    public boolean first = true;
    public int countdownLeft = 30000;
    public boolean readySent;
    public boolean[] sideHasSentReady = new boolean[2];

    public MultiplayerCampaignCombatSetupIntent(StrategicScreen ss, CombatInfo ci, boolean spectate) {
        this.ss = ss;
        this.ci = ci;
        this.spectate = spectate;
    }

    private boolean canStart() {
        FleetOwner attacker = this.ci.attacker(this.ss.w.map);
        if (attacker instanceof Empire && ((Empire)attacker).playerControlled && !this.sideHasSentReady[0]) {
            return false;
        }
        FleetOwner defender = this.ci.defender(this.ss.w.map);
        return !(defender instanceof Empire) || !((Empire)defender).playerControlled || this.sideHasSentReady[1];
    }

    @Override
    public void tick(Input in, int ms, UniScreen us) {
        if (this.first) {
            ZoomToFitButton.zoomToFit(in, us, 1.0);
            this.first = false;
        }
        this.ss.w.tick(ms);
    }

    public void update(int ms) {
        if (this.ss.w.isMultiplayer() && !this.ss.g.isConnected()) {
            this.ss.emergencySave("disconnected");
            this.ss.g.showError(Lang._t("Connection_lost", new Object[0]));
            this.ss.g.s = new MainMenu(this.ss.g, MainMenu.Submenu.MULTIPLAYER);
            return;
        }
        UniScreen us = this.ss.combatUniScreen;
        if (us.g.s != us) {
            us.combat.sounds.clear();
        }
        this.countdownLeft = StrictMath.max(0, this.countdownLeft - ms);
        if (!this.spectate && this.countdownLeft == 0 && !this.readySent) {
            us.combat.giveCommand(Client.msg("combatReady").put("side", us.combat.sides.indexOf(us.mySide)));
            this.readySent = true;
        }
        if (this.canLeave(us)) {
            this.leave(us);
            return;
        }
        if (this.canStart()) {
            this.start(us);
        }
    }

    public void execCommand(JSONObject cmd) {
        Combat.Side side;
        Airship ship;
        String type = cmd.getString("type");
        if (type.equals("combatReady")) {
            this.sideHasSentReady[cmd.getInt((String)"side")] = true;
        }
        if (type.equals("surrender")) {
            this.ci.combat.sides.get((int)cmd.getInt((String)"side")).surrendered = true;
        }
        if (type.equals("placeShip") && (ship = (side = this.ci.combat.sides.get(cmd.getInt("side"))).getShip(cmd.getString("ship"))) != null) {
            if (side.reserve.contains(ship)) {
                side.reserve.remove(ship);
                side.ships.add(ship);
            }
            ship.setX(cmd.getDouble("x"));
            ship.setY(cmd.getDouble("y"));
            ship.moveTo = new Pt(ship.getX(), ship.getY());
            ship.setFlipped(cmd.getBoolean("flipped"), this.ci.combat);
            ship.flipTo = cmd.getBoolean("flipped");
            ship.lastPlaced = new Pt(ship.getX(), ship.getY());
            ship.lastPlacedFlipped = ship.flipped;
            ship.resetWeaponBarrels();
            ship.resetTentaclesForFlipped();
        }
        if (type.equals("reserveShip") && (ship = (side = this.ci.combat.sides.get(cmd.getInt("side"))).getShip(cmd.getString("ship"))) != null && side.ships.contains(ship)) {
            side.ships.remove(ship);
            side.reserve.add(ship);
        }
    }

    private boolean canLeave(UniScreen us) {
        for (Combat.Side s : us.combat.sides) {
            if (!s.surrendered) continue;
            return true;
        }
        return false;
    }

    public void leave(UniScreen us) {
        this.ss.w.multiplayerCampaignCombatSetupIntent = null;
        if (us.g.s == this.ss.combatUniScreen) {
            us.g.s = this.ss;
        }
        this.ss.postCombat();
    }

    public void start(UniScreen us) {
        FleetOwner defender;
        this.ss.w.multiplayerCampaignCombatSetupIntent = null;
        this.ss.w.frameAccumulatedMs = 0;
        this.ss.w.multiplayerCampaignCombatIntent = new MultiplayerCampaignCombatIntent(this.ss, this.ci, this.spectate);
        this.ss.w.multiplayerCampaignCombatIntent.first = this.first;
        us.intent = this.ss.w.multiplayerCampaignCombatIntent;
        FleetOwner attacker = this.ci.attacker(this.ss.w.map);
        if (!(attacker instanceof Empire) || !((Empire)attacker).playerControlled) {
            us.combat.sides.get((int)0).usingAI = true;
            boolean doesSurrender = attacker instanceof Empire && this.ci.defendingLoc != null;
            for (Airship as : us.combat.sides.get((int)0).ships) {
                as.ai = new TacticalAI(as, us.combat, us.combat.sides.get(0), us.combat.sides.get(1));
                as.ai.quality = this.ss.w.map.difficulty.enemyAI;
                as.ai.doesSurrender = doesSurrender;
            }
        }
        if (!((defender = this.ci.defender(this.ss.w.map)) instanceof Empire) || !((Empire)defender).playerControlled) {
            us.combat.sides.get((int)1).usingAI = true;
            boolean doesSurrender = false;
            int surrenderFactor = 8;
            if (defender instanceof Empire) {
                Empire de = (Empire)defender;
                doesSurrender = true;
                surrenderFactor = de.cities.size() > 1 && (!(this.ci.defendingLoc instanceof City) || ((City)this.ci.defendingLoc).isTown) ? 8 : 60;
            }
            for (Airship as : us.combat.sides.get((int)1).ships) {
                as.ai = new TacticalAI(as, us.combat, us.combat.sides.get(1), us.combat.sides.get(0));
                as.ai.quality = this.ss.w.map.difficulty.enemyAI;
                as.ai.doesSurrender = doesSurrender;
                as.ai.baseSurrenderFactor = surrenderFactor;
            }
        }
        us.tool = UniScreen.NAVIGATE;
        us.combat.repairAllShips();
        us.combat.initWheelsLegsTentaclesAndBarrels();
        us.combat.physics = null;
        ((CombatIntent)us.intent).initCombatProcess = new InitCombatProcess(us.combat);
    }

    @Override
    public Rect2D placementLimits(int sideIndex, UniScreen us) {
        switch (sideIndex) {
            case 0: {
                return SingleCombatSetupIntent.LEFT_RECT;
            }
            case 1: {
                return SingleCombatSetupIntent.RIGHT_RECT;
            }
        }
        return null;
    }

    @Override
    public boolean showOutside() {
        return false;
    }

    @Override
    public boolean showDecals() {
        return true;
    }

    @Override
    public boolean drawAsBlueprint() {
        return false;
    }

    @Override
    public boolean allowMultiSelect() {
        return true;
    }

    @Override
    public CombatInfo getCombatInfo() {
        return this.ci;
    }

    @Override
    public StrategicScreen getStrategicScreen() {
        return this.ss;
    }
}

