/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.CombatInfo;
import com.zarkonnen.airships.CombatIntent;
import com.zarkonnen.airships.Empire;
import com.zarkonnen.airships.FleetOwner;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MainMenu;
import com.zarkonnen.airships.StrategicScreen;
import com.zarkonnen.airships.TacticalAI;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.airships.ZoomToFitButton;
import com.zarkonnen.catengine.Input;

public strictfp class MultiplayerCampaignCombatIntent
extends CombatIntent {
    public StrategicScreen ss;
    public CombatInfo ci;
    public boolean spectate;
    public boolean first = true;

    public MultiplayerCampaignCombatIntent(StrategicScreen ss, CombatInfo ci, boolean spectate) {
        this.ss = ss;
        this.ci = ci;
        this.spectate = spectate;
    }

    @Override
    public boolean spectate() {
        return this.spectate;
    }

    public boolean runInitProcess() {
        return this.runInitProcess(this.ss.combatUniScreen);
    }

    @Override
    public void doLeave(UniScreen us) {
        this.ss.w.multiplayerCampaignCombatIntent = null;
        if (us.g.s == this.ss.combatUniScreen) {
            us.g.s = this.ss;
        }
        this.ss.postCombat();
    }

    @Override
    public void combatTick(Input in, int ms, UniScreen us) {
        if (this.first && this.spectate) {
            ZoomToFitButton.zoomToFit(in, us, 1.0);
            this.first = false;
        }
        this.ss.w.tick(ms);
    }

    public void update() {
        FleetOwner defender;
        boolean attackerDoesSurrender;
        if (this.ss.w.isMultiplayer() && !this.ss.g.isConnected()) {
            this.ss.emergencySave("disconnected");
            this.ss.g.showError(Lang._t("Connection_lost", new Object[0]));
            this.ss.g.s = new MainMenu(this.ss.g, MainMenu.Submenu.MULTIPLAYER);
            return;
        }
        UniScreen us = this.ss.combatUniScreen;
        if (us.g.s != us) {
            us.combat.sounds.clear();
        }
        if (us.combat.isFinished()) {
            System.out.println("combat done at time " + us.combat.time);
            this.doLeave(us);
            return;
        }
        FleetOwner attacker = this.ci.attacker(this.ss.w.map);
        boolean attackerShouldUseAI = !(attacker instanceof Empire) || !((Empire)attacker).playerControlled;
        boolean bl = attackerDoesSurrender = attacker instanceof Empire && this.ci.defendingLoc != null;
        if (!us.combat.sides.get((int)0).usingAI && attackerShouldUseAI) {
            System.out.println("Switching attacker to AI");
            us.combat.sides.get((int)0).usingAI = true;
            for (Airship as : us.combat.sides.get((int)0).ships) {
                as.ai = new TacticalAI(as, us.combat, us.combat.sides.get(0), us.combat.sides.get(1));
                as.ai.quality = this.ss.w.map.difficulty.enemyAI;
                as.ai.doesSurrender = attackerDoesSurrender;
            }
        }
        boolean defenderShouldUseAI = !((defender = this.ci.defender(this.ss.w.map)) instanceof Empire) || !((Empire)defender).playerControlled;
        boolean defenderDoesSurrender = defender instanceof Empire;
        if (!us.combat.sides.get((int)1).usingAI && defenderShouldUseAI) {
            System.out.println("Switching defender to AI");
            us.combat.sides.get((int)1).usingAI = true;
            for (Airship as : us.combat.sides.get((int)1).ships) {
                as.ai = new TacticalAI(as, us.combat, us.combat.sides.get(1), us.combat.sides.get(0));
                as.ai.quality = this.ss.w.map.difficulty.enemyAI;
                as.ai.doesSurrender = defenderDoesSurrender;
            }
        }
        if (us.combat.sides.get((int)0).usingAI && us.combat.sides.get((int)1).usingAI) {
            if (attackerDoesSurrender == defenderDoesSurrender) {
                int aStrength = 0;
                for (Airship s : us.combat.sides.get((int)0).ships) {
                    if (!s.inCombat(us.combat)) continue;
                    aStrength += s.getCost();
                }
                int dStrength = 0;
                for (Airship s : us.combat.sides.get((int)1).ships) {
                    if (!s.inCombat(us.combat)) continue;
                    dStrength += s.getCost();
                }
                if (aStrength > dStrength) {
                    System.out.println("Defender autosurrenders: " + aStrength + " vs " + dStrength);
                    us.combat.sides.get((int)1).surrendered = true;
                } else {
                    System.out.println("Attacker autosurrenders: " + aStrength + " vs " + dStrength);
                    us.combat.sides.get((int)0).surrendered = true;
                }
            } else if (attackerDoesSurrender) {
                System.out.println("Attacker autosurrenders because defender can't");
                us.combat.sides.get((int)0).surrendered = true;
            } else {
                System.out.println("Defender autosurrenders because attacker can't");
                us.combat.sides.get((int)1).surrendered = true;
            }
        }
    }

    @Override
    public boolean showOutside() {
        return false;
    }

    @Override
    public boolean showDecals() {
        return true;
    }

    @Override
    public boolean drawAsBlueprint() {
        return false;
    }
}

