/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;

public strictfp final class MultiResourceBundle
extends ResourceBundle {
    private final ArrayList<ResourceBundle> bundles = new ArrayList();
    private final HashMap<String, Object> map = new HashMap();
    private final ArrayList<String> keys = new ArrayList();

    public MultiResourceBundle(ResourceBundle base) {
        this.bundles.add(base);
        this.recalc();
    }

    public void add(ResourceBundle b) {
        this.bundles.add(b);
        Enumeration<String> ks = b.getKeys();
        while (ks.hasMoreElements()) {
            String k = ks.nextElement();
            this.map.put(k, b.getObject(k));
        }
        this.keys.clear();
        this.keys.addAll(this.map.keySet());
    }

    public void resetToBase() {
        this.bundles.retainAll(this.bundles.subList(0, 1));
        this.recalc();
    }

    private void recalc() {
        this.map.clear();
        for (ResourceBundle b : this.bundles) {
            Enumeration<String> ks = b.getKeys();
            while (ks.hasMoreElements()) {
                String k = ks.nextElement();
                this.map.put(k, b.getObject(k));
            }
        }
        this.keys.clear();
        this.keys.addAll(this.map.keySet());
    }

    @Override
    public boolean containsKey(String k) {
        return this.map.containsKey(k);
    }

    @Override
    protected Object handleGetObject(String string) {
        return this.map.get(string);
    }

    @Override
    public Enumeration<String> getKeys() {
        return new ListEnumeration<String>(this.keys);
    }

    private strictfp static class ListEnumeration<T>
    implements Enumeration<T> {
        private final List<T> l;
        private int index = 0;

        public ListEnumeration(List<T> l) {
            this.l = l;
        }

        @Override
        public boolean hasMoreElements() {
            return this.index < this.l.size();
        }

        @Override
        public T nextElement() {
            return this.l.get(this.index++);
        }
    }
}

